/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.appearance;

import java.awt.Color;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.gephi.appearance.api.AppearanceModel;
import org.gephi.appearance.api.AttributeFunction;
import org.gephi.appearance.api.Function;
import org.gephi.appearance.spi.PartitionTransformer;
import org.gephi.appearance.spi.RankingTransformer;
import org.gephi.appearance.spi.Transformer;
import org.gephi.appearance.spi.TransformerCategory;
import org.gephi.appearance.spi.TransformerUI;
import org.gephi.desktop.appearance.AppearanceUIController;
import org.gephi.desktop.appearance.AutoAppyTransformer;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.ui.appearance.plugin.category.DefaultCategory;
import org.openide.util.Lookup;

public class AppearanceUIModel {
    protected final AppearanceUIController controller;
    protected final AppearanceModel appearanceModel;
    protected final GraphController graphController;
    protected final Map<String, Map<TransformerCategory, TransformerUI>> selectedTransformerUI;
    protected final Map<String, Map<TransformerUI, Function>> selectedFunction;
    protected final Map<String, TransformerCategory> selectedCategory;
    protected final Map<String, Map<TransformerCategory, AutoAppyTransformer>> selectedAutoTransformer;
    protected final Map<Function, Map<String, Object>> savedProperties;
    protected String selectedElementClass = "nodes";

    public AppearanceUIModel(AppearanceUIController controller, AppearanceModel model) {
        this.controller = controller;
        this.appearanceModel = model;
        this.graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        this.selectedCategory = new HashMap<String, TransformerCategory>();
        this.selectedTransformerUI = new HashMap<String, Map<TransformerCategory, TransformerUI>>();
        this.selectedFunction = new HashMap<String, Map<TransformerUI, Function>>();
        this.selectedAutoTransformer = new HashMap<String, Map<TransformerCategory, AutoAppyTransformer>>();
        this.savedProperties = new HashMap<Function, Map<String, Object>>();
        for (String ec : AppearanceUIController.ELEMENT_CLASSES) {
            this.initSelectedTransformerUIs(ec);
            this.refreshSelectedFunctions(ec);
        }
    }

    private void initSelectedTransformerUIs(String elementClass) {
        Graph graph = this.graphController.getGraphModel(this.appearanceModel.getWorkspace()).getGraph();
        HashMap<TransformerCategory, TransformerUI> newMap = new HashMap<TransformerCategory, TransformerUI>();
        for (Function func : elementClass.equals("nodes") ? this.appearanceModel.getNodeFunctions(graph) : this.appearanceModel.getEdgeFunctions(graph)) {
            TransformerUI ui = func.getUI();
            if (ui == null) continue;
            TransformerCategory cat = ui.getCategory();
            if (!newMap.containsKey(cat)) {
                newMap.put(cat, ui);
            }
            if (this.selectedCategory.containsKey(elementClass)) continue;
            this.selectedCategory.put(elementClass, cat);
        }
        if (newMap.containsKey(DefaultCategory.COLOR)) {
            this.selectedCategory.put(elementClass, DefaultCategory.COLOR);
        }
        this.selectedTransformerUI.put(elementClass, newMap);
        this.selectedFunction.put(elementClass, new HashMap());
        this.selectedAutoTransformer.put(elementClass, new HashMap());
    }

    private void refreshSelectedFunctions(String elementClass) {
        HashSet<Function> functionSet = new HashSet<Function>();
        Graph graph = this.graphController.getGraphModel(this.appearanceModel.getWorkspace()).getGraph();
        for (Function func : elementClass.equals("nodes") ? this.appearanceModel.getNodeFunctions(graph) : this.appearanceModel.getEdgeFunctions(graph)) {
            TransformerUI ui = func.getUI();
            if (ui == null) continue;
            functionSet.add(func);
        }
        for (Function func : functionSet) {
            Function oldFunc = this.selectedFunction.get(elementClass).get(func.getUI());
            if (oldFunc != null && functionSet.contains(oldFunc) || !func.isSimple()) continue;
            this.selectedFunction.get(elementClass).put(func.getUI(), func);
        }
    }

    public synchronized Function replaceSelectedFunction() {
        Graph graph = this.graphController.getGraphModel(this.appearanceModel.getWorkspace()).getGraph();
        Function sFunction = this.getSelectedFunction();
        if (sFunction instanceof AttributeFunction) {
            AttributeFunction af = (AttributeFunction)sFunction;
            for (Function func : this.getSelectedElementClass().equals("nodes") ? this.appearanceModel.getNodeFunctions(graph) : this.appearanceModel.getEdgeFunctions(graph)) {
                if (!(func instanceof AttributeFunction) || !af.getColumn().equals(((AttributeFunction)func).getColumn()) || !sFunction.getUI().getCategory().equals(func.getUI().getCategory())) continue;
                return func;
            }
        }
        return null;
    }

    public synchronized boolean refreshSelectedFunction() {
        Graph graph = this.graphController.getGraphModel(this.appearanceModel.getWorkspace()).getGraph();
        Function sFunction = this.getSelectedFunction();
        if (sFunction != null && sFunction.isAttribute()) {
            for (Function func : this.getSelectedElementClass().equals("nodes") ? this.appearanceModel.getNodeFunctions(graph) : this.appearanceModel.getEdgeFunctions(graph)) {
                if (!func.equals(sFunction)) continue;
                return false;
            }
        }
        return true;
    }

    public void select() {
    }

    public void unselect() {
    }

    public boolean isLocalScale() {
        return this.appearanceModel.isLocalScale();
    }

    public void saveTransformerProperties() {
        Function func = this.getSelectedFunction();
        if (func != null) {
            Transformer transformer = func.getTransformer();
            Map<String, Object> props = this.savedProperties.get(func);
            if (props == null) {
                props = new HashMap<String, Object>();
                this.savedProperties.put(func, new HashMap());
            }
            for (Map.Entry<String, Method[]> entry : this.getProperties(transformer).entrySet()) {
                String name = entry.getKey();
                Method getMethod = entry.getValue()[0];
                try {
                    Object o = getMethod.invoke((Object)transformer, new Object[0]);
                    props.put(name, o);
                }
                catch (Exception ex) {}
            }
        }
    }

    public void loadTransformerProperties() {
        Function func = this.getSelectedFunction();
        if (func != null) {
            Transformer transformer = func.getTransformer();
            Map<String, Object> props = this.savedProperties.get(func);
            if (props != null) {
                for (Map.Entry<String, Method[]> entry : this.getProperties(transformer).entrySet()) {
                    String name = entry.getKey();
                    Object o = props.get(name);
                    if (o == null) continue;
                    Method setMethod = entry.getValue()[1];
                    try {
                        setMethod.invoke((Object)transformer, o);
                    }
                    catch (Exception ex) {}
                }
            }
        }
    }

    public String getSelectedElementClass() {
        return this.selectedElementClass;
    }

    public TransformerCategory getSelectedCategory() {
        return this.selectedCategory.get(this.selectedElementClass);
    }

    public TransformerUI getSelectedTransformerUI() {
        return this.selectedTransformerUI.get(this.selectedElementClass).get(this.getSelectedCategory());
    }

    public Function getSelectedFunction() {
        return this.selectedFunction.get(this.selectedElementClass).get(this.getSelectedTransformerUI());
    }

    public AutoAppyTransformer getAutoAppyTransformer() {
        String elm = this.getSelectedElementClass();
        TransformerCategory ct = this.getSelectedCategory();
        if (ct != null) {
            return this.selectedAutoTransformer.get(elm).get(ct);
        }
        return null;
    }

    public Collection<Function> getFunctions() {
        Graph graph = this.graphController.getGraphModel(this.appearanceModel.getWorkspace()).getGraph();
        ArrayList<Function> functions = new ArrayList<Function>();
        for (Function func : this.selectedElementClass.equalsIgnoreCase("nodes") ? this.appearanceModel.getNodeFunctions(graph) : this.appearanceModel.getEdgeFunctions(graph)) {
            TransformerUI ui = func.getUI();
            if (ui == null || !ui.getDisplayName().equals(this.getSelectedTransformerUI().getDisplayName()) || !ui.getCategory().equals(this.selectedCategory.get(this.selectedElementClass))) continue;
            functions.add(func);
        }
        return functions;
    }

    protected void setAutoApply(boolean autoApply) {
        AutoAppyTransformer aat;
        if (!autoApply && (aat = this.getAutoAppyTransformer()) != null) {
            aat.stop();
        }
        String elmt = this.getSelectedElementClass();
        TransformerCategory cat = this.getSelectedCategory();
        if (autoApply) {
            this.selectedAutoTransformer.get(elmt).put(cat, new AutoAppyTransformer(this.controller, this.getSelectedFunction()));
        } else {
            this.selectedAutoTransformer.get(elmt).put(cat, null);
        }
    }

    protected boolean isAttributeTransformerUI(TransformerUI ui) {
        Class transformerClass = ui.getTransformerClass();
        return RankingTransformer.class.isAssignableFrom(transformerClass) || PartitionTransformer.class.isAssignableFrom(transformerClass);
    }

    protected void setSelectedElementClass(String selectedElementClass) {
        this.saveTransformerProperties();
        this.selectedElementClass = selectedElementClass;
        this.loadTransformerProperties();
    }

    protected void setSelectedCategory(TransformerCategory category) {
        this.saveTransformerProperties();
        this.selectedCategory.put(this.selectedElementClass, category);
        this.loadTransformerProperties();
    }

    protected void setSelectedTransformerUI(TransformerUI transformerUI) {
        this.saveTransformerProperties();
        this.selectedTransformerUI.get(this.selectedElementClass).put(this.getSelectedCategory(), transformerUI);
        this.loadTransformerProperties();
    }

    protected void setSelectedFunction(Function function) {
        this.saveTransformerProperties();
        this.selectedFunction.get(this.selectedElementClass).put(this.getSelectedTransformerUI(), function);
        this.loadTransformerProperties();
    }

    private Map<String, Method[]> getProperties(Transformer transformer) {
        HashMap<String, Method[]> propertyMethods = new HashMap<String, Method[]>();
        for (Method m : transformer.getClass().getMethods()) {
            String name = m.getName();
            if (!Modifier.isPublic(m.getModifiers())) continue;
            String propertyName = null;
            if (name.startsWith("get")) {
                propertyName = name.substring(3);
            } else if (name.startsWith("set")) {
                propertyName = name.substring(3);
            } else if (name.startsWith("is")) {
                propertyName = name.substring(2);
            }
            Method[] ms = (Method[])propertyMethods.get(propertyName);
            if (ms == null) {
                ms = new Method[2];
                propertyMethods.put(propertyName, ms);
            }
            if (name.startsWith("set")) {
                ms[1] = m;
                continue;
            }
            ms[0] = m;
        }
        Iterator itr = propertyMethods.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            Method get = ((Method[])entry.getValue())[0];
            Method set = ((Method[])entry.getValue())[1];
            if (get != null && set != null && set.getParameterTypes().length == 1 && get.getParameterTypes().length == 0 && set.getParameterTypes()[0].equals(get.getReturnType()) && this.isSupportedPropertyType(get.getReturnType())) continue;
            itr.remove();
        }
        return propertyMethods;
    }

    private boolean isSupportedPropertyType(Class type) {
        Class<?> cmp;
        if (type.isPrimitive()) {
            return true;
        }
        return type.isArray() ? (cmp = type.getComponentType()).isPrimitive() || cmp.equals(Color.class) : type.equals(Color.class);
    }
}

