/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics.plugin;

import java.util.HashMap;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.UndirectedGraph;
import org.gephi.statistics.plugin.ChartUtils;
import org.gephi.statistics.spi.Statistics;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.openide.util.Lookup;

public class PageRank
implements Statistics,
LongTask {
    public static final String PAGERANK = "pageranks";
    private ProgressTicket progress;
    private boolean isCanceled;
    private double epsilon = 0.001;
    private double probability = 0.85;
    private boolean useEdgeWeight = false;
    private double[] pageranks;
    private boolean isDirected;

    public PageRank() {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        if (graphController != null && graphController.getGraphModel() != null) {
            this.isDirected = graphController.getGraphModel().isDirected();
        }
    }

    public void setDirected(boolean isDirected) {
        this.isDirected = isDirected;
    }

    public boolean getDirected() {
        return this.isDirected;
    }

    public void execute(GraphModel graphModel) {
        Object graph = this.isDirected ? graphModel.getDirectedGraphVisible() : graphModel.getUndirectedGraphVisible();
        this.execute((Graph)graph);
    }

    public void execute(Graph hgraph) {
        this.isCanceled = false;
        Column column = this.initializeAttributeColunms(hgraph.getModel());
        hgraph.readLock();
        HashMap<Node, Integer> indicies = this.createIndiciesMap(hgraph);
        this.pageranks = this.calculatePagerank(hgraph, indicies, this.isDirected, this.useEdgeWeight, this.epsilon, this.probability);
        this.saveCalculatedValues(hgraph, column, indicies, this.pageranks);
        hgraph.readUnlockAll();
    }

    private Column initializeAttributeColunms(GraphModel graphModel) {
        Table nodeTable = graphModel.getNodeTable();
        Column pagerankCol = nodeTable.getColumn(PAGERANK);
        if (pagerankCol == null) {
            pagerankCol = nodeTable.addColumn(PAGERANK, "PageRank", Double.class, (Object)new Double(0.0));
        }
        return pagerankCol;
    }

    private void saveCalculatedValues(Graph hgraph, Column attributeColumn, HashMap<Node, Integer> indicies, double[] nodePagrank) {
        for (Node s : hgraph.getNodes()) {
            int s_index = indicies.get(s);
            s.setAttribute(attributeColumn, (Object)nodePagrank[s_index]);
        }
    }

    private void setInitialValues(Graph hgraph, double[] pagerankValues, double[] weights, boolean directed, boolean useWeights) {
        int N = hgraph.getNodeCount();
        int index = 0;
        for (Node s : hgraph.getNodes()) {
            pagerankValues[index] = 1.0f / (float)N;
            if (useWeights) {
                double sum = 0.0;
                EdgeIterable eIter = directed ? ((DirectedGraph)hgraph).getOutEdges(s) : ((UndirectedGraph)hgraph).getEdges(s);
                for (Edge edge : eIter) {
                    sum += edge.getWeight();
                }
                weights[index] = sum;
            }
            ++index;
        }
    }

    private double calculateR(Graph hgraph, double[] pagerankValues, HashMap<Node, Integer> indicies, boolean directed, double prob) {
        int N = hgraph.getNodeCount();
        double r = 0.0;
        for (Node s : hgraph.getNodes()) {
            boolean out;
            int s_index = indicies.get(s);
            if (directed) {
                out = ((DirectedGraph)hgraph).getOutDegree(s) > 0;
            } else {
                boolean bl = out = hgraph.getDegree(s) > 0;
            }
            r = out ? (r += (1.0 - prob) * (pagerankValues[s_index] / (double)N)) : (r += pagerankValues[s_index] / (double)N);
            if (!this.isCanceled) continue;
            hgraph.readUnlockAll();
            return r;
        }
        return r;
    }

    private double updateValueForNode(Graph hgraph, Node s, double[] pagerankValues, double[] weights, HashMap<Node, Integer> indicies, boolean directed, boolean useWeights, double r, double prob) {
        double res = r;
        EdgeIterable eIter = directed ? ((DirectedGraph)hgraph).getInEdges(s) : hgraph.getEdges(s);
        for (Edge edge : eIter) {
            Node neighbor = hgraph.getOpposite(s, edge);
            int neigh_index = indicies.get(neighbor);
            int normalize = directed ? ((DirectedGraph)hgraph).getOutDegree(neighbor) : hgraph.getDegree(neighbor);
            if (useWeights) {
                double weight = edge.getWeight() / weights[neigh_index];
                res += prob * pagerankValues[neigh_index] * weight;
                continue;
            }
            res += prob * (pagerankValues[neigh_index] / (double)normalize);
        }
        return res;
    }

    double[] calculatePagerank(Graph hgraph, HashMap<Node, Integer> indicies, boolean directed, boolean useWeights, double eps, double prob) {
        boolean done;
        int N = hgraph.getNodeCount();
        double[] pagerankValues = new double[N];
        double[] temp = new double[N];
        Progress.start((ProgressTicket)this.progress);
        double[] weights = new double[N];
        this.setInitialValues(hgraph, pagerankValues, weights, directed, useWeights);
        do {
            double r = this.calculateR(hgraph, pagerankValues, indicies, directed, prob);
            done = true;
            for (Node s : hgraph.getNodes()) {
                int s_index = indicies.get(s);
                temp[s_index] = this.updateValueForNode(hgraph, s, pagerankValues, weights, indicies, directed, useWeights, r, prob);
                if ((temp[s_index] - pagerankValues[s_index]) / pagerankValues[s_index] >= eps) {
                    done = false;
                }
                if (!this.isCanceled) continue;
                hgraph.readUnlockAll();
                return pagerankValues;
            }
            pagerankValues = temp;
            temp = new double[N];
        } while (!done && !this.isCanceled);
        return pagerankValues;
    }

    public HashMap<Node, Integer> createIndiciesMap(Graph hgraph) {
        HashMap<Node, Integer> newIndicies = new HashMap<Node, Integer>();
        int index = 0;
        for (Node s : hgraph.getNodes()) {
            newIndicies.put(s, index);
            ++index;
        }
        return newIndicies;
    }

    public String getReport() {
        HashMap<Double, Integer> dist = new HashMap<Double, Integer>();
        for (int i = 0; i < this.pageranks.length; ++i) {
            Double d = this.pageranks[i];
            if (dist.containsKey(d)) {
                Integer v = (Integer)dist.get(d);
                dist.put(d, v + 1);
                continue;
            }
            dist.put(d, 1);
        }
        XYSeries dSeries = ChartUtils.createXYSeries(dist, "PageRanks");
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(dSeries);
        JFreeChart chart = ChartFactory.createXYLineChart((String)"PageRank Distribution", (String)"Score", (String)"Count", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        chart.removeLegend();
        ChartUtils.decorateChart(chart);
        ChartUtils.scaleChart(chart, dSeries, true);
        String imageFile = ChartUtils.renderChart(chart, "pageranks.png");
        String report = "<HTML> <BODY> <h1>PageRank Report </h1> <hr> <br /><h2> Parameters: </h2>Epsilon = " + this.epsilon + "<br>" + "Probability = " + this.probability + "<br> <h2> Results: </h2>" + imageFile + "<br /><br />" + "<h2> Algorithm: </h2>" + "Sergey Brin, Lawrence Page, <i>The Anatomy of a Large-Scale Hypertextual Web Search Engine</i>, in Proceedings of the seventh International Conference on the World Wide Web (WWW1998):107-117<br />" + "</BODY> </HTML>";
        return report;
    }

    public boolean cancel() {
        this.isCanceled = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }

    public void setProbability(double prob) {
        this.probability = prob;
    }

    public void setEpsilon(double eps) {
        this.epsilon = eps;
    }

    public double getProbability() {
        return this.probability;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public boolean isUseEdgeWeight() {
        return this.useEdgeWeight;
    }

    public void setUseEdgeWeight(boolean useEdgeWeight) {
        this.useEdgeWeight = useEdgeWeight;
    }
}

