/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.algorithms.shortestpath;

import java.util.HashMap;
import java.util.Map;
import org.gephi.algorithms.shortestpath.AbstractShortestPathAlgorithm;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Node;

public class BellmanFordShortestPathAlgorithm
extends AbstractShortestPathAlgorithm {
    protected final DirectedGraph graph;
    protected final HashMap<Node, Edge> predecessors;

    public BellmanFordShortestPathAlgorithm(DirectedGraph graph, Node sourceNode) {
        super(sourceNode);
        this.graph = graph;
        this.predecessors = new HashMap();
    }

    @Override
    public void compute() {
        this.graph.readLock();
        int nodeCount = 0;
        for (Node node : this.graph.getNodes()) {
            this.distances.put(node, Double.POSITIVE_INFINITY);
            ++nodeCount;
        }
        this.distances.put(this.sourceNode, 0.0);
        for (int i = 0; i < nodeCount; ++i) {
            boolean relaxed = false;
            for (Edge edge : this.graph.getEdges()) {
                Node target = edge.getTarget();
                if (!this.relax(edge)) continue;
                relaxed = true;
                this.predecessors.put(target, edge);
            }
            if (!relaxed) break;
        }
        for (Edge edge : this.graph.getEdges()) {
            if (!((Double)this.distances.get(edge.getSource()) + this.edgeWeight(edge) < (Double)this.distances.get(edge.getTarget()))) continue;
            this.graph.readUnlock();
            throw new RuntimeException("The Graph contains a negative-weighted cycle");
        }
        this.graph.readUnlock();
    }

    @Override
    public Map<Node, Edge> getPredecessors() {
        return this.predecessors;
    }
}

