/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import org.postgresql.Driver;
import org.postgresql.PGNotification;
import org.postgresql.PGProperty;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.BaseStatement;
import org.postgresql.core.CachedQuery;
import org.postgresql.core.ConnectionFactory;
import org.postgresql.core.Encoding;
import org.postgresql.core.Field;
import org.postgresql.core.Logger;
import org.postgresql.core.Oid;
import org.postgresql.core.ProtocolConnection;
import org.postgresql.core.Query;
import org.postgresql.core.QueryExecutor;
import org.postgresql.core.ResultCursor;
import org.postgresql.core.ResultHandler;
import org.postgresql.core.ServerVersion;
import org.postgresql.core.TypeInfo;
import org.postgresql.core.Utils;
import org.postgresql.core.Version;
import org.postgresql.fastpath.Fastpath;
import org.postgresql.geometric.PGbox;
import org.postgresql.geometric.PGcircle;
import org.postgresql.geometric.PGline;
import org.postgresql.geometric.PGlseg;
import org.postgresql.geometric.PGpath;
import org.postgresql.geometric.PGpoint;
import org.postgresql.geometric.PGpolygon;
import org.postgresql.jdbc2.AbstractJdbc2Statement;
import org.postgresql.jdbc2.CachedQueryCreateAction;
import org.postgresql.jdbc2.CallableQueryKey;
import org.postgresql.jdbc2.TimestampUtils;
import org.postgresql.jdbc2.TypeInfoCache;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.GT;
import org.postgresql.util.HostSpec;
import org.postgresql.util.LruCache;
import org.postgresql.util.PGBinaryObject;
import org.postgresql.util.PGInterval;
import org.postgresql.util.PGmoney;
import org.postgresql.util.PGobject;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public abstract class AbstractJdbc2Connection
implements BaseConnection {
    private static int nextConnectionID = 1;
    private final Logger logger;
    private final String creatingURL;
    private Throwable openStackTrace;
    private final ProtocolConnection protoConnection;
    private final int compatibleInt;
    private final Query commitQuery;
    private final Query rollbackQuery;
    private TypeInfo _typeCache;
    private boolean disableColumnSanitiser = false;
    protected int prepareThreshold;
    protected int defaultFetchSize;
    protected boolean forcebinary = false;
    private boolean autoCommit = true;
    private boolean readOnly = false;
    private final boolean bindStringAsVarchar;
    private SQLWarning firstWarning = null;
    private Set<Integer> useBinarySendForOids;
    private Set<Integer> useBinaryReceiveForOids;
    private volatile Timer cancelTimer = null;
    private final LruCache<Object, CachedQuery> statementCache;
    private final TimestampUtils timestampUtils;
    protected Map typemap;
    private Fastpath fastpath = null;
    private LargeObjectManager largeobject = null;
    protected DatabaseMetaData metadata;
    private CopyManager copyManager = null;

    @Override
    public abstract DatabaseMetaData getMetaData() throws SQLException;

    CachedQuery borrowQuery(String sql, boolean isCallable) throws SQLException {
        Object key = isCallable ? new CallableQueryKey(sql) : sql;
        return this.statementCache.borrow(key);
    }

    void releaseQuery(CachedQuery cachedQuery) {
        this.statementCache.put(cachedQuery.key, cachedQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AbstractJdbc2Connection(HostSpec[] hostSpecs, String user, String database, Properties info, String url) throws SQLException {
        this.creatingURL = url;
        int logLevel = Driver.getLogLevel();
        Integer connectionLogLevel = PGProperty.LOG_LEVEL.getInteger(info);
        if (connectionLogLevel != null) {
            logLevel = connectionLogLevel;
        }
        Class<AbstractJdbc2Connection> clazz = AbstractJdbc2Connection.class;
        synchronized (AbstractJdbc2Connection.class) {
            String stringType;
            this.logger = new Logger(nextConnectionID++);
            this.logger.setLogLevel(logLevel);
            // ** MonitorExit[var8_8] (shouldn't be in output)
            if (logLevel > 0) {
                this.enableDriverManagerLogging();
            }
            this.setDefaultFetchSize(PGProperty.DEFAULT_ROW_FETCH_SIZE.getInt(info));
            this.prepareThreshold = PGProperty.PREPARE_THRESHOLD.getInt(info);
            if (this.prepareThreshold == -1) {
                this.forcebinary = true;
            }
            boolean binaryTransfer = PGProperty.BINARY_TRANSFER.getBoolean(info);
            if (this.logger.logInfo()) {
                this.logger.info(Driver.getVersion());
            }
            this.protoConnection = ConnectionFactory.openConnection(hostSpecs, user, database, info, this.logger);
            int compat = Utils.parseServerVersionStr(PGProperty.COMPATIBLE.get(info));
            if (compat == 0) {
                compat = 90400;
            }
            this.compatibleInt = compat;
            if (PGProperty.READ_ONLY.getBoolean(info)) {
                this.setReadOnly(true);
            }
            HashSet<Integer> binaryOids = new HashSet<Integer>();
            if (binaryTransfer && this.protoConnection.getProtocolVersion() >= 3) {
                binaryOids.add(17);
                binaryOids.add(21);
                binaryOids.add(23);
                binaryOids.add(20);
                binaryOids.add(700);
                binaryOids.add(701);
                binaryOids.add(1083);
                binaryOids.add(1082);
                binaryOids.add(1266);
                binaryOids.add(1114);
                binaryOids.add(1184);
                binaryOids.add(1005);
                binaryOids.add(1007);
                binaryOids.add(1016);
                binaryOids.add(1021);
                binaryOids.add(1022);
                binaryOids.add(1022);
                binaryOids.add(1015);
                binaryOids.add(1009);
                binaryOids.add(600);
                binaryOids.add(603);
                binaryOids.add(2950);
            }
            if (!this.haveMinimumCompatibleVersion(ServerVersion.v8_0)) {
                binaryOids.remove(1083);
                binaryOids.remove(1266);
                binaryOids.remove(1114);
                binaryOids.remove(1184);
            }
            if (!this.haveMinimumCompatibleVersion(ServerVersion.v8_3)) {
                binaryOids.remove(1005);
                binaryOids.remove(1007);
                binaryOids.remove(1016);
                binaryOids.remove(1021);
                binaryOids.remove(1022);
                binaryOids.remove(1022);
                binaryOids.remove(1015);
                binaryOids.remove(1009);
            }
            binaryOids.addAll(this.getOidSet(PGProperty.BINARY_TRANSFER_ENABLE.get(info)));
            binaryOids.removeAll(this.getOidSet(PGProperty.BINARY_TRANSFER_DISABLE.get(info)));
            this.useBinarySendForOids = new HashSet<Integer>();
            this.useBinarySendForOids.addAll(binaryOids);
            this.useBinaryReceiveForOids = new HashSet<Integer>();
            this.useBinaryReceiveForOids.addAll(binaryOids);
            this.useBinarySendForOids.remove(1082);
            this.protoConnection.setBinaryReceiveOids(this.useBinaryReceiveForOids);
            if (this.logger.logDebug()) {
                this.logger.debug("    compatible = " + this.compatibleInt);
                this.logger.debug("    loglevel = " + logLevel);
                this.logger.debug("    prepare threshold = " + this.prepareThreshold);
                this.logger.debug("    types using binary send = " + this.oidsToString(this.useBinarySendForOids));
                this.logger.debug("    types using binary receive = " + this.oidsToString(this.useBinaryReceiveForOids));
                this.logger.debug("    integer date/time = " + this.protoConnection.getIntegerDateTimes());
            }
            if ((stringType = PGProperty.STRING_TYPE.get(info)) != null) {
                if (stringType.equalsIgnoreCase("unspecified")) {
                    this.bindStringAsVarchar = false;
                } else {
                    if (!stringType.equalsIgnoreCase("varchar")) throw new PSQLException(GT.tr("Unsupported value for stringtype parameter: {0}", stringType), PSQLState.INVALID_PARAMETER_VALUE);
                    this.bindStringAsVarchar = true;
                }
            } else {
                this.bindStringAsVarchar = this.haveMinimumCompatibleVersion(ServerVersion.v8_0);
            }
            this.timestampUtils = new TimestampUtils(this.haveMinimumServerVersion(ServerVersion.v7_4), this.haveMinimumServerVersion(ServerVersion.v8_2), !this.protoConnection.getIntegerDateTimes());
            this.commitQuery = this.getQueryExecutor().createSimpleQuery("COMMIT");
            this.rollbackQuery = this.getQueryExecutor().createSimpleQuery("ROLLBACK");
            int unknownLength = PGProperty.UNKNOWN_LENGTH.getInt(info);
            this._typeCache = this.createTypeInfo(this, unknownLength);
            this.initObjectTypes(info);
            if (PGProperty.LOG_UNCLOSED_CONNECTIONS.getBoolean(info)) {
                this.openStackTrace = new Throwable("Connection was created at this point:");
                this.enableDriverManagerLogging();
            }
            this.disableColumnSanitiser = PGProperty.DISABLE_COLUMN_SANITISER.getBoolean(info);
            this.statementCache = new LruCache<Object, CachedQuery>(Math.max(0, PGProperty.PREPARED_STATEMENT_CACHE_QUERIES.getInt(info)), Math.max(0, PGProperty.PREPARED_STATEMENT_CACHE_SIZE_MIB.getInt(info) * 1024 * 1024), new CachedQueryCreateAction(this, this.protoConnection.getServerVersionNum()), new LruCache.EvictAction<CachedQuery>(){

                @Override
                public void evict(CachedQuery cachedQuery) throws SQLException {
                    cachedQuery.query.close();
                }
            });
            return;
        }
    }

    private Set<Integer> getOidSet(String oidList) throws PSQLException {
        HashSet<Integer> oids = new HashSet<Integer>();
        StringTokenizer tokenizer = new StringTokenizer(oidList, ",");
        while (tokenizer.hasMoreTokens()) {
            String oid = tokenizer.nextToken();
            oids.add(Oid.valueOf(oid));
        }
        return oids;
    }

    private String oidsToString(Set<Integer> oids) {
        StringBuilder sb = new StringBuilder();
        for (Integer oid : oids) {
            sb.append(Oid.toString(oid));
            sb.append(',');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        } else {
            sb.append(" <none>");
        }
        return sb.toString();
    }

    @Override
    public TimestampUtils getTimestampUtils() {
        return this.timestampUtils;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public abstract Statement createStatement(int var1, int var2) throws SQLException;

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    @Override
    public abstract PreparedStatement prepareStatement(String var1, int var2, int var3) throws SQLException;

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    @Override
    public abstract CallableStatement prepareCall(String var1, int var2, int var3) throws SQLException;

    public Map getTypeMap() throws SQLException {
        this.checkClosed();
        return this.typemap;
    }

    @Override
    public QueryExecutor getQueryExecutor() {
        return this.protoConnection.getQueryExecutor();
    }

    public void addWarning(SQLWarning warn) {
        if (this.firstWarning != null) {
            this.firstWarning.setNextWarning(warn);
        } else {
            this.firstWarning = warn;
        }
    }

    @Override
    public ResultSet execSQLQuery(String s) throws SQLException {
        return this.execSQLQuery(s, 1003, 1007);
    }

    @Override
    public ResultSet execSQLQuery(String s, int resultSetType, int resultSetConcurrency) throws SQLException {
        BaseStatement stat = (BaseStatement)this.createStatement(resultSetType, resultSetConcurrency);
        boolean hasResultSet = stat.executeWithFlags(s, 16);
        while (!hasResultSet && stat.getUpdateCount() != -1) {
            hasResultSet = stat.getMoreResults();
        }
        if (!hasResultSet) {
            throw new PSQLException(GT.tr("No results were returned by the query."), PSQLState.NO_DATA);
        }
        SQLWarning warnings = stat.getWarnings();
        if (warnings != null) {
            this.addWarning(warnings);
        }
        return stat.getResultSet();
    }

    @Override
    public void execSQLUpdate(String s) throws SQLException {
        BaseStatement stmt = (BaseStatement)this.createStatement();
        if (stmt.executeWithFlags(s, 22)) {
            throw new PSQLException(GT.tr("A result was returned when none was expected."), PSQLState.TOO_MANY_RESULTS);
        }
        SQLWarning warnings = stmt.getWarnings();
        if (warnings != null) {
            this.addWarning(warnings);
        }
        stmt.close();
    }

    public void setCursorName(String cursor) throws SQLException {
        this.checkClosed();
    }

    public String getCursorName() throws SQLException {
        this.checkClosed();
        return null;
    }

    public String getURL() throws SQLException {
        return this.creatingURL;
    }

    public String getUserName() throws SQLException {
        return this.protoConnection.getUser();
    }

    @Override
    public Fastpath getFastpathAPI() throws SQLException {
        this.checkClosed();
        if (this.fastpath == null) {
            this.fastpath = new Fastpath(this);
        }
        return this.fastpath;
    }

    @Override
    public LargeObjectManager getLargeObjectAPI() throws SQLException {
        this.checkClosed();
        if (this.largeobject == null) {
            this.largeobject = new LargeObjectManager(this);
        }
        return this.largeobject;
    }

    @Override
    public Object getObject(String type, String value, byte[] byteValue) throws SQLException {
        Class c;
        if (this.typemap != null && (c = (Class)this.typemap.get(type)) != null) {
            throw new PSQLException(GT.tr("Custom type maps are not supported."), PSQLState.NOT_IMPLEMENTED);
        }
        PGobject obj = null;
        if (this.logger.logDebug()) {
            this.logger.debug("Constructing object from type=" + type + " value=<" + value + ">");
        }
        try {
            Class klass = this._typeCache.getPGobject(type);
            if (klass != null) {
                obj = (PGobject)klass.newInstance();
                obj.setType(type);
                if (byteValue != null && obj instanceof PGBinaryObject) {
                    PGBinaryObject binObj = (PGBinaryObject)((Object)obj);
                    binObj.setByteValue(byteValue, 0);
                } else {
                    obj.setValue(value);
                }
            } else {
                obj = new PGobject();
                obj.setType(type);
                obj.setValue(value);
            }
            return obj;
        }
        catch (SQLException sx) {
            throw sx;
        }
        catch (Exception ex) {
            throw new PSQLException(GT.tr("Failed to create object for: {0}.", type), PSQLState.CONNECTION_FAILURE, (Throwable)ex);
        }
    }

    protected TypeInfo createTypeInfo(BaseConnection conn, int unknownLength) {
        return new TypeInfoCache(conn, unknownLength);
    }

    @Override
    public TypeInfo getTypeInfo() {
        return this._typeCache;
    }

    @Override
    public void addDataType(String type, String name) {
        try {
            this.addDataType(type, Class.forName(name));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot register new type: " + e);
        }
    }

    @Override
    public void addDataType(String type, Class klass) throws SQLException {
        this.checkClosed();
        this._typeCache.addDataType(type, klass);
    }

    private void initObjectTypes(Properties info) throws SQLException {
        this.addDataType("box", PGbox.class);
        this.addDataType("circle", PGcircle.class);
        this.addDataType("line", PGline.class);
        this.addDataType("lseg", PGlseg.class);
        this.addDataType("path", PGpath.class);
        this.addDataType("point", PGpoint.class);
        this.addDataType("polygon", PGpolygon.class);
        this.addDataType("money", PGmoney.class);
        this.addDataType("interval", PGInterval.class);
        Enumeration<?> e = info.propertyNames();
        while (e.hasMoreElements()) {
            Class<?> klass;
            String propertyName = (String)e.nextElement();
            if (!propertyName.startsWith("datatype.")) continue;
            String typeName = propertyName.substring(9);
            String className = info.getProperty(propertyName);
            try {
                klass = Class.forName(className);
            }
            catch (ClassNotFoundException cnfe) {
                throw new PSQLException(GT.tr("Unable to load the class {0} responsible for the datatype {1}", new Object[]{className, typeName}), PSQLState.SYSTEM_ERROR, (Throwable)cnfe);
            }
            this.addDataType(typeName, klass);
        }
    }

    @Override
    public void close() {
        this.releaseTimer();
        this.protoConnection.close();
        this.openStackTrace = null;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        StringBuilder buf = new StringBuilder(sql.length());
        AbstractJdbc2Statement.parseSql(sql, 0, buf, false, this.getStandardConformingStrings());
        return buf.toString();
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        SQLWarning newWarnings = this.protoConnection.getWarnings();
        if (this.firstWarning == null) {
            this.firstWarning = newWarnings;
        } else {
            this.firstWarning.setNextWarning(newWarnings);
        }
        return this.firstWarning;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.checkClosed();
        this.protoConnection.getWarnings();
        this.firstWarning = null;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        if (this.protoConnection.getTransactionState() != 0) {
            throw new PSQLException(GT.tr("Cannot change transaction read-only property in the middle of a transaction."), PSQLState.ACTIVE_SQL_TRANSACTION);
        }
        if (this.haveMinimumServerVersion(ServerVersion.v7_4) && readOnly != this.readOnly) {
            String readOnlySql = "SET SESSION CHARACTERISTICS AS TRANSACTION " + (readOnly ? "READ ONLY" : "READ WRITE");
            this.execSQLUpdate(readOnlySql);
        }
        this.readOnly = readOnly;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return this.readOnly;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        if (this.autoCommit == autoCommit) {
            return;
        }
        if (!this.autoCommit) {
            this.commit();
        }
        this.autoCommit = autoCommit;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return this.autoCommit;
    }

    private void executeTransactionCommand(Query query) throws SQLException {
        int flags = 22;
        if (this.prepareThreshold == 0) {
            flags |= 1;
        }
        this.getQueryExecutor().execute(query, null, (ResultHandler)new TransactionCommandHandler(), 0, 0, flags);
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            throw new PSQLException(GT.tr("Cannot commit when autoCommit is enabled."), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        if (this.protoConnection.getTransactionState() != 0) {
            this.executeTransactionCommand(this.commitQuery);
        }
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw new PSQLException(GT.tr("This connection has been closed."), PSQLState.CONNECTION_DOES_NOT_EXIST);
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            throw new PSQLException(GT.tr("Cannot rollback when autoCommit is enabled."), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        if (this.protoConnection.getTransactionState() != 0) {
            this.executeTransactionCommand(this.rollbackQuery);
        }
    }

    @Override
    public int getTransactionState() {
        return this.protoConnection.getTransactionState();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        String level = null;
        if (this.haveMinimumServerVersion(ServerVersion.v7_3)) {
            ResultSet rs = this.execSQLQuery("SHOW TRANSACTION ISOLATION LEVEL");
            if (rs.next()) {
                level = rs.getString(1);
            }
            rs.close();
        } else {
            SQLWarning saveWarnings = this.getWarnings();
            this.clearWarnings();
            this.execSQLUpdate("SHOW TRANSACTION ISOLATION LEVEL");
            SQLWarning warning = this.getWarnings();
            if (warning != null) {
                level = warning.getMessage();
            }
            this.clearWarnings();
            if (saveWarnings != null) {
                this.addWarning(saveWarnings);
            }
        }
        if (level == null) {
            return 2;
        }
        if ((level = level.toUpperCase(Locale.US)).contains("READ COMMITTED")) {
            return 2;
        }
        if (level.contains("READ UNCOMMITTED")) {
            return 1;
        }
        if (level.contains("REPEATABLE READ")) {
            return 4;
        }
        if (level.contains("SERIALIZABLE")) {
            return 8;
        }
        return 2;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        if (this.protoConnection.getTransactionState() != 0) {
            throw new PSQLException(GT.tr("Cannot change transaction isolation level in the middle of a transaction."), PSQLState.ACTIVE_SQL_TRANSACTION);
        }
        String isolationLevelName = this.getIsolationLevelName(level);
        if (isolationLevelName == null) {
            throw new PSQLException(GT.tr("Transaction isolation level {0} not supported.", level), PSQLState.NOT_IMPLEMENTED);
        }
        String isolationLevelSQL = "SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL " + isolationLevelName;
        this.execSQLUpdate(isolationLevelSQL);
    }

    protected String getIsolationLevelName(int level) {
        boolean pg80 = this.haveMinimumServerVersion(ServerVersion.v8_0);
        if (level == 2) {
            return "READ COMMITTED";
        }
        if (level == 8) {
            return "SERIALIZABLE";
        }
        if (pg80 && level == 1) {
            return "READ UNCOMMITTED";
        }
        if (pg80 && level == 4) {
            return "REPEATABLE READ";
        }
        return null;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkClosed();
        return this.protoConnection.getDatabase();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.openStackTrace != null) {
                this.logger.log(GT.tr("Finalizing a Connection that was never closed:"), this.openStackTrace);
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public String getDBVersionNumber() {
        return this.protoConnection.getServerVersion();
    }

    private static int integerPart(String dirtyString) {
        int end;
        int start;
        for (start = 0; start < dirtyString.length() && !Character.isDigit(dirtyString.charAt(start)); ++start) {
        }
        for (end = start; end < dirtyString.length() && Character.isDigit(dirtyString.charAt(end)); ++end) {
        }
        if (start == end) {
            return 0;
        }
        return Integer.parseInt(dirtyString.substring(start, end));
    }

    public int getServerMajorVersion() {
        try {
            StringTokenizer versionTokens = new StringTokenizer(this.protoConnection.getServerVersion(), ".");
            return AbstractJdbc2Connection.integerPart(versionTokens.nextToken());
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    public int getServerMinorVersion() {
        try {
            StringTokenizer versionTokens = new StringTokenizer(this.protoConnection.getServerVersion(), ".");
            versionTokens.nextToken();
            return AbstractJdbc2Connection.integerPart(versionTokens.nextToken());
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    @Override
    public boolean haveMinimumServerVersion(String ver) {
        int requiredver = Utils.parseServerVersionStr(ver);
        if (requiredver == 0) {
            return this.protoConnection.getServerVersion().compareTo(ver) >= 0;
        }
        return this.haveMinimumServerVersion(requiredver);
    }

    @Override
    public boolean haveMinimumServerVersion(int ver) {
        return this.protoConnection.getServerVersionNum() >= ver;
    }

    @Override
    public boolean haveMinimumServerVersion(Version ver) {
        return this.haveMinimumServerVersion(ver.getVersionNum());
    }

    @Override
    public boolean haveMinimumCompatibleVersion(int ver) {
        return this.compatibleInt >= ver;
    }

    @Override
    public boolean haveMinimumCompatibleVersion(String ver) {
        return this.haveMinimumCompatibleVersion(ServerVersion.from(ver));
    }

    @Override
    public boolean haveMinimumCompatibleVersion(Version ver) {
        return this.haveMinimumCompatibleVersion(ver.getVersionNum());
    }

    @Override
    public Encoding getEncoding() {
        return this.protoConnection.getEncoding();
    }

    @Override
    public byte[] encodeString(String str) throws SQLException {
        try {
            return this.getEncoding().encode(str);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Unable to translate data into the desired encoding."), PSQLState.DATA_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public String escapeString(String str) throws SQLException {
        return Utils.escapeLiteral(null, str, this.protoConnection.getStandardConformingStrings()).toString();
    }

    @Override
    public boolean getStandardConformingStrings() {
        return this.protoConnection.getStandardConformingStrings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.protoConnection.isClosed();
    }

    @Override
    public void cancelQuery() throws SQLException {
        this.checkClosed();
        this.protoConnection.sendQueryCancel();
    }

    @Override
    public PGNotification[] getNotifications() throws SQLException {
        this.checkClosed();
        this.getQueryExecutor().processNotifies();
        PGNotification[] notifications = this.protoConnection.getNotifications();
        return notifications.length == 0 ? null : notifications;
    }

    @Override
    public int getPrepareThreshold() {
        return this.prepareThreshold;
    }

    @Override
    public void setDefaultFetchSize(int fetchSize) throws SQLException {
        if (fetchSize < 0) {
            throw new PSQLException(GT.tr("Fetch size must be a value greater to or equal to 0."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.defaultFetchSize = fetchSize;
    }

    @Override
    public int getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    @Override
    public void setPrepareThreshold(int newThreshold) {
        this.prepareThreshold = newThreshold;
    }

    public boolean getForceBinary() {
        return this.forcebinary;
    }

    public void setForceBinary(boolean newValue) {
        this.forcebinary = newValue;
    }

    public void setTypeMapImpl(Map map) throws SQLException {
        this.typemap = map;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    protected void enableDriverManagerLogging() {
        if (DriverManager.getLogWriter() == null) {
            DriverManager.setLogWriter(new PrintWriter(System.out, true));
        }
    }

    public int getProtocolVersion() {
        return this.protoConnection.getProtocolVersion();
    }

    @Override
    public boolean getStringVarcharFlag() {
        return this.bindStringAsVarchar;
    }

    @Override
    public CopyManager getCopyAPI() throws SQLException {
        this.checkClosed();
        if (this.copyManager == null) {
            this.copyManager = new CopyManager(this);
        }
        return this.copyManager;
    }

    @Override
    public boolean binaryTransferSend(int oid) {
        return this.useBinarySendForOids.contains(oid);
    }

    @Override
    public int getBackendPID() {
        return this.protoConnection.getBackendPID();
    }

    @Override
    public boolean isColumnSanitiserDisabled() {
        return this.disableColumnSanitiser;
    }

    public void setDisableColumnSanitiser(boolean disableColumnSanitiser) {
        this.disableColumnSanitiser = disableColumnSanitiser;
    }

    protected void abort() {
        this.protoConnection.abort();
    }

    private synchronized Timer getTimer() {
        if (this.cancelTimer == null) {
            this.cancelTimer = Driver.getSharedTimer().getTimer();
        }
        return this.cancelTimer;
    }

    private synchronized void releaseTimer() {
        if (this.cancelTimer != null) {
            this.cancelTimer = null;
            Driver.getSharedTimer().releaseTimer();
        }
    }

    @Override
    public void addTimerTask(TimerTask timerTask, long milliSeconds) {
        Timer timer = this.getTimer();
        timer.schedule(timerTask, milliSeconds);
    }

    @Override
    public void purgeTimerTasks() {
        Timer timer = this.cancelTimer;
        if (timer != null) {
            timer.purge();
        }
    }

    @Override
    public String escapeIdentifier(String identifier) throws SQLException {
        return Utils.escapeIdentifier(null, identifier).toString();
    }

    @Override
    public String escapeLiteral(String literal) throws SQLException {
        return Utils.escapeLiteral(null, literal, this.protoConnection.getStandardConformingStrings()).toString();
    }

    private class TransactionCommandHandler
    implements ResultHandler {
        private SQLException error;

        private TransactionCommandHandler() {
        }

        @Override
        public void handleResultRows(Query fromQuery, Field[] fields, List tuples, ResultCursor cursor) {
        }

        @Override
        public void handleCommandStatus(String status, int updateCount, long insertOID) {
        }

        @Override
        public void handleWarning(SQLWarning warning) {
            AbstractJdbc2Connection.this.addWarning(warning);
        }

        @Override
        public void handleError(SQLException newError) {
            if (this.error == null) {
                this.error = newError;
            } else {
                this.error.setNextException(newError);
            }
        }

        @Override
        public void handleCompletion() throws SQLException {
            if (this.error != null) {
                throw this.error;
            }
        }
    }
}

