/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api.types;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.TimeFormat;
import org.gephi.graph.api.types.TimeMap;
import org.gephi.graph.impl.FormattingAndParsingUtils;
import org.joda.time.DateTimeZone;

public abstract class IntervalMap<T>
implements TimeMap<Interval, T> {
    protected double[] array;
    protected int size = 0;

    public IntervalMap() {
        this.array = new double[0];
    }

    public IntervalMap(int capacity) {
        this.array = new double[capacity];
        Arrays.fill(this.array, Double.MAX_VALUE);
    }

    protected IntervalMap(double[] keys) {
        this.array = new double[keys.length];
        System.arraycopy(keys, 0, this.array, 0, keys.length);
        this.size = keys.length / 2;
    }

    @Override
    public boolean put(Interval interval, T value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Object values = this.getValuesArray();
        int valuesLength = Array.getLength(values);
        int index = this.putInner(interval.getLow(), interval.getHigh());
        if (index < 0) {
            int insertIndex = -index - 1;
            if (this.size - 1 < valuesLength) {
                if (insertIndex < this.size - 1) {
                    System.arraycopy(values, insertIndex, values, insertIndex + 1, this.size - insertIndex - 1);
                }
                Array.set(values, insertIndex, value);
            } else {
                Object newArray = Array.newInstance(values.getClass().getComponentType(), valuesLength + 1);
                System.arraycopy(values, 0, newArray, 0, insertIndex);
                System.arraycopy(values, insertIndex, newArray, insertIndex + 1, valuesLength - insertIndex);
                Array.set(newArray, insertIndex, value);
                this.setValuesArray(newArray);
            }
            return true;
        }
        Array.set(values, index, value);
        return false;
    }

    @Override
    public boolean remove(Interval interval) {
        Object values = this.getValuesArray();
        int removeIndex = this.removeInner(interval.getLow(), interval.getHigh());
        if (removeIndex >= 0) {
            if (removeIndex != this.size) {
                System.arraycopy(values, removeIndex + 1, values, removeIndex, this.size - removeIndex);
            }
            return true;
        }
        return false;
    }

    @Override
    public Object get(Interval interval, Estimator estimator) {
        if (!this.isSupported(estimator)) {
            throw new UnsupportedOperationException("Not supported estimator.");
        }
        switch (estimator) {
            case AVERAGE: {
                return this.getAverage(interval);
            }
            case MIN: {
                return this.getMin(interval);
            }
            case MAX: {
                return this.getMax(interval);
            }
            case FIRST: {
                return this.getFirst(interval);
            }
            case LAST: {
                return this.getLast(interval);
            }
        }
        throw new UnsupportedOperationException("Not supported estimator.");
    }

    @Override
    public T get(Interval interval, T defaultValue) {
        int index = this.getIndex(interval.getLow(), interval.getHigh());
        if (index >= 0) {
            return this.getValue(index / 2);
        }
        return defaultValue;
    }

    @Override
    public T[] toValuesArray() {
        Object values = this.getValuesArray();
        int length = Array.getLength(values);
        if (values.getClass().getComponentType().isPrimitive() || this.size < length) {
            Object[] res = (Object[])Array.newInstance(this.getTypeClass(), this.size);
            for (int i = 0; i < this.size; ++i) {
                res[i] = Array.get(values, i);
            }
            return res;
        }
        return (Object[])values;
    }

    protected Object toNativeArray() {
        Object values = this.getValuesArray();
        int length = Array.getLength(values);
        if (this.size < length - 1) {
            Object res = Array.newInstance(values.getClass().getComponentType(), this.size);
            System.arraycopy(values, 0, res, 0, this.size);
            return res;
        }
        return values;
    }

    protected abstract T getValue(int var1);

    protected abstract Object getValuesArray();

    protected abstract void setValuesArray(Object var1);

    protected int putInner(double intervalStart, double intervalEnd) {
        int insertIndex;
        int realSize = this.size * 2;
        int index = Arrays.binarySearch(this.array, 0, realSize, intervalStart);
        if (index < 0) {
            double currentValue;
            int insertIndex2 = -index - 1;
            if (insertIndex2 % 2 == 1) {
                this.overlappingIntervallException();
            }
            if (insertIndex2 < realSize && intervalEnd > (currentValue = this.array[insertIndex2])) {
                this.overlappingIntervallException();
            }
            if (realSize < this.array.length - 2) {
                if (insertIndex2 < realSize) {
                    System.arraycopy(this.array, insertIndex2, this.array, insertIndex2 + 2, realSize - insertIndex2);
                }
                this.array[insertIndex2] = intervalStart;
                this.array[insertIndex2 + 1] = intervalEnd;
            } else {
                double[] newArray = new double[this.array.length + 2];
                System.arraycopy(this.array, 0, newArray, 0, insertIndex2);
                System.arraycopy(this.array, insertIndex2, newArray, insertIndex2 + 2, this.array.length - insertIndex2);
                newArray[insertIndex2] = intervalStart;
                newArray[insertIndex2 + 1] = intervalEnd;
                this.array = newArray;
            }
            ++this.size;
            return -(insertIndex2 / 2) - 1;
        }
        int n = insertIndex = index % 2 == 0 ? index : index - 1;
        while (insertIndex < realSize && insertIndex >= 0) {
            int shift;
            double startValue = this.array[insertIndex];
            double endValue = this.array[insertIndex + 1];
            if (startValue > intervalStart) {
                if (!(intervalEnd >= endValue)) break;
                this.overlappingIntervallException();
                break;
            }
            if (startValue == intervalStart && endValue > intervalEnd) {
                if (intervalEnd <= startValue) break;
                this.overlappingIntervallException();
            }
            int n2 = intervalEnd > endValue ? 2 : (intervalEnd < endValue ? -2 : (shift = intervalStart > startValue ? 2 : 0));
            if (shift == 0) {
                return insertIndex / 2;
            }
            if (startValue == intervalStart && endValue < intervalEnd && startValue != endValue) {
                this.overlappingIntervallException();
            }
            insertIndex += shift;
        }
        if (realSize < this.array.length - 2) {
            if (insertIndex < realSize) {
                System.arraycopy(this.array, insertIndex, this.array, insertIndex + 2, realSize - insertIndex);
            }
            this.array[insertIndex] = intervalStart;
            this.array[insertIndex + 1] = intervalEnd;
        } else {
            double[] newArray = new double[this.array.length + 2];
            System.arraycopy(this.array, 0, newArray, 0, insertIndex);
            System.arraycopy(this.array, insertIndex, newArray, insertIndex + 2, this.array.length - insertIndex);
            newArray[insertIndex] = intervalStart;
            newArray[insertIndex + 1] = intervalEnd;
            this.array = newArray;
        }
        ++this.size;
        return -(insertIndex / 2) - 1;
    }

    protected int removeInner(double intervalStart, double intervalEnd) {
        int realSize = this.size * 2;
        int index = Arrays.binarySearch(this.array, 0, realSize, intervalStart);
        if (index >= 0) {
            int removeIndex;
            int n = removeIndex = index % 2 == 0 ? index : index - 1;
            while (removeIndex < realSize && removeIndex >= 0) {
                int shift;
                double startValue = this.array[removeIndex];
                if (startValue > intervalStart) {
                    return -1;
                }
                double endValue = this.array[removeIndex + 1];
                if (startValue == intervalStart && endValue > intervalEnd) {
                    return -1;
                }
                if ((intervalEnd > endValue ? 2 : (intervalEnd < endValue ? -2 : (shift = intervalStart > startValue ? 2 : 0))) == 0) {
                    if (removeIndex == realSize - 2) {
                        --this.size;
                    } else {
                        System.arraycopy(this.array, removeIndex + 2, this.array, removeIndex, realSize - removeIndex - 2);
                        --this.size;
                    }
                    return removeIndex / 2;
                }
                removeIndex += shift;
            }
        }
        return -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(double timestamp) {
        int realSize = this.size * 2;
        int index = Arrays.binarySearch(this.array, 0, realSize, timestamp);
        return index >= 0 && index < realSize;
    }

    protected int getIndex(double intervalStart, double intervalEnd) {
        int realSize = this.size * 2;
        int index = Arrays.binarySearch(this.array, 0, realSize, intervalStart);
        if (index >= 0) {
            int foundIndex;
            int n = foundIndex = index % 2 == 0 ? index : index - 1;
            while (foundIndex < realSize && foundIndex >= 0) {
                int shift;
                double startValue = this.array[foundIndex];
                if (startValue > intervalStart) {
                    return -1;
                }
                double endValue = this.array[foundIndex + 1];
                if (startValue == intervalStart && endValue > intervalEnd) {
                    return -1;
                }
                if ((intervalEnd > endValue ? 2 : (intervalEnd < endValue ? -2 : (shift = intervalStart > startValue ? 2 : 0))) == 0) {
                    return foundIndex;
                }
                foundIndex += shift;
            }
        }
        return -1;
    }

    protected int[] getOverlappingIntervals(double intervalStart, double intervalEnd) {
        int startIndex;
        int realSize = this.size * 2;
        int index = Arrays.binarySearch(this.array, 0, realSize, intervalStart);
        if (index >= 0) {
            int startIndex2;
            int n = startIndex2 = index % 2 == 0 ? index : index - 1;
            while (startIndex2 - 2 >= 0 && this.array[startIndex2 - 2] == intervalStart) {
                startIndex2 -= 2;
            }
            int[] res = new int[this.size - startIndex2 / 2];
            int i = 0;
            while (startIndex2 < realSize && this.array[startIndex2] <= intervalEnd) {
                res[i++] = startIndex2 / 2;
                startIndex2 += 2;
            }
            if (res.length != i) {
                return Arrays.copyOf(res, i);
            }
            return res;
        }
        int n = startIndex = (-index - 1) % 2 == 0 ? -index - 1 : -index - 2;
        if (startIndex < realSize && this.array[startIndex] <= intervalEnd) {
            int[] res = new int[this.size - startIndex / 2];
            int i = 0;
            while (startIndex < realSize && this.array[startIndex] <= intervalEnd) {
                res[i++] = startIndex / 2;
                startIndex += 2;
            }
            if (i != 0) {
                if (res.length != i) {
                    return Arrays.copyOf(res, i);
                }
                return res;
            }
        }
        return new int[0];
    }

    protected double[] getIntervalsWeight(double intervalStart, double intervalEnd, int[] intervals) {
        double[] res = new double[intervals.length];
        for (int i = 0; i < intervals.length; ++i) {
            double start = this.array[i * 2];
            double end = this.array[i * 2 + 1];
            if (start == end) continue;
            start = Math.max(intervalStart, start);
            end = Math.min(intervalEnd, end);
            res[i] = end - start;
        }
        return res;
    }

    @Override
    public boolean contains(Interval interval) {
        return this.getIndex(interval.getLow(), interval.getHigh()) >= 0;
    }

    public Interval[] toKeysArray() {
        Interval[] res = new Interval[this.size];
        for (int i = 0; i < this.size; ++i) {
            res[i] = new Interval(this.array[i * 2], this.array[i * 2 + 1]);
        }
        return res;
    }

    public double[] getIntervals() {
        int realSize = this.size * 2;
        if (realSize < this.array.length) {
            double[] res = new double[realSize];
            System.arraycopy(this.array, 0, res, 0, realSize);
            return res;
        }
        return this.array;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.array = new double[0];
    }

    private void overlappingIntervallException() {
        throw new IllegalArgumentException("Overlapping intervals aren't allowed");
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + this.size;
        int realSize = this.size * 2;
        for (int i = 0; i < realSize; ++i) {
            double t = this.array[i];
            hash = 29 * hash + (int)(Double.doubleToLongBits(t) ^ Double.doubleToLongBits(t) >>> 32);
            if (i % 2 != 0) continue;
            T obj = this.getValue(i / 2);
            hash = 29 * hash + obj.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntervalMap other = (IntervalMap)obj;
        if (this.size != other.size) {
            return false;
        }
        int realSize = this.size * 2;
        for (int i = 0; i < realSize; ++i) {
            double i1 = this.array[i];
            double i2 = other.array[i];
            if (i1 != i2) {
                return false;
            }
            if (i % 2 != 0) continue;
            T o1 = this.getValue(i / 2);
            T o2 = other.getValue(i / 2);
            if (!(o1 == null && o2 != null || o1 != null && o2 == null) && (o1 == null || o2 == null || o1.equals(o2))) continue;
            return false;
        }
        return true;
    }

    protected Object getFirst(Interval interval) {
        if (this.size == 0) {
            return null;
        }
        int[] intervals = this.getOverlappingIntervals(interval.getLow(), interval.getHigh());
        if (intervals.length == 0) {
            return null;
        }
        return this.getValue(intervals[0]);
    }

    protected Object getLast(Interval interval) {
        if (this.size == 0) {
            return null;
        }
        int[] intervals = this.getOverlappingIntervals(interval.getLow(), interval.getHigh());
        if (intervals.length == 0) {
            return null;
        }
        return this.getValue(intervals[intervals.length - 1]);
    }

    protected Object getMin(Interval interval) {
        Double min = this.getMinDouble(interval);
        return min != null ? Double.valueOf(min) : null;
    }

    protected Double getMinDouble(Interval interval) {
        if (this.size == 0) {
            return null;
        }
        int[] intervals = this.getOverlappingIntervals(interval.getLow(), interval.getHigh());
        if (intervals.length == 0) {
            return null;
        }
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < intervals.length; ++i) {
            double val = ((Number)this.getValue(intervals[i])).doubleValue();
            min = Math.min(val, min);
        }
        return min;
    }

    protected Object getMax(Interval interval) {
        Double max = this.getMaxDouble(interval);
        return max != null ? Double.valueOf(max) : null;
    }

    protected Double getMaxDouble(Interval interval) {
        if (this.size == 0) {
            return null;
        }
        int[] intervals = this.getOverlappingIntervals(interval.getLow(), interval.getHigh());
        if (intervals.length == 0) {
            return null;
        }
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < intervals.length; ++i) {
            double val = ((Number)this.getValue(intervals[i])).doubleValue();
            max = Math.max(val, max);
        }
        return max;
    }

    protected Object getAverage(Interval interval) {
        BigDecimal average = this.getAverageBigDecimal(interval);
        return average != null ? Double.valueOf(average.doubleValue()) : null;
    }

    protected BigDecimal getAverageBigDecimal(Interval interval) {
        if (this.size == 0) {
            return null;
        }
        int[] intervals = this.getOverlappingIntervals(interval.getLow(), interval.getHigh());
        if (intervals.length == 0) {
            return null;
        }
        double[] weights = this.getIntervalsWeight(interval.getLow(), interval.getHigh(), intervals);
        BigDecimal result = new BigDecimal(0.0);
        BigDecimal period = new BigDecimal(0.0);
        for (int i = 0; i < intervals.length; ++i) {
            BigDecimal w = new BigDecimal(weights[i]);
            period = period.add(w);
            w = w.multiply(new BigDecimal(((Number)this.getValue(intervals[i])).doubleValue()));
            result = result.add(w);
        }
        return result.divide(period, 10, RoundingMode.HALF_EVEN);
    }

    protected Double getAverageDouble(Interval interval) {
        if (this.size == 0) {
            return null;
        }
        int[] intervals = this.getOverlappingIntervals(interval.getLow(), interval.getHigh());
        if (intervals.length == 0) {
            return null;
        }
        double[] weights = this.getIntervalsWeight(interval.getLow(), interval.getHigh(), intervals);
        double result = 0.0;
        double period = 0.0;
        for (int i = 0; i < intervals.length; ++i) {
            double w = weights[i];
            period += w;
            result += (w *= ((Number)this.getValue(intervals[i])).doubleValue());
        }
        return result / period;
    }

    @Override
    public String toString(TimeFormat timeFormat, DateTimeZone timeZone) {
        if (this.size == 0) {
            return "<empty>";
        }
        T[] values = this.toValuesArray();
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        for (int i = 0; i < this.size; ++i) {
            sb.append('[');
            sb.append(AttributeUtils.printTimestampInFormat(this.array[i * 2], timeFormat, timeZone));
            sb.append(", ");
            sb.append(AttributeUtils.printTimestampInFormat(this.array[i * 2 + 1], timeFormat, timeZone));
            sb.append(", ");
            String stringValue = values[i].toString();
            if (FormattingAndParsingUtils.containsDynamicSpecialCharacters(stringValue) || stringValue.trim().isEmpty()) {
                sb.append('\"');
                sb.append(stringValue.replace("\\", "\\\\").replace("\"", "\\\""));
                sb.append('\"');
            } else {
                sb.append(stringValue);
            }
            sb.append(']');
            if (i >= this.size - 1) continue;
            sb.append("; ");
        }
        sb.append('>');
        return sb.toString();
    }

    @Override
    public String toString(TimeFormat timeFormat) {
        return this.toString(timeFormat, null);
    }

    public String toString() {
        return this.toString(TimeFormat.DOUBLE, null);
    }
}

