/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.components;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.ui.components.JRangeSlider;
import org.openide.util.NbBundle;

public class JRangeSliderPanel
extends JPanel {
    public static final String LOWER_BOUND = "lowerbound";
    public static final String UPPER_BOUND = "upperbound";
    private static final int SLIDER_MAXIMUM = 1000;
    private String lowerBound = "N/A";
    private String upperBound = "N/A";
    private Range range;
    private JTextField lowerBoundTextField;
    private JSlider rangeSlider;
    private JTextField upperBoundTextField;

    public JRangeSliderPanel() {
        this.initComponents();
        ((JRangeSlider)this.rangeSlider).setUpperValue(1000);
        this.rangeSlider.setOpaque(false);
        this.lowerBoundTextField.setOpaque(false);
        this.upperBoundTextField.setOpaque(false);
        this.lowerBoundTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JRangeSliderPanel.this.lowerBoundTextField.setEnabled(true);
                JRangeSliderPanel.this.lowerBoundTextField.selectAll();
            }
        });
        this.lowerBoundTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!JRangeSliderPanel.this.lowerBoundTextField.getText().equals(JRangeSliderPanel.this.lowerBound)) {
                    JRangeSliderPanel.this.lowerBound = JRangeSliderPanel.this.lowerBoundTextField.getText();
                    if (JRangeSliderPanel.this.range != null) {
                        JRangeSliderPanel.this.range.setLowerBound(JRangeSliderPanel.this.lowerBound);
                        JRangeSliderPanel.this.firePropertyChange(JRangeSliderPanel.LOWER_BOUND, null, JRangeSliderPanel.this.lowerBound);
                    }
                } else {
                    JRangeSliderPanel.this.lowerBound = JRangeSliderPanel.this.lowerBoundTextField.getText();
                }
                JRangeSliderPanel.this.refreshBoundTexts();
                JRangeSliderPanel.this.lowerBoundTextField.setEnabled(false);
            }
        });
        this.lowerBoundTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JRangeSliderPanel.this.lowerBoundTextField.setEnabled(false);
            }
        });
        this.upperBoundTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JRangeSliderPanel.this.upperBoundTextField.setEnabled(true);
                JRangeSliderPanel.this.upperBoundTextField.selectAll();
            }
        });
        this.upperBoundTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!JRangeSliderPanel.this.upperBoundTextField.getText().equals(JRangeSliderPanel.this.upperBound)) {
                    JRangeSliderPanel.this.upperBound = JRangeSliderPanel.this.upperBoundTextField.getText();
                    if (JRangeSliderPanel.this.range != null) {
                        JRangeSliderPanel.this.range.setUpperBound(JRangeSliderPanel.this.upperBound);
                        JRangeSliderPanel.this.firePropertyChange(JRangeSliderPanel.UPPER_BOUND, null, JRangeSliderPanel.this.upperBound);
                    }
                } else {
                    JRangeSliderPanel.this.upperBound = JRangeSliderPanel.this.upperBoundTextField.getText();
                }
                JRangeSliderPanel.this.refreshBoundTexts();
                JRangeSliderPanel.this.upperBoundTextField.setEnabled(false);
            }
        });
        this.upperBoundTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JRangeSliderPanel.this.upperBoundTextField.setEnabled(false);
            }
        });
        this.rangeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JRangeSlider source = (JRangeSlider)e.getSource();
                if (!source.getValueIsAdjusting() && JRangeSliderPanel.this.range != null) {
                    JRangeSliderPanel.this.range.refreshBounds();
                    JRangeSliderPanel.this.refreshBoundTexts();
                }
            }
        });
    }

    private void refreshBoundTexts() {
        if (this.range != null) {
            this.lowerBound = this.range.lowerBound.toString();
            this.upperBound = this.range.upperBound.toString();
            this.lowerBoundTextField.setText(this.lowerBound);
            this.upperBoundTextField.setText(this.upperBound);
        }
    }

    public JRangeSlider getSlider() {
        return (JRangeSlider)this.rangeSlider;
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range) {
        if (!range.min.equals(range.max)) {
            this.range = range;
            this.rangeSlider.setEnabled(true);
            range.refreshSlider();
            this.refreshBoundTexts();
        } else {
            this.lowerBound = range.lowerBound.toString();
            this.upperBound = range.upperBound.toString();
            this.lowerBoundTextField.setText(this.lowerBound);
            this.upperBoundTextField.setText(this.upperBound);
            this.rangeSlider.setEnabled(false);
        }
    }

    private void initComponents() {
        this.rangeSlider = new JRangeSlider();
        this.lowerBoundTextField = new JTextField();
        this.upperBoundTextField = new JTextField();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.rangeSlider.setMaximum(1000);
        this.rangeSlider.setValue(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.rangeSlider, gridBagConstraints);
        this.lowerBoundTextField.setText(NbBundle.getMessage(JRangeSliderPanel.class, (String)"JRangeSliderPanel.lowerBoundTextField.text"));
        this.lowerBoundTextField.setBorder(null);
        this.lowerBoundTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.lowerBoundTextField, gridBagConstraints);
        this.upperBoundTextField.setHorizontalAlignment(4);
        this.upperBoundTextField.setText(NbBundle.getMessage(JRangeSliderPanel.class, (String)"JRangeSliderPanel.upperBoundTextField.text"));
        this.upperBoundTextField.setBorder(null);
        this.upperBoundTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.upperBoundTextField, gridBagConstraints);
    }

    public static class Range {
        private JRangeSliderPanel slider;
        private Object min;
        private Object max;
        private Object lowerBound;
        private Object upperBound;
        private int sliderLowValue = -1;
        private int sliderUpValue = -1;

        public Range(JRangeSliderPanel slider, Object min, Object max) {
            this.slider = slider;
            this.min = min;
            this.max = max;
            this.lowerBound = min;
            this.upperBound = max;
        }

        public Range(JRangeSliderPanel slider, Object min, Object max, Object lowerBound, Object upperBound) {
            this.slider = slider;
            this.min = min;
            this.max = max;
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        public Object getLowerBound() {
            return this.lowerBound;
        }

        public Object getUpperBound() {
            return this.upperBound;
        }

        private void setLowerBound(String bound) {
            block21: {
                if (this.min instanceof Float) {
                    try {
                        Float l = Float.valueOf(Float.parseFloat(bound));
                        if (l.floatValue() < ((Float)this.min).floatValue()) {
                            this.lowerBound = this.min;
                            break block21;
                        }
                        if (l.floatValue() > ((Float)this.upperBound).floatValue()) {
                            this.lowerBound = this.upperBound;
                            break block21;
                        }
                        this.lowerBound = l;
                    }
                    catch (Exception e) {}
                } else if (this.min instanceof Double) {
                    try {
                        Double l = Double.parseDouble(bound);
                        if (l < (Double)this.min) {
                            this.lowerBound = this.min;
                            break block21;
                        }
                        if (l > (Double)this.upperBound) {
                            this.lowerBound = this.upperBound;
                            break block21;
                        }
                        this.lowerBound = l;
                    }
                    catch (Exception e) {}
                } else if (this.min instanceof Integer) {
                    try {
                        Integer l = Integer.parseInt(bound);
                        if (l < (Integer)this.min) {
                            this.lowerBound = this.min;
                            break block21;
                        }
                        if (l > (Integer)this.upperBound) {
                            this.lowerBound = this.upperBound;
                            break block21;
                        }
                        this.lowerBound = l;
                    }
                    catch (Exception e) {}
                } else if (this.min instanceof Long) {
                    try {
                        Long l = Long.parseLong(bound);
                        this.lowerBound = l < (Long)this.min ? this.min : (l > (Long)this.upperBound ? this.upperBound : l);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.refreshSlider();
        }

        private void setUpperBound(String bound) {
            block21: {
                if (this.min instanceof Float) {
                    try {
                        Float l = Float.valueOf(Float.parseFloat(bound));
                        if (l.floatValue() > ((Float)this.max).floatValue()) {
                            this.upperBound = this.max;
                            break block21;
                        }
                        if (l.floatValue() < ((Float)this.lowerBound).floatValue()) {
                            this.upperBound = this.lowerBound;
                            break block21;
                        }
                        this.upperBound = l;
                    }
                    catch (Exception e) {}
                } else if (this.min instanceof Double) {
                    try {
                        Double l = Double.parseDouble(bound);
                        if (l > (Double)this.max) {
                            this.upperBound = this.max;
                            break block21;
                        }
                        if (l < (Double)this.lowerBound) {
                            this.upperBound = this.lowerBound;
                            break block21;
                        }
                        this.upperBound = l;
                    }
                    catch (Exception e) {}
                } else if (this.min instanceof Integer) {
                    try {
                        Integer l = Integer.parseInt(bound);
                        if (l > (Integer)this.max) {
                            this.upperBound = this.max;
                            break block21;
                        }
                        if (l < (Integer)this.lowerBound) {
                            this.upperBound = this.lowerBound;
                            break block21;
                        }
                        this.upperBound = l;
                    }
                    catch (Exception e) {}
                } else if (this.min instanceof Long) {
                    try {
                        Long l = Long.parseLong(bound);
                        this.upperBound = l > (Long)this.max ? this.max : (l < (Long)this.lowerBound ? this.lowerBound : l);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.refreshSlider();
        }

        private void refreshSlider() {
            double normalizedLow = 0.0;
            double normalizedUp = 1.0;
            if (this.min instanceof Float) {
                normalizedLow = (((Float)this.lowerBound).floatValue() - ((Float)this.min).floatValue()) / (((Float)this.max).floatValue() - ((Float)this.min).floatValue());
                normalizedUp = (((Float)this.upperBound).floatValue() - ((Float)this.min).floatValue()) / (((Float)this.max).floatValue() - ((Float)this.min).floatValue());
            } else if (this.min instanceof Double) {
                normalizedLow = ((Double)this.lowerBound - (Double)this.min) / ((Double)this.max - (Double)this.min);
                normalizedUp = ((Double)this.upperBound - (Double)this.min) / ((Double)this.max - (Double)this.min);
            } else if (this.min instanceof Integer) {
                normalizedLow = (double)((Integer)this.lowerBound - (Integer)this.min) / (double)((Integer)this.max - (Integer)this.min);
                normalizedUp = (double)((Integer)this.upperBound - (Integer)this.min) / (double)((Integer)this.max - (Integer)this.min);
            } else if (this.min instanceof Long) {
                normalizedLow = (double)((Long)this.lowerBound - (Long)this.min) / (double)((Long)this.max - (Long)this.min);
                normalizedUp = (double)((Long)this.upperBound - (Long)this.min) / (double)((Long)this.max - (Long)this.min);
            }
            this.sliderLowValue = (int)(normalizedLow * 1000.0);
            this.sliderUpValue = (int)(normalizedUp * 1000.0);
            this.slider.getSlider().setValues(this.sliderLowValue, this.sliderUpValue);
        }

        private void refreshBounds() {
            boolean lowerChanged = this.slider.getSlider().getValue() != this.sliderLowValue;
            boolean upperChanged = this.slider.getSlider().getUpperValue() != this.sliderUpValue;
            this.sliderLowValue = this.slider.getSlider().getValue();
            this.sliderUpValue = this.slider.getSlider().getUpperValue();
            double normalizedLow = (double)this.slider.getSlider().getValue() / 1000.0;
            double normalizedUp = (double)this.slider.getSlider().getUpperValue() / 1000.0;
            if (this.min instanceof Float) {
                this.lowerBound = lowerChanged ? new Float(normalizedLow * (double)(((Float)this.max).floatValue() - ((Float)this.min).floatValue()) + (double)((Float)this.min).floatValue()) : this.lowerBound;
                this.upperBound = upperChanged ? new Float(normalizedUp * (double)(((Float)this.max).floatValue() - ((Float)this.min).floatValue()) + (double)((Float)this.min).floatValue()) : this.upperBound;
            } else if (this.min instanceof Double) {
                this.lowerBound = lowerChanged ? new Double(normalizedLow * ((Double)this.max - (Double)this.min) + (Double)this.min) : this.lowerBound;
                this.upperBound = upperChanged ? new Double(normalizedUp * ((Double)this.max - (Double)this.min) + (Double)this.min) : this.upperBound;
            } else if (this.min instanceof Integer) {
                this.lowerBound = lowerChanged ? new Integer((int)(normalizedLow * (double)((Integer)this.max - (Integer)this.min) + (double)((Integer)this.min).intValue())) : this.lowerBound;
                this.upperBound = upperChanged ? new Integer((int)(normalizedUp * (double)((Integer)this.max - (Integer)this.min) + (double)((Integer)this.min).intValue())) : this.upperBound;
            } else if (this.min instanceof Long) {
                this.lowerBound = lowerChanged ? new Long((long)(normalizedLow * (double)((Long)this.max - (Long)this.min) + (double)((Long)this.min).longValue())) : this.lowerBound;
                Object object = this.upperBound = upperChanged ? new Long((long)(normalizedUp * (double)((Long)this.max - (Long)this.min) + (double)((Long)this.min).longValue())) : this.upperBound;
            }
            if (lowerChanged) {
                this.slider.firePropertyChange(JRangeSliderPanel.LOWER_BOUND, null, this.lowerBound);
            }
            if (upperChanged) {
                this.slider.firePropertyChange(JRangeSliderPanel.UPPER_BOUND, null, this.upperBound);
            }
        }
    }
}

