/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.project.io;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.stream.XMLStreamWriter;
import org.gephi.project.api.Project;
import org.gephi.project.api.ProjectInformation;
import org.gephi.project.api.ProjectMetaData;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceInformation;
import org.gephi.project.impl.ProjectImpl;
import org.gephi.project.spi.WorkspaceXMLPersistenceProvider;
import org.openide.util.NbBundle;

public class GephiWriter {
    static final String VERSION = "0.9";

    public static void writeProject(XMLStreamWriter writer, Project project) throws Exception {
        writer.writeStartDocument("UTF-8", "1.0");
        writer.writeStartElement("projectFile");
        writer.writeAttribute("version", VERSION);
        writer.writeStartElement("lastModifiedDate");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        writer.writeCharacters(sdf.format(cal.getTime()));
        writer.writeComment("yyyy-MM-dd HH:mm:ss");
        writer.writeEndElement();
        writer.writeComment("File saved with " + GephiWriter.getVersion());
        ProjectInformation info = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
        ProjectMetaData metaData = (ProjectMetaData)project.getLookup().lookup(ProjectMetaData.class);
        writer.writeStartElement("project");
        writer.writeAttribute("name", info.getName());
        writer.writeAttribute("ids", String.valueOf(((ProjectImpl)project).getWorkspaceIds()));
        writer.writeStartElement("metadata");
        writer.writeStartElement("title");
        writer.writeCharacters(metaData.getTitle());
        writer.writeEndElement();
        writer.writeStartElement("keywords");
        writer.writeCharacters(metaData.getKeywords());
        writer.writeEndElement();
        writer.writeStartElement("description");
        writer.writeCharacters(metaData.getDescription());
        writer.writeEndElement();
        writer.writeStartElement("author");
        writer.writeCharacters(metaData.getAuthor());
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    public static void writeWorkspace(XMLStreamWriter writer, Workspace workspace) throws Exception {
        writer.writeStartDocument("UTF-8", "1.0");
        writer.writeStartElement("workspace");
        WorkspaceInformation info = (WorkspaceInformation)workspace.getLookup().lookup(WorkspaceInformation.class);
        writer.writeAttribute("name", info.getName());
        writer.writeAttribute("id", String.valueOf(workspace.getId()));
        if (info.isOpen()) {
            writer.writeAttribute("status", "open");
        } else if (info.isClosed()) {
            writer.writeAttribute("status", "closed");
        } else {
            writer.writeAttribute("status", "invalid");
        }
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    public static void writeWorkspaceChildren(XMLStreamWriter writer, Workspace workspace, WorkspaceXMLPersistenceProvider persistenceProvider) throws Exception {
        String identifier = persistenceProvider.getIdentifier();
        writer.writeStartDocument("UTF-8", "1.0");
        writer.writeStartElement(identifier);
        writer.writeComment("Persistence from '" + identifier + "' (" + persistenceProvider.getClass().getName() + ")");
        try {
            persistenceProvider.writeXML(writer, workspace);
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    private static String getVersion() {
        try {
            return MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.core.startup.Bundle").getString("currentVersion"), System.getProperty("netbeans.buildnumber"));
        }
        catch (Exception e) {
            return "?";
        }
    }
}

