/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.filters.plugin.attribute;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.filters.plugin.attribute.AttributeEqualBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class EqualNumberPanel
extends JPanel
implements ChangeListener {
    private AttributeEqualBuilder.EqualNumberFilter filter;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel labelValue;
    private JLabel maxLabel;
    private JLabel minLabel;
    private JSpinner valueSpinner;

    public EqualNumberPanel() {
        this.initComponents();
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        FilterProperty match = this.filter.getProperties()[1];
        try {
            match.setValue((Object)((Number)this.valueSpinner.getValue()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setup(AttributeEqualBuilder.EqualNumberFilter f) {
        this.filter = f;
        new Thread(new Runnable(){

            @Override
            public void run() {
                EqualNumberPanel.this.setToolTipText(EqualNumberPanel.this.filter.getName() + " '" + EqualNumberPanel.this.filter.getColumn().getTitle() + "'");
                Number match = EqualNumberPanel.this.filter.getMatch();
                Number stepSize = null;
                final Comparable min = (Comparable)((Object)EqualNumberPanel.this.filter.getRange().getMinimum());
                final Comparable max = (Comparable)((Object)EqualNumberPanel.this.filter.getRange().getMaximum());
                Class type = EqualNumberPanel.this.filter.getColumn().getTypeClass();
                if (type.equals(Double.class)) {
                    match = match != null ? (Number)match : (Number)((Double)min);
                    stepSize = 0.1;
                } else if (type.equals(Float.class)) {
                    match = match != null ? (Number)match : (Number)((Float)min);
                    stepSize = Float.valueOf(0.1f);
                } else if (type.equals(Long.class)) {
                    match = match != null ? (Number)match : (Number)((Long)min);
                    stepSize = 1L;
                } else if (type.equals(Integer.class)) {
                    match = match != null ? (Number)match : (Number)((Integer)min);
                    stepSize = 1;
                } else {
                    throw new IllegalArgumentException("Column must be number");
                }
                Number minNumber = (Number)((Object)min);
                Number maxNumber = (Number)((Object)max);
                if (match.doubleValue() < minNumber.doubleValue()) {
                    match = minNumber;
                    EqualNumberPanel.this.filter.getProperties()[1].setValue((Object)minNumber);
                } else if (match.doubleValue() > maxNumber.doubleValue()) {
                    match = maxNumber;
                    EqualNumberPanel.this.filter.getProperties()[1].setValue((Object)maxNumber);
                }
                final SpinnerNumberModel model = new SpinnerNumberModel(match, min, max, stepSize);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (min.equals(Double.NEGATIVE_INFINITY) || min.equals(Integer.MIN_VALUE)) {
                            EqualNumberPanel.this.minLabel.setText("");
                            EqualNumberPanel.this.maxLabel.setText("");
                        } else {
                            DecimalFormat df = new DecimalFormat();
                            df.setMaximumFractionDigits(5);
                            EqualNumberPanel.this.minLabel.setText(df.format(min));
                            EqualNumberPanel.this.maxLabel.setText(df.format(max));
                        }
                        EqualNumberPanel.this.valueSpinner.setModel(model);
                        model.addChangeListener(WeakListeners.change((ChangeListener)EqualNumberPanel.this, (Object)model));
                    }
                });
            }
        }).start();
    }

    private void initComponents() {
        this.labelValue = new JLabel();
        this.valueSpinner = new JSpinner();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.minLabel = new JLabel();
        this.maxLabel = new JLabel();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.labelValue.setText(NbBundle.getMessage(EqualNumberPanel.class, (String)"EqualNumberPanel.labelValue.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.labelValue, gridBagConstraints);
        this.valueSpinner.setPreferredSize(new Dimension(75, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.valueSpinner, gridBagConstraints);
        this.jLabel1.setFont(new Font("Tahoma", 0, 10));
        this.jLabel1.setText(NbBundle.getMessage(EqualNumberPanel.class, (String)"EqualNumberPanel.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setFont(new Font("Tahoma", 0, 10));
        this.jLabel2.setText(NbBundle.getMessage(EqualNumberPanel.class, (String)"EqualNumberPanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.minLabel.setFont(new Font("Tahoma", 0, 10));
        this.minLabel.setText(NbBundle.getMessage(EqualNumberPanel.class, (String)"EqualNumberPanel.minLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.minLabel, gridBagConstraints);
        this.maxLabel.setFont(new Font("Tahoma", 0, 10));
        this.maxLabel.setText(NbBundle.getMessage(EqualNumberPanel.class, (String)"EqualNumberPanel.maxLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.maxLabel, gridBagConstraints);
    }
}

