# -*- coding: utf-8 -*-
# Auto-generated by Stone, do not modify.
# flake8: noqa
# pylint: skip-file

from abc import ABCMeta, abstractmethod
import warnings

from . import (
    async,
    auth,
    common,
    files,
    paper,
    properties,
    sharing,
    team,
    team_common,
    team_log,
    team_policies,
    users,
    users_common,
)


class DropboxTeamBase(object):
    __metaclass__ = ABCMeta

    @abstractmethod
    def request(self, route, namespace, arg, arg_binary=None):
        pass

    # ------------------------------------------
    # Routes in team namespace

    def team_devices_list_member_devices(self,
                                         team_member_id,
                                         include_web_sessions=True,
                                         include_desktop_clients=True,
                                         include_mobile_clients=True):
        """
        List all device sessions of a team's member.

        :param str team_member_id: The team's member id
        :param bool include_web_sessions: Whether to list web sessions of the
            team's member
        :param bool include_desktop_clients: Whether to list linked desktop
            devices of the team's member
        :param bool include_mobile_clients: Whether to list linked mobile
            devices of the team's member
        :rtype: :class:`dropbox.team.ListMemberDevicesResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.ListMemberDevicesError`
        """
        arg = team.ListMemberDevicesArg(team_member_id,
                                        include_web_sessions,
                                        include_desktop_clients,
                                        include_mobile_clients)
        r = self.request(
            team.devices_list_member_devices,
            'team',
            arg,
            None,
        )
        return r

    def team_devices_list_members_devices(self,
                                          cursor=None,
                                          include_web_sessions=True,
                                          include_desktop_clients=True,
                                          include_mobile_clients=True):
        """
        List all device sessions of a team.

        :param Nullable cursor: At the first call to the
            :meth:`team_devices_list_members_devices` the cursor shouldn't be
            passed. Then, if the result of the call includes a cursor, the
            following requests should include the received cursors in order to
            receive the next sub list of team devices
        :param bool include_web_sessions: Whether to list web sessions of the
            team members
        :param bool include_desktop_clients: Whether to list desktop clients of
            the team members
        :param bool include_mobile_clients: Whether to list mobile clients of
            the team members
        :rtype: :class:`dropbox.team.ListMembersDevicesResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.ListMembersDevicesError`
        """
        arg = team.ListMembersDevicesArg(cursor,
                                         include_web_sessions,
                                         include_desktop_clients,
                                         include_mobile_clients)
        r = self.request(
            team.devices_list_members_devices,
            'team',
            arg,
            None,
        )
        return r

    def team_devices_list_team_devices(self,
                                       cursor=None,
                                       include_web_sessions=True,
                                       include_desktop_clients=True,
                                       include_mobile_clients=True):
        """
        List all device sessions of a team.

        :param Nullable cursor: At the first call to the
            :meth:`team_devices_list_team_devices` the cursor shouldn't be
            passed. Then, if the result of the call includes a cursor, the
            following requests should include the received cursors in order to
            receive the next sub list of team devices
        :param bool include_web_sessions: Whether to list web sessions of the
            team members
        :param bool include_desktop_clients: Whether to list desktop clients of
            the team members
        :param bool include_mobile_clients: Whether to list mobile clients of
            the team members
        :rtype: :class:`dropbox.team.ListTeamDevicesResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.ListTeamDevicesError`
        """
        warnings.warn(
            'devices/list_team_devices is deprecated. Use devices/list_members_devices.',
            DeprecationWarning,
        )
        arg = team.ListTeamDevicesArg(cursor,
                                      include_web_sessions,
                                      include_desktop_clients,
                                      include_mobile_clients)
        r = self.request(
            team.devices_list_team_devices,
            'team',
            arg,
            None,
        )
        return r

    def team_devices_revoke_device_session(self,
                                           arg):
        """
        Revoke a device session of a team's member

        :type arg: :class:`dropbox.team.RevokeDeviceSessionArg`
        :rtype: None
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.RevokeDeviceSessionError`
        """
        r = self.request(
            team.devices_revoke_device_session,
            'team',
            arg,
            None,
        )
        return None

    def team_devices_revoke_device_session_batch(self,
                                                 revoke_devices):
        """
        Revoke a list of device sessions of team members

        :type revoke_devices: list
        :rtype: :class:`dropbox.team.RevokeDeviceSessionBatchResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.RevokeDeviceSessionBatchError`
        """
        arg = team.RevokeDeviceSessionBatchArg(revoke_devices)
        r = self.request(
            team.devices_revoke_device_session_batch,
            'team',
            arg,
            None,
        )
        return r

    def team_features_get_values(self,
                                 features):
        """
        Get the values for one or more featues. This route allows you to check
        your account's capability for what feature you can access or what value
        you have for certain features. Permission : Team information.

        :param list features: A list of features in
            :class:`dropbox.team.Feature`. If the list is empty, this route will
            return :class:`dropbox.team.FeaturesGetValuesBatchError`.
        :rtype: :class:`dropbox.team.FeaturesGetValuesBatchResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.FeaturesGetValuesBatchError`
        """
        arg = team.FeaturesGetValuesBatchArg(features)
        r = self.request(
            team.features_get_values,
            'team',
            arg,
            None,
        )
        return r

    def team_get_info(self):
        """
        Retrieves information about a team.

        :rtype: :class:`dropbox.team.TeamGetInfoResult`
        """
        arg = None
        r = self.request(
            team.get_info,
            'team',
            arg,
            None,
        )
        return r

    def team_groups_create(self,
                           group_name,
                           group_external_id=None,
                           group_management_type=None):
        """
        Creates a new, empty group, with a requested name. Permission : Team
        member management.

        :param str group_name: Group name.
        :param Nullable group_external_id: The creator of a team can associate
            an arbitrary external ID to the group.
        :param Nullable group_management_type: Whether the team can be managed
            by selected users, or only by team admins.
        :rtype: :class:`dropbox.team.GroupFullInfo`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.GroupCreateError`
        """
        arg = team.GroupCreateArg(group_name,
                                  group_external_id,
                                  group_management_type)
        r = self.request(
            team.groups_create,
            'team',
            arg,
            None,
        )
        return r

    def team_groups_delete(self,
                           arg):
        """
        Deletes a group. The group is deleted immediately. However the revoking
        of group-owned resources may take additional time. Use the
        :meth:`team_groups_job_status_get` to determine whether this process has
        completed. Permission : Team member management.

        :param arg: Argument for selecting a single group, either by group_id or
            by external group ID.
        :type arg: :class:`dropbox.team.GroupSelector`
        :rtype: :class:`dropbox.team.LaunchEmptyResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.GroupDeleteError`
        """
        r = self.request(
            team.groups_delete,
            'team',
            arg,
            None,
        )
        return r

    def team_groups_get_info(self,
                             arg):
        """
        Retrieves information about one or more groups. Note that the optional
        field  ``GroupFullInfo.members`` is not returned for system-managed
        groups. Permission : Team Information.

        :param arg: Argument for selecting a list of groups, either by
            group_ids, or external group IDs.
        :type arg: :class:`dropbox.team.GroupsSelector`
        :rtype: list
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.GroupsGetInfoError`
        """
        r = self.request(
            team.groups_get_info,
            'team',
            arg,
            None,
        )
        return r

    def team_groups_job_status_get(self,
                                   async_job_id):
        """
        Once an async_job_id is returned from :meth:`team_groups_delete`,
        :meth:`team_groups_members_add` , or :meth:`team_groups_members_remove`
        use this method to poll the status of granting/revoking group members'
        access to group-owned resources. Permission : Team member management.

        :param str async_job_id: Id of the asynchronous job. This is the value
            of a response returned from the method that launched the job.
        :rtype: :class:`dropbox.team.PollEmptyResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.GroupsPollError`
        """
        arg = async.PollArg(async_job_id)
        r = self.request(
            team.groups_job_status_get,
            'team',
            arg,
            None,
        )
        return r

    def team_groups_list(self,
                         limit=1000):
        """
        Lists groups on a team. Permission : Team Information.

        :param long limit: Number of results to return per call.
        :rtype: :class:`dropbox.team.GroupsListResult`
        """
        arg = team.GroupsListArg(limit)
        r = self.request(
            team.groups_list,
            'team',
            arg,
            None,
        )
        return r

    def team_groups_list_continue(self,
                                  cursor):
        """
        Once a cursor has been retrieved from :meth:`team_groups_list`, use this
        to paginate through all groups. Permission : Team Information.

        :param str cursor: Indicates from what point to get the next set of
            groups.
        :rtype: :class:`dropbox.team.GroupsListResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.GroupsListContinueError`
        """
        arg = team.GroupsListContinueArg(cursor)
        r = self.request(
            team.groups_list_continue,
            'team',
            arg,
            None,
        )
        return r

    def team_groups_members_add(self,
                                group,
                                members,
                                return_members=True):
        """
        Adds members to a group. The members are added immediately. However the
        granting of group-owned resources may take additional time. Use the
        :meth:`team_groups_job_status_get` to determine whether this process has
        completed. Permission : Team member management.

        :param group: Group to which users will be added.
        :type group: :class:`dropbox.team.GroupSelector`
        :param list members: List of users to be added to the group.
        :rtype: :class:`dropbox.team.GroupMembersChangeResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.GroupMembersAddError`
        """
        arg = team.GroupMembersAddArg(group,
                                      members,
                                      return_members)
        r = self.request(
            team.groups_members_add,
            'team',
            arg,
            None,
        )
        return r

    def team_groups_members_list(self,
                                 group,
                                 limit=1000):
        """
        Lists members of a group. Permission : Team Information.

        :param group: The group whose members are to be listed.
        :type group: :class:`dropbox.team.GroupSelector`
        :param long limit: Number of results to return per call.
        :rtype: :class:`dropbox.team.GroupsMembersListResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.GroupSelectorError`
        """
        arg = team.GroupsMembersListArg(group,
                                        limit)
        r = self.request(
            team.groups_members_list,
            'team',
            arg,
            None,
        )
        return r

    def team_groups_members_list_continue(self,
                                          cursor):
        """
        Once a cursor has been retrieved from :meth:`team_groups_members_list`,
        use this to paginate through all members of the group. Permission : Team
        information.

        :param str cursor: Indicates from what point to get the next set of
            groups.
        :rtype: :class:`dropbox.team.GroupsMembersListResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.GroupsMembersListContinueError`
        """
        arg = team.GroupsMembersListContinueArg(cursor)
        r = self.request(
            team.groups_members_list_continue,
            'team',
            arg,
            None,
        )
        return r

    def team_groups_members_remove(self,
                                   group,
                                   users,
                                   return_members=True):
        """
        Removes members from a group. The members are removed immediately.
        However the revoking of group-owned resources may take additional time.
        Use the :meth:`team_groups_job_status_get` to determine whether this
        process has completed. This method permits removing the only owner of a
        group, even in cases where this is not possible via the web client.
        Permission : Team member management.

        :param group: Group from which users will be removed.
        :type group: :class:`dropbox.team.GroupSelector`
        :param list users: List of users to be removed from the group.
        :rtype: :class:`dropbox.team.GroupMembersChangeResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.GroupMembersRemoveError`
        """
        arg = team.GroupMembersRemoveArg(group,
                                         users,
                                         return_members)
        r = self.request(
            team.groups_members_remove,
            'team',
            arg,
            None,
        )
        return r

    def team_groups_members_set_access_type(self,
                                            group,
                                            user,
                                            access_type,
                                            return_members=True):
        """
        Sets a member's access type in a group. Permission : Team member
        management.

        :param access_type: New group access type the user will have.
        :type access_type: :class:`dropbox.team.GroupAccessType`
        :param bool return_members: Whether to return the list of members in the
            group.  Note that the default value will cause all the group members
            to be returned in the response. This may take a long time for large
            groups.
        :rtype: list
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.GroupMemberSetAccessTypeError`
        """
        arg = team.GroupMembersSetAccessTypeArg(group,
                                                user,
                                                access_type,
                                                return_members)
        r = self.request(
            team.groups_members_set_access_type,
            'team',
            arg,
            None,
        )
        return r

    def team_groups_update(self,
                           group,
                           return_members=True,
                           new_group_name=None,
                           new_group_external_id=None,
                           new_group_management_type=None):
        """
        Updates a group's name and/or external ID. Permission : Team member
        management.

        :param group: Specify a group.
        :type group: :class:`dropbox.team.GroupSelector`
        :param Nullable new_group_name: Optional argument. Set group name to
            this if provided.
        :param Nullable new_group_external_id: Optional argument. New group
            external ID. If the argument is None, the group's external_id won't
            be updated. If the argument is empty string, the group's external id
            will be cleared.
        :param Nullable new_group_management_type: Set new group management
            type, if provided.
        :rtype: :class:`dropbox.team.GroupFullInfo`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.GroupUpdateError`
        """
        arg = team.GroupUpdateArgs(group,
                                   return_members,
                                   new_group_name,
                                   new_group_external_id,
                                   new_group_management_type)
        r = self.request(
            team.groups_update,
            'team',
            arg,
            None,
        )
        return r

    def team_linked_apps_list_member_linked_apps(self,
                                                 team_member_id):
        """
        List all linked applications of the team member. Note, this endpoint
        does not list any team-linked applications.

        :param str team_member_id: The team member id
        :rtype: :class:`dropbox.team.ListMemberAppsResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.ListMemberAppsError`
        """
        arg = team.ListMemberAppsArg(team_member_id)
        r = self.request(
            team.linked_apps_list_member_linked_apps,
            'team',
            arg,
            None,
        )
        return r

    def team_linked_apps_list_members_linked_apps(self,
                                                  cursor=None):
        """
        List all applications linked to the team members' accounts. Note, this
        endpoint does not list any team-linked applications.

        :param Nullable cursor: At the first call to the
            :meth:`team_linked_apps_list_members_linked_apps` the cursor
            shouldn't be passed. Then, if the result of the call includes a
            cursor, the following requests should include the received cursors
            in order to receive the next sub list of the team applications
        :rtype: :class:`dropbox.team.ListMembersAppsResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.ListMembersAppsError`
        """
        arg = team.ListMembersAppsArg(cursor)
        r = self.request(
            team.linked_apps_list_members_linked_apps,
            'team',
            arg,
            None,
        )
        return r

    def team_linked_apps_list_team_linked_apps(self,
                                               cursor=None):
        """
        List all applications linked to the team members' accounts. Note, this
        endpoint doesn't list any team-linked applications.

        :param Nullable cursor: At the first call to the
            :meth:`team_linked_apps_list_team_linked_apps` the cursor shouldn't
            be passed. Then, if the result of the call includes a cursor, the
            following requests should include the received cursors in order to
            receive the next sub list of the team applications
        :rtype: :class:`dropbox.team.ListTeamAppsResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.ListTeamAppsError`
        """
        warnings.warn(
            'linked_apps/list_team_linked_apps is deprecated. Use linked_apps/list_members_linked_apps.',
            DeprecationWarning,
        )
        arg = team.ListTeamAppsArg(cursor)
        r = self.request(
            team.linked_apps_list_team_linked_apps,
            'team',
            arg,
            None,
        )
        return r

    def team_linked_apps_revoke_linked_app(self,
                                           app_id,
                                           team_member_id,
                                           keep_app_folder=True):
        """
        Revoke a linked application of the team member

        :param str app_id: The application's unique id
        :param str team_member_id: The unique id of the member owning the device
        :param bool keep_app_folder: Whether to keep the application dedicated
            folder (in case the application uses  one)
        :rtype: None
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.RevokeLinkedAppError`
        """
        arg = team.RevokeLinkedApiAppArg(app_id,
                                         team_member_id,
                                         keep_app_folder)
        r = self.request(
            team.linked_apps_revoke_linked_app,
            'team',
            arg,
            None,
        )
        return None

    def team_linked_apps_revoke_linked_app_batch(self,
                                                 revoke_linked_app):
        """
        Revoke a list of linked applications of the team members

        :type revoke_linked_app: list
        :rtype: :class:`dropbox.team.RevokeLinkedAppBatchResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.RevokeLinkedAppBatchError`
        """
        arg = team.RevokeLinkedApiAppBatchArg(revoke_linked_app)
        r = self.request(
            team.linked_apps_revoke_linked_app_batch,
            'team',
            arg,
            None,
        )
        return r

    def team_members_add(self,
                         new_members,
                         force_async=False):
        """
        Adds members to a team. Permission : Team member management A maximum of
        20 members can be specified in a single call. If no Dropbox account
        exists with the email address specified, a new Dropbox account will be
        created with the given email address, and that account will be invited
        to the team. If a personal Dropbox account exists with the email address
        specified in the call, this call will create a placeholder Dropbox
        account for the user on the team and send an email inviting the user to
        migrate their existing personal account onto the team. Team member
        management apps are required to set an initial given_name and surname
        for a user to use in the team invitation and for 'Perform as team
        member' actions taken on the user before they become 'active'.

        :param list new_members: Details of new members to be added to the team.
        :param bool force_async: Whether to force the add to happen
            asynchronously.
        :rtype: :class:`dropbox.team.MembersAddLaunch`
        """
        arg = team.MembersAddArg(new_members,
                                 force_async)
        r = self.request(
            team.members_add,
            'team',
            arg,
            None,
        )
        return r

    def team_members_add_job_status_get(self,
                                        async_job_id):
        """
        Once an async_job_id is returned from :meth:`team_members_add` , use
        this to poll the status of the asynchronous request. Permission : Team
        member management

        :param str async_job_id: Id of the asynchronous job. This is the value
            of a response returned from the method that launched the job.
        :rtype: :class:`dropbox.team.MembersAddJobStatus`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.PollError`
        """
        arg = async.PollArg(async_job_id)
        r = self.request(
            team.members_add_job_status_get,
            'team',
            arg,
            None,
        )
        return r

    def team_members_get_info(self,
                              members):
        """
        Returns information about multiple team members. Permission : Team
        information This endpoint will return
        ``MembersGetInfoItem.id_not_found``, for IDs (or emails) that cannot be
        matched to a valid team member.

        :param list members: List of team members.
        :rtype: list
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.MembersGetInfoError`
        """
        arg = team.MembersGetInfoArgs(members)
        r = self.request(
            team.members_get_info,
            'team',
            arg,
            None,
        )
        return r

    def team_members_list(self,
                          limit=1000,
                          include_removed=False):
        """
        Lists members of a team. Permission : Team information

        :param long limit: Number of results to return per call.
        :param bool include_removed: Whether to return removed members.
        :rtype: :class:`dropbox.team.MembersListResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.MembersListError`
        """
        arg = team.MembersListArg(limit,
                                  include_removed)
        r = self.request(
            team.members_list,
            'team',
            arg,
            None,
        )
        return r

    def team_members_list_continue(self,
                                   cursor):
        """
        Once a cursor has been retrieved from :meth:`team_members_list`, use
        this to paginate through all team members. Permission : Team information

        :param str cursor: Indicates from what point to get the next set of
            members.
        :rtype: :class:`dropbox.team.MembersListResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.MembersListContinueError`
        """
        arg = team.MembersListContinueArg(cursor)
        r = self.request(
            team.members_list_continue,
            'team',
            arg,
            None,
        )
        return r

    def team_members_recover(self,
                             user):
        """
        Recover a deleted member. Permission : Team member management Exactly
        one of team_member_id, email, or external_id must be provided to
        identify the user account.

        :param user: Identity of user to recover.
        :type user: :class:`dropbox.team.UserSelectorArg`
        :rtype: None
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.MembersRecoverError`
        """
        arg = team.MembersRecoverArg(user)
        r = self.request(
            team.members_recover,
            'team',
            arg,
            None,
        )
        return None

    def team_members_remove(self,
                            user,
                            wipe_data=True,
                            transfer_dest_id=None,
                            transfer_admin_id=None,
                            keep_account=False):
        """
        Removes a member from a team. Permission : Team member management
        Exactly one of team_member_id, email, or external_id must be provided to
        identify the user account. Accounts can be recovered via
        :meth:`team_members_recover` for a 7 day period or until the account has
        been permanently deleted or transferred to another account (whichever
        comes first). Calling :meth:`team_members_add` while a user is still
        recoverable on your team will return with
        ``MemberAddResult.user_already_on_team``. This endpoint may initiate an
        asynchronous job. To obtain the final result of the job, the client
        should periodically poll :meth:`team_members_remove_job_status_get`.

        :param Nullable transfer_dest_id: If provided, files from the deleted
            member account will be transferred to this user.
        :param Nullable transfer_admin_id: If provided, errors during the
            transfer process will be sent via email to this user. If the
            transfer_dest_id argument was provided, then this argument must be
            provided as well.
        :param bool keep_account: Downgrade the member to a Basic account. The
            user will retain the email address associated with their Dropbox
            account and data in their account that is not restricted to team
            members. In order to keep the account the argument wipe_data should
            be set to False.
        :rtype: :class:`dropbox.team.LaunchEmptyResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.MembersRemoveError`
        """
        arg = team.MembersRemoveArg(user,
                                    wipe_data,
                                    transfer_dest_id,
                                    transfer_admin_id,
                                    keep_account)
        r = self.request(
            team.members_remove,
            'team',
            arg,
            None,
        )
        return r

    def team_members_remove_job_status_get(self,
                                           async_job_id):
        """
        Once an async_job_id is returned from :meth:`team_members_remove` , use
        this to poll the status of the asynchronous request. Permission : Team
        member management

        :param str async_job_id: Id of the asynchronous job. This is the value
            of a response returned from the method that launched the job.
        :rtype: :class:`dropbox.team.PollEmptyResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.PollError`
        """
        arg = async.PollArg(async_job_id)
        r = self.request(
            team.members_remove_job_status_get,
            'team',
            arg,
            None,
        )
        return r

    def team_members_send_welcome_email(self,
                                        arg):
        """
        Sends welcome email to pending team member. Permission : Team member
        management Exactly one of team_member_id, email, or external_id must be
        provided to identify the user account. No-op if team member is not
        pending.

        :param arg: Argument for selecting a single user, either by
            team_member_id, external_id or email.
        :type arg: :class:`dropbox.team.UserSelectorArg`
        :rtype: None
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.MembersSendWelcomeError`
        """
        r = self.request(
            team.members_send_welcome_email,
            'team',
            arg,
            None,
        )
        return None

    def team_members_set_admin_permissions(self,
                                           user,
                                           new_role):
        """
        Updates a team member's permissions. Permission : Team member management

        :param user: Identity of user whose role will be set.
        :type user: :class:`dropbox.team.UserSelectorArg`
        :param new_role: The new role of the member.
        :type new_role: :class:`dropbox.team.AdminTier`
        :rtype: :class:`dropbox.team.MembersSetPermissionsResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.MembersSetPermissionsError`
        """
        arg = team.MembersSetPermissionsArg(user,
                                            new_role)
        r = self.request(
            team.members_set_admin_permissions,
            'team',
            arg,
            None,
        )
        return r

    def team_members_set_profile(self,
                                 user,
                                 new_email=None,
                                 new_external_id=None,
                                 new_given_name=None,
                                 new_surname=None,
                                 new_persistent_id=None):
        """
        Updates a team member's profile. Permission : Team member management

        :param user: Identity of user whose profile will be set.
        :type user: :class:`dropbox.team.UserSelectorArg`
        :param Nullable new_email: New email for member.
        :param Nullable new_external_id: New external ID for member.
        :param Nullable new_given_name: New given name for member.
        :param Nullable new_surname: New surname for member.
        :param Nullable new_persistent_id: New persistent ID. This field only
            available to teams using persistent ID SAML configuration.
        :rtype: :class:`dropbox.team.TeamMemberInfo`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.MembersSetProfileError`
        """
        arg = team.MembersSetProfileArg(user,
                                        new_email,
                                        new_external_id,
                                        new_given_name,
                                        new_surname,
                                        new_persistent_id)
        r = self.request(
            team.members_set_profile,
            'team',
            arg,
            None,
        )
        return r

    def team_members_suspend(self,
                             user,
                             wipe_data=True):
        """
        Suspend a member from a team. Permission : Team member management
        Exactly one of team_member_id, email, or external_id must be provided to
        identify the user account.

        :param user: Identity of user to remove/suspend.
        :type user: :class:`dropbox.team.UserSelectorArg`
        :param bool wipe_data: If provided, controls if the user's data will be
            deleted on their linked devices.
        :rtype: None
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.MembersSuspendError`
        """
        arg = team.MembersDeactivateArg(user,
                                        wipe_data)
        r = self.request(
            team.members_suspend,
            'team',
            arg,
            None,
        )
        return None

    def team_members_unsuspend(self,
                               user):
        """
        Unsuspend a member from a team. Permission : Team member management
        Exactly one of team_member_id, email, or external_id must be provided to
        identify the user account.

        :param user: Identity of user to unsuspend.
        :type user: :class:`dropbox.team.UserSelectorArg`
        :rtype: None
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.MembersUnsuspendError`
        """
        arg = team.MembersUnsuspendArg(user)
        r = self.request(
            team.members_unsuspend,
            'team',
            arg,
            None,
        )
        return None

    def team_properties_template_add(self,
                                     name,
                                     description,
                                     fields):
        """
        Add a property template. See route files/properties/add to add
        properties to a file.

        :rtype: :class:`dropbox.team.AddPropertyTemplateResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.ModifyPropertyTemplateError`
        """
        arg = team.AddPropertyTemplateArg(name,
                                          description,
                                          fields)
        r = self.request(
            team.properties_template_add,
            'team',
            arg,
            None,
        )
        return r

    def team_properties_template_get(self,
                                     template_id):
        """
        Get the schema for a specified template.

        :param str template_id: An identifier for property template added by
            route properties/template/add.
        :rtype: :class:`dropbox.team.GetPropertyTemplateResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.PropertyTemplateError`
        """
        arg = properties.GetPropertyTemplateArg(template_id)
        r = self.request(
            team.properties_template_get,
            'team',
            arg,
            None,
        )
        return r

    def team_properties_template_list(self):
        """
        Get the property template identifiers for a team. To get the schema of
        each template use :meth:`team_properties_template_get`.

        :rtype: :class:`dropbox.team.ListPropertyTemplateIds`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.PropertyTemplateError`
        """
        arg = None
        r = self.request(
            team.properties_template_list,
            'team',
            arg,
            None,
        )
        return r

    def team_properties_template_update(self,
                                        template_id,
                                        name=None,
                                        description=None,
                                        add_fields=None):
        """
        Update a property template. This route can update the template name, the
        template description and add optional properties to templates.

        :param str template_id: An identifier for property template added by
            :meth:`team_properties_template_add`.
        :param Nullable name: A display name for the property template. Property
            template names can be up to 256 bytes.
        :param Nullable description: Description for new property template.
            Property template descriptions can be up to 1024 bytes.
        :param Nullable add_fields: This is a list of custom properties to add
            to the property template. There can be up to 64 properties in a
            single property template.
        :rtype: :class:`dropbox.team.UpdatePropertyTemplateResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.ModifyPropertyTemplateError`
        """
        arg = team.UpdatePropertyTemplateArg(template_id,
                                             name,
                                             description,
                                             add_fields)
        r = self.request(
            team.properties_template_update,
            'team',
            arg,
            None,
        )
        return r

    def team_reports_get_activity(self,
                                  start_date=None,
                                  end_date=None):
        """
        Retrieves reporting data about a team's user activity.

        :param Nullable start_date: Optional starting date (inclusive)
        :param Nullable end_date: Optional ending date (exclusive)
        :rtype: :class:`dropbox.team.GetActivityReport`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.DateRangeError`
        """
        arg = team.DateRange(start_date,
                             end_date)
        r = self.request(
            team.reports_get_activity,
            'team',
            arg,
            None,
        )
        return r

    def team_reports_get_devices(self,
                                 start_date=None,
                                 end_date=None):
        """
        Retrieves reporting data about a team's linked devices.

        :param Nullable start_date: Optional starting date (inclusive)
        :param Nullable end_date: Optional ending date (exclusive)
        :rtype: :class:`dropbox.team.GetDevicesReport`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.DateRangeError`
        """
        arg = team.DateRange(start_date,
                             end_date)
        r = self.request(
            team.reports_get_devices,
            'team',
            arg,
            None,
        )
        return r

    def team_reports_get_membership(self,
                                    start_date=None,
                                    end_date=None):
        """
        Retrieves reporting data about a team's membership.

        :param Nullable start_date: Optional starting date (inclusive)
        :param Nullable end_date: Optional ending date (exclusive)
        :rtype: :class:`dropbox.team.GetMembershipReport`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.DateRangeError`
        """
        arg = team.DateRange(start_date,
                             end_date)
        r = self.request(
            team.reports_get_membership,
            'team',
            arg,
            None,
        )
        return r

    def team_reports_get_storage(self,
                                 start_date=None,
                                 end_date=None):
        """
        Retrieves reporting data about a team's storage usage.

        :param Nullable start_date: Optional starting date (inclusive)
        :param Nullable end_date: Optional ending date (exclusive)
        :rtype: :class:`dropbox.team.GetStorageReport`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.DateRangeError`
        """
        arg = team.DateRange(start_date,
                             end_date)
        r = self.request(
            team.reports_get_storage,
            'team',
            arg,
            None,
        )
        return r

    def team_team_folder_activate(self,
                                  team_folder_id):
        """
        Sets an archived team folder's status to active. Permission : Team
        member file access.

        :param str team_folder_id: The ID of the team folder.
        :rtype: :class:`dropbox.team.TeamFolderMetadata`
        """
        arg = team.TeamFolderIdArg(team_folder_id)
        r = self.request(
            team.team_folder_activate,
            'team',
            arg,
            None,
        )
        return r

    def team_team_folder_archive(self,
                                 team_folder_id,
                                 force_async_off=False):
        """
        Sets an active team folder's status to archived and removes all folder
        and file members. Permission : Team member file access.

        :param bool force_async_off: Whether to force the archive to happen
            synchronously.
        :rtype: :class:`dropbox.team.TeamFolderArchiveLaunch`
        """
        arg = team.TeamFolderArchiveArg(team_folder_id,
                                        force_async_off)
        r = self.request(
            team.team_folder_archive,
            'team',
            arg,
            None,
        )
        return r

    def team_team_folder_archive_check(self,
                                       async_job_id):
        """
        Returns the status of an asynchronous job for archiving a team folder.
        Permission : Team member file access.

        :param str async_job_id: Id of the asynchronous job. This is the value
            of a response returned from the method that launched the job.
        :rtype: :class:`dropbox.team.TeamFolderArchiveJobStatus`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.PollError`
        """
        arg = async.PollArg(async_job_id)
        r = self.request(
            team.team_folder_archive_check,
            'team',
            arg,
            None,
        )
        return r

    def team_team_folder_create(self,
                                name):
        """
        Creates a new, active, team folder. Permission : Team member file
        access.

        :param str name: Name for the new team folder.
        :rtype: :class:`dropbox.team.TeamFolderMetadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.TeamFolderCreateError`
        """
        arg = team.TeamFolderCreateArg(name)
        r = self.request(
            team.team_folder_create,
            'team',
            arg,
            None,
        )
        return r

    def team_team_folder_get_info(self,
                                  team_folder_ids):
        """
        Retrieves metadata for team folders. Permission : Team member file
        access.

        :param list team_folder_ids: The list of team folder IDs.
        :rtype: list
        """
        arg = team.TeamFolderIdListArg(team_folder_ids)
        r = self.request(
            team.team_folder_get_info,
            'team',
            arg,
            None,
        )
        return r

    def team_team_folder_list(self,
                              limit=1000):
        """
        Lists all team folders. Permission : Team member file access.

        :param long limit: The maximum number of results to return per request.
        :rtype: :class:`dropbox.team.TeamFolderListResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.TeamFolderListError`
        """
        arg = team.TeamFolderListArg(limit)
        r = self.request(
            team.team_folder_list,
            'team',
            arg,
            None,
        )
        return r

    def team_team_folder_list_continue(self,
                                       cursor):
        """
        Once a cursor has been retrieved from :meth:`team_team_folder_list`, use
        this to paginate through all team folders. Permission : Team member file
        access.

        :param str cursor: Indicates from what point to get the next set of team
            folders.
        :rtype: :class:`dropbox.team.TeamFolderListResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.TeamFolderListContinueError`
        """
        arg = team.TeamFolderListContinueArg(cursor)
        r = self.request(
            team.team_folder_list_continue,
            'team',
            arg,
            None,
        )
        return r

    def team_team_folder_permanently_delete(self,
                                            team_folder_id):
        """
        Permanently deletes an archived team folder. Permission : Team member
        file access.

        :param str team_folder_id: The ID of the team folder.
        :rtype: None
        """
        arg = team.TeamFolderIdArg(team_folder_id)
        r = self.request(
            team.team_folder_permanently_delete,
            'team',
            arg,
            None,
        )
        return None

    def team_team_folder_rename(self,
                                team_folder_id,
                                name):
        """
        Changes an active team folder's name. Permission : Team member file
        access.

        :param str name: New team folder name.
        :rtype: :class:`dropbox.team.TeamFolderMetadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.TeamFolderRenameError`
        """
        arg = team.TeamFolderRenameArg(team_folder_id,
                                       name)
        r = self.request(
            team.team_folder_rename,
            'team',
            arg,
            None,
        )
        return r

    def team_token_get_authenticated_admin(self):
        """
        Returns the member profile of the admin who generated the team access
        token used to make the call.

        :rtype: :class:`dropbox.team.TokenGetAuthenticatedAdminResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.team.TokenGetAuthenticatedAdminError`
        """
        arg = None
        r = self.request(
            team.token_get_authenticated_admin,
            'team',
            arg,
            None,
        )
        return r

