/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.event;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;

public class SelectionEventManager
implements DataSelectionListener,
MainLayerManager.ActiveLayerChangeListener {
    private static final SelectionEventManager INSTANCE = new SelectionEventManager();
    private final CopyOnWriteArrayList<ListenerInfo> inEDTListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerInfo> immedatelyListeners = new CopyOnWriteArrayList();

    public static SelectionEventManager getInstance() {
        return INSTANCE;
    }

    protected SelectionEventManager() {
        MainLayerManager mainLayerManager = Main.getLayerManager();
        mainLayerManager.addAndFireActiveLayerChangeListener(this);
    }

    public void addSelectionListener(SelectionChangedListener selectionChangedListener, DatasetEventManager.FireMode fireMode) {
        if (fireMode == DatasetEventManager.FireMode.IN_EDT) {
            throw new UnsupportedOperationException("IN_EDT mode not supported, you probably want to use IN_EDT_CONSOLIDATED.");
        }
        if (fireMode == DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED) {
            this.inEDTListeners.addIfAbsent(new OldListenerInfo(selectionChangedListener));
        } else {
            this.immedatelyListeners.addIfAbsent(new OldListenerInfo(selectionChangedListener));
        }
    }

    public void addSelectionListener(DataSelectionListener dataSelectionListener) {
        this.immedatelyListeners.addIfAbsent(new DataListenerInfo(dataSelectionListener));
    }

    public void addSelectionListenerForEdt(DataSelectionListener dataSelectionListener) {
        this.inEDTListeners.addIfAbsent(new DataListenerInfo(dataSelectionListener));
    }

    public void removeSelectionListener(SelectionChangedListener selectionChangedListener) {
        this.remove(new OldListenerInfo(selectionChangedListener));
    }

    public void removeSelectionListener(DataSelectionListener dataSelectionListener) {
        this.remove(new DataListenerInfo(dataSelectionListener));
    }

    private void remove(ListenerInfo listenerInfo) {
        this.inEDTListeners.remove(listenerInfo);
        this.immedatelyListeners.remove(listenerInfo);
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent activeLayerChangeEvent) {
        Object object;
        DataSet dataSet = activeLayerChangeEvent.getPreviousEditDataSet();
        if (dataSet != null) {
            object = new DataSelectionListener.SelectionReplaceEvent(dataSet, new HashSet<OsmPrimitive>(dataSet.getAllSelected()), Stream.empty());
            this.selectionChanged((DataSelectionListener.SelectionChangeEvent)object);
            dataSet.removeSelectionListener(this);
        }
        if ((object = activeLayerChangeEvent.getSource().getEditDataSet()) != null) {
            ((DataSet)object).addSelectionListener(this);
            DataSelectionListener.SelectionReplaceEvent selectionReplaceEvent = new DataSelectionListener.SelectionReplaceEvent((DataSet)object, Collections.emptySet(), ((DataSet)object).getAllSelected().stream());
            this.selectionChanged(selectionReplaceEvent);
        }
    }

    @Override
    public void selectionChanged(DataSelectionListener.SelectionChangeEvent selectionChangeEvent) {
        SelectionEventManager.fireEvent(this.immedatelyListeners, selectionChangeEvent);
        SwingUtilities.invokeLater(() -> SelectionEventManager.fireEvent(this.inEDTListeners, selectionChangeEvent));
    }

    private static void fireEvent(List<ListenerInfo> list, DataSelectionListener.SelectionChangeEvent selectionChangeEvent) {
        for (ListenerInfo listenerInfo : list) {
            listenerInfo.fire(selectionChangeEvent);
        }
    }

    public void resetState() {
        this.inEDTListeners.clear();
        this.immedatelyListeners.clear();
        Main.getLayerManager().addAndFireActiveLayerChangeListener(this);
    }

    private static class DataListenerInfo
    implements ListenerInfo {
        private final DataSelectionListener listener;

        DataListenerInfo(DataSelectionListener dataSelectionListener) {
            this.listener = dataSelectionListener;
        }

        @Override
        public void fire(DataSelectionListener.SelectionChangeEvent selectionChangeEvent) {
            this.listener.selectionChanged(selectionChangeEvent);
        }

        public int hashCode() {
            return Objects.hash(this.listener);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            DataListenerInfo dataListenerInfo = (DataListenerInfo)object;
            return Objects.equals(this.listener, dataListenerInfo.listener);
        }
    }

    private static class OldListenerInfo
    implements ListenerInfo {
        private final SelectionChangedListener listener;

        OldListenerInfo(SelectionChangedListener selectionChangedListener) {
            this.listener = selectionChangedListener;
        }

        @Override
        public void fire(DataSelectionListener.SelectionChangeEvent selectionChangeEvent) {
            this.listener.selectionChanged(selectionChangeEvent.getSelection());
        }

        public int hashCode() {
            return Objects.hash(this.listener);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            OldListenerInfo oldListenerInfo = (OldListenerInfo)object;
            return Objects.equals(this.listener, oldListenerInfo.listener);
        }
    }

    private static interface ListenerInfo {
        public void fire(DataSelectionListener.SelectionChangeEvent var1);
    }
}

