/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projecting;
import org.openstreetmap.josm.data.projection.Projection;

public class ShiftedProjecting
implements Projecting {
    private final Projecting base;
    private final EastNorth offset;

    public ShiftedProjecting(Projecting projecting, EastNorth eastNorth) {
        this.base = projecting;
        this.offset = eastNorth;
    }

    @Override
    public EastNorth latlon2eastNorth(ILatLon iLatLon) {
        return this.base.latlon2eastNorth(iLatLon).add(this.offset);
    }

    @Override
    public LatLon eastNorth2latlonClamped(EastNorth eastNorth) {
        return this.base.eastNorth2latlonClamped(eastNorth.subtract(this.offset));
    }

    @Override
    public Projection getBaseProjection() {
        return this.base.getBaseProjection();
    }

    @Override
    public Map<ProjectionBounds, Projecting> getProjectingsForArea(ProjectionBounds projectionBounds2) {
        Map<ProjectionBounds, Projecting> map = this.base.getProjectingsForArea(new ProjectionBounds(projectionBounds2.getMin().subtract(this.offset), projectionBounds2.getMax().subtract(this.offset)));
        HashMap<ProjectionBounds, Projecting> hashMap = new HashMap<ProjectionBounds, Projecting>();
        map.forEach((projectionBounds, projecting) -> {
            Projecting cfr_ignored_0 = hashMap.put(new ProjectionBounds(projectionBounds.getMin().add(this.offset), projectionBounds.getMax().add(this.offset)), new ShiftedProjecting((Projecting)projecting, this.offset));
        });
        return hashMap;
    }
}

