/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement;

import java.util.Objects;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.TextLabel;
import org.openstreetmap.josm.gui.mappaint.styleelement.placement.CompletelyInsideAreaStrategy;
import org.openstreetmap.josm.gui.mappaint.styleelement.placement.PositionForAreaStrategy;

public class TextElement
extends StyleElement {
    private final TextLabel text;
    private final PositionForAreaStrategy labelPositionStrategy;

    protected TextElement(Cascade cascade, TextLabel textLabel, PositionForAreaStrategy positionForAreaStrategy) {
        super(cascade, 4.9f);
        this.text = Objects.requireNonNull(textLabel, "text");
        this.labelPositionStrategy = Objects.requireNonNull(positionForAreaStrategy, "labelPositionStrategy");
    }

    public PositionForAreaStrategy getLabelPositionStrategy() {
        return this.labelPositionStrategy;
    }

    public static TextElement create(Environment environment) {
        TextLabel textLabel = TextLabel.create(environment, PaintColors.TEXT.get(), false);
        if (textLabel == null) {
            return null;
        }
        Cascade cascade = environment.mc.getCascade(environment.layer);
        Keyword keyword = cascade.get("text-position", null, Keyword.class);
        PositionForAreaStrategy positionForAreaStrategy = PositionForAreaStrategy.forKeyword(keyword);
        positionForAreaStrategy = positionForAreaStrategy.withAddedOffset(TextLabel.getTextOffset(cascade));
        return new TextElement(cascade, textLabel, positionForAreaStrategy);
    }

    public static TextElement createForContent(Environment environment) {
        Cascade cascade = environment.mc.getCascade(environment.layer);
        Keyword keyword = cascade.get("text-position", null, Keyword.class);
        if (keyword != null) {
            return null;
        }
        TextLabel textLabel = TextLabel.create(environment, PaintColors.TEXT.get(), true);
        if (textLabel == null) {
            return null;
        }
        return new TextElement(cascade, textLabel, CompletelyInsideAreaStrategy.INSTANCE);
    }

    @Override
    public void paintPrimitive(OsmPrimitive osmPrimitive, MapPaintSettings mapPaintSettings, StyledMapRenderer styledMapRenderer, boolean bl, boolean bl2, boolean bl3) {
        styledMapRenderer.drawText(osmPrimitive, this.text, this.getLabelPositionStrategy());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        TextElement textElement = (TextElement)object;
        return Objects.equals(this.labelPositionStrategy, textElement.labelPositionStrategy) && Objects.equals(this.text, textElement.text);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.text, this.labelPositionStrategy);
    }

    @Override
    public String toString() {
        return "TextElement{" + super.toString() + "text=" + this.text + " labelPositionStrategy=" + this.labelPositionStrategy + '}';
    }
}

