/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.progress;

import java.awt.Component;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.progress.AbstractProgressMonitor;
import org.openstreetmap.josm.gui.progress.CancelHandler;
import org.openstreetmap.josm.gui.progress.ProgressRenderer;
import org.openstreetmap.josm.gui.progress.ProgressTaskId;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class SwingRenderingProgressMonitor
extends AbstractProgressMonitor {
    private static final int PROGRESS_BAR_MAX = 100;
    private int currentProgressValue;
    private final ProgressRenderer delegate;

    public SwingRenderingProgressMonitor(ProgressRenderer progressRenderer) {
        super(new CancelHandler());
        CheckParameterUtil.ensureParameterNotNull(progressRenderer, "delegate");
        this.delegate = progressRenderer;
    }

    @Override
    public void doBeginTask() {
        GuiHelper.runInEDT(() -> {
            this.delegate.setCustomText("");
            this.delegate.setMaximum(100);
        });
    }

    @Override
    public void doFinishTask() {
    }

    @Override
    protected void updateProgress(double d) {
        int n = (int)(d * 100.0);
        if (n != this.currentProgressValue) {
            this.currentProgressValue = n;
            GuiHelper.runInEDT(() -> this.delegate.setValue(this.currentProgressValue));
        }
    }

    @Override
    protected void doSetCustomText(String string) {
        this.checkState(AbstractProgressMonitor.State.IN_TASK, AbstractProgressMonitor.State.IN_SUBTASK);
        GuiHelper.runInEDT(() -> this.delegate.setCustomText(string));
    }

    @Override
    protected void doSetTitle(String string) {
        this.checkState(AbstractProgressMonitor.State.IN_TASK, AbstractProgressMonitor.State.IN_SUBTASK);
        GuiHelper.runInEDT(() -> this.delegate.setTaskTitle(string));
    }

    @Override
    protected void doSetIntermediate(boolean bl) {
        GuiHelper.runInEDT(() -> this.delegate.setIndeterminate(bl));
    }

    @Override
    public void setProgressTaskId(ProgressTaskId progressTaskId) {
    }

    @Override
    public ProgressTaskId getProgressTaskId() {
        return null;
    }

    @Override
    public Component getWindowParent() {
        return Main.parent;
    }
}

