/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.runtime;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Map;
import org.jcodings.Encoding;
import org.jruby.EvalType;
import org.jruby.MetaClass;
import org.jruby.NativeException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyMatchData;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyProc;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.Unrescuable;
import org.jruby.internal.runtime.AbstractIRMethod;
import org.jruby.internal.runtime.methods.CompiledIRMethod;
import org.jruby.internal.runtime.methods.CompiledIRNoProtocolMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.InterpretedIRBodyMethod;
import org.jruby.internal.runtime.methods.InterpretedIRMetaClassBody;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.internal.runtime.methods.MixedModeIRMethod;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRMetaClassBody;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.Interp;
import org.jruby.ir.JIT;
import org.jruby.ir.Tuple;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Splat;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.persistence.IRReader;
import org.jruby.ir.persistence.IRReaderStream;
import org.jruby.ir.runtime.IRBreakJump;
import org.jruby.ir.runtime.IRReturnJump;
import org.jruby.ir.runtime.IRWrappedLambdaReturnValue;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.runtime.callsite.FunctionalCachingCallSite;
import org.jruby.runtime.callsite.NormalCachingCallSite;
import org.jruby.runtime.callsite.RefinedCachingCallSite;
import org.jruby.runtime.callsite.VariableCachingCallSite;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.util.ArraySupport;
import org.jruby.util.ByteList;
import org.jruby.util.RegexpOptions;
import org.jruby.util.TypeConverter;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class IRRuntimeHelpers {
    private static final Logger LOG = LoggerFactory.getLogger(IRRuntimeHelpers.class);
    private static final RubyHash.VisitorWithState<Tuple<RubyHash, RubyHash>> DivvyKeywordsVisitor = new RubyHash.VisitorWithState<Tuple<RubyHash, RubyHash>>(){

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Tuple<RubyHash, RubyHash> hashes) {
            if (key2 instanceof RubySymbol) {
                ((RubyHash)hashes.a).op_aset(context, key2, value2);
            } else {
                ((RubyHash)hashes.b).op_aset(context, key2, value2);
            }
        }
    };
    private static final InvalidKeyException INVALID_KEY_EXCEPTION = new InvalidKeyException();
    private static final RubyHash.VisitorWithState<StaticScope> CheckUnwantedKeywordsVisitor = new RubyHash.VisitorWithState<StaticScope>(){

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, StaticScope scope) {
            String javaName = key2.asJavaString();
            if (!scope.keywordExists(javaName)) {
                throw INVALID_KEY_EXCEPTION;
            }
        }
    };

    public static boolean inProfileMode() {
        return RubyInstanceConfig.IR_PROFILE;
    }

    public static boolean isDebug() {
        return RubyInstanceConfig.IR_DEBUG;
    }

    public static boolean inNonMethodBodyLambda(StaticScope scope, Block.Type blockType) {
        return blockType == Block.Type.LAMBDA && !scope.isArgumentScope();
    }

    public static boolean inLambda(Block.Type blockType) {
        return blockType == Block.Type.LAMBDA;
    }

    public static boolean inProc(Block.Type blockType) {
        return blockType == Block.Type.PROC;
    }

    public static void checkForLJE(ThreadContext context, DynamicScope dynScope, boolean definedWithinMethod, Block.Type blockType) {
        boolean inDefineMethod;
        if (IRRuntimeHelpers.inLambda(blockType)) {
            return;
        }
        boolean bl = inDefineMethod = (dynScope = IRRuntimeHelpers.getContainingMethodsDynamicScope(dynScope)) != null && dynScope.getStaticScope().isArgumentScope() && dynScope.getStaticScope().getScopeType().isBlock();
        if (!definedWithinMethod && !inDefineMethod || !context.scopeExistsOnCallStack(dynScope)) {
            throw IRException.RETURN_LocalJumpError.getException(context.runtime);
        }
    }

    public static IRubyObject initiateNonLocalReturn(ThreadContext context, DynamicScope dynScope, Block.Type blockType, IRubyObject returnValue) {
        if (IRRuntimeHelpers.inLambda(blockType)) {
            throw new IRWrappedLambdaReturnValue(returnValue);
        }
        throw IRReturnJump.create(IRRuntimeHelpers.getContainingMethodOrLambdasDynamicScope(dynScope), returnValue);
    }

    private static DynamicScope getContainingMethodsDynamicScope(DynamicScope dynScope) {
        while (dynScope != null) {
            StaticScope scope = dynScope.getStaticScope();
            IRScopeType scopeType = scope.getScopeType();
            if (scopeType.isMethodType() || scopeType.isBlock() && scope.isArgumentScope()) {
                return dynScope;
            }
            dynScope = dynScope.getParentScope();
        }
        return null;
    }

    private static DynamicScope getContainingMethodOrLambdasDynamicScope(DynamicScope dynScope) {
        while (dynScope != null) {
            StaticScope staticScope = dynScope.getStaticScope();
            IRScope scope = staticScope.getIRScope();
            if (scope instanceof IRMethod || scope instanceof IRClosure && (dynScope.isLambda() || staticScope.isArgumentScope())) {
                return dynScope;
            }
            dynScope = dynScope.getParentScope();
        }
        return null;
    }

    @JIT
    public static IRubyObject handleNonlocalReturn(StaticScope scope, DynamicScope dynScope, Object rjExc, Block.Type blockType) throws RuntimeException {
        if (!(rjExc instanceof IRReturnJump)) {
            Helpers.throwException((Throwable)rjExc);
            return null;
        }
        IRReturnJump rj = (IRReturnJump)rjExc;
        if (rj.methodToReturnFrom == dynScope) {
            if (IRRuntimeHelpers.isDebug()) {
                System.out.println("---> Non-local Return reached target in scope: " + dynScope);
            }
            return (IRubyObject)rj.returnValue;
        }
        throw rj;
    }

    private static IRScopeType ensureScopeIsClosure(ThreadContext context, DynamicScope dynamicScope) {
        IRScopeType scopeType = dynamicScope.getStaticScope().getScopeType();
        if (!scopeType.isClosureType()) {
            throw IRException.BREAK_LocalJumpError.getException(context.runtime);
        }
        return scopeType;
    }

    public static IRubyObject initiateBreak(ThreadContext context, DynamicScope dynScope, IRubyObject breakValue, Block.Type blockType) throws RuntimeException {
        if (IRRuntimeHelpers.inLambda(blockType)) {
            throw new IRWrappedLambdaReturnValue(breakValue);
        }
        IRScopeType scopeType = IRRuntimeHelpers.ensureScopeIsClosure(context, dynScope);
        throw IRBreakJump.create(dynScope.getParentScope(), breakValue, scopeType.isEval());
    }

    private static boolean inReturnScope(Block.Type blockType, IRReturnJump exception2, DynamicScope dynScope) {
        return (blockType == null || IRRuntimeHelpers.inLambda(blockType)) && exception2.methodToReturnFrom == dynScope;
    }

    @JIT
    public static IRubyObject handleBreakAndReturnsInLambdas(ThreadContext context, StaticScope scope, DynamicScope dynScope, Object exc, Block.Type blockType) throws RuntimeException {
        if (exc instanceof IRWrappedLambdaReturnValue) {
            return ((IRWrappedLambdaReturnValue)exc).returnValue;
        }
        if (exc instanceof IRReturnJump && IRRuntimeHelpers.inReturnScope(blockType, (IRReturnJump)exc, dynScope)) {
            if (IRRuntimeHelpers.isDebug()) {
                System.out.println("---> Non-local Return reached target in scope: " + dynScope);
            }
            return (IRubyObject)((IRReturnJump)exc).returnValue;
        }
        context.setSavedExceptionInLambda((Throwable)exc);
        return null;
    }

    @JIT
    public static IRubyObject returnOrRethrowSavedException(ThreadContext context, IRubyObject value2) {
        Throwable exc = context.getSavedExceptionInLambda();
        if (exc != null) {
            context.setSavedExceptionInLambda(null);
            Helpers.throwException(exc);
        }
        return value2;
    }

    @JIT
    public static IRubyObject handlePropagatedBreak(ThreadContext context, DynamicScope dynScope, Object bjExc, Block.Type blockType) {
        if (!(bjExc instanceof IRBreakJump)) {
            Helpers.throwException((Throwable)bjExc);
            return null;
        }
        IRBreakJump bj = (IRBreakJump)bjExc;
        if (bj.breakInEval) {
            IRRuntimeHelpers.ensureScopeIsClosure(context, dynScope);
            bj.breakInEval = false;
            throw bj;
        }
        if (bj.scopeToReturnTo == dynScope) {
            if (IRRuntimeHelpers.isDebug()) {
                System.out.println("---> Break reached target in scope: " + dynScope);
            }
            return bj.breakValue;
        }
        throw bj;
    }

    public static IRubyObject undefMethod(ThreadContext context, Object nameArg, DynamicScope currDynScope, IRubyObject self2) {
        String name2;
        RubyModule module = IRRuntimeHelpers.findInstanceMethodContainer(context, currDynScope, self2);
        String string2 = name2 = nameArg instanceof String ? (String)nameArg : nameArg.toString();
        if (module == null) {
            throw context.runtime.newTypeError("No class to undef method '" + name2 + "'.");
        }
        module.undef(context, name2);
        return context.nil;
    }

    public static double unboxFloat(IRubyObject val) {
        if (val instanceof RubyFloat) {
            return ((RubyFloat)val).getValue();
        }
        return ((RubyFixnum)val).getDoubleValue();
    }

    public static long unboxFixnum(IRubyObject val) {
        if (val instanceof RubyFloat) {
            return (long)((RubyFloat)val).getValue();
        }
        return ((RubyFixnum)val).getLongValue();
    }

    public static boolean flt(double v1, double v2) {
        return v1 < v2;
    }

    public static boolean fgt(double v1, double v2) {
        return v1 > v2;
    }

    public static boolean feq(double v1, double v2) {
        return v1 == v2;
    }

    public static boolean ilt(long v1, long v2) {
        return v1 < v2;
    }

    public static boolean igt(long v1, long v2) {
        return v1 > v2;
    }

    public static boolean ieq(long v1, long v2) {
        return v1 == v2;
    }

    public static Object unwrapRubyException(Object excObj) {
        if (excObj instanceof Unrescuable) {
            Helpers.throwException((Throwable)excObj);
        }
        return excObj instanceof RaiseException ? ((RaiseException)excObj).getException() : excObj;
    }

    private static boolean isJavaExceptionHandled(ThreadContext context, IRubyObject excType, Object excObj, boolean arrayCheck) {
        if (!(excObj instanceof Throwable)) {
            return false;
        }
        Ruby runtime = context.runtime;
        Throwable ex = (Throwable)excObj;
        if (excType instanceof RubyArray) {
            RubyArray testTypes = (RubyArray)excType;
            int n = testTypes.getLength();
            for (int i2 = 0; i2 < n; ++i2) {
                IRubyObject testType = testTypes.eltInternal(i2);
                if (!IRRuntimeHelpers.isJavaExceptionHandled(context, testType, ex, true)) continue;
                IRubyObject exception2 = n == 1 ? IRRuntimeHelpers.wrapJavaException(context, testType, ex) : Helpers.wrapJavaException(runtime, ex);
                runtime.getGlobalVariables().set("$!", exception2);
                return true;
            }
        } else {
            IRubyObject exception3 = IRRuntimeHelpers.wrapJavaException(context, excType, ex);
            if (Helpers.checkJavaException(exception3, ex, excType, context)) {
                runtime.getGlobalVariables().set("$!", exception3);
                return true;
            }
        }
        return false;
    }

    private static IRubyObject wrapJavaException(ThreadContext context, IRubyObject excType, Throwable throwable) {
        Ruby runtime = context.runtime;
        if (excType == runtime.getNativeException()) {
            NativeException exception2 = new NativeException(runtime, runtime.getNativeException(), throwable);
            exception2.prepareIntegratedBacktrace(context, throwable.getStackTrace());
            return exception2;
        }
        return Helpers.wrapJavaException(runtime, throwable);
    }

    private static boolean isRubyExceptionHandled(ThreadContext context, IRubyObject excType, Object excObj) {
        if (excType instanceof RubyArray) {
            RubyArray testTypes = (RubyArray)excType;
            int n = testTypes.getLength();
            for (int i2 = 0; i2 < n; ++i2) {
                IRubyObject testType = testTypes.eltInternal(i2);
                if (!IRRuntimeHelpers.isRubyExceptionHandled(context, testType, excObj)) continue;
                context.runtime.getGlobalVariables().set("$!", (IRubyObject)excObj);
                return true;
            }
        } else if (excObj instanceof IRubyObject) {
            if (!(excType instanceof RubyModule)) {
                throw context.runtime.newTypeError("class or module required for rescue clause. Found: " + excType);
            }
            if (excType.callMethod(context, "===", (IRubyObject)excObj).isTrue()) {
                context.runtime.getGlobalVariables().set("$!", (IRubyObject)excObj);
                return true;
            }
        }
        return false;
    }

    public static IRubyObject isExceptionHandled(ThreadContext context, IRubyObject excType, Object excObj) {
        boolean ret = IRRuntimeHelpers.isRubyExceptionHandled(context, excType, excObj = IRRuntimeHelpers.unwrapRubyException(excObj)) || IRRuntimeHelpers.isJavaExceptionHandled(context, excType, excObj, false);
        return context.runtime.newBoolean(ret);
    }

    public static IRubyObject isEQQ(ThreadContext context, IRubyObject receiver2, IRubyObject value2, CallSite callSite, boolean splattedValue) {
        boolean isUndefValue;
        boolean bl = isUndefValue = value2 == UndefinedValue.UNDEFINED;
        if (splattedValue && receiver2 instanceof RubyArray) {
            RubyArray testVals = (RubyArray)receiver2;
            int n = testVals.getLength();
            for (int i2 = 0; i2 < n; ++i2) {
                IRubyObject eqqVal;
                IRubyObject v = testVals.eltInternal(i2);
                IRubyObject iRubyObject = eqqVal = isUndefValue ? v : callSite.call(context, v, v, value2);
                if (!eqqVal.isTrue()) continue;
                return eqqVal;
            }
            return context.runtime.getFalse();
        }
        return isUndefValue ? receiver2 : callSite.call(context, receiver2, receiver2, value2);
    }

    @Deprecated
    public static IRubyObject isEQQ(ThreadContext context, IRubyObject receiver2, IRubyObject value2, CallSite callSite) {
        return IRRuntimeHelpers.isEQQ(context, receiver2, value2, callSite, true);
    }

    public static IRubyObject newProc(Ruby runtime, Block block) {
        return block == Block.NULL_BLOCK ? runtime.getNil() : runtime.newProc(Block.Type.PROC, block);
    }

    public static IRubyObject yield(ThreadContext context, Block b2, IRubyObject yieldVal, boolean unwrapArray) {
        return unwrapArray && yieldVal instanceof RubyArray ? b2.yieldArray(context, yieldVal, null) : b2.yield(context, yieldVal);
    }

    public static IRubyObject yieldSpecific(ThreadContext context, Block b2) {
        return b2.yieldSpecific(context);
    }

    public static IRubyObject[] convertValueIntoArgArray(ThreadContext context, IRubyObject value2, Signature signature, boolean argIsArray) {
        if (argIsArray && !(value2 instanceof RubyArray)) {
            argIsArray = false;
        }
        switch (signature.arityValue()) {
            case -1: {
                IRubyObject[] iRubyObjectArray;
                if (argIsArray || signature.opt() > 1 && value2 instanceof RubyArray) {
                    iRubyObjectArray = ((RubyArray)value2).toJavaArray();
                } else {
                    IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
                    iRubyObjectArray = iRubyObjectArray2;
                    iRubyObjectArray2[0] = value2;
                }
                return iRubyObjectArray;
            }
            case 0: {
                return new IRubyObject[]{value2};
            }
            case 1: {
                RubyArray valArray;
                if (argIsArray && (valArray = (RubyArray)value2).size() == 0) {
                    value2 = RubyArray.newEmptyArray(context.runtime);
                }
                return new IRubyObject[]{value2};
            }
        }
        if (argIsArray) {
            IRubyObject[] iRubyObjectArray;
            RubyArray valArray = (RubyArray)value2;
            if (valArray.size() == 1) {
                value2 = valArray.eltInternal(0);
            }
            if ((value2 = Helpers.aryToAry(value2)) instanceof RubyArray) {
                iRubyObjectArray = ((RubyArray)value2).toJavaArray();
            } else {
                IRubyObject[] iRubyObjectArray3 = new IRubyObject[1];
                iRubyObjectArray = iRubyObjectArray3;
                iRubyObjectArray3[0] = value2;
            }
            return iRubyObjectArray;
        }
        IRubyObject val0 = Helpers.aryToAry(value2);
        if (val0.isNil()) {
            return new IRubyObject[]{value2};
        }
        if (!(val0 instanceof RubyArray)) {
            throw context.runtime.newTypeError(value2.getType().getName() + "#to_ary should return Array");
        }
        return ((RubyArray)val0).toJavaArray();
    }

    @JIT
    public static Block getBlockFromObject(ThreadContext context, Object value2) {
        Block block;
        if (value2 instanceof Block) {
            block = (Block)value2;
        } else if (value2 instanceof RubyProc) {
            block = ((RubyProc)value2).getBlock();
        } else if (value2 instanceof RubyMethod) {
            block = ((RubyProc)((RubyMethod)value2).to_proc(context)).getBlock();
        } else if (value2 instanceof IRubyObject && ((IRubyObject)value2).isNil()) {
            block = Block.NULL_BLOCK;
        } else if (value2 instanceof IRubyObject) {
            block = ((RubyProc)TypeConverter.convertToType((IRubyObject)value2, context.runtime.getProc(), "to_proc", true)).getBlock();
        } else {
            throw new RuntimeException("Unhandled case in CallInstr:prepareBlock.  Got block arg: " + value2);
        }
        return block;
    }

    public static void checkArity(ThreadContext context, StaticScope scope, Object[] args2, int required, int opt, boolean rest2, boolean receivesKwargs, int restKey, Block.Type blockType) {
        int argsLength = args2.length;
        RubyHash keywordArgs = IRRuntimeHelpers.extractKwargsHash(args2, required, receivesKwargs);
        if (restKey == -1 && keywordArgs != null) {
            IRRuntimeHelpers.checkForExtraUnwantedKeywordArgs(context, scope, keywordArgs);
        }
        if (keywordArgs != null) {
            --argsLength;
        }
        if ((blockType == null || blockType.checkArity) && (argsLength < required || !rest2 && argsLength > required + opt)) {
            Arity.raiseArgumentError(context.runtime, argsLength, required, required + opt);
        }
    }

    public static IRubyObject[] frobnicateKwargsArgument(ThreadContext context, IRubyObject[] args2, int requiredArgsCount) {
        if (args2.length <= requiredArgsCount) {
            return args2;
        }
        IRubyObject kwargs = IRRuntimeHelpers.toHash(args2[args2.length - 1], context);
        if (kwargs != null) {
            if (kwargs.isNil()) {
                return ArraySupport.newCopy(args2, RubyHash.newSmallHash(context.runtime));
            }
            Tuple<RubyHash, RubyHash> hashes = new Tuple<RubyHash, RubyHash>(RubyHash.newSmallHash(context.runtime), RubyHash.newSmallHash(context.runtime));
            ((RubyHash)kwargs).visitAll(context, DivvyKeywordsVisitor, hashes);
            if (!((RubyHash)hashes.b).isEmpty()) {
                IRubyObject[] newArgs = new IRubyObject[args2.length + 1];
                System.arraycopy(args2, 0, newArgs, 0, args2.length);
                args2 = newArgs;
                args2[args2.length - 2] = (IRubyObject)hashes.b;
            }
            args2[args2.length - 1] = (IRubyObject)hashes.a;
        }
        return args2;
    }

    private static IRubyObject toHash(IRubyObject lastArg, ThreadContext context) {
        if (lastArg instanceof RubyHash) {
            return (RubyHash)lastArg;
        }
        if (lastArg.respondsTo("to_hash")) {
            if (context == null) {
                context = lastArg.getRuntime().getCurrentContext();
            }
            if ((lastArg = lastArg.callMethod(context, "to_hash")).isNil()) {
                return lastArg;
            }
            TypeConverter.checkType(context, lastArg, context.runtime.getHash());
            return (RubyHash)lastArg;
        }
        return null;
    }

    public static RubyHash extractKwargsHash(Object[] args2, int requiredArgsCount, boolean receivesKwargs) {
        IRubyObject returnValue;
        if (!receivesKwargs) {
            return null;
        }
        if (args2.length <= requiredArgsCount) {
            return null;
        }
        Object lastArg = args2[args2.length - 1];
        if (lastArg instanceof IRubyObject && (returnValue = IRRuntimeHelpers.toHash((IRubyObject)lastArg, null)) instanceof RubyHash) {
            return (RubyHash)returnValue;
        }
        return null;
    }

    public static void checkForExtraUnwantedKeywordArgs(ThreadContext context, StaticScope scope, RubyHash keywordArgs) {
        try {
            keywordArgs.visitAll(context, CheckUnwantedKeywordsVisitor, scope);
        }
        catch (InvalidKeyException ike) {
            GatherUnwantedKeywordsVisitor visitor = new GatherUnwantedKeywordsVisitor();
            keywordArgs.visitAll(context, visitor, scope);
            visitor.raiseIfError(context);
        }
    }

    public static IRubyObject match3(ThreadContext context, RubyRegexp regexp2, IRubyObject argValue) {
        if (argValue instanceof RubyString) {
            return regexp2.op_match19(context, argValue);
        }
        return argValue.callMethod(context, "=~", regexp2);
    }

    public static IRubyObject extractOptionalArgument(RubyArray rubyArray, int minArgsLength, int index2) {
        int n = rubyArray.getLength();
        return minArgsLength < n ? rubyArray.entry(index2) : UndefinedValue.UNDEFINED;
    }

    @JIT
    @Interp
    public static IRubyObject isDefinedBackref(ThreadContext context, IRubyObject definedMessage) {
        return RubyMatchData.class.isInstance(context.getBackRef()) ? definedMessage : context.nil;
    }

    @JIT
    @Interp
    public static IRubyObject isDefinedGlobal(ThreadContext context, String name2, IRubyObject definedMessage) {
        return context.runtime.getGlobalVariables().isDefined(name2) ? definedMessage : context.nil;
    }

    @JIT
    @Interp
    public static IRubyObject isDefinedNthRef(ThreadContext context, int matchNumber, IRubyObject definedMessage) {
        IRubyObject backref = context.getBackRef();
        if (backref instanceof RubyMatchData && !((RubyMatchData)backref).group(matchNumber).isNil()) {
            return definedMessage;
        }
        return context.nil;
    }

    @JIT
    @Interp
    public static IRubyObject isDefinedClassVar(ThreadContext context, RubyModule receiver2, String name2, IRubyObject definedMessage) {
        IRubyObject attached;
        boolean defined = receiver2.isClassVarDefined(name2);
        if (!defined && receiver2.isSingleton() && (attached = ((MetaClass)receiver2).getAttached()) instanceof RubyModule) {
            defined = ((RubyModule)attached).isClassVarDefined(name2);
        }
        return defined ? definedMessage : context.nil;
    }

    @JIT
    @Interp
    public static IRubyObject isDefinedInstanceVar(ThreadContext context, IRubyObject receiver2, String name2, IRubyObject definedMessage) {
        return receiver2.getInstanceVariables().hasInstanceVariable(name2) ? definedMessage : context.nil;
    }

    @JIT
    @Interp
    public static IRubyObject isDefinedCall(ThreadContext context, IRubyObject self2, IRubyObject receiver2, String name2, IRubyObject definedMessage) {
        IRubyObject boundValue = Helpers.getDefinedCall(context, self2, receiver2, name2, definedMessage);
        return boundValue == null ? context.nil : boundValue;
    }

    @JIT
    @Interp
    public static IRubyObject isDefinedConstantOrMethod(ThreadContext context, IRubyObject receiver2, String name2, IRubyObject definedConstantMessage, IRubyObject definedMethodMessage) {
        IRubyObject definedType = Helpers.getDefinedConstantOrBoundMethod(receiver2, name2, definedConstantMessage, definedMethodMessage);
        return definedType == null ? context.nil : definedType;
    }

    @JIT
    @Interp
    public static IRubyObject isDefinedMethod(ThreadContext context, IRubyObject receiver2, String name2, boolean checkIfPublic, IRubyObject definedMessage) {
        boolean defined;
        DynamicMethod method = receiver2.getMetaClass().searchMethod(name2);
        boolean bl = defined = !method.isUndefined();
        defined = defined ? !checkIfPublic || method.getVisibility() == Visibility.PUBLIC : receiver2.respondsToMissing(name2, checkIfPublic);
        return defined ? definedMessage : context.nil;
    }

    @Interp
    public static IRubyObject isDefinedSuper(ThreadContext context, IRubyObject receiver2, IRubyObject definedMessage) {
        return IRRuntimeHelpers.isDefinedSuper(context, receiver2, context.getFrameName(), context.getFrameKlazz(), definedMessage);
    }

    @JIT
    public static IRubyObject isDefinedSuper(ThreadContext context, IRubyObject receiver2, String frameName, RubyModule frameClass, IRubyObject definedMessage) {
        boolean defined = frameName != null && frameClass != null && Helpers.findImplementerIfNecessary(receiver2.getMetaClass(), frameClass).getSuperClass().isMethodBound(frameName, false);
        return defined ? definedMessage : context.nil;
    }

    public static IRubyObject nthMatch(ThreadContext context, int matchNumber) {
        return RubyRegexp.nth_match(matchNumber, context.getBackRef());
    }

    public static void defineAlias(ThreadContext context, IRubyObject self2, DynamicScope currDynScope, String newNameString, String oldNameString) {
        if (self2 == null || self2 instanceof RubyFixnum || self2 instanceof RubySymbol) {
            throw context.runtime.newTypeError("no class to make alias");
        }
        RubyModule module = IRRuntimeHelpers.findInstanceMethodContainer(context, currDynScope, self2);
        module.defineAlias(newNameString, oldNameString);
        module.callMethod(context, "method_added", (IRubyObject)context.runtime.newSymbol(newNameString));
    }

    public static RubyModule getModuleFromScope(ThreadContext context, StaticScope scope, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        RubyModule rubyClass = scope.getModule();
        while (scope != null && (rubyClass.isSingleton() || rubyClass == runtime.getDummy())) {
            scope = scope.getPreviousCRefScope();
            rubyClass = scope.getModule();
            if (scope.getPreviousCRefScope() != null) continue;
            runtime.getWarnings().warn(IRubyWarnings.ID.CVAR_FROM_TOPLEVEL_SINGLETON_METHOD, "class variable access from toplevel singleton method");
        }
        if (scope == null && arg2 != null) {
            rubyClass = arg2.getMetaClass();
        }
        if (rubyClass == null) {
            throw context.runtime.newTypeError("no class/module to define class variable");
        }
        return rubyClass;
    }

    @JIT
    @Interp
    public static IRubyObject mergeKeywordArguments(ThreadContext context, IRubyObject restKwarg, IRubyObject explicitKwarg) {
        RubyHash hash2 = (RubyHash)TypeConverter.checkHashType(context.runtime, restKwarg).dup();
        hash2.modify();
        RubyHash otherHash = explicitKwarg.convertToHash();
        if (otherHash.empty_p().isTrue()) {
            return hash2;
        }
        otherHash.visitAll(context, new KwargMergeVisitor(hash2), Block.NULL_BLOCK);
        return hash2;
    }

    @JIT
    public static IRubyObject restoreExceptionVar(ThreadContext context, IRubyObject exc, IRubyObject savedExc) {
        if (exc instanceof IRReturnJump || exc instanceof IRBreakJump) {
            context.runtime.getGlobalVariables().set("$!", savedExc);
        }
        return null;
    }

    public static RubyModule findInstanceMethodContainer(ThreadContext context, DynamicScope currDynScope, IRubyObject self2) {
        boolean inBindingEval = currDynScope.inBindingEval();
        if (!inBindingEval && self2 == context.runtime.getTopSelf()) {
            return self2.getType();
        }
        DynamicScope ds = currDynScope;
        while (ds != null) {
            IRScopeType scopeType = ds.getStaticScope().getScopeType();
            switch (ds.getEvalType()) {
                case MODULE_EVAL: {
                    return self2 instanceof RubyModule ? (RubyModule)self2 : self2.getMetaClass();
                }
                case INSTANCE_EVAL: {
                    return self2.getSingletonClass();
                }
                case BINDING_EVAL: {
                    ds = ds.getParentScope();
                    break;
                }
                case NONE: {
                    if (scopeType == null || scopeType.isClosureType()) {
                        ds = ds.getParentScope();
                        break;
                    }
                    if (inBindingEval) {
                        return ds.getStaticScope().getModule();
                    }
                    switch (scopeType) {
                        case CLASS_METHOD: 
                        case MODULE_BODY: 
                        case CLASS_BODY: 
                        case METACLASS_BODY: {
                            return self2 instanceof RubyModule ? (RubyModule)self2 : self2.getMetaClass();
                        }
                        case INSTANCE_METHOD: 
                        case SCRIPT_BODY: {
                            return self2.getMetaClass();
                        }
                    }
                    throw new RuntimeException("Should not get here! scopeType is " + (Object)((Object)scopeType));
                }
            }
        }
        throw new RuntimeException("Should not get here!");
    }

    public static RubyBoolean isBlockGiven(ThreadContext context, Object blk) {
        if (blk instanceof RubyProc) {
            blk = ((RubyProc)blk).getBlock();
        }
        if (blk instanceof RubyNil) {
            blk = Block.NULL_BLOCK;
        }
        return context.runtime.newBoolean(((Block)blk).isGiven());
    }

    public static IRubyObject receiveRestArg(ThreadContext context, Object[] args2, int required, int argIndex, boolean acceptsKeywordArguments) {
        RubyHash keywordArguments = IRRuntimeHelpers.extractKwargsHash(args2, required, acceptsKeywordArguments);
        return IRRuntimeHelpers.constructRestArg(context, args2, keywordArguments, required, argIndex);
    }

    public static IRubyObject receiveRestArg(ThreadContext context, IRubyObject[] args2, int required, int argIndex, boolean acceptsKeywordArguments) {
        RubyHash keywordArguments = IRRuntimeHelpers.extractKwargsHash(args2, required, acceptsKeywordArguments);
        return IRRuntimeHelpers.constructRestArg(context, args2, keywordArguments, required, argIndex);
    }

    public static IRubyObject constructRestArg(ThreadContext context, Object[] args2, RubyHash keywordArguments, int required, int argIndex) {
        int argsLength = keywordArguments != null ? args2.length - 1 : args2.length;
        int remainingArguments = argsLength - required;
        if (remainingArguments <= 0) {
            return context.runtime.newEmptyArray();
        }
        return RubyArray.newArrayMayCopy(context.runtime, (IRubyObject[])args2, argIndex, remainingArguments);
    }

    private static IRubyObject constructRestArg(ThreadContext context, IRubyObject[] args2, RubyHash keywordArguments, int required, int argIndex) {
        int argsLength;
        int n = argsLength = keywordArguments != null ? args2.length - 1 : args2.length;
        if (required == 0 && argsLength == args2.length) {
            return RubyArray.newArray(context.runtime, args2);
        }
        int remainingArguments = argsLength - required;
        if (remainingArguments <= 0) {
            return context.runtime.newEmptyArray();
        }
        return RubyArray.newArrayMayCopy(context.runtime, args2, argIndex, remainingArguments);
    }

    @JIT
    @Interp
    public static IRubyObject receivePostReqdArg(ThreadContext context, IRubyObject[] args2, int pre, int opt, boolean rest2, int post, int argIndex, boolean acceptsKeywordArgument) {
        int required = pre + post;
        boolean kwargs = IRRuntimeHelpers.extractKwargsHash(args2, required, acceptsKeywordArgument) != null;
        int n = kwargs ? args2.length - 1 : args2.length;
        int remaining = n - pre;
        if (remaining < post) {
            if (pre + argIndex >= n) {
                return context.nil;
            }
            return args2[pre + argIndex];
        }
        if (rest2) {
            return args2[n - post + argIndex];
        }
        if (n > required + opt) {
            return args2[pre + opt + argIndex];
        }
        return args2[n - post + argIndex];
    }

    public static IRubyObject receiveOptArg(IRubyObject[] args2, int requiredArgs, int preArgs, int argIndex, boolean acceptsKeywordArgument) {
        int argsLength;
        int optArgIndex = argIndex;
        RubyHash keywordArguments = IRRuntimeHelpers.extractKwargsHash(args2, requiredArgs, acceptsKeywordArgument);
        int n = argsLength = keywordArguments != null ? args2.length - 1 : args2.length;
        if (requiredArgs + optArgIndex >= argsLength) {
            return UndefinedValue.UNDEFINED;
        }
        return args2[preArgs + optArgIndex];
    }

    public static IRubyObject getPreArgSafe(ThreadContext context, IRubyObject[] args2, int argIndex) {
        IRubyObject result2 = argIndex < args2.length ? args2[argIndex] : context.nil;
        return result2;
    }

    public static IRubyObject receiveKeywordArg(ThreadContext context, IRubyObject[] args2, int required, String argName, boolean acceptsKeywordArgument) {
        RubyHash keywordArguments = IRRuntimeHelpers.extractKwargsHash(args2, required, acceptsKeywordArgument);
        if (keywordArguments == null) {
            return UndefinedValue.UNDEFINED;
        }
        RubySymbol keywordName = context.runtime.newSymbol(argName);
        if (keywordArguments.fastARef(keywordName) == null) {
            return UndefinedValue.UNDEFINED;
        }
        return keywordArguments.delete(context, keywordName, Block.NULL_BLOCK);
    }

    public static IRubyObject receiveKeywordRestArg(ThreadContext context, IRubyObject[] args2, int required, boolean keywordArgumentSupplied) {
        RubyHash keywordArguments = IRRuntimeHelpers.extractKwargsHash(args2, required, keywordArgumentSupplied);
        return keywordArguments == null ? RubyHash.newSmallHash(context.runtime) : keywordArguments;
    }

    public static IRubyObject setCapturedVar(ThreadContext context, IRubyObject matchRes, String varName) {
        IRubyObject val;
        if (matchRes.isNil()) {
            val = context.nil;
        } else {
            IRubyObject backref = context.getBackRef();
            int n = ((RubyMatchData)backref).getNameToBackrefNumber(varName);
            val = RubyRegexp.nth_match(n, backref);
        }
        return val;
    }

    @JIT
    public static IRubyObject instanceSuperSplatArgs(ThreadContext context, IRubyObject self2, String methodName, RubyModule definingModule, IRubyObject[] args2, Block block, boolean[] splatMap) {
        return IRRuntimeHelpers.instanceSuper(context, self2, methodName, definingModule, IRRuntimeHelpers.splatArguments(args2, splatMap), block);
    }

    @Interp
    public static IRubyObject instanceSuper(ThreadContext context, IRubyObject self2, String methodName, RubyModule definingModule, IRubyObject[] args2, Block block) {
        RubyClass superClass = definingModule.getMethodLocation().getSuperClass();
        UndefinedMethod method = superClass != null ? superClass.searchMethod(methodName) : UndefinedMethod.INSTANCE;
        IRubyObject rVal = method.isUndefined() ? Helpers.callMethodMissing(context, self2, method.getVisibility(), methodName, CallType.SUPER, args2, block) : ((DynamicMethod)method).call(context, self2, (RubyModule)superClass, methodName, args2, block);
        return rVal;
    }

    @JIT
    public static IRubyObject classSuperSplatArgs(ThreadContext context, IRubyObject self2, String methodName, RubyModule definingModule, IRubyObject[] args2, Block block, boolean[] splatMap) {
        return IRRuntimeHelpers.classSuper(context, self2, methodName, definingModule, IRRuntimeHelpers.splatArguments(args2, splatMap), block);
    }

    @Interp
    public static IRubyObject classSuper(ThreadContext context, IRubyObject self2, String methodName, RubyModule definingModule, IRubyObject[] args2, Block block) {
        RubyClass superClass = definingModule.getMetaClass().getMethodLocation().getSuperClass();
        UndefinedMethod method = superClass != null ? superClass.searchMethod(methodName) : UndefinedMethod.INSTANCE;
        IRubyObject rVal = method.isUndefined() ? Helpers.callMethodMissing(context, self2, method.getVisibility(), methodName, CallType.SUPER, args2, block) : ((DynamicMethod)method).call(context, self2, (RubyModule)superClass, methodName, args2, block);
        return rVal;
    }

    public static IRubyObject unresolvedSuperSplatArgs(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block, boolean[] splatMap) {
        return IRRuntimeHelpers.unresolvedSuper(context, self2, IRRuntimeHelpers.splatArguments(args2, splatMap), block);
    }

    public static IRubyObject unresolvedSuper(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        RubyModule klazz = context.getFrameKlazz();
        String methodName = context.getCurrentFrame().getName();
        Helpers.checkSuperDisabledOrOutOfMethod(context, klazz, methodName);
        RubyModule implMod = Helpers.findImplementerIfNecessary(self2.getMetaClass(), klazz);
        RubyClass superClass = implMod.getSuperClass();
        UndefinedMethod method = superClass != null ? superClass.searchMethod(methodName) : UndefinedMethod.INSTANCE;
        IRubyObject rVal = method.isUndefined() ? Helpers.callMethodMissing(context, self2, method.getVisibility(), methodName, CallType.SUPER, args2, block) : ((DynamicMethod)method).call(context, self2, (RubyModule)superClass, methodName, args2, block);
        return rVal;
    }

    public static IRubyObject zSuperSplatArgs(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block, boolean[] splatMap) {
        if (block == null || !block.isGiven()) {
            block = context.getFrameBlock();
        }
        return IRRuntimeHelpers.unresolvedSuper(context, self2, IRRuntimeHelpers.splatArguments(args2, splatMap), block);
    }

    public static IRubyObject zSuper(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        if (block == null || !block.isGiven()) {
            block = context.getFrameBlock();
        }
        return IRRuntimeHelpers.unresolvedSuper(context, self2, args2, block);
    }

    public static IRubyObject[] splatArguments(IRubyObject[] args2, boolean[] splatMap) {
        if (splatMap != null && splatMap.length > 0) {
            int count2 = 0;
            for (int i2 = 0; i2 < splatMap.length; ++i2) {
                count2 += splatMap[i2] ? ((RubyArray)args2[i2]).size() : 1;
            }
            IRubyObject[] newArgs = new IRubyObject[count2];
            int actualOffset = 0;
            for (int i3 = 0; i3 < splatMap.length; ++i3) {
                if (splatMap[i3]) {
                    RubyArray ary = (RubyArray)args2[i3];
                    for (int j = 0; j < ary.size(); ++j) {
                        newArgs[actualOffset++] = ary.eltOk(j);
                    }
                    continue;
                }
                newArgs[actualOffset++] = args2[i3];
            }
            args2 = newArgs;
        }
        return args2;
    }

    public static String encodeSplatmap(boolean[] splatmap) {
        if (splatmap == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (boolean b2 : splatmap) {
            builder.append(b2 ? (char)'1' : '0');
        }
        return builder.toString();
    }

    public static boolean[] decodeSplatmap(String splatmapString) {
        boolean[] splatMap;
        if (splatmapString.length() > 0) {
            splatMap = new boolean[splatmapString.length()];
            for (int i2 = 0; i2 < splatmapString.length(); ++i2) {
                if (splatmapString.charAt(i2) != '1') continue;
                splatMap[i2] = true;
            }
        } else {
            splatMap = null;
        }
        return splatMap;
    }

    public static boolean[] buildSplatMap(Operand[] args2) {
        boolean[] splatMap = null;
        for (int i2 = 0; i2 < args2.length; ++i2) {
            Operand operand = args2[i2];
            if (!(operand instanceof Splat)) continue;
            if (splatMap == null) {
                splatMap = new boolean[args2.length];
            }
            splatMap[i2] = true;
        }
        return splatMap;
    }

    public static boolean anyTrue(boolean[] booleans) {
        for (boolean b2 : booleans) {
            if (!b2) continue;
            return true;
        }
        return false;
    }

    public static boolean needsSplatting(boolean[] splatmap) {
        return splatmap != null && splatmap.length > 0 && IRRuntimeHelpers.anyTrue(splatmap);
    }

    public static final Type[] typesFromSignature(com.headius.invokebinder.Signature signature) {
        Type[] types = new Type[signature.argCount()];
        for (int i2 = 0; i2 < signature.argCount(); ++i2) {
            types[i2] = Type.getType(signature.argType(i2));
        }
        return types;
    }

    @JIT
    public static RubyString newFrozenStringFromRaw(ThreadContext context, String str, String encoding2, int cr, String file2, int line) {
        return IRRuntimeHelpers.newFrozenString(context, IRRuntimeHelpers.newByteListFromRaw(context.runtime, str, encoding2), cr, file2, line);
    }

    @JIT
    public static final ByteList newByteListFromRaw(Ruby runtime, String str, String encoding2) {
        return new ByteList(str.getBytes(RubyEncoding.ISO), runtime.getEncodingService().getEncodingFromString(encoding2), false);
    }

    @JIT
    public static RubyEncoding retrieveEncoding(ThreadContext context, String name2) {
        return context.runtime.getEncodingService().getEncoding(IRRuntimeHelpers.retrieveJCodingsEncoding(context, name2));
    }

    @JIT
    public static Encoding retrieveJCodingsEncoding(ThreadContext context, String name2) {
        return context.runtime.getEncodingService().findEncodingOrAliasEntry(name2.getBytes()).getEncoding();
    }

    @JIT
    public static RubyHash constructHashFromArray(Ruby runtime, IRubyObject[] pairs) {
        int length2 = pairs.length / 2;
        boolean useSmallHash = length2 <= 10;
        RubyHash hash2 = useSmallHash ? RubyHash.newHash(runtime) : RubyHash.newSmallHash(runtime);
        int i2 = 0;
        while (i2 < pairs.length) {
            if (useSmallHash) {
                hash2.fastASetSmall(runtime, pairs[i2++], pairs[i2++], true);
                continue;
            }
            hash2.fastASet(runtime, pairs[i2++], pairs[i2++], true);
        }
        return hash2;
    }

    @JIT
    public static RubyHash dupKwargsHashAndPopulateFromArray(ThreadContext context, RubyHash dupHash, IRubyObject[] pairs) {
        Ruby runtime = context.runtime;
        RubyHash hash2 = dupHash.dupFast(context);
        int i2 = 0;
        while (i2 < pairs.length) {
            hash2.fastASet(runtime, pairs[i2++], pairs[i2++], true);
        }
        return hash2;
    }

    @JIT
    public static IRubyObject searchConst(ThreadContext context, StaticScope staticScope, String constName, boolean noPrivateConsts) {
        RubyClass object = context.runtime.getObject();
        IRubyObject constant = staticScope == null ? object.getConstant(constName) : staticScope.getConstantInner(constName);
        RubyModule module = null;
        if (constant == null) {
            module = staticScope == null ? object : staticScope.getModule();
            IRubyObject iRubyObject = constant = noPrivateConsts ? module.getConstantFromNoConstMissing(constName, false) : module.getConstantNoConstMissing(constName);
        }
        if (constant == null) {
            return module.callMethod(context, "const_missing", (IRubyObject)context.runtime.fastNewSymbol(constName));
        }
        return constant;
    }

    @JIT
    public static IRubyObject inheritedSearchConst(ThreadContext context, IRubyObject cmVal, String constName, boolean noPrivateConsts) {
        IRubyObject constant;
        if (!(cmVal instanceof RubyModule)) {
            throw context.runtime.newTypeError(cmVal + " is not a type/class");
        }
        RubyModule module = (RubyModule)cmVal;
        IRubyObject iRubyObject = constant = noPrivateConsts ? module.getConstantFromNoConstMissing(constName, false) : module.getConstantNoConstMissing(constName);
        if (constant == null) {
            constant = UndefinedValue.UNDEFINED;
        }
        return constant;
    }

    @JIT
    public static IRubyObject lexicalSearchConst(ThreadContext context, StaticScope staticScope, String constName) {
        IRubyObject constant = staticScope.getConstantInner(constName);
        if (constant == null) {
            constant = UndefinedValue.UNDEFINED;
        }
        return constant;
    }

    public static IRubyObject setInstanceVariable(IRubyObject self2, IRubyObject value2, String name2) {
        return self2.getInstanceVariables().setInstanceVariable(name2, value2);
    }

    @Interp
    public static DynamicMethod newInterpretedMetaClass(Ruby runtime, IRScope metaClassBody, IRubyObject obj) {
        RubyClass singletonClass = IRRuntimeHelpers.newMetaClassFromIR(runtime, metaClassBody, obj);
        return new InterpretedIRMetaClassBody(metaClassBody, singletonClass);
    }

    @JIT
    public static DynamicMethod newCompiledMetaClass(ThreadContext context, MethodHandle handle, IRScope metaClassBody, IRubyObject obj) {
        RubyClass singletonClass = IRRuntimeHelpers.newMetaClassFromIR(context.runtime, metaClassBody, obj);
        return new CompiledIRNoProtocolMethod(handle, metaClassBody, (RubyModule)singletonClass);
    }

    private static RubyClass newMetaClassFromIR(Ruby runtime, IRScope metaClassBody, IRubyObject obj) {
        RubyClass singletonClass = Helpers.getSingletonClass(runtime, obj);
        StaticScope metaClassScope = metaClassBody.getStaticScope();
        metaClassScope.setModule(singletonClass);
        return singletonClass;
    }

    @Interp
    public static DynamicMethod newInterpretedModuleBody(ThreadContext context, IRScope irModule, Object rubyContainer) {
        RubyModule newRubyModule = IRRuntimeHelpers.newRubyModuleFromIR(context, irModule, rubyContainer);
        return new InterpretedIRBodyMethod(irModule, newRubyModule);
    }

    @JIT
    public static DynamicMethod newCompiledModuleBody(ThreadContext context, MethodHandle handle, IRScope irModule, Object rubyContainer) {
        RubyModule newRubyModule = IRRuntimeHelpers.newRubyModuleFromIR(context, irModule, rubyContainer);
        return new CompiledIRMethod(handle, irModule, Visibility.PUBLIC, newRubyModule, false);
    }

    private static RubyModule newRubyModuleFromIR(ThreadContext context, IRScope irModule, Object rubyContainer) {
        if (!(rubyContainer instanceof RubyModule)) {
            throw context.runtime.newTypeError("no outer class/module");
        }
        RubyModule newRubyModule = ((RubyModule)rubyContainer).defineOrGetModuleUnder(irModule.getName());
        irModule.getStaticScope().setModule(newRubyModule);
        return newRubyModule;
    }

    @Interp
    public static DynamicMethod newInterpretedClassBody(ThreadContext context, IRScope irClassBody, Object container, Object superClass) {
        RubyModule newRubyClass = IRRuntimeHelpers.newRubyClassFromIR(context.runtime, irClassBody, superClass, container);
        return new InterpretedIRBodyMethod(irClassBody, newRubyClass);
    }

    @JIT
    public static DynamicMethod newCompiledClassBody(ThreadContext context, MethodHandle handle, IRScope irClassBody, Object container, Object superClass) {
        RubyModule newRubyClass = IRRuntimeHelpers.newRubyClassFromIR(context.runtime, irClassBody, superClass, container);
        return new CompiledIRMethod(handle, irClassBody, Visibility.PUBLIC, newRubyClass, false);
    }

    public static RubyModule newRubyClassFromIR(Ruby runtime, IRScope irClassBody, Object superClass, Object container) {
        RubyClass newRubyClass;
        if (!(container instanceof RubyModule)) {
            throw runtime.newTypeError("no outer class/module");
        }
        if (irClassBody instanceof IRMetaClassBody) {
            newRubyClass = ((RubyModule)container).getMetaClass();
        } else {
            RubyClass sc;
            if (superClass == UndefinedValue.UNDEFINED) {
                sc = null;
            } else {
                RubyClass.checkInheritable((IRubyObject)superClass);
                sc = (RubyClass)superClass;
            }
            newRubyClass = ((RubyModule)container).defineOrGetClassUnder(irClassBody.getName(), sc);
        }
        irClassBody.getStaticScope().setModule(newRubyClass);
        return newRubyClass;
    }

    @Interp
    public static void defInterpretedClassMethod(ThreadContext context, IRScope method, IRubyObject obj) {
        RubyClass rubyClass = IRRuntimeHelpers.checkClassForDef(context, method, obj);
        AbstractIRMethod newMethod = context.runtime.getInstanceConfig().getCompileMode() == RubyInstanceConfig.CompileMode.OFF ? new InterpretedIRMethod(method, Visibility.PUBLIC, rubyClass) : new MixedModeIRMethod(method, Visibility.PUBLIC, rubyClass);
        rubyClass.addMethod(method.getName(), newMethod);
        if (!rubyClass.isRefinement()) {
            obj.callMethod(context, "singleton_method_added", context.runtime.fastNewSymbol(method.getName()));
        }
    }

    @JIT
    public static void defCompiledClassMethod(ThreadContext context, MethodHandle handle, IRScope method, IRubyObject obj) {
        RubyClass rubyClass = IRRuntimeHelpers.checkClassForDef(context, method, obj);
        rubyClass.addMethod(method.getName(), new CompiledIRMethod(handle, method, Visibility.PUBLIC, rubyClass, method.receivesKeywordArgs()));
        if (!rubyClass.isRefinement()) {
            obj.callMethod(context, "singleton_method_added", context.runtime.fastNewSymbol(method.getName()));
        }
    }

    @JIT
    public static void defCompiledClassMethod(ThreadContext context, MethodHandle variable, MethodHandle specific, int specificArity, IRScope method, IRubyObject obj) {
        RubyClass rubyClass = IRRuntimeHelpers.checkClassForDef(context, method, obj);
        rubyClass.addMethod(method.getName(), new CompiledIRMethod(variable, specific, specificArity, method, Visibility.PUBLIC, rubyClass, method.receivesKeywordArgs()));
        if (!rubyClass.isRefinement()) {
            obj.callMethod(context, "singleton_method_added", context.runtime.fastNewSymbol(method.getName()));
        }
    }

    private static RubyClass checkClassForDef(ThreadContext context, IRScope method, IRubyObject obj) {
        if (obj instanceof RubyFixnum || obj instanceof RubySymbol || obj instanceof RubyFloat) {
            throw context.runtime.newTypeError("can't define singleton method \"" + method.getName() + "\" for " + obj.getMetaClass().getBaseName());
        }
        return obj.getSingletonClass();
    }

    @Interp
    public static void defInterpretedInstanceMethod(ThreadContext context, IRScope method, DynamicScope currDynScope, IRubyObject self2) {
        Ruby runtime = context.runtime;
        RubyModule rubyClass = IRRuntimeHelpers.findInstanceMethodContainer(context, currDynScope, self2);
        Visibility currVisibility = context.getCurrentVisibility();
        Visibility newVisibility = Helpers.performNormalMethodChecksAndDetermineVisibility(runtime, rubyClass, method.getName(), currVisibility);
        AbstractIRMethod newMethod = context.runtime.getInstanceConfig().getCompileMode() == RubyInstanceConfig.CompileMode.OFF ? new InterpretedIRMethod(method, newVisibility, rubyClass) : new MixedModeIRMethod(method, newVisibility, rubyClass);
        Helpers.addInstanceMethod(rubyClass, method.getName(), newMethod, currVisibility, context, runtime);
    }

    @JIT
    public static void defCompiledInstanceMethod(ThreadContext context, MethodHandle handle, IRScope method, DynamicScope currDynScope, IRubyObject self2) {
        Ruby runtime = context.runtime;
        RubyModule clazz = IRRuntimeHelpers.findInstanceMethodContainer(context, currDynScope, self2);
        Visibility currVisibility = context.getCurrentVisibility();
        Visibility newVisibility = Helpers.performNormalMethodChecksAndDetermineVisibility(runtime, clazz, method.getName(), currVisibility);
        CompiledIRMethod newMethod = new CompiledIRMethod(handle, method, newVisibility, clazz, method.receivesKeywordArgs());
        Helpers.addInstanceMethod(clazz, method.getName(), newMethod, currVisibility, context, runtime);
    }

    @JIT
    public static void defCompiledInstanceMethod(ThreadContext context, MethodHandle variable, MethodHandle specific, int specificArity, IRScope method, DynamicScope currDynScope, IRubyObject self2) {
        Ruby runtime = context.runtime;
        RubyModule clazz = IRRuntimeHelpers.findInstanceMethodContainer(context, currDynScope, self2);
        Visibility currVisibility = context.getCurrentVisibility();
        Visibility newVisibility = Helpers.performNormalMethodChecksAndDetermineVisibility(runtime, clazz, method.getName(), currVisibility);
        CompiledIRMethod newMethod = new CompiledIRMethod(variable, specific, specificArity, method, newVisibility, clazz, method.receivesKeywordArgs());
        Helpers.addInstanceMethod(clazz, method.getName(), newMethod, currVisibility, context, runtime);
    }

    @JIT
    public static IRubyObject invokeModuleBody(ThreadContext context, DynamicMethod method, Block block) {
        RubyModule implClass = method.getImplementationClass();
        return method.call(context, (IRubyObject)implClass, implClass, "", block);
    }

    @JIT
    public static RubyRegexp newDynamicRegexp(ThreadContext context, IRubyObject[] pieces, int embeddedOptions) {
        RegexpOptions options2 = RegexpOptions.fromEmbeddedOptions(embeddedOptions);
        RubyString pattern = RubyRegexp.preprocessDRegexp(context.runtime, pieces, options2);
        RubyRegexp re = RubyRegexp.newDRegexp(context.runtime, pattern, options2);
        re.setLiteral();
        return re;
    }

    @JIT
    public static RubyRegexp newDynamicRegexp(ThreadContext context, IRubyObject arg0, int embeddedOptions) {
        RegexpOptions options2 = RegexpOptions.fromEmbeddedOptions(embeddedOptions);
        RubyString pattern = RubyRegexp.preprocessDRegexp(context.runtime, arg0, options2);
        RubyRegexp re = RubyRegexp.newDRegexp(context.runtime, pattern, options2);
        re.setLiteral();
        return re;
    }

    @JIT
    public static RubyRegexp newDynamicRegexp(ThreadContext context, IRubyObject arg0, IRubyObject arg1, int embeddedOptions) {
        RegexpOptions options2 = RegexpOptions.fromEmbeddedOptions(embeddedOptions);
        RubyString pattern = RubyRegexp.preprocessDRegexp(context.runtime, arg0, arg1, options2);
        RubyRegexp re = RubyRegexp.newDRegexp(context.runtime, pattern, options2);
        re.setLiteral();
        return re;
    }

    @JIT
    public static RubyRegexp newDynamicRegexp(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, int embeddedOptions) {
        RegexpOptions options2 = RegexpOptions.fromEmbeddedOptions(embeddedOptions);
        RubyString pattern = RubyRegexp.preprocessDRegexp(context.runtime, arg0, arg1, arg2, options2);
        RubyRegexp re = RubyRegexp.newDRegexp(context.runtime, pattern, options2);
        re.setLiteral();
        return re;
    }

    @JIT
    public static RubyRegexp newDynamicRegexp(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, int embeddedOptions) {
        RegexpOptions options2 = RegexpOptions.fromEmbeddedOptions(embeddedOptions);
        RubyString pattern = RubyRegexp.preprocessDRegexp(context.runtime, arg0, arg1, arg2, arg3, options2);
        RubyRegexp re = RubyRegexp.newDRegexp(context.runtime, pattern, options2);
        re.setLiteral();
        return re;
    }

    @JIT
    public static RubyRegexp newDynamicRegexp(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, int embeddedOptions) {
        RegexpOptions options2 = RegexpOptions.fromEmbeddedOptions(embeddedOptions);
        RubyString pattern = RubyRegexp.preprocessDRegexp(context.runtime, arg0, arg1, arg2, arg3, arg4, options2);
        RubyRegexp re = RubyRegexp.newDRegexp(context.runtime, pattern, options2);
        re.setLiteral();
        return re;
    }

    public static RubyRegexp newLiteralRegexp(ThreadContext context, ByteList source2, RegexpOptions options2) {
        RubyRegexp re = RubyRegexp.newRegexp(context.runtime, source2, options2);
        re.setLiteral();
        return re;
    }

    @JIT
    public static RubyRegexp newLiteralRegexp(ThreadContext context, ByteList source2, int embeddedOptions) {
        return IRRuntimeHelpers.newLiteralRegexp(context, source2, RegexpOptions.fromEmbeddedOptions(embeddedOptions));
    }

    @JIT
    public static RubyArray irSplat(ThreadContext context, IRubyObject ary) {
        Ruby runtime = context.runtime;
        IRubyObject tmp = TypeConverter.convertToTypeWithCheck19(context, ary, runtime.getArray(), IRRuntimeHelpers.sites((ThreadContext)context).to_a_checked);
        tmp = tmp.isNil() ? runtime.newArray(ary) : ((RubyArray)tmp).aryDup();
        return (RubyArray)tmp;
    }

    @JIT
    @Interp
    public static RubyArray splatArray(ThreadContext context, IRubyObject ary, boolean dupArray) {
        Ruby runtime = context.runtime;
        IRubyObject tmp = TypeConverter.convertToTypeWithCheck19(context, ary, runtime.getArray(), IRRuntimeHelpers.sites((ThreadContext)context).to_a_checked);
        if (tmp.isNil()) {
            tmp = runtime.newArray(ary);
        } else if (dupArray) {
            tmp = ((RubyArray)tmp).aryDup();
        }
        return (RubyArray)tmp;
    }

    public static IRubyObject irToAry(ThreadContext context, IRubyObject value2) {
        if (!(value2 instanceof RubyArray)) {
            value2 = RubyArray.aryToAry(value2);
        }
        return value2;
    }

    public static int irReqdArgMultipleAsgnIndex(int n, int preArgsCount, int index2, int postArgsCount) {
        if (preArgsCount == -1) {
            return index2 < n ? index2 : -1;
        }
        int remaining = n - preArgsCount;
        if (remaining <= index2) {
            return -1;
        }
        return remaining > postArgsCount ? n - postArgsCount + index2 : preArgsCount + index2;
    }

    public static IRubyObject irReqdArgMultipleAsgn(ThreadContext context, RubyArray rubyArray, int preArgsCount, int index2, int postArgsCount) {
        int i2 = IRRuntimeHelpers.irReqdArgMultipleAsgnIndex(rubyArray.getLength(), preArgsCount, index2, postArgsCount);
        return i2 == -1 ? context.nil : rubyArray.entry(i2);
    }

    public static IRubyObject irNot(ThreadContext context, IRubyObject obj) {
        return context.runtime.newBoolean(!obj.isTrue());
    }

    @JIT
    public static RaiseException newRequiredKeywordArgumentError(ThreadContext context, String name2) {
        return context.runtime.newArgumentError("missing keyword: " + name2);
    }

    @JIT
    public static void pushExitBlock(ThreadContext context, Block blk) {
        context.runtime.pushEndBlock(context.runtime.newProc(Block.Type.LAMBDA, blk));
    }

    @JIT
    public static FunctionalCachingCallSite newFunctionalCachingCallSite(String name2) {
        return new FunctionalCachingCallSite(name2);
    }

    @JIT
    public static NormalCachingCallSite newNormalCachingCallSite(String name2) {
        return new NormalCachingCallSite(name2);
    }

    @JIT
    public static VariableCachingCallSite newVariableCachingCallSite(String name2) {
        return new VariableCachingCallSite(name2);
    }

    @JIT
    public static RefinedCachingCallSite newRefinedCachingCallSite(String name2, String callType) {
        return new RefinedCachingCallSite(name2, CallType.valueOf(callType));
    }

    @JIT
    public static IRScope decodeScopeFromBytes(Ruby runtime, byte[] scopeBytes, String filename2) {
        try {
            return IRReader.load(runtime.getIRManager(), new IRReaderStream(runtime.getIRManager(), new ByteArrayInputStream(scopeBytes), new ByteList(filename2.getBytes())));
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @JIT
    public static VariableAccessor getVariableAccessorForRead(IRubyObject object, String name2) {
        return ((RubyBasicObject)object).getMetaClass().getRealClass().getVariableAccessorForRead(name2);
    }

    @JIT
    public static VariableAccessor getVariableAccessorForWrite(IRubyObject object, String name2) {
        return ((RubyBasicObject)object).getMetaClass().getRealClass().getVariableAccessorForWrite(name2);
    }

    @JIT
    public static IRubyObject getVariableWithAccessor(IRubyObject self2, VariableAccessor accessor, ThreadContext context, String name2) {
        IRubyObject result2 = (IRubyObject)accessor.get(self2);
        if (result2 == null) {
            if (context.runtime.isVerbose()) {
                context.runtime.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, "instance variable " + name2 + " not initialized");
            }
            result2 = context.nil;
        }
        return result2;
    }

    @JIT
    public static void setVariableWithAccessor(IRubyObject self2, IRubyObject value2, VariableAccessor accessor) {
        accessor.set(self2, value2);
    }

    @JIT
    public static RubyFixnum getArgScopeDepth(ThreadContext context, StaticScope currScope) {
        int i2 = 0;
        while (!currScope.isArgumentScope()) {
            currScope = currScope.getEnclosingScope();
            ++i2;
        }
        return context.runtime.newFixnum(i2);
    }

    public static IRubyObject[] toAry(ThreadContext context, IRubyObject[] args2) {
        if (args2.length == 1 && args2[0].respondsTo("to_ary")) {
            IRubyObject newAry = Helpers.aryToAry(args2[0]);
            if (newAry.isNil()) {
                args2 = new IRubyObject[]{args2[0]};
            } else if (newAry instanceof RubyArray) {
                args2 = ((RubyArray)newAry).toJavaArray();
            } else {
                throw context.runtime.newTypeError(args2[0].getType().getName() + "#to_ary should return Array");
            }
        }
        return args2;
    }

    private static IRubyObject[] prepareProcArgs(ThreadContext context, Block b2, IRubyObject[] args2) {
        if (args2.length != 1) {
            return args2;
        }
        return IRRuntimeHelpers.convertValueIntoArgArray(context, args2[0], b2.getBody().getSignature(), b2.type == Block.Type.NORMAL && args2[0] instanceof RubyArray);
    }

    private static IRubyObject[] prepareBlockArgsInternal(ThreadContext context, Block block, IRubyObject[] args2) {
        if (args2 == null) {
            args2 = IRubyObject.NULL_ARRAY;
        }
        boolean isProcCall = context.getCurrentBlockType() == Block.Type.PROC;
        Signature sig = block.getBody().getSignature();
        if (block.type == Block.Type.LAMBDA) {
            if (!isProcCall && sig.arityValue() != -1 && sig.required() != 1) {
                args2 = IRRuntimeHelpers.toAry(context, args2);
            }
            sig.checkArity(context.runtime, args2);
            return args2;
        }
        if (isProcCall) {
            return IRRuntimeHelpers.prepareProcArgs(context, block, args2);
        }
        int arityValue = sig.arityValue();
        if (!sig.hasKwargs() && arityValue >= -1 && arityValue <= 1) {
            return args2;
        }
        args2 = IRRuntimeHelpers.toAry(context, args2);
        int needsKwargs = sig.hasKwargs() ? 1 - sig.getRequiredKeywordForArityCount() : 0;
        int required = sig.required();
        int actual = args2.length;
        if (needsKwargs == 0 || required > actual) {
            return args2;
        }
        if (sig.isFixed() && required > 0 && required + needsKwargs != actual) {
            int len = required + needsKwargs;
            IRubyObject[] newArgs = ArraySupport.newCopy(args2, len);
            newArgs[len - 1] = actual < len ? RubyHash.newHash(context.runtime) : args2[args2.length - 1];
            args2 = newArgs;
        }
        return args2;
    }

    @Interp
    @JIT
    public static IRubyObject[] prepareNoBlockArgs(ThreadContext context, Block block, IRubyObject[] args2) {
        if (args2 == null) {
            args2 = IRubyObject.NULL_ARRAY;
        }
        if (block.type == Block.Type.LAMBDA) {
            block.getSignature().checkArity(context.runtime, args2);
        }
        return args2;
    }

    @Interp
    @JIT
    public static IRubyObject[] prepareSingleBlockArgs(ThreadContext context, Block block, IRubyObject[] args2) {
        boolean isProcCall;
        if (args2 == null) {
            args2 = IRubyObject.NULL_ARRAY;
        }
        if (block.type == Block.Type.LAMBDA) {
            block.getBody().getSignature().checkArity(context.runtime, args2);
            return args2;
        }
        boolean bl = isProcCall = context.getCurrentBlockType() == Block.Type.PROC;
        if (isProcCall) {
            args2 = args2.length == 0 ? context.runtime.getSingleNilArray() : (args2.length == 1 ? IRRuntimeHelpers.prepareProcArgs(context, block, args2) : new IRubyObject[]{args2[0]});
        }
        return args2;
    }

    @Interp
    @JIT
    public static IRubyObject[] prepareFixedBlockArgs(ThreadContext context, Block block, IRubyObject[] args2) {
        boolean isProcCall;
        if (args2 == null) {
            args2 = IRubyObject.NULL_ARRAY;
        }
        boolean bl = isProcCall = context.getCurrentBlockType() == Block.Type.PROC;
        if (block.type == Block.Type.LAMBDA) {
            Signature sig = block.getBody().getSignature();
            if (!isProcCall && sig.arityValue() != 1) {
                args2 = IRRuntimeHelpers.toAry(context, args2);
            }
            sig.checkArity(context.runtime, args2);
            return args2;
        }
        if (isProcCall) {
            return IRRuntimeHelpers.prepareProcArgs(context, block, args2);
        }
        return IRRuntimeHelpers.toAry(context, args2);
    }

    @Interp
    @JIT
    public static IRubyObject[] prepareBlockArgs(ThreadContext context, Block block, IRubyObject[] args2, boolean usesKwArgs) {
        args2 = IRRuntimeHelpers.prepareBlockArgsInternal(context, block, args2);
        if (usesKwArgs) {
            args2 = IRRuntimeHelpers.frobnicateKwargsArgument(context, args2, block.getBody().getSignature().required());
        }
        return args2;
    }

    private static DynamicScope getNewBlockScope(Block block, boolean pushNewDynScope, boolean reuseParentDynScope) {
        DynamicScope newScope = block.getBinding().getDynamicScope();
        if (pushNewDynScope) {
            return block.allocScope(newScope);
        }
        if (reuseParentDynScope) {
            return newScope;
        }
        return null;
    }

    @Interp
    @JIT
    public static DynamicScope pushBlockDynamicScopeIfNeeded(ThreadContext context, Block block, boolean pushNewDynScope, boolean reuseParentDynScope) {
        DynamicScope newScope = IRRuntimeHelpers.getNewBlockScope(block, pushNewDynScope, reuseParentDynScope);
        if (newScope != null) {
            context.pushScope(newScope);
        }
        return newScope;
    }

    @Interp
    @JIT
    public static IRubyObject updateBlockState(Block block, IRubyObject self2) {
        if (self2 == null || block.getEvalType() == EvalType.BINDING_EVAL) {
            self2 = IRRuntimeHelpers.useBindingSelf(block.getBinding());
        }
        block.setEvalType(EvalType.NONE);
        return self2;
    }

    public static IRubyObject useBindingSelf(Binding binding2) {
        IRubyObject self2 = binding2.getSelf();
        binding2.getFrame().setSelf(self2);
        return self2;
    }

    @Interp
    public static RubyProc newSymbolProc(ThreadContext context, String symbol, Encoding encoding2) {
        return (RubyProc)context.runtime.newSymbol(symbol, encoding2).to_proc(context);
    }

    @JIT
    public static RubyProc newSymbolProc(ThreadContext context, String symbol, String encoding2) {
        return IRRuntimeHelpers.newSymbolProc(context, symbol, IRRuntimeHelpers.retrieveJCodingsEncoding(context, encoding2));
    }

    @JIT
    public static IRubyObject[] singleBlockArgToArray(IRubyObject value2) {
        IRubyObject[] args2 = value2 instanceof RubyArray ? value2.convertToArray().toJavaArray() : new IRubyObject[]{value2};
        return args2;
    }

    @JIT
    public static Block prepareBlock(ThreadContext context, IRubyObject self2, DynamicScope scope, BlockBody body) {
        Block block = new Block(body, context.currentBinding(self2, scope));
        return block;
    }

    public static RubyString newFrozenString(ThreadContext context, ByteList bytelist, int coderange, String file2, int line) {
        Ruby runtime = context.runtime;
        RubyString string2 = RubyString.newString(runtime, bytelist, coderange);
        if (runtime.getInstanceConfig().isDebuggingFrozenStringLiteral()) {
            RubyArray info = (RubyArray)runtime.newArray(runtime.newString(file2).freeze(context), (IRubyObject)runtime.newFixnum(line)).freeze(context);
            string2.setInstanceVariable("@debug_created_info", info);
            string2.setFrozen(true);
        } else {
            string2 = runtime.freezeAndDedupString(string2);
        }
        return string2;
    }

    public static RubyString freezeLiteralString(ThreadContext context, RubyString string2, String file2, int line) {
        Ruby runtime = context.runtime;
        if (runtime.getInstanceConfig().isDebuggingFrozenStringLiteral()) {
            RubyArray info = (RubyArray)runtime.newArray(runtime.newString(file2).freeze(context), (IRubyObject)runtime.newFixnum(line)).freeze(context);
            string2.setInstanceVariable("@debug_created_info", info);
        }
        string2.setFrozen(true);
        return string2;
    }

    @JIT
    public static IRubyObject callOptimizedAref(ThreadContext context, IRubyObject caller, IRubyObject target, RubyString keyStr, CallSite site) {
        if (target instanceof RubyHash && ((CachingCallSite)site).isBuiltin(target.getMetaClass())) {
            return ((RubyHash)target).op_aref(context, keyStr);
        }
        return site.call(context, caller, target, (IRubyObject)keyStr.strDup(context.runtime));
    }

    public static DynamicMethod getRefinedMethodForClass(StaticScope refinedScope, RubyModule target, String methodName) {
        DynamicMethod method = null;
        while (refinedScope != null) {
            DynamicMethod maybeMethod;
            RubyModule refinement;
            Map<RubyClass, RubyModule> refinements;
            RubyModule overlay = refinedScope.getOverlayModuleForRead();
            if (overlay != null && !(refinements = overlay.getRefinements()).isEmpty() && (refinement = refinements.get(target)) != null && !(maybeMethod = refinement.searchMethod(methodName)).isUndefined()) {
                method = maybeMethod;
                break;
            }
            refinedScope = refinedScope.getEnclosingScope();
        }
        return method;
    }

    @JIT
    public static RubyArray newArray(ThreadContext context) {
        return RubyArray.newEmptyArray(context.runtime);
    }

    @JIT
    public static RubyArray newArray(ThreadContext context, IRubyObject obj) {
        return RubyArray.newArray(context.runtime, obj);
    }

    @JIT
    public static RubyArray newArray(ThreadContext context, IRubyObject obj0, IRubyObject obj1) {
        return RubyArray.newArray(context.runtime, obj0, obj1);
    }

    private static JavaSites.IRRuntimeHelpersSites sites(ThreadContext context) {
        return context.sites.IRRuntimeHelpers;
    }

    private static class KwargMergeVisitor
    extends RubyHash.VisitorWithState<Block> {
        final RubyHash target;

        KwargMergeVisitor(RubyHash target) {
            this.target = target;
        }

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Block block) {
            TypeConverter.checkType(context, key2, context.runtime.getSymbol());
            this.target.op_aset(context, key2, value2);
        }
    }

    private static class GatherUnwantedKeywordsVisitor
    extends RubyHash.VisitorWithState<StaticScope> {
        ArrayList invalidKwargs;

        private GatherUnwantedKeywordsVisitor() {
        }

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, StaticScope scope) {
            String javaName = key2.asJavaString();
            if (!scope.keywordExists(javaName)) {
                if (this.invalidKwargs == null) {
                    this.invalidKwargs = new ArrayList();
                }
                this.invalidKwargs.add(javaName);
            }
        }

        public void raiseIfError(ThreadContext context) {
            if (this.invalidKwargs != null) {
                String invalidKwargs = this.invalidKwargs.toString();
                throw context.runtime.newArgumentError((this.invalidKwargs.size() == 1 ? "unknown keyword: " : "unknown keywords: ") + invalidKwargs.substring(1, invalidKwargs.length() - 1));
            }
        }
    }

    private static class InvalidKeyException
    extends RuntimeException {
        private InvalidKeyException() {
        }
    }
}

