#ifndef _EFL_EVENT_KEY_EO_H_
#define _EFL_EVENT_KEY_EO_H_

#ifndef _EFL_EVENT_KEY_EO_CLASS_TYPE
#define _EFL_EVENT_KEY_EO_CLASS_TYPE

typedef Eo Efl_Event_Key;

#endif

#ifndef _EFL_EVENT_KEY_EO_TYPES
#define _EFL_EVENT_KEY_EO_TYPES


#endif
/** Represents a single key event from a keyboard or similar device.
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Key
 */
#define EFL_EVENT_KEY_CLASS efl_event_key_class_get()

EWAPI const Eo_Class *efl_event_key_class_get(void);

/**
 * @brief @c true if the key is down, @c false if it is released.
 *
 * @param[in] val
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Key
 */
EOAPI void efl_event_key_pressed_set(Eo *obj, Eina_Bool val);

/** @c true if the key is down, @c false if it is released.
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Key
 */
EOAPI Eina_Bool efl_event_key_pressed_get(const Eo *obj);

/**
 * @brief Name string of the key.
 *
 * @param[in] val
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Key
 */
EOAPI void efl_event_key_name_set(Eo *obj, const char *val);

/** Name string of the key.
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Key
 */
EOAPI const char *efl_event_key_name_get(const Eo *obj);

/**
 * @brief Logical key.
 *
 * Eg. Shift + 1 = exclamation
 *
 * @param[in] val
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Key
 */
EOAPI void efl_event_key_set(Eo *obj, const char *val);

/**
 * @brief Logical key.
 *
 * Eg. Shift + 1 = exclamation
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Key
 */
EOAPI const char *efl_event_key_get(const Eo *obj);

/**
 * @brief A UTF8 string if this keystroke has produced a visible string to be
 * added.
 *
 * @param[in] val
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Key
 */
EOAPI void efl_event_key_string_set(Eo *obj, const char *val);

/** A UTF8 string if this keystroke has produced a visible string to be added.
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Key
 */
EOAPI const char *efl_event_key_string_get(const Eo *obj);

/**
 * @brief A UTF8 string if this keystroke has modified a string in the middle
 * of being composed.
 *
 * @note This string replaces the previous one
 *
 * @param[in] val
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Key
 */
EOAPI void efl_event_key_compose_set(Eo *obj, const char *val);

/**
 * @brief A UTF8 string if this keystroke has modified a string in the middle
 * of being composed.
 *
 * @note This string replaces the previous one
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Key
 */
EOAPI const char *efl_event_key_compose_get(const Eo *obj);

/**
 * @brief Key scan code numeric value.
 *
 * @param[in] val
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Key
 */
EOAPI void efl_event_key_code_set(Eo *obj, int val);

/** Key scan code numeric value.
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Key
 */
EOAPI int efl_event_key_code_get(const Eo *obj);


#endif
