#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: bytestring-strict-builder
version: 0.4.5
id: bytestring-strict-builder-0.4.5-I0Ehywg0AoS9bYVGMdsGC5
key: bytestring-strict-builder-0.4.5-I0Ehywg0AoS9bYVGMdsGC5
license: MIT
copyright: (c) 2017, Nikita Volkov
maintainer: Nikita Volkov <nikita.y.volkov@mail.ru>
homepage: https://github.com/nikita-volkov/bytestring-strict-builder
synopsis: An efficient strict bytestring builder
description:
    According to
    <https://github.com/nikita-volkov/bytestring-builders-benchmark the competition benchmarks>,
    this library provides on average the fastest builder of strict bytestrings.
    .
    Practical benchmarks have proven it to be highly performant as well.
    The encoders from the \"postgresql-binary\" library have shown
    a stable performance improvement by factors of up to 10 after the migration
    from the standard builder to \"bytestring-strict-builder\".
category: Text, ByteString, Builders, Serialization
author: Nikita Volkov <nikita.y.volkov@mail.ru>
exposed: True
exposed-modules:
    ByteString.StrictBuilder
hidden-modules: ByteString.StrictBuilder.Prelude
                ByteString.StrictBuilder.Population
                ByteString.StrictBuilder.Population.UncheckedShifting
                ByteString.StrictBuilder.UTF8
abi: e1643e296f09ae7a1bda7becbefd57b9
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/bytestring-strict-builder-0.4.5
library-dirs: /usr/lib/ghc-8.0.2/site-local/bytestring-strict-builder-0.4.5
dynamic-library-dirs: /usr/lib/arm-linux-ghc-8.0.2
data-dir: /usr/share/arm-linux-ghc-8.0.2/bytestring-strict-builder-0.4.5
hs-libraries: HSbytestring-strict-builder-0.4.5-I0Ehywg0AoS9bYVGMdsGC5
depends:
    base-4.9.1.0 base-prelude-1.2.0.1-HJh3WMXaeu8jTCoycvBYB
    bytestring-0.10.8.1 semigroups-0.18.3-5xL9BgkWQsCGwo6YahyMCM
haddock-interfaces: /usr/share/doc/haskell-bytestring-strict-builder/html/bytestring-strict-builder.haddock
haddock-html: /usr/share/doc/haskell-bytestring-strict-builder/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
