/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.QuadTiling;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.OsmPrimitive;

public class QuadBuckets<T extends OsmPrimitive>
implements Collection<T> {
    private static final boolean CONSISTENCY_TESTING = false;
    private static final byte NW_INDEX = 1;
    private static final byte NE_INDEX = 3;
    private static final byte SE_INDEX = 2;
    private static final byte SW_INDEX = 0;
    private static final int MAX_OBJECTS_PER_NODE = 48;
    private QBLevel<T> root;
    private QBLevel<T> searchCache;
    private int size;
    private Collection<T> invalidBBoxPrimitives;

    static void abort(String string) {
        throw new AssertionError((Object)string);
    }

    public QuadBuckets() {
        this.clear();
    }

    @Override
    public final void clear() {
        this.root = new QBLevel();
        this.invalidBBoxPrimitives = new LinkedHashSet<T>();
        this.searchCache = null;
        this.size = 0;
    }

    @Override
    public boolean add(T t) {
        if (((OsmPrimitive)t).getBBox().isValid()) {
            this.root.add(t);
        } else {
            this.invalidBBoxPrimitives.add(t);
        }
        ++this.size;
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        for (OsmPrimitive osmPrimitive : this) {
            if (collection.contains(osmPrimitive) || this.remove(osmPrimitive)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            bl |= this.remove(obj);
        }
        return bl;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        boolean bl = false;
        for (OsmPrimitive osmPrimitive : collection) {
            bl |= this.add((T)osmPrimitive);
        }
        return bl;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(Object object) {
        OsmPrimitive osmPrimitive = (OsmPrimitive)object;
        this.searchCache = null;
        QBLevel<OsmPrimitive> qBLevel = this.root.findBucket(osmPrimitive.getBBox());
        boolean bl = qBLevel.removeContent(osmPrimitive);
        if (!bl) {
            bl = this.invalidBBoxPrimitives.remove(object);
        }
        if (bl) {
            --this.size;
        }
        return bl;
    }

    @Override
    public boolean contains(Object object) {
        OsmPrimitive osmPrimitive = (OsmPrimitive)object;
        if (!osmPrimitive.getBBox().isValid()) {
            return this.invalidBBoxPrimitives.contains(object);
        }
        QBLevel<T> qBLevel = this.root.findBucket(osmPrimitive.getBBox());
        return qBLevel != null && ((QBLevel)qBLevel).content != null && ((QBLevel)qBLevel).content.contains(osmPrimitive);
    }

    public List<T> toList() {
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : this) {
            arrayList.add(osmPrimitive);
        }
        return arrayList;
    }

    @Override
    public Object[] toArray() {
        return this.toList().toArray();
    }

    @Override
    public <A> A[] toArray(A[] AArray) {
        return this.toList().toArray(AArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new QuadBucketIterator(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public List<T> search(BBox bBox) {
        ArrayList arrayList = new ArrayList();
        if (!bBox.isValid()) {
            return arrayList;
        }
        if (this.searchCache == null) {
            this.searchCache = this.root;
        }
        while (this.searchCache != null && !this.searchCache.bounds(bBox)) {
            this.searchCache = ((QBLevel)this.searchCache).parent;
        }
        if (this.searchCache == null) {
            this.searchCache = this.root;
            Main.info("bbox: " + bBox + " is out of the world");
        }
        QBLevel qBLevel = ((QBLevel)this.searchCache).parent;
        ((QBLevel)this.searchCache).search(this, bBox, arrayList);
        while (qBLevel != null) {
            qBLevel.searchContents(bBox, arrayList);
            qBLevel = qBLevel.parent;
        }
        return arrayList;
    }

    class QuadBucketIterator
    implements Iterator<T> {
        private QBLevel<T> currentNode;
        private int contentIndex;
        private final Iterator<T> invalidBBoxIterator;
        boolean fromInvalidBBoxPrimitives;
        QuadBuckets<T> qb;

        final QBLevel<T> nextContentNode(QBLevel<T> qBLevel) {
            if (qBLevel == null) {
                return null;
            }
            QBLevel qBLevel2 = qBLevel;
            QBLevel qBLevel3 = qBLevel.nextContentNode();
            if (qBLevel2 == qBLevel3) {
                QuadBuckets.abort("got same leaf back leaf: " + qBLevel.isLeaf());
            }
            return qBLevel3;
        }

        QuadBucketIterator(QuadBuckets<T> quadBuckets2) {
            this.invalidBBoxIterator = QuadBuckets.this.invalidBBoxPrimitives.iterator();
            this.currentNode = !quadBuckets2.root.hasChildren() || quadBuckets2.root.hasContent() ? quadBuckets2.root : this.nextContentNode(quadBuckets2.root);
            this.qb = quadBuckets2;
        }

        @Override
        public boolean hasNext() {
            if (this.peek() == null) {
                this.fromInvalidBBoxPrimitives = true;
                return this.invalidBBoxIterator.hasNext();
            }
            return true;
        }

        T peek() {
            if (this.currentNode == null) {
                return null;
            }
            while (this.currentNode.content == null || this.contentIndex >= this.currentNode.content.size()) {
                this.contentIndex = 0;
                this.currentNode = this.nextContentNode(this.currentNode);
                if (this.currentNode != null) continue;
            }
            if (this.currentNode == null || this.currentNode.content == null) {
                return null;
            }
            return (OsmPrimitive)this.currentNode.content.get(this.contentIndex);
        }

        @Override
        public T next() {
            if (this.fromInvalidBBoxPrimitives) {
                return (OsmPrimitive)this.invalidBBoxIterator.next();
            }
            Object t = this.peek();
            if (t == null) {
                throw new NoSuchElementException();
            }
            ++this.contentIndex;
            return t;
        }

        @Override
        public void remove() {
            if (this.fromInvalidBBoxPrimitives) {
                this.invalidBBoxIterator.remove();
                this.qb.size--;
            } else {
                --this.contentIndex;
                Object t = this.peek();
                if (this.currentNode.removeContent(t)) {
                    this.qb.size--;
                }
            }
        }
    }

    static class QBLevel<T extends OsmPrimitive>
    extends BBox {
        private final byte level;
        private final byte index;
        private final long quad;
        private final QBLevel<T> parent;
        private boolean isLeaf = true;
        private List<T> content;
        private QBLevel<T> nw;
        private QBLevel<T> ne;
        private QBLevel<T> sw;
        private QBLevel<T> se;

        private QBLevel<T> getChild(byte by) {
            switch (by) {
                case 3: {
                    if (this.ne == null) {
                        this.ne = new QBLevel<T>(this, by);
                    }
                    return this.ne;
                }
                case 1: {
                    if (this.nw == null) {
                        this.nw = new QBLevel<T>(this, by);
                    }
                    return this.nw;
                }
                case 2: {
                    if (this.se == null) {
                        this.se = new QBLevel<T>(this, by);
                    }
                    return this.se;
                }
                case 0: {
                    if (this.sw == null) {
                        this.sw = new QBLevel<T>(this, by);
                    }
                    return this.sw;
                }
            }
            return null;
        }

        private QBLevel<T>[] getChildren() {
            return new QBLevel[]{this.sw, this.nw, this.se, this.ne};
        }

        @Override
        public String toString() {
            return super.toString() + '[' + this.level + "]: ";
        }

        QBLevel() {
            super(-180.0, 90.0, 180.0, -90.0);
            this.level = 0;
            this.index = 0;
            this.quad = 0L;
            this.parent = null;
        }

        QBLevel(QBLevel<T> qBLevel, byte by) {
            this.parent = qBLevel;
            this.level = (byte)(qBLevel.level + 1);
            this.index = by;
            int n = (24 - this.level) * 2;
            long l = (long)by << n;
            this.quad = qBLevel.quad | l;
            LatLon latLon = QuadTiling.tile2LatLon(this.quad);
            this.xmin = latLon.lon();
            this.ymin = latLon.lat();
            this.xmax = this.xmin + qBLevel.width() / 2.0;
            this.ymax = this.ymin + qBLevel.height() / 2.0;
        }

        QBLevel<T> findBucket(BBox bBox) {
            if (!this.hasChildren()) {
                return this;
            }
            byte by = bBox.getIndex(this.level);
            if (by == -1) {
                return this;
            }
            QBLevel<T> qBLevel = this.getChild(by);
            if (qBLevel == null) {
                return this;
            }
            return qBLevel.findBucket(bBox);
        }

        boolean removeContent(T t) {
            if (this.content == null) {
                return false;
            }
            boolean bl = this.content.remove(t);
            if (this.content.isEmpty()) {
                this.content = null;
            }
            if (this.canRemove()) {
                this.removeFromParent();
            }
            return bl;
        }

        void doSplit() {
            List<T> list = this.content;
            this.content = null;
            for (OsmPrimitive osmPrimitive : list) {
                byte by = osmPrimitive.getBBox().getIndex(this.level);
                if (by == -1) {
                    this.doAddContent(osmPrimitive);
                    continue;
                }
                QBLevel<OsmPrimitive> qBLevel = this.getChild(by);
                if (qBLevel == null) continue;
                qBLevel.doAdd(osmPrimitive);
            }
            this.isLeaf = false;
        }

        boolean doAddContent(T t) {
            if (this.content == null) {
                this.content = new ArrayList<T>();
            }
            return this.content.add(t);
        }

        boolean matches(T t, BBox bBox) {
            return ((OsmPrimitive)t).getBBox().intersects(bBox);
        }

        private void searchContents(BBox bBox, List<T> list) {
            if (this.content == null) {
                return;
            }
            for (OsmPrimitive osmPrimitive : this.content) {
                if (!this.matches(osmPrimitive, bBox)) continue;
                list.add(osmPrimitive);
            }
        }

        boolean isLeaf() {
            return this.isLeaf;
        }

        boolean hasChildren() {
            return this.nw != null || this.ne != null || this.sw != null || this.se != null;
        }

        QBLevel<T> findNextSibling() {
            return this.parent == null ? null : this.parent.firstSiblingOf(this);
        }

        boolean hasContent() {
            return this.content != null;
        }

        QBLevel<T> nextSibling() {
            QBLevel<T> qBLevel = this;
            QBLevel<T> qBLevel2 = qBLevel.findNextSibling();
            while (qBLevel2 == null && (qBLevel = qBLevel.parent) != null) {
                qBLevel2 = qBLevel.findNextSibling();
            }
            return qBLevel2;
        }

        QBLevel<T> firstChild() {
            if (this.sw != null) {
                return this.sw;
            }
            if (this.nw != null) {
                return this.nw;
            }
            if (this.se != null) {
                return this.se;
            }
            return this.ne;
        }

        QBLevel<T> firstSiblingOf(QBLevel<T> qBLevel) {
            switch (qBLevel.index) {
                case 0: {
                    if (this.nw != null) {
                        return this.nw;
                    }
                    if (this.se != null) {
                        return this.se;
                    }
                    return this.ne;
                }
                case 1: {
                    if (this.se != null) {
                        return this.se;
                    }
                    return this.ne;
                }
                case 2: {
                    return this.ne;
                }
            }
            return null;
        }

        QBLevel<T> nextNode() {
            if (!this.hasChildren()) {
                return this.nextSibling();
            }
            return this.firstChild();
        }

        QBLevel<T> nextContentNode() {
            QBLevel<T> qBLevel = this.nextNode();
            if (qBLevel == null) {
                return qBLevel;
            }
            if (qBLevel.hasContent()) {
                return qBLevel;
            }
            return qBLevel.nextContentNode();
        }

        void doAdd(T t) {
            this.doAddContent(t);
            if (this.level < 24 && this.isLeaf() && this.content.size() > 48) {
                this.doSplit();
            }
        }

        void add(T t) {
            this.findBucket(((OsmPrimitive)t).getBBox()).doAdd(t);
        }

        private void search(QuadBuckets<T> quadBuckets, BBox bBox, List<T> list) {
            if (!this.intersects(bBox)) {
                return;
            }
            if (this.bounds(bBox)) {
                ((QuadBuckets)quadBuckets).searchCache = this;
            }
            if (this.hasContent()) {
                this.searchContents(bBox, list);
            }
            if (this.nw != null) {
                super.search(quadBuckets, bBox, list);
            }
            if (this.ne != null) {
                super.search(quadBuckets, bBox, list);
            }
            if (this.se != null) {
                super.search(quadBuckets, bBox, list);
            }
            if (this.sw != null) {
                super.search(quadBuckets, bBox, list);
            }
        }

        public String quads() {
            return Long.toHexString(this.quad);
        }

        int indexOf(QBLevel<T> qBLevel) {
            QBLevel<T>[] qBLevelArray = this.getChildren();
            for (int i = 0; i < 4; ++i) {
                if (qBLevelArray[i] != qBLevel) continue;
                return i;
            }
            return -1;
        }

        void removeFromParent() {
            if (this.parent == null) {
                return;
            }
            if (!this.canRemove()) {
                QuadBuckets.abort("attempt to remove non-empty child: " + this.content + ' ' + Arrays.toString(this.getChildren()));
            }
            if (this.parent.nw == this) {
                this.parent.nw = null;
            } else if (this.parent.ne == this) {
                this.parent.ne = null;
            } else if (this.parent.sw == this) {
                this.parent.sw = null;
            } else if (this.parent.se == this) {
                this.parent.se = null;
            }
            if (this.parent.canRemove()) {
                this.parent.removeFromParent();
            }
        }

        boolean canRemove() {
            return (this.content == null || this.content.isEmpty()) && !this.hasChildren();
        }
    }
}

