/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.CustomProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.datum.Datum;
import org.openstreetmap.josm.data.projection.datum.GRS80Datum;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShiftFileWrapper;
import org.openstreetmap.josm.data.projection.datum.SevenParameterDatum;
import org.openstreetmap.josm.data.projection.datum.ThreeParameterDatum;
import org.openstreetmap.josm.data.projection.datum.WGS84Datum;
import org.openstreetmap.josm.data.projection.proj.AlbersEqualArea;
import org.openstreetmap.josm.data.projection.proj.CassiniSoldner;
import org.openstreetmap.josm.data.projection.proj.ClassProjFactory;
import org.openstreetmap.josm.data.projection.proj.DoubleStereographic;
import org.openstreetmap.josm.data.projection.proj.LambertAzimuthalEqualArea;
import org.openstreetmap.josm.data.projection.proj.LambertConformalConic;
import org.openstreetmap.josm.data.projection.proj.LonLat;
import org.openstreetmap.josm.data.projection.proj.Mercator;
import org.openstreetmap.josm.data.projection.proj.ObliqueMercator;
import org.openstreetmap.josm.data.projection.proj.PolarStereographic;
import org.openstreetmap.josm.data.projection.proj.Proj;
import org.openstreetmap.josm.data.projection.proj.ProjFactory;
import org.openstreetmap.josm.data.projection.proj.Sinusoidal;
import org.openstreetmap.josm.data.projection.proj.SwissObliqueMercator;
import org.openstreetmap.josm.data.projection.proj.TransverseMercator;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Utils;

public final class Projections {
    private static final Set<String> allCodes = new HashSet<String>();
    private static final Map<String, ProjectionChoice> allProjectionChoicesByCode = new HashMap<String, ProjectionChoice>();
    private static final Map<String, Projection> projectionsByCode_cache = new HashMap<String, Projection>();
    private static final Map<String, ProjFactory> projs = new HashMap<String, ProjFactory>();
    private static final Map<String, Ellipsoid> ellipsoids = new HashMap<String, Ellipsoid>();
    private static final Map<String, Datum> datums = new HashMap<String, Datum>();
    private static final Map<String, NTV2GridShiftFileWrapper> nadgrids = new HashMap<String, NTV2GridShiftFileWrapper>();
    private static final Map<String, ProjectionDefinition> inits;

    private Projections() {
    }

    private static void loadNadgrids(String string) {
        String string2 = CustomProjection.Param.nadgrids.key;
        if (string.contains(string2)) {
            try {
                String string3 = CustomProjection.parseParameterList(string, true).get(string2);
                if (string3.startsWith("@")) {
                    string3 = string3.substring(1);
                }
                if (!"null".equals(string3) && !nadgrids.containsKey(string3)) {
                    nadgrids.put(string3, new NTV2GridShiftFileWrapper(string3));
                }
            }
            catch (ProjectionConfigurationException projectionConfigurationException) {
                Main.trace(projectionConfigurationException);
            }
        }
    }

    public static EastNorth project(LatLon latLon) {
        if (latLon == null) {
            return null;
        }
        return Main.getProjection().latlon2eastNorth(latLon);
    }

    public static LatLon inverseProject(EastNorth eastNorth) {
        if (eastNorth == null) {
            return null;
        }
        return Main.getProjection().eastNorth2latlon(eastNorth);
    }

    public static void registerBaseProjection(String string, ProjFactory projFactory, String string2) {
        projs.put(string, projFactory);
    }

    public static void registerBaseProjection(String string, Class<? extends Proj> clazz, String string2) {
        Projections.registerBaseProjection(string, new ClassProjFactory(clazz), string2);
    }

    public static Proj getBaseProjection(String string) {
        ProjFactory projFactory = projs.get(string);
        if (projFactory == null) {
            return null;
        }
        return projFactory.createInstance();
    }

    public static Ellipsoid getEllipsoid(String string) {
        return ellipsoids.get(string);
    }

    public static Datum getDatum(String string) {
        return datums.get(string);
    }

    public static NTV2GridShiftFileWrapper getNTV2Grid(String string) {
        return nadgrids.get(string);
    }

    public static String getInit(String string) {
        ProjectionDefinition projectionDefinition = inits.get(string.toUpperCase(Locale.ENGLISH));
        if (projectionDefinition == null) {
            return null;
        }
        return projectionDefinition.definition;
    }

    /*
     * Exception decompiling
     */
    public static List<ProjectionDefinition> loadProjectionDefinitions(String var0) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<ProjectionDefinition> loadProjectionDefinitions(BufferedReader bufferedReader) throws IOException {
        String string;
        ArrayList<ProjectionDefinition> arrayList = new ArrayList<ProjectionDefinition>();
        Pattern pattern = Pattern.compile("<(\\d+)>(.*)<>");
        String string2 = "";
        while ((string = bufferedReader.readLine()) != null) {
            if (!(string = string.trim()).startsWith("#") && !string.isEmpty()) {
                if (!string2.startsWith("#")) {
                    throw new AssertionError((Object)"EPSG file seems corrupted");
                }
                String string3 = string2.substring(1).trim();
                Matcher matcher = pattern.matcher(string);
                if (matcher.matches()) {
                    String string4 = "EPSG:" + matcher.group(1);
                    String string5 = matcher.group(2).trim();
                    arrayList.add(new ProjectionDefinition(string4, string3, string5));
                } else {
                    Main.warn("Failed to parse line from the EPSG projection definition: " + string);
                }
            }
            string2 = string;
        }
        return arrayList;
    }

    public static Projection getProjectionByCode(String string) {
        Object object;
        Projection projection = projectionsByCode_cache.get(string);
        if (projection != null) {
            return projection;
        }
        ProjectionChoice projectionChoice = allProjectionChoicesByCode.get(string);
        if (projectionChoice != null) {
            object = projectionChoice.getPreferencesFromCode(string);
            projectionChoice.setPreferences((Collection<String>)object);
            try {
                projection = projectionChoice.getProjection();
            }
            catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException runtimeException) {
                Main.warn((Throwable)runtimeException, "Unable to get projection " + string + " with " + projectionChoice + ':');
            }
        }
        if (projection == null) {
            object = inits.get(string);
            if (object == null) {
                return null;
            }
            projection = new CustomProjection(((ProjectionDefinition)object).name, string, ((ProjectionDefinition)object).definition);
        }
        projectionsByCode_cache.put(string, projection);
        return projection;
    }

    public static Collection<String> getAllProjectionCodes() {
        return Collections.unmodifiableCollection(allCodes);
    }

    public static Collection<String> getAllBaseProjectionIds() {
        return projs.keySet();
    }

    private static String listKeys(Map<String, ?> map) {
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        Collections.sort(arrayList);
        return Utils.join(", ", arrayList);
    }

    public static String listProjs() {
        return Projections.listKeys(projs);
    }

    public static String listEllipsoids() {
        return Projections.listKeys(ellipsoids);
    }

    public static String listDatums() {
        return Projections.listKeys(datums);
    }

    public static String listNadgrids() {
        return Projections.listKeys(nadgrids);
    }

    static {
        Projections.registerBaseProjection("aea", AlbersEqualArea.class, "core");
        Projections.registerBaseProjection("cass", CassiniSoldner.class, "core");
        Projections.registerBaseProjection("laea", LambertAzimuthalEqualArea.class, "core");
        Projections.registerBaseProjection("lcc", LambertConformalConic.class, "core");
        Projections.registerBaseProjection("lonlat", LonLat.class, "core");
        Projections.registerBaseProjection("merc", Mercator.class, "core");
        Projections.registerBaseProjection("omerc", ObliqueMercator.class, "core");
        Projections.registerBaseProjection("somerc", SwissObliqueMercator.class, "core");
        Projections.registerBaseProjection("sinu", Sinusoidal.class, "core");
        Projections.registerBaseProjection("stere", PolarStereographic.class, "core");
        Projections.registerBaseProjection("sterea", DoubleStereographic.class, "core");
        Projections.registerBaseProjection("tmerc", TransverseMercator.class, "core");
        ellipsoids.put("airy", Ellipsoid.Airy);
        ellipsoids.put("mod_airy", Ellipsoid.AiryMod);
        ellipsoids.put("aust_SA", Ellipsoid.AustSA);
        ellipsoids.put("bessel", Ellipsoid.Bessel1841);
        ellipsoids.put("bess_nam", Ellipsoid.BesselNamibia);
        ellipsoids.put("clrk66", Ellipsoid.Clarke1866);
        ellipsoids.put("clrk80", Ellipsoid.Clarke1880);
        ellipsoids.put("clrk80ign", Ellipsoid.ClarkeIGN);
        ellipsoids.put("evrstSS", Ellipsoid.EverestSabahSarawak);
        ellipsoids.put("intl", Ellipsoid.Hayford);
        ellipsoids.put("helmert", Ellipsoid.Helmert);
        ellipsoids.put("krass", Ellipsoid.Krassowsky);
        ellipsoids.put("GRS67", Ellipsoid.GRS67);
        ellipsoids.put("GRS80", Ellipsoid.GRS80);
        ellipsoids.put("WGS66", Ellipsoid.WGS66);
        ellipsoids.put("WGS72", Ellipsoid.WGS72);
        ellipsoids.put("WGS84", Ellipsoid.WGS84);
        datums.put("WGS84", WGS84Datum.INSTANCE);
        datums.put("NAD83", GRS80Datum.INSTANCE);
        datums.put("carthage", new ThreeParameterDatum("Carthage 1934 Tunisia", "carthage", Ellipsoid.ClarkeIGN, -263.0, 6.0, 431.0));
        datums.put("GGRS87", new ThreeParameterDatum("Greek Geodetic Reference System 1987", "GGRS87", Ellipsoid.GRS80, -199.87, 74.79, 246.62));
        datums.put("hermannskogel", new SevenParameterDatum("Hermannskogel", "hermannskogel", Ellipsoid.Bessel1841, 577.326, 90.129, 463.919, 5.137, 1.474, 5.297, 2.4232));
        datums.put("ire65", new SevenParameterDatum("Ireland 1965", "ire65", Ellipsoid.AiryMod, 482.53, -130.596, 564.557, -1.042, -0.214, -0.631, 8.15));
        datums.put("nzgd49", new SevenParameterDatum("New Zealand Geodetic Datum 1949", "nzgd49", Ellipsoid.Hayford, 59.47, -5.04, 187.44, 0.47, -0.1, 1.024, -4.5993));
        datums.put("OSGB36", new SevenParameterDatum("Airy 1830", "OSGB36", Ellipsoid.Airy, 446.448, -125.157, 542.06, 0.1502, 0.247, 0.8421, -20.4894));
        datums.put("potsdam", new SevenParameterDatum("Potsdam Rauenberg 1950 DHDN", "potsdam", Ellipsoid.Bessel1841, 598.1, 73.7, 418.2, 0.202, 0.045, -2.455, 6.7));
        try {
            inits = new LinkedHashMap<String, ProjectionDefinition>();
            for (ProjectionDefinition object : Projections.loadProjectionDefinitions("resource://data/projection/custom-epsg")) {
                inits.put(object.code, object);
                Projections.loadNadgrids(object.definition);
            }
        }
        catch (IOException iOException) {
            throw new JosmRuntimeException(iOException);
        }
        for (ProjectionChoice projectionChoice : ProjectionPreference.getProjectionChoices()) {
            for (String string : projectionChoice.allCodes()) {
                allProjectionChoicesByCode.put(string, projectionChoice);
            }
        }
        allCodes.addAll(inits.keySet());
        allCodes.addAll(allProjectionChoicesByCode.keySet());
    }

    public static class ProjectionDefinition {
        public final String code;
        public final String name;
        public final String definition;

        public ProjectionDefinition(String string, String string2, String string3) {
            this.code = string;
            this.name = string2;
            this.definition = string3;
        }
    }
}

