/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.MenuComponent;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AddImageryLayerAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.MapRectifierWMSmenuAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.data.imagery.Shape;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MenuScroller;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ImageryMenu
extends JMenu
implements LayerManager.LayerChangeListener {
    public static final Comparator<ImageryInfo> alphabeticImageryComparator = (imageryInfo, imageryInfo2) -> imageryInfo.getName().toLowerCase(Locale.ENGLISH).compareTo(imageryInfo2.getName().toLowerCase(Locale.ENGLISH));
    private final transient Action offsetAction = new AdjustImageryOffsetAction();
    private final JMenuItem singleOffset;
    private JMenuItem offsetMenuItem = this.singleOffset = new JMenuItem(this.offsetAction);
    private final MapRectifierWMSmenuAction rectaction = new MapRectifierWMSmenuAction();
    private final List<Object> dynamicItems = new ArrayList<Object>(20);

    public ImageryMenu(JMenu jMenu) {
        super(I18n.trc("menu", "Imagery"));
        this.setupMenuScroller();
        Main.getLayerManager().addLayerChangeListener(this);
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                ImageryMenu.this.refreshImageryMenu();
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        MainMenu.add(jMenu, this.rectaction);
    }

    private void setupMenuScroller() {
        if (!GraphicsEnvironment.isHeadless()) {
            MenuScroller.setScrollerFor(this, 150, 2);
        }
    }

    public void refreshImageryMenu() {
        Object object;
        this.removeDynamicItems();
        this.addDynamic(this.offsetMenuItem);
        this.addDynamicSeparator();
        ArrayList<ImageryInfo> arrayList = new ArrayList<ImageryInfo>(ImageryLayerInfo.instance.getLayers());
        arrayList.sort(alphabeticImageryComparator);
        for (ImageryInfo object2 : arrayList) {
            this.addDynamic(new AddImageryLayerAction(object2));
        }
        if (Main.isDisplayingMapView()) {
            object = Main.map.mapView;
            LatLon n = ((NavigatableComponent)object).getProjection().eastNorth2latlon(((NavigatableComponent)object).getCenter());
            ArrayList<ImageryInfo> arrayList2 = new ArrayList<ImageryInfo>();
            for (ImageryInfo imageryInfo : ImageryLayerInfo.instance.getDefaultLayers()) {
                if (imageryInfo.getBounds() == null || !imageryInfo.getBounds().contains(n)) continue;
                arrayList2.add(imageryInfo);
            }
            arrayList2.removeAll(ImageryLayerInfo.instance.getLayers());
            Iterator<ImageryInfo> iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                List<Shape> list = iterator.next().getBounds().getShapes();
                if (list == null || list.isEmpty()) continue;
                boolean bl = false;
                Iterator<Shape> iterator2 = list.iterator();
                while (iterator2.hasNext() && !bl) {
                    bl = iterator2.next().contains(n);
                }
                if (bl) continue;
                iterator.remove();
            }
            if (!arrayList2.isEmpty()) {
                arrayList2.sort(alphabeticImageryComparator);
                this.addDynamicSeparator();
                for (ImageryInfo imageryInfo : arrayList2) {
                    this.addDynamic(new AddImageryLayerAction(imageryInfo));
                }
            }
        }
        this.addDynamicSeparator();
        object = Main.main.menu.imagerySubMenu;
        int n = 30 * (this.getItemCount() + ((JMenu)object).getItemCount());
        if (n < Main.main.panel.getHeight()) {
            int n2 = ((JMenu)object).getItemCount();
            for (int i = 0; i < n2; ++i) {
                this.addDynamic(((JMenu)object).getItem(i).getAction());
            }
        } else {
            this.addDynamic((JMenuItem)object);
        }
    }

    private JMenuItem getNewOffsetMenu() {
        List<ImageryLayer> list = Main.getLayerManager().getLayersOfType(ImageryLayer.class);
        if (list.isEmpty()) {
            this.offsetAction.setEnabled(false);
            return this.singleOffset;
        }
        this.offsetAction.setEnabled(true);
        JMenu jMenu = new JMenu(I18n.trc("layer", "Offset"));
        jMenu.setIcon(ImageProvider.get("mapmode", "adjustimg"));
        jMenu.setAction(this.offsetAction);
        if (list.size() == 1) {
            return (JMenuItem)((ImageryLayer)list.iterator().next()).getOffsetMenuItem(jMenu);
        }
        for (ImageryLayer imageryLayer : list) {
            JMenuItem jMenuItem = imageryLayer.getOffsetMenuItem();
            jMenuItem.setText(imageryLayer.getName());
            jMenuItem.setIcon(imageryLayer.getIcon());
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    public void refreshOffsetMenu() {
        this.offsetMenuItem = this.getNewOffsetMenu();
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent layerAddEvent) {
        if (layerAddEvent.getAddedLayer() instanceof ImageryLayer) {
            this.refreshOffsetMenu();
        }
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent layerRemoveEvent) {
        if (layerRemoveEvent.getRemovedLayer() instanceof ImageryLayer) {
            this.refreshOffsetMenu();
        }
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent layerOrderChangeEvent) {
        this.refreshOffsetMenu();
    }

    private void removeDynamicItems() {
        for (Object object : this.dynamicItems) {
            if (object instanceof JMenuItem) {
                Optional.ofNullable(((JMenuItem)object).getAction()).ifPresent(Main.toolbar::unregister);
                this.remove((JMenuItem)object);
                continue;
            }
            if (object instanceof MenuComponent) {
                this.remove((MenuComponent)object);
                continue;
            }
            if (!(object instanceof Component)) continue;
            this.remove((Component)object);
        }
        this.dynamicItems.clear();
    }

    private void addDynamicSeparator() {
        JPopupMenu.Separator separator = new JPopupMenu.Separator();
        this.dynamicItems.add(separator);
        this.add(separator);
    }

    private void addDynamic(Action action) {
        this.dynamicItems.add(this.add(action));
    }

    private void addDynamic(JMenuItem jMenuItem) {
        this.dynamicItems.add(this.add(jMenuItem));
    }

    static final class AdjustImageryOffsetAction
    extends JosmAction {
        AdjustImageryOffsetAction() {
            super(I18n.tr("Imagery offset", new Object[0]), "mapmode/adjustimg", I18n.tr("Adjust imagery offset", new Object[0]), null, false, false);
            this.putValue("toolbar", "imagery-offset");
            Main.toolbar.register(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            List<ImageryLayer> list = Main.getLayerManager().getLayersOfType(ImageryLayer.class);
            if (list.isEmpty()) {
                this.setEnabled(false);
                return;
            }
            Component component = null;
            if (actionEvent.getSource() instanceof Component) {
                component = (Component)actionEvent.getSource();
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            if (list.size() == 1) {
                JComponent jComponent = ((ImageryLayer)list.iterator().next()).getOffsetMenuItem(jPopupMenu);
                if (jComponent instanceof JMenuItem) {
                    ((JMenuItem)jComponent).getAction().actionPerformed(actionEvent);
                } else {
                    if (component == null) {
                        return;
                    }
                    jPopupMenu.show(component, component.getWidth() / 2, component.getHeight() / 2);
                }
                return;
            }
            if (component == null || !component.isShowing()) {
                return;
            }
            for (ImageryLayer imageryLayer : list) {
                JMenuItem jMenuItem = imageryLayer.getOffsetMenuItem();
                jMenuItem.setText(imageryLayer.getName());
                jMenuItem.setIcon(imageryLayer.getIcon());
                jPopupMenu.add(jMenuItem);
            }
            jPopupMenu.show(component, component.getWidth() / 2, component.getHeight() / 2);
        }
    }
}

