/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.autofilter;

import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;

public class AutoFilterRule {
    private final String key;
    private final int minZoomLevel;
    private Function<String, String> valueFormatter = string -> string;
    private Comparator<String> valueComparator = Comparator.comparingInt(string -> Integer.parseInt(this.valueFormatter.apply((String)string)));

    public AutoFilterRule(String string2, int n) {
        this.key = string2;
        this.minZoomLevel = n;
    }

    public String getKey() {
        return this.key;
    }

    public int getMinZoomLevel() {
        return this.minZoomLevel;
    }

    public Function<String, String> getValueFormatter() {
        return this.valueFormatter;
    }

    public AutoFilterRule setValueFormatter(Function<String, String> function) {
        this.valueFormatter = Objects.requireNonNull(function);
        return this;
    }

    public Comparator<String> getValueComparator() {
        return this.valueComparator;
    }

    public AutoFilterRule setValueComparator(Comparator<String> comparator) {
        this.valueComparator = comparator;
        return this;
    }

    public static AutoFilterRule[] defaultRules() {
        return new AutoFilterRule[]{new AutoFilterRule("level", 17), new AutoFilterRule("layer", 16), new AutoFilterRule("maxspeed", 16).setValueFormatter(string -> string.replaceAll(" mph", "")), new AutoFilterRule("voltage", 5).setValueFormatter(string -> string.replaceAll("000$", "k") + 'V').setValueComparator(Comparator.comparingInt(Integer::parseInt))};
    }

    public String toString() {
        return this.key + '[' + this.minZoomLevel + ']';
    }
}

