/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.xml.sax.SAXException;

public abstract class TaggingPresetItem {
    private static final Map<String, Set<TaggingPresetType>> TYPE_CACHE = new LinkedHashMap<String, Set<TaggingPresetType>>(16, 1.1f, true);

    protected void initAutoCompletionField(AutoCompletingTextField autoCompletingTextField, String ... stringArray) {
        this.initAutoCompletionField(autoCompletingTextField, Arrays.asList(stringArray));
    }

    protected void initAutoCompletionField(AutoCompletingTextField autoCompletingTextField, List<String> list) {
        if (Main.main == null) {
            return;
        }
        OsmDataLayer osmDataLayer = Main.getLayerManager().getEditLayer();
        if (osmDataLayer == null) {
            return;
        }
        AutoCompletionList autoCompletionList = new AutoCompletionList();
        osmDataLayer.data.getAutoCompletionManager().populateWithTagValues(autoCompletionList, list);
        autoCompletingTextField.setAutoCompletionList(autoCompletionList);
    }

    protected abstract boolean addToPanel(JPanel var1, Collection<OsmPrimitive> var2, boolean var3);

    protected abstract void addCommands(List<Tag> var1);

    protected Boolean matches(Map<String, String> map) {
        return null;
    }

    protected static Set<TaggingPresetType> getType(String string) throws SAXException {
        if (string == null || string.isEmpty()) {
            throw new SAXException(I18n.tr("Unknown type: {0}", string));
        }
        if (TYPE_CACHE.containsKey(string)) {
            return TYPE_CACHE.get(string);
        }
        EnumSet<TaggingPresetType> enumSet = EnumSet.noneOf(TaggingPresetType.class);
        for (String string2 : Arrays.asList(string.split(","))) {
            try {
                TaggingPresetType taggingPresetType = TaggingPresetType.fromString(string2);
                if (taggingPresetType == null) continue;
                enumSet.add(taggingPresetType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SAXException(I18n.tr("Unknown type: {0}", string2), illegalArgumentException);
            }
        }
        TYPE_CACHE.put(string, enumSet);
        return enumSet;
    }

    protected static String fixPresetString(String string) {
        return string == null ? string : string.replaceAll("'", "''");
    }

    protected static String getLocaleText(String string, String string2, String string3) {
        if (string == null) {
            return string3;
        }
        if (string2 != null) {
            return I18n.trc(string2, TaggingPresetItem.fixPresetString(string));
        }
        return I18n.tr(TaggingPresetItem.fixPresetString(string), new Object[0]);
    }

    protected static Integer parseInteger(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            Main.trace(numberFormatException);
            return null;
        }
    }

    protected static ImageIcon loadImageIcon(String string, File file, Integer n) {
        Collection<String> collection = Main.pref.getCollection("taggingpreset.icon.sources", null);
        ImageProvider imageProvider = new ImageProvider(string).setDirs(collection).setId("presets").setArchive(file).setOptional(true);
        if (n != null) {
            imageProvider.setMaxSize(n);
        }
        return imageProvider.get();
    }

    public static boolean matches(Iterable<? extends TaggingPresetItem> iterable, Map<String, String> map) {
        boolean bl = false;
        for (TaggingPresetItem taggingPresetItem : iterable) {
            Boolean bl2 = taggingPresetItem.matches(map);
            if (bl2 != null && !bl2.booleanValue()) {
                return false;
            }
            if (bl2 == null) continue;
            bl = true;
        }
        return bl;
    }
}

