/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.util.Collection;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.GeoProperty;
import org.openstreetmap.josm.tools.Geometry;

public class DefaultGeoProperty
implements GeoProperty<Boolean> {
    private final Area area;

    public DefaultGeoProperty(Collection<Way> collection) {
        Path2D.Double double_ = new Path2D.Double();
        double_.setWindingRule(0);
        for (Way way : collection) {
            Geometry.buildPath2DLatLon(way.getNodes(), double_);
        }
        this.area = new Area(double_);
    }

    public DefaultGeoProperty(Relation relation) {
        this.area = Geometry.getAreaLatLon(relation);
    }

    @Override
    public Boolean get(LatLon latLon) {
        return this.area.contains(latLon.lon(), latLon.lat());
    }

    @Override
    public Boolean get(BBox bBox) {
        Area area = new Area(bBox.toRectangle());
        Geometry.PolygonIntersection polygonIntersection = Geometry.polygonIntersection(area, this.area, 1.0E-10);
        switch (polygonIntersection) {
            case FIRST_INSIDE_SECOND: {
                return Boolean.TRUE;
            }
            case OUTSIDE: {
                return Boolean.FALSE;
            }
        }
        return null;
    }
}

