/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.filechooser.FileFilter;

public class DialogFileFilter
extends FileFilter {
    private String description;
    private List<String> extensions;

    public DialogFileFilter(String description) {
        if (description == null) {
            Logger.getLogger(DialogFileFilter.class.getName()).throwing(this.getClass().getName(), "constructor", new NullPointerException("Description cannot be null."));
        }
        this.description = description;
        this.extensions = new ArrayList<String>();
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory() || this.extensions.isEmpty()) {
            return true;
        }
        String fileName = file.getName().toLowerCase();
        for (String extension : this.extensions) {
            if (!fileName.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        StringBuffer buffer = new StringBuffer(this.description);
        buffer.append(" (");
        for (String extension : this.extensions) {
            buffer.append("*" + extension).append(" ");
        }
        buffer.deleteCharAt(buffer.length() - 1);
        return buffer.append(")").toString();
    }

    public void setDescription(String description) {
        if (description == null) {
            Logger.getLogger(DialogFileFilter.class.getName()).throwing(this.getClass().getName(), "setDescription", new NullPointerException("Description cannot be null."));
        }
        this.description = description;
    }

    public void addExtension(String extension) {
        if (extension == null) {
            Logger.getLogger(DialogFileFilter.class.getName()).throwing(this.getClass().getName(), "addExtension", new NullPointerException("Description cannot be null."));
        }
        this.extensions.add(extension);
    }

    public void addExtensions(String[] extension) {
        if (extension == null) {
            Logger.getLogger(DialogFileFilter.class.getName()).throwing(this.getClass().getName(), "addExtensions", new NullPointerException("Description cannot be null."));
        }
        for (int i = 0; i < extension.length; ++i) {
            this.extensions.add(extension[i]);
        }
    }

    public void removeExtension(String extension) {
        this.extensions.remove(extension);
    }

    public void clearExtensions() {
        this.extensions.clear();
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DialogFileFilter)) {
            return false;
        }
        DialogFileFilter s = (DialogFileFilter)obj;
        if (s.extensions.size() != this.extensions.size()) {
            return false;
        }
        for (int i = 0; i < this.extensions.size(); ++i) {
            if (this.extensions.get(i) == s.extensions.get(i) || this.extensions.get(i).equals(s.extensions.get(i))) continue;
            return false;
        }
        return this.description.equals(s.description);
    }
}

