/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import org.gephi.graph.api.DirectedSubgraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.TimeIndex;
import org.gephi.graph.api.types.TimeMap;
import org.gephi.graph.api.types.TimeSet;
import org.gephi.graph.impl.ElementImpl;
import org.gephi.graph.impl.GraphLock;
import org.gephi.graph.impl.GraphViewImpl;
import org.gephi.graph.impl.TimeIndexImpl;
import org.gephi.graph.impl.utils.MapDeepEquals;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class TimeIndexStore<T extends Element, K, S extends TimeSet<K>, M extends TimeMap<K, ?>> {
    protected final GraphLock graphLock;
    protected final Class<T> elementType;
    protected final Map<K, Integer> timeSortedMap;
    protected final IntSortedSet garbageQueue;
    protected int[] countMap;
    protected int length;
    protected TimeIndexImpl mainIndex;
    protected final Map<GraphView, TimeIndexImpl> viewIndexes;

    protected TimeIndexStore(Class<T> type, GraphLock lock, boolean indexed, Map<K, Integer> sortedMap) {
        this.elementType = type;
        this.graphLock = lock;
        this.garbageQueue = new IntRBTreeSet();
        this.timeSortedMap = sortedMap;
        this.countMap = new int[0];
        this.viewIndexes = indexed ? new Object2ObjectOpenHashMap() : null;
    }

    protected abstract void checkK(K var1);

    protected abstract double getLow(K var1);

    protected abstract TimeIndexImpl createIndex(boolean var1);

    public Integer add(K k) {
        this.checkK(k);
        Integer id = this.timeSortedMap.get(k);
        if (id == null) {
            if (!this.garbageQueue.isEmpty()) {
                id = this.garbageQueue.firstInt();
                this.garbageQueue.remove((Object)id);
            } else {
                id = this.length++;
            }
            this.timeSortedMap.put(k, id);
            this.ensureArraySize(id);
            this.countMap[id.intValue()] = 1;
        } else {
            int n = id;
            this.countMap[n] = this.countMap[n] + 1;
        }
        return id;
    }

    public int add(K k, Element element) {
        int timeIndex = this.add(k);
        if (this.mainIndex != null) {
            this.mainIndex.add(timeIndex, element);
            if (!this.viewIndexes.isEmpty()) {
                for (Map.Entry<GraphView, TimeIndexImpl> entry : this.viewIndexes.entrySet()) {
                    GraphViewImpl graphView = (GraphViewImpl)entry.getKey();
                    DirectedSubgraph graph = graphView.getDirectedGraph();
                    boolean node = element instanceof Node;
                    if (!(node ? graph.contains((Node)element) : graph.contains((Edge)element))) continue;
                    entry.getValue().add(timeIndex, element);
                }
            }
        }
        return timeIndex;
    }

    public void add(TimeMap<K, ?> timeMap) {
        for (K timeKey : timeMap.toKeysArray()) {
            this.add(timeKey);
        }
    }

    public void add(TimeSet<K> timeSet) {
        for (K timeKey : timeSet.toArray()) {
            this.add(timeKey);
        }
    }

    public Integer remove(K k) {
        this.checkK(k);
        Integer id = this.timeSortedMap.get(k);
        if (id != null) {
            int n = id;
            this.countMap[n] = this.countMap[n] - 1;
            if (this.countMap[n] == 0) {
                this.garbageQueue.add((Object)id);
                this.timeSortedMap.remove(k);
            }
        }
        return id;
    }

    public int remove(K k, Element element) {
        Integer timeIndex = this.remove(k);
        this.checkTimeIndex(timeIndex);
        if (this.mainIndex != null) {
            this.mainIndex.remove(timeIndex, element);
            if (!this.viewIndexes.isEmpty()) {
                for (Map.Entry<GraphView, TimeIndexImpl> entry : this.viewIndexes.entrySet()) {
                    GraphViewImpl graphView = (GraphViewImpl)entry.getKey();
                    DirectedSubgraph graph = graphView.getDirectedGraph();
                    if (element instanceof Node) {
                        if (!graph.contains((Node)element)) continue;
                        entry.getValue().remove(timeIndex, element);
                        continue;
                    }
                    if (!graph.contains((Edge)element)) continue;
                    entry.getValue().remove(timeIndex, element);
                }
            }
        }
        return timeIndex;
    }

    public void remove(M timeMap) {
        for (Object timeKey : timeMap.toKeysArray()) {
            this.remove((K)timeKey);
        }
    }

    public void remove(S timeSet) {
        for (Object timeKey : timeSet.toArray()) {
            this.remove((K)timeKey);
        }
    }

    public boolean contains(K k) {
        this.checkK(k);
        return this.timeSortedMap.containsKey(k);
    }

    public void index(Element element) {
        S timeSet = this.getTimeSet(element);
        if (timeSet != null) {
            this.add((TimeSet<K>)timeSet);
        }
        for (Object val : element.getAttributes()) {
            if (val == null || !(val instanceof TimeMap)) continue;
            TimeMap dynamicValue = (TimeMap)val;
            this.add(dynamicValue);
        }
        if (timeSet != null && this.mainIndex != null) {
            K[] ts = timeSet.toArray();
            int tsLength = ts.length;
            for (int i = 0; i < tsLength; ++i) {
                int timestampIndex = this.timeSortedMap.get(ts[i]);
                this.mainIndex.add(timestampIndex, element);
            }
        }
    }

    public void clear(Element element) {
        S timeSet = this.getTimeSet(element);
        if (timeSet != null && this.mainIndex != null) {
            K[] ts = timeSet.toArray();
            int tsLength = ts.length;
            for (int i = 0; i < tsLength; ++i) {
                int timestampIndex = this.timeSortedMap.get(ts[i]);
                this.mainIndex.remove(timestampIndex, element);
            }
            if (!this.viewIndexes.isEmpty()) {
                for (Map.Entry<GraphView, TimeIndexImpl> entry : this.viewIndexes.entrySet()) {
                    GraphViewImpl graphView = (GraphViewImpl)entry.getKey();
                    DirectedSubgraph graph = graphView.getDirectedGraph();
                    boolean node = element instanceof Node;
                    if (!(node ? graph.contains((Node)element) : graph.contains((Edge)element))) continue;
                    for (int i = 0; i < tsLength; ++i) {
                        int timestampIndex = this.timeSortedMap.get(ts[i]);
                        entry.getValue().remove(timestampIndex, element);
                    }
                }
            }
        }
        if (timeSet != null) {
            this.remove(timeSet);
        }
        for (Object val : element.getAttributes()) {
            if (val == null || !(val instanceof TimeMap)) continue;
            TimeMap dynamicValue = (TimeMap)val;
            this.remove((S)dynamicValue);
        }
    }

    public void clear() {
        this.timeSortedMap.clear();
        this.garbageQueue.clear();
        this.countMap = new int[0];
        this.length = 0;
        if (this.mainIndex != null) {
            this.mainIndex.clear();
            if (!this.viewIndexes.isEmpty()) {
                for (TimeIndexImpl index : this.viewIndexes.values()) {
                    index.clear();
                }
            }
        }
    }

    public int size() {
        return this.timeSortedMap.size();
    }

    public TimeIndex getIndex(Graph graph) {
        GraphView view = graph.getView();
        if (view.isMainView()) {
            return this.mainIndex;
        }
        TimeIndexImpl viewIndex = this.viewIndexes.get(graph.getView());
        if (viewIndex == null) {
            viewIndex = this.createViewIndex(graph);
            this.viewIndexes.put(graph.getView(), viewIndex);
        }
        return viewIndex;
    }

    protected TimeIndexImpl createViewIndex(Graph graph) {
        if (graph.getView().isMainView()) {
            throw new IllegalArgumentException("Can't create a view index for the main view");
        }
        TimeIndexImpl viewIndex = this.createIndex(false);
        this.viewIndexes.put(graph.getView(), viewIndex);
        this.indexView(graph);
        return viewIndex;
    }

    public void deleteViewIndex(Graph graph) {
        if (graph.getView().isMainView()) {
            throw new IllegalArgumentException("Can't delete a view index for the main view");
        }
        TimeIndexImpl index = this.viewIndexes.remove(graph.getView());
        if (index != null) {
            index.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexView(Graph graph) {
        TimeIndexImpl viewIndex = this.viewIndexes.get(graph.getView());
        if (viewIndex != null) {
            graph.readLock();
            try {
                Iterator<Element> iterator = null;
                if (this.elementType.equals(Node.class)) {
                    iterator = graph.getNodes().iterator();
                } else if (this.elementType.equals(Edge.class)) {
                    iterator = graph.getEdges().iterator();
                }
                if (iterator != null) {
                    while (iterator.hasNext()) {
                        Element element = iterator.next();
                        S set = this.getTimeSet(element);
                        if (set == null) continue;
                        K[] ts = set.toArray();
                        int tsLength = ts.length;
                        for (int i = 0; i < tsLength; ++i) {
                            int timestamp = this.timeSortedMap.get(ts[i]);
                            viewIndex.add(timestamp, element);
                        }
                    }
                }
            }
            finally {
                graph.readUnlock();
            }
        }
    }

    public void indexInView(T element, GraphView view) {
        S set;
        TimeIndexImpl viewIndex = this.viewIndexes.get(view);
        if (viewIndex != null && (set = this.getTimeSet((Element)element)) != null) {
            K[] ts = set.toArray();
            int tsLength = ts.length;
            for (int i = 0; i < tsLength; ++i) {
                int timestampIndex = this.timeSortedMap.get(ts[i]);
                viewIndex.add(timestampIndex, (Element)element);
            }
        }
    }

    public void clearInView(T element, GraphView view) {
        S set;
        ElementImpl elementImpl = (ElementImpl)element;
        TimeIndexImpl viewIndex = this.viewIndexes.get(view);
        if (viewIndex != null && (set = this.getTimeSet((Element)element)) != null) {
            K[] ts = set.toArray();
            int tsLength = ts.length;
            for (int i = 0; i < tsLength; ++i) {
                int timestampIndex = this.timeSortedMap.get(ts[i]);
                viewIndex.remove(timestampIndex, elementImpl);
            }
        }
    }

    public void clear(GraphView view) {
        TimeIndexImpl viewIndex = this.viewIndexes.get(view);
        if (viewIndex != null) {
            viewIndex.clear();
        }
    }

    public boolean hasIndex() {
        return this.mainIndex != null;
    }

    private S getTimeSet(Element element) {
        Object[] attributes = element.getAttributes();
        if (2 < attributes.length) {
            return (S)((TimeSet)attributes[2]);
        }
        return null;
    }

    private void checkTimeIndex(Integer timeIndex) {
        if (timeIndex == null) {
            throw new IllegalArgumentException("Unknown time index");
        }
    }

    protected void ensureArraySize(int index) {
        if (index >= this.countMap.length) {
            int newSize = Math.min(Math.max(index + 1, (int)((double)index * 1.1)), Integer.MAX_VALUE);
            int[] newArray = new int[newSize];
            System.arraycopy(this.countMap, 0, newArray, 0, this.countMap.length);
            this.countMap = newArray;
        }
    }

    public int deepHashCode() {
        int hash = 3;
        hash = 29 * hash + this.elementType.hashCode();
        for (Map.Entry<K, Integer> entry : this.timeSortedMap.entrySet()) {
            hash = 29 * hash + entry.getKey().hashCode();
            hash = 29 * hash + entry.getValue().hashCode();
            hash = 29 * hash + this.countMap[entry.getValue()];
        }
        return hash;
    }

    public boolean deepEquals(TimeIndexStore obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        TimeIndexStore other = obj;
        if (!other.elementType.equals(this.elementType)) {
            return false;
        }
        if (!MapDeepEquals.mapDeepEquals(this.timeSortedMap, other.timeSortedMap)) {
            return false;
        }
        int[] otherCountMap = other.countMap;
        for (Integer k : this.timeSortedMap.values()) {
            if (otherCountMap[k] == this.countMap[k]) continue;
            return false;
        }
        return true;
    }
}

