/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.function.Predicate;
import org.elasticsearch.cluster.ClusterState;

public final class MasterNodeChangePredicate {
    private MasterNodeChangePredicate() {
    }

    public static Predicate<ClusterState> build(ClusterState currentState) {
        long currentVersion = currentState.version();
        String currentMaster = currentState.nodes().getMasterNodeId();
        return newState -> {
            String newMaster = newState.nodes().getMasterNodeId();
            boolean accept = newMaster == null ? false : (!newMaster.equals(currentMaster) ? true : newState.version() > currentVersion);
            return accept;
        };
    }
}

