/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.mrufiles.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.event.EventListenerList;
import org.gephi.desktop.mrufiles.api.MostRecentFiles;
import org.openide.util.NbPreferences;

public class MostRecentFilesImpl
implements MostRecentFiles {
    protected static String DEFAULT_NODE_NAME = "prefs";
    protected String nodeName = "mrufiles";
    private EventListenerList listenerList;
    public static final String MRU_FILE_LIST_PROPERTY = "MRUFileList";
    private List<String> mruFileList = new ArrayList<String>(this.maxSize);
    private int maxSize = 9;

    public MostRecentFilesImpl() {
        this.listenerList = new EventListenerList();
        this.retrieve();
    }

    @Override
    public List<String> getMRUFileList() {
        return this.mruFileList;
    }

    public void setMRUFileList(List<String> list) {
        this.mruFileList.clear();
        for (int i = 0; i < list.size(); ++i) {
            this.mruFileList.add(list.get(i));
            if (i >= this.maxSize) break;
        }
        this.firePropertyChange(MRU_FILE_LIST_PROPERTY, null, this.mruFileList);
        this.store();
    }

    @Override
    public void addFile(String absolutePath) {
        this.mruFileList.remove(absolutePath);
        this.mruFileList.add(0, absolutePath);
        while (this.mruFileList.size() > this.maxSize) {
            this.mruFileList.remove(this.mruFileList.size() - 1);
        }
        this.firePropertyChange(MRU_FILE_LIST_PROPERTY, null, this.mruFileList);
        this.store();
    }

    protected void store() {
        Preferences prefs = this.getPreferences();
        try {
            prefs.clear();
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
        for (int i = 0; i < this.mruFileList.size(); ++i) {
            String str = this.mruFileList.get(i);
            prefs.put(MRU_FILE_LIST_PROPERTY + i, str);
        }
    }

    protected void retrieve() {
        String str;
        this.mruFileList.clear();
        Preferences prefs = this.getPreferences();
        for (int i = 0; i < this.maxSize && (str = prefs.get(MRU_FILE_LIST_PROPERTY + i, null)) != null; ++i) {
            this.mruFileList.add(str);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listenerList.add(PropertyChangeListener.class, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listenerList.remove(PropertyChangeListener.class, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        Object[] listeners = this.listenerList.getListenerList();
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PropertyChangeListener.class) continue;
            ((PropertyChangeListener)listeners[i + 1]).propertyChange(event);
        }
    }

    protected final Preferences getPreferences() {
        String name = DEFAULT_NODE_NAME;
        if (this.nodeName != null) {
            name = this.nodeName;
        }
        Preferences prefs = NbPreferences.forModule(this.getClass()).node("options").node(name);
        return prefs;
    }
}

