/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.importer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.gephi.desktop.importer.ReportPanel;
import org.gephi.desktop.importer.api.ImportControllerUI;
import org.gephi.desktop.mrufiles.api.MostRecentFiles;
import org.gephi.desktop.project.api.ProjectControllerUI;
import org.gephi.io.importer.api.Container;
import org.gephi.io.importer.api.Database;
import org.gephi.io.importer.api.ImportController;
import org.gephi.io.importer.api.Report;
import org.gephi.io.importer.spi.DatabaseImporter;
import org.gephi.io.importer.spi.FileImporter;
import org.gephi.io.importer.spi.Importer;
import org.gephi.io.importer.spi.ImporterUI;
import org.gephi.io.importer.spi.ImporterWizardUI;
import org.gephi.io.importer.spi.WizardImporter;
import org.gephi.io.processor.spi.Processor;
import org.gephi.io.processor.spi.ProcessorUI;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.utils.longtask.api.LongTaskErrorHandler;
import org.gephi.utils.longtask.api.LongTaskExecutor;
import org.gephi.utils.longtask.spi.LongTask;
import org.netbeans.validation.api.ui.ValidationPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DesktopImportControllerUI
implements ImportControllerUI {
    private final LongTaskExecutor executor;
    private final LongTaskErrorHandler errorHandler;
    private final ImportController controller = (ImportController)Lookup.getDefault().lookup(ImportController.class);

    public DesktopImportControllerUI() {
        this.errorHandler = new LongTaskErrorHandler(){

            public void fatalError(Throwable t) {
                if (t instanceof OutOfMemoryError) {
                    return;
                }
                Exceptions.printStackTrace((Throwable)t);
                t.printStackTrace();
            }
        };
        this.executor = new LongTaskExecutor(true, "Importer", 10);
    }

    public void importFile(FileObject fileObject) {
        try {
            final FileImporter importer = this.controller.getFileImporter(FileUtil.toFile((FileObject)fileObject));
            if (importer == null) {
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(this.getClass(), (String)"DesktopImportControllerUI.error_no_matching_file_importer"), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                return;
            }
            MostRecentFiles mostRecentFiles = (MostRecentFiles)Lookup.getDefault().lookup(MostRecentFiles.class);
            mostRecentFiles.addFile(fileObject.getPath());
            ImporterUI ui = this.controller.getUI((Importer)importer);
            if (ui != null) {
                Object result;
                String title = NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.file.ui.dialog.title", (Object)ui.getDisplayName());
                JPanel panel = ui.getPanel();
                FileImporter[] fi = (FileImporter[])Array.newInstance(importer.getClass(), 1);
                fi[0] = importer;
                ui.setup((Importer[])fi);
                final DialogDescriptor dd = new DialogDescriptor((Object)panel, title);
                if (panel instanceof ValidationPanel) {
                    ValidationPanel vp = (ValidationPanel)panel;
                    vp.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            dd.setValid(!((ValidationPanel)e.getSource()).isProblem());
                        }
                    });
                }
                if (!(result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd)).equals(NotifyDescriptor.OK_OPTION)) {
                    ui.unsetup(false);
                    return;
                }
                ui.unsetup(true);
            }
            LongTask task = null;
            if (importer instanceof LongTask) {
                task = (LongTask)importer;
            }
            fileObject = this.getArchivedFile(fileObject);
            final String containerSource = fileObject.getNameExt();
            final InputStream stream = fileObject.getInputStream();
            String taskName = NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.taskName", (Object)containerSource);
            this.executor.execute(task, new Runnable(){

                @Override
                public void run() {
                    try {
                        Container container = DesktopImportControllerUI.this.controller.importFile(stream, importer);
                        if (container != null) {
                            container.setSource(containerSource);
                            DesktopImportControllerUI.this.finishImport(container);
                        }
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }, taskName, this.errorHandler);
        }
        catch (Exception ex) {
            Logger.getLogger("").log(Level.WARNING, "", ex);
        }
    }

    public void importFiles(FileObject[] fileObjects) {
        try {
            HashMap<ImporterUI, ArrayList<FileImporter>> importerUIs = new HashMap<ImporterUI, ArrayList<FileImporter>>();
            ArrayList<FileImporter> importers = new ArrayList<FileImporter>();
            for (FileObject fileObject : fileObjects) {
                FileImporter importer = this.controller.getFileImporter(FileUtil.toFile((FileObject)fileObject));
                if (importer == null) {
                    NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(this.getClass(), (String)"DesktopImportControllerUI.error_no_matching_file_importer"), 2);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                    return;
                }
                importers.add(importer);
                ImporterUI ui = this.controller.getUI((Importer)importer);
                if (ui != null) {
                    ArrayList<FileImporter> l = (ArrayList<FileImporter>)importerUIs.get(ui);
                    if (l == null) {
                        l = new ArrayList<FileImporter>();
                        importerUIs.put(ui, l);
                    }
                    l.add(importer);
                }
                MostRecentFiles mostRecentFiles = (MostRecentFiles)Lookup.getDefault().lookup(MostRecentFiles.class);
                mostRecentFiles.addFile(fileObject.getPath());
            }
            for (Map.Entry entry : importerUIs.entrySet()) {
                Object result;
                ImporterUI ui = (ImporterUI)entry.getKey();
                String title = NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.file.ui.dialog.title", (Object)ui.getDisplayName());
                JPanel panel = ui.getPanel();
                FileImporter[] fi = ((List)entry.getValue()).toArray((FileImporter[])Array.newInstance(((FileImporter)((List)entry.getValue()).get(0)).getClass(), 0));
                ui.setup((Importer[])fi);
                final DialogDescriptor dd = new DialogDescriptor((Object)panel, title);
                if (panel instanceof ValidationPanel) {
                    ValidationPanel vp = (ValidationPanel)panel;
                    vp.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            dd.setValid(!((ValidationPanel)e.getSource()).isProblem());
                        }
                    });
                }
                if (!(result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd)).equals(NotifyDescriptor.OK_OPTION)) {
                    ui.unsetup(false);
                    return;
                }
                ui.unsetup(true);
            }
            final ArrayList result = new ArrayList();
            for (int i = 0; i < importers.size(); ++i) {
                FileObject fileObject;
                final FileImporter importer = (FileImporter)importers.get(i);
                fileObject = fileObjects[i];
                LongTask task = null;
                if (importer instanceof LongTask) {
                    task = (LongTask)importer;
                }
                fileObject = this.getArchivedFile(fileObject);
                final String containerSource = fileObject.getNameExt();
                final InputStream stream = fileObject.getInputStream();
                String taskName = NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.taskName", (Object)containerSource);
                this.executor.execute(task, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Container container = DesktopImportControllerUI.this.controller.importFile(stream, importer);
                            if (container != null) {
                                container.setSource(containerSource);
                                result.add(container);
                            }
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                }, taskName, this.errorHandler);
            }
            this.executor.execute(null, new Runnable(){

                @Override
                public void run() {
                    if (!result.isEmpty()) {
                        DesktopImportControllerUI.this.finishImport(result.toArray(new Container[0]));
                    }
                }
            });
        }
        catch (Exception ex) {
            Logger.getLogger("").log(Level.WARNING, "", ex);
        }
    }

    public void importStream(final InputStream stream, String importerName) {
        try {
            final FileImporter importer = this.controller.getFileImporter(importerName);
            if (importer == null) {
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(this.getClass(), (String)"DesktopImportControllerUI.error_no_matching_file_importer"), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                return;
            }
            ImporterUI ui = this.controller.getUI((Importer)importer);
            if (ui != null) {
                Object result;
                String title = NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.file.ui.dialog.title", (Object)ui.getDisplayName());
                JPanel panel = ui.getPanel();
                FileImporter[] fi = (FileImporter[])Array.newInstance(importer.getClass(), 1);
                fi[0] = importer;
                ui.setup((Importer[])fi);
                final DialogDescriptor dd = new DialogDescriptor((Object)panel, title);
                if (panel instanceof ValidationPanel) {
                    ValidationPanel vp = (ValidationPanel)panel;
                    vp.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            dd.setValid(!((ValidationPanel)e.getSource()).isProblem());
                        }
                    });
                }
                if (!(result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd)).equals(NotifyDescriptor.OK_OPTION)) {
                    ui.unsetup(false);
                    return;
                }
                ui.unsetup(true);
            }
            LongTask task = null;
            if (importer instanceof LongTask) {
                task = (LongTask)importer;
            }
            final String containerSource = NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.streamSource", (Object)importerName);
            String taskName = NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.taskName", (Object)containerSource);
            this.executor.execute(task, new Runnable(){

                @Override
                public void run() {
                    try {
                        Container container = DesktopImportControllerUI.this.controller.importFile(stream, importer);
                        if (container != null) {
                            container.setSource(containerSource);
                            DesktopImportControllerUI.this.finishImport(container);
                        }
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }, taskName, this.errorHandler);
        }
        catch (Exception ex) {
            Logger.getLogger("").log(Level.WARNING, "", ex);
        }
    }

    public void importFile(final Reader reader, String importerName) {
        try {
            final FileImporter importer = this.controller.getFileImporter(importerName);
            if (importer == null) {
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(this.getClass(), (String)"DesktopImportControllerUI.error_no_matching_file_importer"), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                return;
            }
            ImporterUI ui = this.controller.getUI((Importer)importer);
            if (ui != null) {
                Object result;
                FileImporter[] fi = (FileImporter[])Array.newInstance(importer.getClass(), 1);
                fi[0] = importer;
                ui.setup((Importer[])fi);
                String title = NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.file.ui.dialog.title", (Object)ui.getDisplayName());
                JPanel panel = ui.getPanel();
                final DialogDescriptor dd = new DialogDescriptor((Object)panel, title);
                if (panel instanceof ValidationPanel) {
                    ValidationPanel vp = (ValidationPanel)panel;
                    vp.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            dd.setValid(!((ValidationPanel)e.getSource()).isProblem());
                        }
                    });
                }
                if (!(result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd)).equals(NotifyDescriptor.OK_OPTION)) {
                    ui.unsetup(false);
                    return;
                }
                ui.unsetup(true);
            }
            LongTask task = null;
            if (importer instanceof LongTask) {
                task = (LongTask)importer;
            }
            final String containerSource = NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.streamSource", (Object)importerName);
            String taskName = NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.taskName", (Object)containerSource);
            this.executor.execute(task, new Runnable(){

                @Override
                public void run() {
                    try {
                        Container container = DesktopImportControllerUI.this.controller.importFile(reader, importer);
                        if (container != null) {
                            container.setSource(containerSource);
                            DesktopImportControllerUI.this.finishImport(container);
                        }
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }, taskName, this.errorHandler);
        }
        catch (Exception ex) {
            Logger.getLogger("").log(Level.WARNING, "", ex);
        }
    }

    public void importDatabase(DatabaseImporter importer) {
        this.importDatabase(null, importer);
    }

    public void importDatabase(Database database, final DatabaseImporter importer) {
        try {
            if (importer == null) {
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.error_no_matching_db_importer"), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                return;
            }
            ImporterUI ui = this.controller.getUI((Importer)importer);
            if (ui != null) {
                Object result;
                String title = NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.database.ui.dialog.title");
                JPanel panel = ui.getPanel();
                ui.setup((Importer[])new DatabaseImporter[]{importer});
                final DialogDescriptor dd = new DialogDescriptor((Object)panel, title);
                if (panel instanceof ValidationPanel) {
                    ValidationPanel vp = (ValidationPanel)panel;
                    vp.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            dd.setValid(!((ValidationPanel)e.getSource()).isProblem());
                        }
                    });
                }
                if ((result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd)).equals(NotifyDescriptor.CANCEL_OPTION) || result.equals(NotifyDescriptor.CLOSED_OPTION)) {
                    ui.unsetup(false);
                    return;
                }
                ui.unsetup(true);
                if (database == null) {
                    database = importer.getDatabase();
                }
            }
            LongTask task = null;
            if (importer instanceof LongTask) {
                task = (LongTask)importer;
            }
            final String containerSource = database != null ? database.getName() : (ui != null ? ui.getDisplayName() : importer.getClass().getSimpleName());
            final Database db = database;
            String taskName = NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.taskName", (Object)containerSource);
            this.executor.execute(task, new Runnable(){

                @Override
                public void run() {
                    try {
                        Container container = DesktopImportControllerUI.this.controller.importDatabase(db, importer);
                        if (container != null) {
                            container.setSource(containerSource);
                            DesktopImportControllerUI.this.finishImport(container);
                        }
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }, taskName, this.errorHandler);
        }
        catch (Exception ex) {
            Logger.getLogger("").log(Level.WARNING, "", ex);
        }
    }

    public void importWizard(final WizardImporter importer) {
        try {
            ImporterWizardUI wizardUI;
            if (importer == null) {
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.error_no_matching_db_importer"), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                return;
            }
            String containerSource = NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.wizardSource", (Object)"");
            ImporterUI ui = this.controller.getUI((Importer)importer);
            if (ui != null) {
                Object result;
                String title = NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.wizard.ui.dialog.title", (Object)ui.getDisplayName());
                JPanel panel = ui.getPanel();
                ui.setup((Importer[])new WizardImporter[]{importer});
                final DialogDescriptor dd = new DialogDescriptor((Object)panel, title);
                if (panel instanceof ValidationPanel) {
                    ValidationPanel vp = (ValidationPanel)panel;
                    vp.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            dd.setValid(!((ValidationPanel)e.getSource()).isProblem());
                        }
                    });
                }
                if ((result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd)).equals(NotifyDescriptor.CANCEL_OPTION) || result.equals(NotifyDescriptor.CLOSED_OPTION)) {
                    ui.unsetup(false);
                    return;
                }
                ui.unsetup(true);
                containerSource = ui.getDisplayName();
            }
            if ((wizardUI = this.controller.getWizardUI((Importer)importer)) != null) {
                containerSource = wizardUI.getCategory() + ":" + wizardUI.getDisplayName();
            }
            LongTask task = null;
            if (importer instanceof LongTask) {
                task = (LongTask)importer;
            }
            final String source = containerSource;
            String taskName = NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.taskName", (Object)containerSource);
            this.executor.execute(task, new Runnable(){

                @Override
                public void run() {
                    try {
                        Container container = DesktopImportControllerUI.this.controller.importWizard(importer);
                        if (container != null) {
                            container.setSource(source);
                            DesktopImportControllerUI.this.finishImport(container);
                        }
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }, taskName, this.errorHandler);
        }
        catch (Exception ex) {
            Logger.getLogger("").log(Level.WARNING, "", ex);
        }
    }

    private void finishImport(Container container) {
        this.finishImport(new Container[]{container});
    }

    private void finishImport(Container[] containers) {
        Report finalReport = new Report();
        for (Container container : containers) {
            if (!container.verify()) continue;
            Report report = container.getReport();
            report.close();
            finalReport.append(report);
        }
        finalReport.close();
        ReportPanel reportPanel = new ReportPanel();
        reportPanel.setData(finalReport, containers);
        DialogDescriptor dd = new DialogDescriptor((Object)reportPanel, NbBundle.getMessage(DesktopImportControllerUI.class, (String)"ReportPanel.title"));
        Object response = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        reportPanel.destroy();
        finalReport.clean();
        for (Container c : containers) {
            c.getReport().clean();
        }
        if (!response.equals(NotifyDescriptor.OK_OPTION)) {
            return;
        }
        final Processor processor = reportPanel.getProcessor();
        Workspace workspace = null;
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        ProjectControllerUI pcui = (ProjectControllerUI)Lookup.getDefault().lookup(ProjectControllerUI.class);
        if (pc.getCurrentProject() == null) {
            pcui.newProject();
            workspace = pc.getCurrentWorkspace();
        }
        final ProcessorUI pui = this.getProcessorUI(processor);
        final ValidResult validResult = new ValidResult();
        if (pui != null) {
            try {
                final JPanel panel = pui.getPanel();
                if (panel != null) {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            Object result;
                            String title = NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.processor.ui.dialog.title");
                            pui.setup(processor);
                            final DialogDescriptor dd2 = new DialogDescriptor((Object)panel, title);
                            if (panel instanceof ValidationPanel) {
                                ValidationPanel vp = (ValidationPanel)panel;
                                vp.addChangeListener(new ChangeListener(){

                                    @Override
                                    public void stateChanged(ChangeEvent e) {
                                        dd2.setValid(!((ValidationPanel)e.getSource()).isProblem());
                                    }
                                });
                                dd2.setValid(!vp.isProblem());
                            }
                            if ((result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd2)).equals(NotifyDescriptor.CANCEL_OPTION) || result.equals(NotifyDescriptor.CLOSED_OPTION)) {
                                validResult.setResult(false);
                            } else {
                                pui.unsetup();
                                validResult.setResult(true);
                            }
                        }
                    });
                }
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (validResult.isResult()) {
            this.controller.process(containers, processor, workspace);
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(DesktopImportControllerUI.class, (String)"DesktopImportControllerUI.status.multiImportSuccess", (Object)containers.length));
        }
    }

    private FileObject getArchivedFile(FileObject fileObject) {
        if (FileUtil.isArchiveFile((FileObject)fileObject)) {
            try {
                fileObject = FileUtil.getArchiveRoot((FileObject)fileObject).getChildren()[0];
            }
            catch (Exception e) {
                throw new RuntimeException("The archive can't be opened, be sure it has no password and contains a single file, without folders");
            }
        }
        boolean isGz = fileObject.getExt().equalsIgnoreCase("gz");
        boolean isBzip = fileObject.getExt().equalsIgnoreCase("bz2");
        if (isGz || isBzip) {
            try {
                String[] splittedFileName = fileObject.getName().split("\\.");
                if (splittedFileName.length < 2) {
                    return fileObject;
                }
                String fileExt1 = splittedFileName[splittedFileName.length - 1];
                String fileExt2 = splittedFileName[splittedFileName.length - 2];
                File tempFile = null;
                if (fileExt1.equalsIgnoreCase("tar")) {
                    String fname = fileObject.getName().replaceAll("\\.tar$", "");
                    fname = fname.replace(fileExt2, "");
                    tempFile = File.createTempFile(fname, "." + fileExt2);
                    tempFile = isGz ? DesktopImportControllerUI.getGzFile(fileObject, tempFile, true) : DesktopImportControllerUI.getBzipFile(fileObject, tempFile, true);
                } else {
                    String fname = fileObject.getName();
                    fname = fname.replace(fileExt1, "");
                    tempFile = File.createTempFile(fname, "." + fileExt1);
                    tempFile = isGz ? DesktopImportControllerUI.getGzFile(fileObject, tempFile, false) : DesktopImportControllerUI.getBzipFile(fileObject, tempFile, false);
                }
                tempFile.deleteOnExit();
                tempFile = FileUtil.normalizeFile((File)tempFile);
                fileObject = FileUtil.toFileObject((File)tempFile);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return fileObject;
    }

    public ImportController getImportController() {
        return this.controller;
    }

    private ProcessorUI getProcessorUI(Processor processor) {
        for (ProcessorUI pui : Lookup.getDefault().lookupAll(ProcessorUI.class)) {
            if (!pui.isUIFoProcessor(processor)) continue;
            return pui;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getBzipFile(FileObject in, File out, boolean isTar) throws IOException {
        int BUFF_SIZE = 8192;
        byte[] buffer = new byte[8192];
        BZip2CompressorInputStream inputStream = null;
        FileOutputStream outStream = null;
        try {
            FileInputStream is = new FileInputStream(in.getPath());
            inputStream = new BZip2CompressorInputStream((InputStream)is);
            outStream = new FileOutputStream(out.getAbsolutePath());
            if (isTar) {
                int nRead;
                int remainingBytes = DesktopImportControllerUI.readTarHeader((InputStream)inputStream);
                ByteBuffer bb = ByteBuffer.allocateDirect(32768);
                byte[] tmpCache = new byte[8192];
                while ((nRead = inputStream.read(tmpCache)) != -1) {
                    if (nRead == 0) continue;
                    bb.put(tmpCache);
                    bb.position(0);
                    bb.limit(nRead);
                    while (bb.hasRemaining() && remainingBytes > 0) {
                        int nGet = Math.min(bb.remaining(), 8192);
                        nGet = Math.min(nGet, remainingBytes);
                        bb.get(buffer, 0, nGet);
                        outStream.write(buffer, 0, nGet);
                        remainingBytes -= nGet;
                    }
                    bb.clear();
                }
            } else {
                int len;
                while ((len = inputStream.read(buffer)) > 0) {
                    outStream.write(buffer, 0, len);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outStream != null) {
                outStream.close();
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getGzFile(FileObject in, File out, boolean isTar) throws IOException {
        int BUFF_SIZE = 8192;
        byte[] buffer = new byte[8192];
        GZIPInputStream inputStream = null;
        FileOutputStream outStream = null;
        try {
            inputStream = new GZIPInputStream(new FileInputStream(in.getPath()));
            outStream = new FileOutputStream(out);
            if (isTar) {
                int nRead;
                int remainingBytes = DesktopImportControllerUI.readTarHeader(inputStream);
                ByteBuffer bb = ByteBuffer.allocateDirect(32768);
                byte[] tmpCache = new byte[8192];
                while ((nRead = inputStream.read(tmpCache)) != -1) {
                    if (nRead == 0) continue;
                    bb.put(tmpCache);
                    bb.position(0);
                    bb.limit(nRead);
                    while (bb.hasRemaining() && remainingBytes > 0) {
                        int nGet = Math.min(bb.remaining(), 8192);
                        nGet = Math.min(nGet, remainingBytes);
                        bb.get(buffer, 0, nGet);
                        outStream.write(buffer, 0, nGet);
                        remainingBytes -= nGet;
                    }
                    bb.clear();
                }
            } else {
                int len;
                while ((len = inputStream.read(buffer)) > 0) {
                    outStream.write(buffer, 0, len);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outStream != null) {
                outStream.close();
            }
        }
        return out;
    }

    private static int readTarHeader(InputStream inputStream) throws IOException {
        int FILE_SIZE_OFFSET = 124;
        int FILE_SIZE_LENGTH = 12;
        int HEADER_LENGTH = 512;
        DesktopImportControllerUI.ignoreBytes(inputStream, 124);
        String fileSizeLengthOctalString = DesktopImportControllerUI.readString(inputStream, 12).trim();
        int fileSize = Integer.parseInt(fileSizeLengthOctalString, 8);
        DesktopImportControllerUI.ignoreBytes(inputStream, 376);
        return fileSize;
    }

    private static void ignoreBytes(InputStream inputStream, int numberOfBytes) throws IOException {
        for (int counter = 0; counter < numberOfBytes; ++counter) {
            inputStream.read();
        }
    }

    private static String readString(InputStream inputStream, int numberOfBytes) throws IOException {
        return new String(DesktopImportControllerUI.readBytes(inputStream, numberOfBytes));
    }

    private static byte[] readBytes(InputStream inputStream, int numberOfBytes) throws IOException {
        byte[] readBytes = new byte[numberOfBytes];
        inputStream.read(readBytes);
        return readBytes;
    }

    private static class ValidResult {
        private boolean result = true;

        private ValidResult() {
        }

        public void setResult(boolean result) {
            this.result = result;
        }

        public boolean isResult() {
            return this.result;
        }
    }
}

