/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.progress.spi;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.modules.progress.spi.Controller;
import org.netbeans.modules.progress.spi.ProgressUIWorker;
import org.netbeans.modules.progress.spi.ProgressUIWorkerProvider;
import org.netbeans.modules.progress.spi.ProgressUIWorkerWithModel;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class SwingController
extends Controller
implements Executor,
Runnable {
    private static final SwingController INSTANCE = new SwingController(null);
    private static final int TIMER_QUANTUM = 400;
    final Timer timer = new Timer(400, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingController.this.runNow();
        }
    });
    static final Method compatInit;

    public SwingController(ProgressUIWorker comp) {
        super(comp);
        this.timer.setRepeats(false);
        SwingController.runCompatInit(this);
    }

    protected Executor getEventExecutor() {
        return this;
    }

    protected void runEvents() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.runNow();
        } else {
            this.execute(this);
        }
    }

    @Override
    public void run() {
        this.runNow();
    }

    @Override
    public void execute(final Runnable r) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                r.run();
            }
        });
    }

    protected void resetTimer(int delay, boolean restart) {
        if (delay > 0) {
            this.timer.setInitialDelay(delay);
            if (restart) {
                this.timer.restart();
            }
        } else {
            this.timer.stop();
        }
    }

    public static SwingController getDefault() {
        return INSTANCE;
    }

    public Component getVisualComponent() {
        ProgressUIWorker component = this.getProgressUIWorker();
        if (component instanceof Component) {
            return (Component)component;
        }
        return null;
    }

    protected ProgressUIWorkerWithModel createWorker() {
        return ((ProgressUIWorkerProvider)Lookup.getDefault().lookup(ProgressUIWorkerProvider.class)).getDefaultWorker();
    }

    protected Timer getTimer() {
        return this.timer;
    }

    private static void runCompatInit(SwingController instance) {
        if (compatInit != null) {
            try {
                compatInit.invoke((Object)instance, instance.timer);
            }
            catch (IllegalAccessException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    static {
        Class clazz = SwingController.class.getSuperclass().getSuperclass();
        Method m = null;
        try {
            m = clazz.getDeclaredMethod("compatPostInit", Timer.class);
            m.setAccessible(true);
        }
        catch (NoSuchMethodException ex) {
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        compatInit = m;
    }
}

