/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.file;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gephi.io.importer.api.ContainerLoader;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.ImportUtils;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.importer.api.Report;
import org.gephi.io.importer.spi.FileImporter;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;

public class ImporterCSV
implements FileImporter,
LongTask {
    private Reader reader;
    private ContainerLoader container;
    private Report report;
    private ProgressTicket progressTicket;
    private boolean cancel = false;

    public boolean execute(ContainerLoader container) {
        this.container = container;
        this.report = new Report();
        LineNumberReader lineReader = ImportUtils.getTextReader((Reader)this.reader);
        try {
            this.importData(lineReader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                lineReader.close();
            }
            catch (IOException ex) {}
        }
        return !this.cancel;
    }

    private void importData(LineNumberReader reader) throws Exception {
        Progress.start((ProgressTicket)this.progressTicket);
        ArrayList<String> lines = new ArrayList<String>();
        while (reader.ready()) {
            String line = reader.readLine();
            if (line == null || line.isEmpty()) continue;
            lines.add(line);
        }
        Progress.switchToDeterminate((ProgressTicket)this.progressTicket, (int)lines.size());
        Pattern pattern = Pattern.compile("(?<=(?:,|;|\\s|^)\")(.*?)(?=(?<=(?:[^\\\\]))\",|;|\"\\s|\"$)|(?<=(?:,|;|\\s|^)')(.*?)(?=(?<=(?:[^\\\\]))',|;|'\\s|'$)|(?<=(?:,|;|\\s|^))(?=[^'\"])(.*?)(?=(?:,|;|\\s|$))|(?<=,|;)($)");
        if (((String)lines.get(0)).startsWith(";")) {
            String line0 = (String)lines.get(0);
            line0 = line0.substring(1, line0.length());
            lines.remove(0);
            Matcher m = pattern.matcher(line0);
            ArrayList<String> labels = new ArrayList<String>();
            while (m.find()) {
                int end;
                int start = m.start();
                if (start == (end = m.end())) continue;
                String data = line0.substring(start, end);
                if ((data = data.trim()).isEmpty() || data.toLowerCase().equals("null")) continue;
                labels.add(data);
            }
            int size = lines.size();
            if (size != labels.size()) {
                throw new Exception("Inconsistent number of matrix lines compared to the number of labels.");
            }
            for (int i = 0; i < size; ++i) {
                if (this.cancel) {
                    return;
                }
                String line = (String)lines.get(i);
                m = pattern.matcher(line);
                int count = -1;
                String sourceID = "";
                while (m.find()) {
                    int end;
                    int start = m.start();
                    if (start != (end = m.end())) {
                        String data = line.substring(start, end);
                        if (!(data = data.trim()).isEmpty() && !data.toLowerCase().equals("null")) {
                            if (count == -1) {
                                sourceID = data;
                                this.addNode(sourceID, (String)labels.get(i));
                            } else if (!data.equals("0")) {
                                this.addEdge(sourceID, (String)labels.get(count), Float.parseFloat(data));
                            }
                        }
                    }
                    ++count;
                }
                Progress.progress((ProgressTicket)this.progressTicket);
            }
        } else {
            for (String line : lines) {
                if (this.cancel) {
                    return;
                }
                Matcher m = pattern.matcher(line);
                int count = 0;
                String sourceID = "";
                while (m.find()) {
                    int end;
                    int start = m.start();
                    if (start != (end = m.end())) {
                        String data = line.substring(start, end);
                        if (!(data = data.trim()).isEmpty() && !data.toLowerCase().equals("null")) {
                            if (count == 0) {
                                sourceID = data;
                                this.addNode(sourceID, data);
                            } else {
                                this.addEdge(sourceID, data);
                            }
                        }
                    }
                    ++count;
                }
                Progress.progress((ProgressTicket)this.progressTicket);
            }
        }
    }

    private void addNode(String id, String label) {
        if (!this.container.nodeExists(id)) {
            NodeDraft node = this.container.factory().newNodeDraft(id);
            node.setLabel(label);
            this.container.addNode(node);
        }
    }

    private void addEdge(String source, String target) {
        this.addEdge(source, target, 1.0f);
    }

    private void addEdge(String source, String target, float weight) {
        NodeDraft targetNode;
        NodeDraft sourceNode;
        if (!this.container.nodeExists(source)) {
            sourceNode = this.container.factory().newNodeDraft(source);
            this.container.addNode(sourceNode);
        } else {
            sourceNode = this.container.getNode(source);
        }
        if (!this.container.nodeExists(target)) {
            targetNode = this.container.factory().newNodeDraft(target);
            this.container.addNode(targetNode);
        } else {
            targetNode = this.container.getNode(target);
        }
        EdgeDraft edge = this.container.factory().newEdgeDraft();
        edge.setSource(sourceNode);
        edge.setTarget(targetNode);
        edge.setWeight((double)weight);
        this.container.addEdge(edge);
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public ContainerLoader getContainer() {
        return this.container;
    }

    public Report getReport() {
        return this.report;
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }
}

