/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics.plugin;

import java.util.HashMap;
import java.util.Map;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Table;
import org.gephi.statistics.plugin.ChartUtils;
import org.gephi.statistics.spi.Statistics;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.openide.util.Lookup;

public class Hits
implements Statistics,
LongTask {
    public static final String AUTHORITY = "authority";
    public static final String HUB = "hub";
    private boolean isCanceled;
    private ProgressTicket progress;
    private double[] authority;
    private double[] hubs;
    private boolean useUndirected;
    private double epsilon = 1.0E-4;

    public Hits() {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        if (graphController != null && graphController.getGraphModel() != null) {
            this.useUndirected = graphController.getGraphModel().isUndirected();
        }
    }

    public void setUndirected(boolean pUndirected) {
        this.useUndirected = pUndirected;
    }

    public boolean getUndirected() {
        return this.useUndirected;
    }

    public void execute(GraphModel graphModel) {
        Object graph = null;
        graph = this.useUndirected ? graphModel.getUndirectedGraphVisible() : graphModel.getDirectedGraphVisible();
        this.execute((Graph)graph);
    }

    public void execute(Graph hgraph) {
        this.initializeAttributeColunms(hgraph.getModel());
        hgraph.readLock();
        int N = hgraph.getNodeCount();
        this.authority = new double[N];
        this.hubs = new double[N];
        HashMap<Node, Integer> indicies = this.createIndiciesMap(hgraph);
        this.calculateHits(hgraph, this.hubs, this.authority, indicies, !this.useUndirected, this.epsilon);
        this.saveCalculatedValues(hgraph, this.authority, this.hubs);
        hgraph.readUnlockAll();
    }

    public void calculateHits(Graph hgraph, double[] hubValues, double[] authorityValues, Map<Node, Integer> indicies, boolean isDirected, double eps) {
        boolean done;
        int N = hgraph.getNodeCount();
        double[] temp_authority = new double[N];
        double[] temp_hubs = new double[N];
        this.initializeStartValues(hubValues, authorityValues);
        Progress.start((ProgressTicket)this.progress);
        do {
            done = true;
            this.updateAutorithy(hgraph, temp_authority, hubValues, isDirected, indicies);
            this.updateHub(hgraph, temp_hubs, temp_authority, isDirected, indicies);
            done = this.checkDiff(authorityValues, temp_authority, eps) && this.checkDiff(hubValues, temp_hubs, eps);
            System.arraycopy(temp_authority, 0, authorityValues, 0, N);
            System.arraycopy(temp_hubs, 0, hubValues, 0, N);
            temp_authority = new double[N];
            temp_hubs = new double[N];
        } while (!done && !this.isCanceled);
    }

    private void initializeAttributeColunms(GraphModel graphModel) {
        Table nodeTable = graphModel.getNodeTable();
        if (!nodeTable.hasColumn(AUTHORITY)) {
            nodeTable.addColumn(AUTHORITY, "Authority", Float.class, (Object)new Float(0.0f));
        }
        if (!nodeTable.hasColumn(HUB)) {
            nodeTable.addColumn(HUB, "Hub", Float.class, (Object)new Float(0.0f));
        }
    }

    private void initializeStartValues(double[] hubValues, double[] authorityValues) {
        for (int i = 0; i < authorityValues.length; ++i) {
            authorityValues[i] = 1.0;
            hubValues[i] = 1.0;
        }
    }

    void updateAutorithy(Graph hgraph, double[] newValues, double[] hubValues, boolean isDirected, Map<Node, Integer> indicies) {
        double norm = 0.0;
        int j = 0;
        for (Node node : hgraph.getNodes()) {
            double auth = 0.0;
            EdgeIterable edge_iter = isDirected ? ((DirectedGraph)hgraph).getInEdges(node) : hgraph.getEdges(node);
            for (Edge edge : edge_iter) {
                Node target = hgraph.getOpposite(node, edge);
                auth += hubValues[indicies.get(target)];
            }
            if (auth > 0.0) {
                newValues[j] = auth;
            }
            norm += newValues[j++];
            if (!this.isCanceled) continue;
            return;
        }
        if (norm > 0.0) {
            for (int i = 0; i < newValues.length; ++i) {
                newValues[i] = newValues[i] / norm;
            }
        }
    }

    void updateHub(Graph hgraph, double[] newValues, double[] authValues, boolean isDirected, Map<Node, Integer> indicies) {
        double norm = 0.0;
        int j = 0;
        for (Node node : hgraph.getNodes()) {
            double hub = 0.0;
            EdgeIterable edge_iter = isDirected ? ((DirectedGraph)hgraph).getOutEdges(node) : hgraph.getEdges(node);
            for (Edge edge : edge_iter) {
                Node target = hgraph.getOpposite(node, edge);
                hub += authValues[indicies.get(target)];
            }
            if (hub > 0.0) {
                newValues[j] = hub;
            }
            norm += newValues[j++];
            if (!this.isCanceled) continue;
            return;
        }
        if (norm > 0.0) {
            for (int i = 0; i < newValues.length; ++i) {
                newValues[i] = newValues[i] / norm;
            }
        }
    }

    private boolean checkDiff(double[] oldValues, double[] newValues, double epsilon) {
        for (int i = 0; i < oldValues.length; ++i) {
            if (!(oldValues[i] > 0.0) || !((newValues[i] - oldValues[i]) / oldValues[i] >= epsilon)) continue;
            return false;
        }
        return true;
    }

    private void saveCalculatedValues(Graph hgraph, double[] nodeAuthority, double[] nodeHubs) {
        int i = 0;
        for (Node s : hgraph.getNodes()) {
            int s_index = i++;
            s.setAttribute(AUTHORITY, (Object)Float.valueOf((float)nodeAuthority[s_index]));
            s.setAttribute(HUB, (Object)Float.valueOf((float)nodeHubs[s_index]));
        }
    }

    public HashMap<Node, Integer> createIndiciesMap(Graph hgraph) {
        HashMap<Node, Integer> newIndicies = new HashMap<Node, Integer>();
        int index = 0;
        for (Node s : hgraph.getNodes()) {
            newIndicies.put(s, index);
            ++index;
        }
        return newIndicies;
    }

    public String getReport() {
        HashMap<Double, Integer> distHubs = new HashMap<Double, Integer>();
        for (int i = 0; i < this.hubs.length; ++i) {
            Double d = this.hubs[i];
            if (distHubs.containsKey(d)) {
                Integer v = (Integer)distHubs.get(d);
                distHubs.put(d, v + 1);
                continue;
            }
            distHubs.put(d, 1);
        }
        HashMap<Double, Integer> distAuthorities = new HashMap<Double, Integer>();
        for (int i = 0; i < this.authority.length; ++i) {
            Double d = this.authority[i];
            if (distAuthorities.containsKey(d)) {
                Integer v = (Integer)distAuthorities.get(d);
                distAuthorities.put(d, v + 1);
                continue;
            }
            distAuthorities.put(d, 1);
        }
        XYSeries dHubsSeries = ChartUtils.createXYSeries(distHubs, "Hubs");
        XYSeries dAuthsSeries = ChartUtils.createXYSeries(distAuthorities, "Authority");
        XYSeriesCollection datasetHubs = new XYSeriesCollection();
        datasetHubs.addSeries(dHubsSeries);
        XYSeriesCollection datasetAuths = new XYSeriesCollection();
        datasetAuths.addSeries(dAuthsSeries);
        JFreeChart chart = ChartFactory.createXYLineChart((String)"Hubs Distribution", (String)"Score", (String)"Count", (XYDataset)datasetHubs, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        chart.removeLegend();
        ChartUtils.decorateChart(chart);
        ChartUtils.scaleChart(chart, dHubsSeries, true);
        String imageFile1 = ChartUtils.renderChart(chart, "hubs.png");
        JFreeChart chart2 = ChartFactory.createXYLineChart((String)"Authority Distribution", (String)"Score", (String)"Count", (XYDataset)datasetAuths, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        chart2.removeLegend();
        ChartUtils.decorateChart(chart2);
        ChartUtils.scaleChart(chart2, dAuthsSeries, true);
        String imageFile2 = ChartUtils.renderChart(chart2, "authorities.png");
        String report = "<HTML> <BODY> <h1> HITS Metric Report </h1><hr><br /><h2> Parameters: </h2>  &#917; = " + this.epsilon + "<br /> <h2> Results: </h2><br />" + imageFile1 + "<br />" + imageFile2 + "<br /><br />" + "<h2> Algorithm: </h2>" + "Jon M. Kleinberg, <i>Authoritative Sources in a Hyperlinked Environment</i>, in Journal of the ACM 46 (5): 604\u2013632 (1999)<br />" + "</BODY> </HTML>";
        return report;
    }

    public boolean cancel() {
        this.isCanceled = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }

    public void setEpsilon(double eps) {
        this.epsilon = eps;
    }

    public double getEpsilon() {
        return this.epsilon;
    }
}

