/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Node;
import org.gephi.preview.AbstractRenderTarget;
import org.gephi.preview.PreviewModelImpl;
import org.gephi.preview.api.Item;
import org.gephi.preview.api.PreviewController;
import org.gephi.preview.api.PreviewModel;
import org.gephi.preview.api.PreviewMouseEvent;
import org.gephi.preview.api.PreviewProperties;
import org.gephi.preview.api.RenderTarget;
import org.gephi.preview.spi.ItemBuilder;
import org.gephi.preview.spi.MouseResponsiveRenderer;
import org.gephi.preview.spi.PreviewMouseListener;
import org.gephi.preview.spi.RenderTargetBuilder;
import org.gephi.preview.spi.Renderer;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceListener;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class PreviewControllerImpl
implements PreviewController {
    private PreviewModelImpl model;
    private final GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
    private Renderer[] registeredRenderers = null;
    private Boolean anyPluginRendererRegistered = null;
    private boolean mousePressed = false;

    public PreviewControllerImpl() {
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        pc.addWorkspaceListener(new WorkspaceListener(){

            public void initialize(Workspace workspace) {
            }

            public void select(Workspace workspace) {
                PreviewControllerImpl.this.model = (PreviewModelImpl)workspace.getLookup().lookup(PreviewModelImpl.class);
                if (PreviewControllerImpl.this.model == null) {
                    PreviewControllerImpl.this.model = new PreviewModelImpl(workspace);
                    workspace.add((Object)PreviewControllerImpl.this.model);
                }
            }

            public void unselect(Workspace workspace) {
                PreviewControllerImpl.this.model = null;
            }

            public void close(Workspace workspace) {
            }

            public void disable() {
                PreviewControllerImpl.this.model = null;
            }
        });
        if (pc.getCurrentWorkspace() != null) {
            this.model = (PreviewModelImpl)pc.getCurrentWorkspace().getLookup().lookup(PreviewModelImpl.class);
            if (this.model == null) {
                this.model = new PreviewModelImpl(pc.getCurrentWorkspace(), this);
                pc.getCurrentWorkspace().add((Object)this.model);
            }
        }
    }

    @Override
    public void refreshPreview() {
        this.refreshPreview(this.model.getWorkspace());
    }

    @Override
    public synchronized void refreshPreview(Workspace workspace) {
        Renderer[] renderers;
        GraphModel graphModel = this.graphController.getGraphModel(workspace);
        PreviewModelImpl previewModel = this.getModel(workspace);
        previewModel.clear();
        previewModel.getProperties().putValue("directed", graphModel.isDirected() || graphModel.isMixed());
        Graph graph = graphModel.getGraphVisible();
        if (previewModel.getProperties().getFloatValue("visibility-ratio") < 1.0f) {
            float visibilityRatio = previewModel.getProperties().getFloatValue("visibility-ratio");
            GraphView reducedView = graphModel.copyView(graph.getView());
            graph = graphModel.getGraph(reducedView);
            Node[] nodes = graph.getNodes().toArray();
            for (int i = 0; i < nodes.length; ++i) {
                float r = (float)i / (float)nodes.length;
                if (!(r > visibilityRatio)) continue;
                graph.removeNode(nodes[i]);
            }
        }
        if (!this.mousePressed) {
            renderers = this.model.getManagedEnabledRenderers();
        } else {
            ArrayList<Renderer> renderersList = new ArrayList<Renderer>();
            for (Renderer renderer : this.model.getManagedEnabledRenderers()) {
                if (!(renderer instanceof MouseResponsiveRenderer)) continue;
                renderersList.add(renderer);
            }
            renderers = renderersList.toArray(new Renderer[0]);
        }
        if (renderers == null) {
            renderers = this.getRegisteredRenderers();
        }
        for (ItemBuilder b : Lookup.getDefault().lookupAll(ItemBuilder.class)) {
            if (!this.isItemBuilderNeeded(b, previewModel.getProperties(), renderers)) continue;
            try {
                Item[] items = b.getItems(graph);
                if (items == null) continue;
                previewModel.loadItems(b.getType(), items);
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        if (previewModel.getProperties().getFloatValue("visibility-ratio") < 1.0f) {
            graphModel.destroyView(graph.getView());
        }
        for (Renderer r : renderers) {
            r.preProcess(this.model);
        }
    }

    private boolean isItemBuilderNeeded(ItemBuilder itemBuilder, PreviewProperties properties, Renderer[] renderers) {
        for (Renderer r : renderers) {
            if (!r.needsItemBuilder(itemBuilder, properties)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void render(RenderTarget target) {
        PreviewModelImpl m = this.getModel();
        this.render(target, m.getManagedEnabledRenderers(), m);
    }

    @Override
    public void render(RenderTarget target, Workspace workspace) {
        PreviewModelImpl m = this.getModel(workspace);
        this.render(target, m.getManagedEnabledRenderers(), m);
    }

    @Override
    public void render(RenderTarget target, Renderer[] renderers) {
        this.render(target, renderers, this.getModel());
    }

    @Override
    public void render(RenderTarget target, Renderer[] renderers, Workspace workspace) {
        this.render(target, renderers != null ? renderers : this.getModel(workspace).getManagedEnabledRenderers(), this.getModel(workspace));
    }

    private synchronized void render(RenderTarget target, Renderer[] renderers, PreviewModelImpl previewModel) {
        if (previewModel != null) {
            PreviewProperties properties = previewModel.getProperties();
            ProgressTicket progressTicket = null;
            if (target instanceof AbstractRenderTarget) {
                int tasks = 0;
                for (Renderer r : renderers) {
                    if (this.mousePressed && !(r instanceof MouseResponsiveRenderer)) continue;
                    for (String type : previewModel.getItemTypes()) {
                        for (Item item : previewModel.getItems(type)) {
                            if (!r.isRendererForitem(item, properties)) continue;
                            ++tasks;
                        }
                    }
                }
                progressTicket = ((AbstractRenderTarget)((Object)target)).getProgressTicket();
                Progress.switchToDeterminate((ProgressTicket)progressTicket, (int)tasks);
            }
            for (Renderer r : renderers) {
                if (this.mousePressed && !(r instanceof MouseResponsiveRenderer)) continue;
                for (String type : previewModel.getItemTypes()) {
                    for (Item item : previewModel.getItems(type)) {
                        if (!r.isRendererForitem(item, properties)) continue;
                        r.render(item, target, properties);
                        Progress.progress((ProgressTicket)progressTicket);
                        if (!(target instanceof AbstractRenderTarget) || !((AbstractRenderTarget)((Object)target)).isCancelled()) continue;
                        return;
                    }
                }
            }
        }
    }

    @Override
    public synchronized PreviewModelImpl getModel() {
        ProjectController pc;
        if (this.model == null && (pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class)).getCurrentWorkspace() != null) {
            return this.getModel(pc.getCurrentWorkspace());
        }
        return this.model;
    }

    @Override
    public synchronized PreviewModelImpl getModel(Workspace workspace) {
        PreviewModelImpl m = (PreviewModelImpl)workspace.getLookup().lookup(PreviewModelImpl.class);
        if (m == null) {
            m = new PreviewModelImpl(workspace);
            workspace.add((Object)m);
        }
        return m;
    }

    @Override
    public RenderTarget getRenderTarget(String name) {
        return this.getRenderTarget(name, this.getModel());
    }

    @Override
    public RenderTarget getRenderTarget(String name, Workspace workspace) {
        return this.getRenderTarget(name, this.getModel(workspace));
    }

    private synchronized RenderTarget getRenderTarget(String name, PreviewModel m) {
        if (m != null) {
            for (RenderTargetBuilder rtb : Lookup.getDefault().lookupAll(RenderTargetBuilder.class)) {
                if (!rtb.getName().equals(name)) continue;
                return rtb.buildRenderTarget(m);
            }
        }
        return null;
    }

    @Override
    public Renderer[] getRegisteredRenderers() {
        if (this.registeredRenderers == null) {
            LinkedHashMap<String, Renderer> renderers = new LinkedHashMap<String, Renderer>();
            for (Renderer r : Lookup.getDefault().lookupAll(Renderer.class)) {
                renderers.put(r.getClass().getName(), r);
            }
            for (Renderer r : renderers.values().toArray(new Renderer[0])) {
                Class<?> superClass = r.getClass().getSuperclass();
                if (superClass == null || !superClass.getName().startsWith("org.gephi.preview.plugin.renderers.")) continue;
                renderers.remove(superClass.getName());
            }
            this.registeredRenderers = renderers.values().toArray(new Renderer[0]);
        }
        return this.registeredRenderers;
    }

    @Override
    public boolean isAnyPluginRendererRegistered() {
        if (this.anyPluginRendererRegistered == null) {
            this.anyPluginRendererRegistered = false;
            for (Renderer renderer : this.getRegisteredRenderers()) {
                if (renderer.getClass().getName().startsWith("org.gephi.preview.plugin.renderers.")) continue;
                this.anyPluginRendererRegistered = true;
                break;
            }
        }
        return this.anyPluginRendererRegistered;
    }

    @Override
    public boolean sendMouseEvent(PreviewMouseEvent event) {
        return this.sendMouseEvent(event, ((ProjectController)Lookup.getDefault().lookup(ProjectController.class)).getCurrentWorkspace());
    }

    @Override
    public boolean sendMouseEvent(PreviewMouseEvent event, Workspace workspace) {
        if (workspace == null) {
            return false;
        }
        PreviewModelImpl previewModel = this.getModel(workspace);
        if (event.type != PreviewMouseEvent.Type.DRAGGED && event.type != PreviewMouseEvent.Type.RELEASED || this.mousePressed) {
            for (PreviewMouseListener listener : previewModel.getEnabledMouseListeners()) {
                switch (event.type) {
                    case CLICKED: {
                        listener.mouseClicked(event, previewModel.getProperties(), workspace);
                        break;
                    }
                    case PRESSED: {
                        this.mousePressed = true;
                        listener.mousePressed(event, previewModel.getProperties(), workspace);
                        break;
                    }
                    case DRAGGED: {
                        listener.mouseDragged(event, previewModel.getProperties(), workspace);
                        break;
                    }
                    case RELEASED: {
                        this.mousePressed = false;
                        listener.mouseReleased(event, previewModel.getProperties(), workspace);
                    }
                }
                if (!event.isConsumed()) continue;
                return true;
            }
        }
        this.mousePressed = false;
        return false;
    }
}

