/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.packages;

import java.io.IOException;
import org.netbeans.modules.profiler.snaptracer.ItemValueFormatter;
import org.netbeans.modules.profiler.snaptracer.ProbeItemDescriptor;
import org.netbeans.modules.profiler.snaptracer.TracerProbe;
import org.netbeans.modules.profiler.snaptracer.impl.IdeSnapshot;
import org.openide.util.Exceptions;

class UiGesturesProbe
extends TracerProbe {
    private IdeSnapshot snapshot;

    public UiGesturesProbe(IdeSnapshot ideSnapshot) {
        super(UiGesturesProbe.descriptors(1, ideSnapshot));
        this.snapshot = ideSnapshot;
    }

    @Override
    public long[] getItemValues(int n) {
        return this.values(n);
    }

    private static ProbeItemDescriptor[] descriptors(int n, IdeSnapshot ideSnapshot) {
        ProbeItemDescriptor[] probeItemDescriptorArray = new ProbeItemDescriptor[n];
        probeItemDescriptorArray[0] = ProbeItemDescriptor.iconItem("UI Gesture", "Shows UI actions performed by the user in the IDE", new UiGesturesFormatter(ideSnapshot));
        return probeItemDescriptorArray;
    }

    private long[] values(int n) {
        long[] lArray = new long[1];
        try {
            lArray[0] = this.snapshot.getValue(n, 1);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return lArray;
    }

    private static class UiGesturesFormatter
    extends ItemValueFormatter {
        private IdeSnapshot snapshot;

        UiGesturesFormatter(IdeSnapshot ideSnapshot) {
            this.snapshot = ideSnapshot;
        }

        @Override
        public String formatValue(long l, int n) {
            switch (n) {
                case 0: 
                case 2: 
                case 3: {
                    IdeSnapshot.LogRecordInfo logRecordInfo = this.snapshot.getLogInfoForValue(l);
                    String string = null;
                    if (logRecordInfo != null) {
                        string = logRecordInfo.getDisplayName();
                        if (string == null) {
                            string = logRecordInfo.getName();
                        }
                        if (string == null) {
                            string = "<unknown>";
                        }
                    }
                    return string != null ? string : "<none>";
                }
                case 1: {
                    return "";
                }
            }
            return null;
        }

        @Override
        public String getUnits(int n) {
            return "";
        }
    }
}

