/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.application.snapshot;

import com.sun.tools.visualvm.application.snapshot.ApplicationSnapshotsSupport;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.Storage;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.datasupport.Utils;
import com.sun.tools.visualvm.core.snapshot.Snapshot;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public final class ApplicationSnapshot
extends Snapshot {
    private Storage storage;

    public ApplicationSnapshot(File directory, Storage storage) {
        super(directory, ApplicationSnapshotsSupport.getInstance().getCategory());
        this.storage = storage;
    }

    public void save(File directory) {
        this.saveArchive(new File(directory, this.getFile().getName()));
    }

    public boolean supportsSaveAs() {
        return true;
    }

    public void saveAs() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(NbBundle.getMessage(ApplicationSnapshot.class, (String)"LBL_Save_Application_Snapshot_As"));
        chooser.setSelectedFile(new File(this.getFile().getName()));
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(this.getCategory().getFileFilter());
        if (chooser.showSaveDialog(WindowManager.getDefault().getMainWindow()) == 0) {
            String categorySuffix = ".apps";
            String filePath = chooser.getSelectedFile().getAbsolutePath();
            if (!filePath.endsWith(categorySuffix)) {
                filePath = filePath + categorySuffix;
            }
            final File file = new File(filePath);
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ProgressHandle pHandleF;
                    ProgressHandle pHandle = null;
                    try {
                        pHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ApplicationSnapshot.class, (String)"MSG_Saving", (Object)DataSourceDescriptorFactory.getDescriptor((DataSource)ApplicationSnapshot.this).getName()));
                        pHandle.setInitialDelay(0);
                        pHandle.start();
                        ApplicationSnapshot.this.saveArchive(file);
                        pHandleF = pHandle;
                    }
                    catch (Throwable throwable) {
                        ProgressHandle pHandleF2 = pHandle;
                        SwingUtilities.invokeLater(new Runnable(pHandleF2){
                            final /* synthetic */ ProgressHandle val$pHandleF;
                            {
                                this.val$pHandleF = progressHandle;
                            }

                            public void run() {
                                if (this.val$pHandleF != null) {
                                    this.val$pHandleF.finish();
                                }
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            });
        }
    }

    protected Storage createStorage() {
        return this.storage;
    }

    private void saveArchive(File archive) {
        Utils.createArchive((File)this.getFile(), (File)archive);
    }
}

