/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.util.ArrayList;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.MethodNotSupportedException;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.event.ConnectionEvent;
import javax.mail.event.ConnectionListener;
import javax.mail.event.FolderEvent;
import javax.mail.event.FolderListener;
import javax.mail.event.MessageChangedEvent;
import javax.mail.event.MessageChangedListener;
import javax.mail.event.MessageCountEvent;
import javax.mail.event.MessageCountListener;
import javax.mail.search.SearchTerm;

public abstract class Folder {
    public static final int HOLDS_MESSAGES = 1;
    public static final int HOLDS_FOLDERS = 2;
    public static final int READ_ONLY = 1;
    public static final int READ_WRITE = 2;
    protected Store store;
    protected int mode = -1;
    private volatile ArrayList connectionListeners = null;
    private volatile ArrayList folderListeners = null;
    private volatile ArrayList messageCountListeners = null;
    private volatile ArrayList messageChangedListeners = null;

    protected Folder(Store store) {
        this.store = store;
    }

    public abstract String getName();

    public abstract String getFullName();

    public URLName getURLName() throws MessagingException {
        URLName url = this.getStore().getURLName();
        String name = this.getFullName();
        return new URLName(url.getProtocol(), url.getHost(), url.getPort(), name, url.getUsername(), null);
    }

    public Store getStore() {
        return this.store;
    }

    public abstract Folder getParent() throws MessagingException;

    public abstract boolean exists() throws MessagingException;

    public abstract Folder[] list(String var1) throws MessagingException;

    public Folder[] listSubscribed(String pattern) throws MessagingException {
        return this.list(pattern);
    }

    public Folder[] list() throws MessagingException {
        return this.list("%");
    }

    public Folder[] listSubscribed() throws MessagingException {
        return this.listSubscribed("%");
    }

    public abstract char getSeparator() throws MessagingException;

    public abstract int getType() throws MessagingException;

    public abstract boolean create(int var1) throws MessagingException;

    public boolean isSubscribed() {
        return true;
    }

    public void setSubscribed(boolean flag) throws MessagingException {
        throw new MethodNotSupportedException();
    }

    public abstract boolean hasNewMessages() throws MessagingException;

    public abstract Folder getFolder(String var1) throws MessagingException;

    public abstract boolean delete(boolean var1) throws MessagingException;

    public abstract boolean renameTo(Folder var1) throws MessagingException;

    public abstract void open(int var1) throws MessagingException;

    public abstract void close(boolean var1) throws MessagingException;

    public abstract boolean isOpen();

    public int getMode() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Folder not open");
        }
        return this.mode;
    }

    public abstract Flags getPermanentFlags();

    public abstract int getMessageCount() throws MessagingException;

    public synchronized int getNewMessageCount() throws MessagingException {
        if (!this.isOpen()) {
            return -1;
        }
        int count = 0;
        int total = this.getMessageCount();
        for (int i = 1; i <= total; ++i) {
            try {
                if (!this.getMessage(i).isSet(Flags.Flag.RECENT)) continue;
                ++count;
                continue;
            }
            catch (MessageRemovedException e) {
                // empty catch block
            }
        }
        return count;
    }

    public synchronized int getUnreadMessageCount() throws MessagingException {
        if (!this.isOpen()) {
            return -1;
        }
        int count = 0;
        int total = this.getMessageCount();
        for (int i = 1; i <= total; ++i) {
            try {
                if (this.getMessage(i).isSet(Flags.Flag.SEEN)) continue;
                ++count;
                continue;
            }
            catch (MessageRemovedException e) {
                // empty catch block
            }
        }
        return count;
    }

    public synchronized int getDeletedMessageCount() throws MessagingException {
        if (!this.isOpen()) {
            return -1;
        }
        int count = 0;
        int total = this.getMessageCount();
        for (int i = 1; i <= total; ++i) {
            try {
                if (this.getMessage(i).isSet(Flags.Flag.DELETED)) continue;
                ++count;
                continue;
            }
            catch (MessageRemovedException e) {
                // empty catch block
            }
        }
        return count;
    }

    public abstract Message getMessage(int var1) throws MessagingException;

    public synchronized Message[] getMessages(int start, int end) throws MessagingException {
        Message[] messages = new Message[end - start + 1];
        for (int i = start; i <= end; ++i) {
            messages[i - start] = this.getMessage(i);
        }
        return messages;
    }

    public synchronized Message[] getMessages(int[] msgnums) throws MessagingException {
        int total = msgnums.length;
        Message[] messages = new Message[total];
        for (int i = 0; i < total; ++i) {
            messages[i] = this.getMessage(msgnums[i]);
        }
        return messages;
    }

    public synchronized Message[] getMessages() throws MessagingException {
        if (!this.isOpen()) {
            throw new IllegalStateException("Folder not open");
        }
        int total = this.getMessageCount();
        Message[] messages = new Message[total];
        for (int i = 1; i <= total; ++i) {
            messages[i - 1] = this.getMessage(i);
        }
        return messages;
    }

    public abstract void appendMessages(Message[] var1) throws MessagingException;

    public void fetch(Message[] msgs, FetchProfile fp) throws MessagingException {
    }

    public synchronized void setFlags(Message[] msgs, Flags flag, boolean value) throws MessagingException {
        for (int i = 0; i < msgs.length; ++i) {
            try {
                msgs[i].setFlags(flag, value);
                continue;
            }
            catch (MessageRemovedException e) {
                // empty catch block
            }
        }
    }

    public synchronized void setFlags(int start, int end, Flags flag, boolean value) throws MessagingException {
        for (int i = start; i <= end; ++i) {
            try {
                this.getMessage(i).setFlags(flag, value);
                continue;
            }
            catch (MessageRemovedException e) {
                // empty catch block
            }
        }
    }

    public synchronized void setFlags(int[] msgnums, Flags flag, boolean value) throws MessagingException {
        for (int i = 0; i < msgnums.length; ++i) {
            try {
                this.getMessage(msgnums[i]).setFlags(flag, value);
                continue;
            }
            catch (MessageRemovedException e) {
                // empty catch block
            }
        }
    }

    public void copyMessages(Message[] msgs, Folder folder) throws MessagingException {
        if (!folder.exists()) {
            throw new FolderNotFoundException("Folder does not exist", folder);
        }
        boolean isOpen = folder.isOpen();
        if (!isOpen) {
            folder.open(2);
        }
        folder.appendMessages(msgs);
        if (!isOpen) {
            folder.close(false);
        }
    }

    public abstract Message[] expunge() throws MessagingException;

    public Message[] search(SearchTerm term) throws MessagingException {
        return this.search(term, this.getMessages());
    }

    public Message[] search(SearchTerm term, Message[] msgs) throws MessagingException {
        ArrayList<Message> acc = new ArrayList<Message>();
        for (int i = 0; i < msgs.length; ++i) {
            try {
                if (!msgs[i].match(term)) continue;
                acc.add(msgs[i]);
                continue;
            }
            catch (MessageRemovedException e) {
                // empty catch block
            }
        }
        Message[] m = new Message[acc.size()];
        acc.toArray(m);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(ConnectionListener l) {
        if (this.connectionListeners == null) {
            this.connectionListeners = new ArrayList();
        }
        ArrayList arrayList = this.connectionListeners;
        synchronized (arrayList) {
            this.connectionListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(ConnectionListener l) {
        if (this.connectionListeners != null) {
            ArrayList arrayList = this.connectionListeners;
            synchronized (arrayList) {
                this.connectionListeners.remove(l);
            }
        }
    }

    protected void notifyConnectionListeners(int type) {
        ConnectionEvent event = new ConnectionEvent(this, type);
        switch (type) {
            case 1: {
                this.fireOpened(event);
                break;
            }
            case 2: {
                this.fireDisconnected(event);
                break;
            }
            case 3: {
                this.fireClosed(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireOpened(ConnectionEvent event) {
        if (this.connectionListeners != null) {
            ConnectionListener[] l = null;
            ArrayList arrayList = this.connectionListeners;
            synchronized (arrayList) {
                l = new ConnectionListener[this.connectionListeners.size()];
                this.connectionListeners.toArray(l);
            }
            for (int i = 0; i < l.length; ++i) {
                l[i].opened(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireDisconnected(ConnectionEvent event) {
        if (this.connectionListeners != null) {
            ConnectionListener[] l = null;
            ArrayList arrayList = this.connectionListeners;
            synchronized (arrayList) {
                l = new ConnectionListener[this.connectionListeners.size()];
                this.connectionListeners.toArray(l);
            }
            for (int i = 0; i < l.length; ++i) {
                l[i].disconnected(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireClosed(ConnectionEvent event) {
        if (this.connectionListeners != null) {
            ConnectionListener[] l = null;
            ArrayList arrayList = this.connectionListeners;
            synchronized (arrayList) {
                l = new ConnectionListener[this.connectionListeners.size()];
                this.connectionListeners.toArray(l);
            }
            for (int i = 0; i < l.length; ++i) {
                l[i].closed(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFolderListener(FolderListener l) {
        if (this.folderListeners == null) {
            this.folderListeners = new ArrayList();
        }
        ArrayList arrayList = this.folderListeners;
        synchronized (arrayList) {
            this.folderListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFolderListener(FolderListener l) {
        if (this.folderListeners != null) {
            ArrayList arrayList = this.folderListeners;
            synchronized (arrayList) {
                this.folderListeners.remove(l);
            }
        }
    }

    protected void notifyFolderListeners(int type) {
        FolderEvent event = new FolderEvent(this, this, type);
        switch (type) {
            case 1: {
                this.fireFolderCreated(event);
                break;
            }
            case 2: {
                this.fireFolderDeleted(event);
            }
        }
        this.store.notifyFolderListeners(type, this);
    }

    protected void notifyFolderRenamedListeners(Folder folder) {
        FolderEvent event = new FolderEvent(this, this, folder, 3);
        this.fireFolderRenamed(event);
        this.store.notifyFolderRenamedListeners(this, folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFolderCreated(FolderEvent event) {
        if (this.folderListeners != null) {
            FolderListener[] l = null;
            ArrayList arrayList = this.folderListeners;
            synchronized (arrayList) {
                l = new FolderListener[this.folderListeners.size()];
                this.folderListeners.toArray(l);
            }
            for (int i = 0; i < l.length; ++i) {
                l[i].folderCreated(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFolderDeleted(FolderEvent event) {
        if (this.folderListeners != null) {
            FolderListener[] l = null;
            ArrayList arrayList = this.folderListeners;
            synchronized (arrayList) {
                l = new FolderListener[this.folderListeners.size()];
                this.folderListeners.toArray(l);
            }
            for (int i = 0; i < l.length; ++i) {
                l[i].folderDeleted(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFolderRenamed(FolderEvent event) {
        if (this.folderListeners != null) {
            FolderListener[] l = null;
            ArrayList arrayList = this.folderListeners;
            synchronized (arrayList) {
                l = new FolderListener[this.folderListeners.size()];
                this.folderListeners.toArray(l);
            }
            for (int i = 0; i < l.length; ++i) {
                l[i].folderRenamed(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageCountListener(MessageCountListener l) {
        if (this.messageCountListeners == null) {
            this.messageCountListeners = new ArrayList();
        }
        ArrayList arrayList = this.messageCountListeners;
        synchronized (arrayList) {
            this.messageCountListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageCountListener(MessageCountListener l) {
        if (this.messageCountListeners != null) {
            ArrayList arrayList = this.messageCountListeners;
            synchronized (arrayList) {
                this.messageCountListeners.remove(l);
            }
        }
    }

    protected void notifyMessageAddedListeners(Message[] msgs) {
        MessageCountEvent event = new MessageCountEvent(this, 1, false, msgs);
        this.fireMessagesAdded(event);
    }

    protected void notifyMessageRemovedListeners(boolean removed, Message[] msgs) {
        MessageCountEvent event = new MessageCountEvent(this, 2, removed, msgs);
        this.fireMessagesRemoved(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMessagesAdded(MessageCountEvent event) {
        if (this.messageCountListeners != null) {
            MessageCountListener[] l = null;
            ArrayList arrayList = this.messageCountListeners;
            synchronized (arrayList) {
                l = new MessageCountListener[this.messageCountListeners.size()];
                this.messageCountListeners.toArray(l);
            }
            for (int i = 0; i < l.length; ++i) {
                l[i].messagesAdded(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMessagesRemoved(MessageCountEvent event) {
        if (this.messageCountListeners != null) {
            MessageCountListener[] l = null;
            ArrayList arrayList = this.messageCountListeners;
            synchronized (arrayList) {
                l = new MessageCountListener[this.messageCountListeners.size()];
                this.messageCountListeners.toArray(l);
            }
            for (int i = 0; i < l.length; ++i) {
                l[i].messagesRemoved(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageChangedListener(MessageChangedListener l) {
        if (this.messageChangedListeners == null) {
            this.messageChangedListeners = new ArrayList();
        }
        ArrayList arrayList = this.messageChangedListeners;
        synchronized (arrayList) {
            this.messageChangedListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageChangedListener(MessageChangedListener l) {
        if (this.messageChangedListeners != null) {
            ArrayList arrayList = this.messageChangedListeners;
            synchronized (arrayList) {
                this.messageChangedListeners.remove(l);
            }
        }
    }

    protected void notifyMessageChangedListeners(int type, Message msg) {
        MessageChangedEvent event = new MessageChangedEvent(this, type, msg);
        this.fireMessageChanged(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMessageChanged(MessageChangedEvent event) {
        if (this.messageChangedListeners != null) {
            MessageChangedListener[] l = null;
            ArrayList arrayList = this.messageChangedListeners;
            synchronized (arrayList) {
                l = new MessageChangedListener[this.messageChangedListeners.size()];
                this.messageChangedListeners.toArray(l);
            }
            for (int i = 0; i < l.length; ++i) {
                l[i].messageChanged(event);
            }
        }
    }

    public String toString() {
        String name = this.getFullName();
        return name != null ? name : super.toString();
    }
}

