/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.branding.desktop;

import java.awt.Color;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.gephi.branding.desktop.DragNDropFrameAdapter;
import org.gephi.branding.desktop.MemoryStarvationManager;
import org.gephi.branding.desktop.reporter.ReporterHandler;
import org.gephi.desktop.project.api.ProjectControllerUI;
import org.gephi.project.api.ProjectController;
import org.openide.modules.ModuleInstall;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.IOColorLines;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;
import org.openide.windows.WindowManager;

public class Installer
extends ModuleInstall {
    private static final String LATEST_GEPHI_VERSION_URL = "https://raw.githubusercontent.com/gephi/gephi/gh-pages/latest";

    public void restored() {
        this.initGephi();
        UIManager.put("Slider.paintValue", Boolean.FALSE);
        if (System.getProperty("org.gephi.crashReporter.enabled", "true").equals("true")) {
            Logger.getLogger("").addHandler(new ReporterHandler());
        }
        if (System.getProperty("org.gephiMemoryStarvationManager.enabled", "true").equals("true")) {
            MemoryStarvationManager memoryStarvationManager = new MemoryStarvationManager();
            memoryStarvationManager.startup();
        }
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                new Thread(){

                    @Override
                    public void run() {
                        Installer.this.checkForNewMajorRelease();
                    }
                }.start();
            }
        });
        this.installOutputLogger();
    }

    private void initGephi() {
        final ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                pc.startup();
                DragNDropFrameAdapter.register();
            }
        });
    }

    public boolean closing() {
        if (((ProjectController)Lookup.getDefault().lookup(ProjectController.class)).getCurrentProject() == null) {
            return true;
        }
        int option = JOptionPane.showConfirmDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(Installer.class, (String)"CloseConfirmation.message"), NbBundle.getMessage(Installer.class, (String)"CloseConfirmation.message"), 1, 2);
        if (option == 0) {
            ((ProjectControllerUI)Lookup.getDefault().lookup(ProjectControllerUI.class)).saveProject();
        } else if (option == 2 || option == -1) {
            return false;
        }
        ((ProjectController)Lookup.getDefault().lookup(ProjectController.class)).closeCurrentProject();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForNewMajorRelease() {
        boolean doCheck = NbPreferences.forModule(Installer.class).getBoolean("check_latest_version", true);
        if (doCheck) {
            InputStream stream = null;
            BufferedReader reader = null;
            try {
                String gephiVersion = System.getProperty("netbeans.productversion");
                if (gephiVersion.contains("SNAPSHOT")) {
                    return;
                }
                URL url = new URL(LATEST_GEPHI_VERSION_URL);
                URLConnection connection = url.openConnection();
                connection.setRequestProperty("User-Agent", "");
                connection.connect();
                stream = connection.getInputStream();
                reader = new BufferedReader(new InputStreamReader(stream));
                String latest = reader.readLine();
                latest = latest.replaceAll("[a-zA-Z .-]", "");
                String gephiVersionTst = gephiVersion.replaceAll("[0-9]{12}", "").replaceAll("[a-zA-Z .-]", "");
                if (Integer.parseInt(latest) > Integer.parseInt(gephiVersionTst)) {
                    JCheckBox checkbox = new JCheckBox(NbBundle.getMessage(Installer.class, (String)"MajorReleaseCheck.dontShowAgain"), false);
                    String message = NbBundle.getMessage(Installer.class, (String)"MajorReleaseCheck.message", (Object)latest, (Object)gephiVersion);
                    int option = JOptionPane.showConfirmDialog(null, new Object[]{message, checkbox}, NbBundle.getMessage(Installer.class, (String)"MajorReleaseCheck.newVersion"), 2, 1);
                    NbPreferences.forModule(Installer.class).putBoolean("check_latest_version", !checkbox.isSelected());
                    if (option == 0) {
                        Desktop.getDesktop().browse(new URI("http://gephi.org/users/download/"));
                    }
                }
            }
            catch (Exception ex) {
                Logger.getLogger("").warning("Error while checking latest Gephi version");
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {}
            }
        }
    }

    private void installOutputLogger() {
        Logger.getLogger("").addHandler(new OutputHandler());
    }

    private static class OutputHandler
    extends Handler {
        private final InputOutput io = IOProvider.getDefault().getIO("Log", true);
        private final OutputWriter outputWriter = this.io.getOut();
        private final MsgFormatter formatter = new MsgFormatter();

        @Override
        public void publish(LogRecord record) {
            if ((record.getMessage() == null || record.getMessage().isEmpty()) && record.getThrown() == null) {
                return;
            }
            Color color = Color.BLACK;
            if (record.getLevel().equals(Level.WARNING)) {
                color = Color.ORANGE;
            } else if (record.getLevel().equals(Level.SEVERE)) {
                color = Color.RED;
            }
            String msg = this.formatter.format(record);
            if (IOColorLines.isSupported((InputOutput)this.io)) {
                try {
                    IOColorLines.println((InputOutput)this.io, (CharSequence)msg, (Color)color);
                }
                catch (IOException ex) {
                    this.outputWriter.println(msg);
                }
            } else {
                this.outputWriter.println(msg);
            }
        }

        @Override
        public void flush() {
            this.outputWriter.flush();
        }

        @Override
        public void close() throws SecurityException {
            this.outputWriter.close();
        }

        public class MsgFormatter
        extends Formatter {
            @Override
            public synchronized String format(LogRecord record) {
                String formattedMessage = this.formatMessage(record);
                String throwable = "";
                String outputFormat = "[%1$s] %2$s %3$s";
                if (record.getThrown() != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    pw.println();
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                    throwable = sw.toString();
                }
                return String.format(outputFormat, record.getLevel().getName(), formattedMessage, throwable);
            }
        }
    }
}

