/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.general.ui;

import com.csvreader.CsvReader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.gephi.datalab.plugin.manipulators.general.ui.ImportCSVUIWizardAction;
import org.gephi.datalab.plugin.manipulators.general.ui.ImportCSVUIWizardPanel1;
import org.gephi.ui.utils.DialogFileFilter;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationPanel;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class ImportCSVUIVisualPanel1
extends JPanel {
    private static final String CHARSET_SAVED_PREFERENCES = "ImportCSVUIVisualPanel1_Charset";
    private static final String SEPARATOR_SAVED_PREFERENCES = "ImportCSVUIVisualPanel1_Separator";
    private static final String TABLE_SAVED_PREFERENCES = "ImportCSVUIVisualPanel1_Table";
    private static final int MAX_ROWS_PREVIEW = 25;
    private File selectedFile = null;
    private ImportCSVUIWizardPanel1 wizard1;
    private int columnCount = 0;
    private boolean hasSourceNodeColumn = false;
    private boolean hasTargetNodeColumn = false;
    private boolean hasColumnNamesRepeated = false;
    private boolean hasRowsMissingSourcesOrTargets = false;
    private ValidationPanel validationPanel;
    private static final String LAST_PATH = "ImportCSVUIVisualPanel1_Save_Last_Path";
    private JComboBox charsetComboBox;
    private JLabel charsetLabel;
    private JLabel descriptionLabel;
    private JButton fileButton;
    private JTextField pathTextField;
    private JLabel previewLabel;
    private JTable previewTable;
    private JScrollPane scroll;
    private JComboBox separatorComboBox;
    private JLabel separatorLabel;
    private JComboBox tableComboBox;
    private JLabel tableLabel;

    public ImportCSVUIVisualPanel1(ImportCSVUIWizardPanel1 wizard1) {
        this.initComponents();
        this.wizard1 = wizard1;
        this.separatorComboBox.addItem(new SeparatorWrapper(Character.valueOf(','), this.getMessage("ImportCSVUIVisualPanel1.comma")));
        this.separatorComboBox.addItem(new SeparatorWrapper(Character.valueOf(';'), this.getMessage("ImportCSVUIVisualPanel1.semicolon")));
        this.separatorComboBox.addItem(new SeparatorWrapper(Character.valueOf('\t'), this.getMessage("ImportCSVUIVisualPanel1.tab")));
        this.separatorComboBox.addItem(new SeparatorWrapper(Character.valueOf(' '), this.getMessage("ImportCSVUIVisualPanel1.space")));
        this.separatorComboBox.setSelectedIndex(NbPreferences.forModule(ImportCSVUIVisualPanel1.class).getInt(SEPARATOR_SAVED_PREFERENCES, 0));
        this.tableComboBox.addItem(this.getMessage("ImportCSVUIVisualPanel1.nodes-table"));
        this.tableComboBox.addItem(this.getMessage("ImportCSVUIVisualPanel1.edges-table"));
        this.tableComboBox.setSelectedIndex(NbPreferences.forModule(ImportCSVUIVisualPanel1.class).getInt(TABLE_SAVED_PREFERENCES, 0));
        for (String charset : Charset.availableCharsets().keySet()) {
            this.charsetComboBox.addItem(charset);
        }
        String savedCharset = NbPreferences.forModule(ImportCSVUIVisualPanel1.class).get(CHARSET_SAVED_PREFERENCES, null);
        if (savedCharset != null) {
            this.charsetComboBox.setSelectedItem(savedCharset);
        } else {
            this.charsetComboBox.setSelectedItem(Charset.forName("UTF-8").name());
        }
    }

    public void unSetup() {
        NbPreferences.forModule(ImportCSVUIVisualPanel1.class).put(CHARSET_SAVED_PREFERENCES, this.charsetComboBox.getSelectedItem().toString());
        NbPreferences.forModule(ImportCSVUIVisualPanel1.class).putInt(SEPARATOR_SAVED_PREFERENCES, this.separatorComboBox.getSelectedIndex());
        NbPreferences.forModule(ImportCSVUIVisualPanel1.class).putInt(TABLE_SAVED_PREFERENCES, this.tableComboBox.getSelectedIndex());
    }

    public ValidationPanel getValidationPanel() {
        if (this.validationPanel != null) {
            return this.validationPanel;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ImportCSVUIVisualPanel1.this.validationPanel = new ValidationPanel();
                    ImportCSVUIVisualPanel1.this.validationPanel.setInnerComponent((Component)ImportCSVUIVisualPanel1.this);
                    ValidationGroup validationGroup = ImportCSVUIVisualPanel1.this.validationPanel.getValidationGroup();
                    validationGroup.add((JTextComponent)ImportCSVUIVisualPanel1.this.pathTextField, new Validator[]{new Validator<String>(){

                        public boolean validate(Problems prblms, String string, String t) {
                            if (!ImportCSVUIVisualPanel1.this.isValidFile()) {
                                prblms.add(ImportCSVUIVisualPanel1.this.getMessage("ImportCSVUIVisualPanel1.validation.invalid-file"));
                                return false;
                            }
                            if (!ImportCSVUIVisualPanel1.this.hasColumns()) {
                                prblms.add(ImportCSVUIVisualPanel1.this.getMessage("ImportCSVUIVisualPanel1.validation.no-columns"));
                                return false;
                            }
                            if (ImportCSVUIVisualPanel1.this.hasColumnNamesRepeated()) {
                                prblms.add(ImportCSVUIVisualPanel1.this.getMessage("ImportCSVUIVisualPanel1.validation.repeated-columns"));
                                return false;
                            }
                            if (!ImportCSVUIVisualPanel1.this.areValidColumnsForTable()) {
                                prblms.add(ImportCSVUIVisualPanel1.this.getMessage("ImportCSVUIVisualPanel1.validation.edges.no-source-target-columns"));
                                return false;
                            }
                            if (ImportCSVUIVisualPanel1.this.hasRowsMissingSourcesOrTargets()) {
                                prblms.add(NbBundle.getMessage(ImportCSVUIVisualPanel1.class, (String)"ImportCSVUIVisualPanel1.validation.edges.empty-sources-or-targets"));
                                return false;
                            }
                            return true;
                        }
                    }});
                }
            });
            this.validationPanel.setName(this.getName());
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return this.validationPanel;
    }

    public void refreshPreviewTable() {
        if (this.selectedFile != null && this.selectedFile.exists()) {
            try {
                String[] headers;
                CsvReader reader = new CsvReader((InputStream)new FileInputStream(this.selectedFile), this.getSelectedSeparator().charValue(), this.getSelectedCharset());
                reader.setTrimWhitespace(false);
                try {
                    reader.readHeaders();
                    headers = reader.getHeaders();
                }
                catch (Exception ex) {
                    headers = new String[]{};
                }
                this.columnCount = headers.length;
                HashSet<String> columnNamesSet = new HashSet<String>();
                this.hasColumnNamesRepeated = false;
                this.hasSourceNodeColumn = false;
                this.hasTargetNodeColumn = false;
                int sourceColumnIndex = 0;
                int targetColumnIndex = 0;
                int currentColumn = 0;
                for (String header : headers) {
                    if (header.equalsIgnoreCase("source")) {
                        this.hasSourceNodeColumn = true;
                        sourceColumnIndex = currentColumn;
                    }
                    if (header.equalsIgnoreCase("target")) {
                        this.hasTargetNodeColumn = true;
                        targetColumnIndex = currentColumn;
                    }
                    if (columnNamesSet.contains(header)) {
                        this.hasColumnNamesRepeated = true;
                        break;
                    }
                    columnNamesSet.add(header);
                    ++currentColumn;
                }
                ArrayList<String[]> records = new ArrayList<String[]>();
                this.hasRowsMissingSourcesOrTargets = false;
                ImportCSVUIWizardAction.Mode mode = this.getMode();
                if (this.columnCount > 0) {
                    while (reader.readRecord()) {
                        int recordColumnCount = reader.getColumnCount();
                        String[] currentRecord = new String[recordColumnCount];
                        for (int i = 0; i < currentRecord.length; ++i) {
                            currentRecord[i] = reader.get(i);
                        }
                        if (mode == ImportCSVUIWizardAction.Mode.EDGES_TABLE && (recordColumnCount < sourceColumnIndex || currentRecord[sourceColumnIndex].trim().isEmpty() || recordColumnCount < targetColumnIndex || currentRecord[targetColumnIndex].trim().isEmpty())) {
                            this.hasRowsMissingSourcesOrTargets = true;
                        }
                        if (records.size() >= 25) continue;
                        records.add(currentRecord);
                    }
                }
                reader.close();
                final String[] columnNames = headers;
                final String[][] values = (String[][])records.toArray((T[])new String[0][]);
                this.previewTable.setModel(new TableModel(){

                    @Override
                    public int getRowCount() {
                        return values.length;
                    }

                    @Override
                    public int getColumnCount() {
                        return columnNames.length;
                    }

                    @Override
                    public String getColumnName(int columnIndex) {
                        return columnNames[columnIndex];
                    }

                    @Override
                    public Class<?> getColumnClass(int columnIndex) {
                        return String.class;
                    }

                    @Override
                    public boolean isCellEditable(int rowIndex, int columnIndex) {
                        return false;
                    }

                    @Override
                    public Object getValueAt(int rowIndex, int columnIndex) {
                        if (values[rowIndex].length > columnIndex) {
                            return values[rowIndex][columnIndex];
                        }
                        return null;
                    }

                    @Override
                    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                    }

                    @Override
                    public void addTableModelListener(TableModelListener l) {
                    }

                    @Override
                    public void removeTableModelListener(TableModelListener l) {
                    }
                });
            }
            catch (FileNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, this.getMessage("ImportCSVUIVisualPanel1.validation.error"), this.getMessage("ImportCSVUIVisualPanel1.validation.file-permissions-error"), 0);
            }
        }
        this.wizard1.fireChangeEvent();
        this.pathTextField.setText(this.pathTextField.getText());
    }

    @Override
    public String getName() {
        return this.getMessage("ImportCSVUIVisualPanel1.name");
    }

    public Character getSelectedSeparator() {
        Object item = this.separatorComboBox.getSelectedItem();
        if (item instanceof SeparatorWrapper) {
            return ((SeparatorWrapper)item).separator;
        }
        return Character.valueOf(item.toString().charAt(0));
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public ImportCSVUIWizardAction.Mode getMode() {
        switch (this.tableComboBox.getSelectedIndex()) {
            case 0: {
                return ImportCSVUIWizardAction.Mode.NODES_TABLE;
            }
            case 1: {
                return ImportCSVUIWizardAction.Mode.EDGES_TABLE;
            }
        }
        return ImportCSVUIWizardAction.Mode.NODES_TABLE;
    }

    public Charset getSelectedCharset() {
        return Charset.forName(this.charsetComboBox.getSelectedItem().toString());
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public boolean hasColumnNamesRepeated() {
        return this.hasColumnNamesRepeated;
    }

    public boolean isValidFile() {
        return this.selectedFile != null && this.selectedFile.exists();
    }

    public boolean hasColumns() {
        return this.columnCount > 0;
    }

    public boolean areValidColumnsForTable() {
        switch (this.getMode()) {
            case NODES_TABLE: {
                return true;
            }
            case EDGES_TABLE: {
                return this.hasSourceNodeColumn && this.hasTargetNodeColumn;
            }
        }
        return false;
    }

    public boolean isCSVValid() {
        return this.isValidFile() && this.hasColumns() && !this.hasColumnNamesRepeated && this.areValidColumnsForTable() && !this.hasRowsMissingSourcesOrTargets();
    }

    public boolean hasRowsMissingSourcesOrTargets() {
        return this.hasRowsMissingSourcesOrTargets;
    }

    private String getMessage(String resName) {
        return NbBundle.getMessage(ImportCSVUIVisualPanel1.class, (String)resName);
    }

    private void initComponents() {
        this.descriptionLabel = new JLabel();
        this.pathTextField = new JTextField();
        this.fileButton = new JButton();
        this.separatorLabel = new JLabel();
        this.separatorComboBox = new JComboBox();
        this.tableLabel = new JLabel();
        this.tableComboBox = new JComboBox();
        this.previewLabel = new JLabel();
        this.scroll = new JScrollPane();
        this.previewTable = new JTable();
        this.charsetLabel = new JLabel();
        this.charsetComboBox = new JComboBox();
        this.descriptionLabel.setText(NbBundle.getMessage(ImportCSVUIVisualPanel1.class, (String)"ImportCSVUIVisualPanel1.descriptionLabel.text"));
        this.pathTextField.setEditable(false);
        this.pathTextField.setText(NbBundle.getMessage(ImportCSVUIVisualPanel1.class, (String)"ImportCSVUIVisualPanel1.pathTextField.text"));
        this.fileButton.setText(NbBundle.getMessage(ImportCSVUIVisualPanel1.class, (String)"ImportCSVUIVisualPanel1.fileButton.text"));
        this.fileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportCSVUIVisualPanel1.this.fileButtonActionPerformed(evt);
            }
        });
        this.separatorLabel.setHorizontalAlignment(0);
        this.separatorLabel.setText(NbBundle.getMessage(ImportCSVUIVisualPanel1.class, (String)"ImportCSVUIVisualPanel1.separatorLabel.text"));
        this.separatorComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ImportCSVUIVisualPanel1.this.separatorComboBoxItemStateChanged(evt);
            }
        });
        this.tableLabel.setHorizontalAlignment(0);
        this.tableLabel.setText(NbBundle.getMessage(ImportCSVUIVisualPanel1.class, (String)"ImportCSVUIVisualPanel1.tableLabel.text"));
        this.tableComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ImportCSVUIVisualPanel1.this.tableComboBoxItemStateChanged(evt);
            }
        });
        this.previewLabel.setText(NbBundle.getMessage(ImportCSVUIVisualPanel1.class, (String)"ImportCSVUIVisualPanel1.previewLabel.text"));
        this.scroll.setViewportView(this.previewTable);
        this.charsetLabel.setHorizontalAlignment(0);
        this.charsetLabel.setText(NbBundle.getMessage(ImportCSVUIVisualPanel1.class, (String)"ImportCSVUIVisualPanel1.charsetLabel.text"));
        this.charsetComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ImportCSVUIVisualPanel1.this.charsetComboBoxItemStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.scroll, GroupLayout.Alignment.LEADING, -1, 325, Short.MAX_VALUE).addComponent(this.descriptionLabel, GroupLayout.Alignment.LEADING, -1, 325, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.pathTextField, -1, 274, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileButton)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.separatorLabel, -1, -1, Short.MAX_VALUE).addComponent(this.separatorComboBox, 0, 90, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.tableLabel, -1, -1, Short.MAX_VALUE).addComponent(this.tableComboBox, 0, 123, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.charsetLabel, -1, 96, Short.MAX_VALUE).addComponent(this.charsetComboBox, 0, 96, Short.MAX_VALUE))).addComponent(this.previewLabel, GroupLayout.Alignment.LEADING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.descriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pathTextField, -2, -1, -2).addComponent(this.fileButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.separatorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.separatorComboBox, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tableLabel).addComponent(this.charsetLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tableComboBox, -2, -1, -2).addComponent(this.charsetComboBox, -2, -1, -2)))).addGap(18, 18, 18).addComponent(this.previewLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scroll, -1, 147, Short.MAX_VALUE).addContainerGap()));
    }

    private void fileButtonActionPerformed(ActionEvent evt) {
        String lastPath = NbPreferences.forModule(ImportCSVUIVisualPanel1.class).get(LAST_PATH, null);
        JFileChooser chooser = new JFileChooser(lastPath);
        chooser.setAcceptAllFileFilterUsed(true);
        DialogFileFilter dialogFileFilter = new DialogFileFilter(NbBundle.getMessage(ImportCSVUIVisualPanel1.class, (String)"ImportCSVUIVisualPanel1.filechooser.csvDescription"));
        dialogFileFilter.addExtension("csv");
        chooser.addChoosableFileFilter((FileFilter)dialogFileFilter);
        chooser.setSelectedFile(this.selectedFile);
        int returnFile = chooser.showOpenDialog(null);
        if (returnFile != 0) {
            return;
        }
        this.selectedFile = chooser.getSelectedFile();
        String path = this.selectedFile.getAbsolutePath();
        this.pathTextField.setText(path);
        String defaultDirectory = this.selectedFile.getParentFile().getAbsolutePath();
        NbPreferences.forModule(ImportCSVUIVisualPanel1.class).put(LAST_PATH, defaultDirectory);
        this.refreshPreviewTable();
    }

    private void separatorComboBoxItemStateChanged(ItemEvent evt) {
        this.refreshPreviewTable();
    }

    private void charsetComboBoxItemStateChanged(ItemEvent evt) {
        this.refreshPreviewTable();
    }

    private void tableComboBoxItemStateChanged(ItemEvent evt) {
        this.refreshPreviewTable();
    }

    class SeparatorWrapper {
        private Character separator;
        private String displayText;

        public SeparatorWrapper(Character separator) {
            this.separator = separator;
        }

        public SeparatorWrapper(Character separator, String displayText) {
            this.separator = separator;
            this.displayText = displayText;
        }

        public String toString() {
            if (this.displayText != null) {
                return this.displayText;
            }
            return String.valueOf(this.separator);
        }
    }
}

