/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.general.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.io.File;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.datalab.api.datatables.DataTablesController;
import org.gephi.datalab.plugin.manipulators.general.ui.ImportCSVUIWizardPanel1;
import org.gephi.datalab.plugin.manipulators.general.ui.ImportCSVUIWizardPanel2;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public final class ImportCSVUIWizardAction
extends CallableSystemAction {
    private WizardDescriptor.Panel[] panels;
    private ImportCSVUIWizardPanel1 step1;
    private ImportCSVUIWizardPanel2 step2;
    private WizardDescriptor wizardDescriptor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performAction() {
        boolean cancelled;
        this.wizardDescriptor = new WizardDescriptor(this.getPanels());
        this.step1.setWizardDescriptor(this.wizardDescriptor);
        this.step2.setWizardDescriptor(this.wizardDescriptor);
        this.wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        this.wizardDescriptor.setTitle(this.getName());
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.wizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl = cancelled = this.wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!cancelled) {
            File file = (File)this.wizardDescriptor.getProperty("file");
            Character separator = (Character)this.wizardDescriptor.getProperty("separator");
            Charset charset = (Charset)this.wizardDescriptor.getProperty("charset");
            String[] columnNames = (String[])this.wizardDescriptor.getProperty("columns-names");
            Class[] columnTypes = (Class[])this.wizardDescriptor.getProperty("columns-types");
            Boolean assignNewNodeIds = (Boolean)this.wizardDescriptor.getProperty("assign-new-node-ids");
            Boolean createNewNodes = (Boolean)this.wizardDescriptor.getProperty("create-new-nodes");
            Graph graph = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getGraph();
            AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
            DataTablesController dtc = (DataTablesController)Lookup.getDefault().lookup(DataTablesController.class);
            dtc.setAutoRefreshEnabled(false);
            try {
                switch ((Mode)((Object)this.wizardDescriptor.getProperty("mode"))) {
                    case NODES_TABLE: {
                        ac.importCSVToNodesTable(graph, file, separator, charset, columnNames, columnTypes, assignNewNodeIds.booleanValue());
                        break;
                    }
                    case EDGES_TABLE: {
                        ac.importCSVToEdgesTable(graph, file, separator, charset, columnNames, columnTypes, createNewNodes.booleanValue());
                    }
                }
                dtc.refreshCurrentTable();
            }
            catch (Exception e) {
                Logger.getLogger("").log(Level.SEVERE, null, e);
            }
            finally {
                dtc.setAutoRefreshEnabled(true);
            }
        }
        this.step1.unSetup();
        this.step2.unSetup();
    }

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            WizardDescriptor.Panel[] panelArray = new WizardDescriptor.Panel[2];
            this.step1 = new ImportCSVUIWizardPanel1();
            panelArray[0] = this.step1;
            this.step2 = new ImportCSVUIWizardPanel2();
            panelArray[1] = this.step2;
            this.panels = panelArray;
            String[] steps = new String[this.panels.length];
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                steps[i] = c.getName();
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public String getName() {
        return NbBundle.getMessage(ImportCSVUIWizardAction.class, (String)"ImportCSVUIWizardAction.name");
    }

    public String iconResource() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    public static enum Mode {
        NODES_TABLE,
        EDGES_TABLE;

    }
}

