/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.graph;

import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.plugin.graph.EgoUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.ComplexFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class EgoBuilder
implements FilterBuilder {
    public Category getCategory() {
        return FilterLibrary.TOPOLOGY;
    }

    public String getName() {
        return NbBundle.getMessage(EgoBuilder.class, (String)"EgoBuilder.name");
    }

    public Icon getIcon() {
        return null;
    }

    public String getDescription() {
        return NbBundle.getMessage(EgoBuilder.class, (String)"EgoBuilder.description");
    }

    public Filter getFilter(Workspace workspace) {
        return new EgoFilter();
    }

    public JPanel getPanel(Filter filter) {
        EgoUI ui = (EgoUI)Lookup.getDefault().lookup(EgoUI.class);
        if (ui != null) {
            return ui.getPanel((EgoFilter)filter);
        }
        return null;
    }

    public void destroy(Filter filter) {
    }

    public static class EgoFilter
    implements ComplexFilter {
        private String pattern = "";
        private boolean self = true;
        private int depth = 1;

        public Graph filter(Graph graph) {
            String str = this.pattern.toLowerCase();
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (Node n : graph.getNodes()) {
                if (n.getId().toString().toLowerCase().equals(str)) {
                    nodes.add(n);
                    continue;
                }
                if (n.getLabel() == null || !n.getLabel().toLowerCase().equals(str)) continue;
                nodes.add(n);
            }
            HashSet<Node> result = new HashSet<Node>();
            HashSet<Node> neighbours = new HashSet<Node>();
            neighbours.addAll(nodes);
            for (int i = 0; i < this.depth; ++i) {
                Node[] nei = neighbours.toArray(new Node[0]);
                neighbours.clear();
                for (Node n : nei) {
                    for (Node neighbor : graph.getNeighbors(n)) {
                        if (result.contains(neighbor)) continue;
                        neighbours.add(neighbor);
                        result.add(neighbor);
                    }
                }
                if (neighbours.isEmpty()) break;
            }
            if (this.self) {
                result.addAll(nodes);
            } else {
                result.removeAll(nodes);
            }
            for (Node node : graph.getNodes().toArray()) {
                if (result.contains(node)) continue;
                graph.removeNode(node);
            }
            return graph;
        }

        public String getName() {
            return NbBundle.getMessage(EgoBuilder.class, (String)"EgoBuilder.name");
        }

        public FilterProperty[] getProperties() {
            try {
                return new FilterProperty[]{FilterProperty.createProperty((Filter)this, String.class, (String)"pattern"), FilterProperty.createProperty((Filter)this, Integer.class, (String)"depth"), FilterProperty.createProperty((Filter)this, Boolean.class, (String)"self")};
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
                return new FilterProperty[0];
            }
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public Integer getDepth() {
            return this.depth;
        }

        public void setDepth(Integer depth) {
            this.depth = depth;
        }

        public boolean isSelf() {
            return this.self;
        }

        public void setSelf(boolean self) {
            this.self = self;
        }
    }
}

