/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TimerTask;
import org.postgresql.Driver;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.BaseStatement;
import org.postgresql.core.CachedQuery;
import org.postgresql.core.Field;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Query;
import org.postgresql.core.ResultCursor;
import org.postgresql.core.ResultHandler;
import org.postgresql.core.ServerVersion;
import org.postgresql.jdbc2.AbstractJdbc2Array;
import org.postgresql.jdbc2.AbstractJdbc2Connection;
import org.postgresql.jdbc2.AbstractJdbc2ResultSet;
import org.postgresql.jdbc2.EscapedFunctions;
import org.postgresql.jdbc2.ResultWrapper;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.ByteConverter;
import org.postgresql.util.GT;
import org.postgresql.util.HStoreConverter;
import org.postgresql.util.PGBinaryObject;
import org.postgresql.util.PGobject;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public abstract class AbstractJdbc2Statement
implements BaseStatement {
    private static final boolean DEFAULT_FORCE_BINARY_TRANSFERS = Boolean.getBoolean("org.postgresql.forceBinary");
    private boolean forceBinaryTransfers = DEFAULT_FORCE_BINARY_TRANSFERS;
    protected ArrayList<Query> batchStatements = null;
    protected ArrayList<ParameterList> batchParameters = null;
    protected final int resultsettype;
    protected final int concurrency;
    protected int fetchdirection = 1000;
    private volatile TimerTask cancelTimerTask = null;
    protected boolean wantsGeneratedKeysOnce = false;
    public boolean wantsGeneratedKeysAlways = false;
    protected BaseConnection connection;
    protected SQLWarning warnings = null;
    protected SQLWarning lastWarning = null;
    protected int maxrows = 0;
    protected int fetchSize = 0;
    protected int timeout = 0;
    protected boolean replaceProcessingEnabled = true;
    protected ResultWrapper result = null;
    protected ResultWrapper firstUnclosedResult = null;
    protected ResultWrapper generatedKeys = null;
    protected boolean adjustIndex = false;
    protected boolean outParmBeforeFunc = false;
    private static final short IN_SQLCODE = 0;
    private static final short IN_STRING = 1;
    private static final short IN_IDENTIFIER = 6;
    private static final short BACKSLASH = 2;
    private static final short ESC_TIMEDATE = 3;
    private static final short ESC_FUNCTION = 4;
    private static final short ESC_OUTERJOIN = 5;
    private static final short ESC_ESCAPECHAR = 7;
    protected final CachedQuery preparedQuery;
    protected final ParameterList preparedParameters;
    protected Query lastSimpleQuery;
    protected int m_prepareThreshold;
    private boolean isFunction;
    private int[] functionReturnType;
    private int[] testReturn;
    private boolean returnTypeSet;
    protected Object[] callResult;
    protected int maxfieldSize = 0;
    protected boolean isClosed = false;
    private int lastIndex = 0;

    @Override
    public ResultSet createDriverResultSet(Field[] fields, List tuples) throws SQLException {
        return this.createResultSet(null, fields, tuples, null);
    }

    public AbstractJdbc2Statement(AbstractJdbc2Connection c, int rsType, int rsConcurrency) throws SQLException {
        this.connection = c;
        this.preparedQuery = null;
        this.preparedParameters = null;
        this.lastSimpleQuery = null;
        this.forceBinaryTransfers |= c.getForceBinary();
        this.resultsettype = rsType;
        this.concurrency = rsConcurrency;
        this.setFetchSize(c.getDefaultFetchSize());
        this.setPrepareThreshold(c.getPrepareThreshold());
    }

    public AbstractJdbc2Statement(AbstractJdbc2Connection connection, String sql, boolean isCallable, int rsType, int rsConcurrency) throws SQLException {
        this.connection = connection;
        this.lastSimpleQuery = null;
        CachedQuery cachedQuery = connection.borrowQuery(sql, isCallable);
        if (isCallable) {
            this.isFunction = cachedQuery.isFunction;
            this.outParmBeforeFunc = cachedQuery.outParmBeforeFunc;
        }
        this.preparedQuery = cachedQuery;
        this.preparedParameters = this.preparedQuery.query.createParameterList();
        if (this.isFunction) {
            int inParamCount = this.preparedParameters.getInParameterCount() + 1;
            this.testReturn = new int[inParamCount];
            this.functionReturnType = new int[inParamCount];
        }
        this.forceBinaryTransfers |= connection.getForceBinary();
        this.resultsettype = rsType;
        this.concurrency = rsConcurrency;
        this.setFetchSize(connection.getDefaultFetchSize());
        this.setPrepareThreshold(connection.getPrepareThreshold());
    }

    @Override
    public abstract ResultSet createResultSet(Query var1, Field[] var2, List var3, ResultCursor var4) throws SQLException;

    public BaseConnection getPGConnection() {
        return this.connection;
    }

    public String getFetchingCursorName() {
        return null;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    protected boolean wantsScrollableResultSet() {
        return this.resultsettype != 1003;
    }

    protected boolean wantsHoldableResultSet() {
        return false;
    }

    @Override
    public ResultSet executeQuery(String p_sql) throws SQLException {
        if (this.preparedQuery != null) {
            throw new PSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement."), PSQLState.WRONG_OBJECT_TYPE);
        }
        if (this.forceBinaryTransfers) {
            this.clearWarnings();
            while (this.firstUnclosedResult != null) {
                if (this.firstUnclosedResult.getResultSet() != null) {
                    this.firstUnclosedResult.getResultSet().close();
                }
                this.firstUnclosedResult = this.firstUnclosedResult.getNext();
            }
            PreparedStatement ps = this.connection.prepareStatement(p_sql, this.resultsettype, this.concurrency, this.getResultSetHoldability());
            ps.setMaxFieldSize(this.getMaxFieldSize());
            ps.setFetchSize(this.getFetchSize());
            ps.setFetchDirection(this.getFetchDirection());
            AbstractJdbc2ResultSet rs = (AbstractJdbc2ResultSet)ps.executeQuery();
            rs.registerRealStatement(this);
            this.result = this.firstUnclosedResult = new ResultWrapper(rs);
            return rs;
        }
        if (!this.executeWithFlags(p_sql, 0)) {
            throw new PSQLException(GT.tr("No results were returned by the query."), PSQLState.NO_DATA);
        }
        if (this.result.getNext() != null) {
            throw new PSQLException(GT.tr("Multiple ResultSets were returned by the query."), PSQLState.TOO_MANY_RESULTS);
        }
        return this.result.getResultSet();
    }

    public ResultSet executeQuery() throws SQLException {
        if (!this.executeWithFlags(0)) {
            throw new PSQLException(GT.tr("No results were returned by the query."), PSQLState.NO_DATA);
        }
        if (this.result.getNext() != null) {
            throw new PSQLException(GT.tr("Multiple ResultSets were returned by the query."), PSQLState.TOO_MANY_RESULTS);
        }
        return this.result.getResultSet();
    }

    @Override
    public int executeUpdate(String p_sql) throws SQLException {
        if (this.preparedQuery != null) {
            throw new PSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement."), PSQLState.WRONG_OBJECT_TYPE);
        }
        if (this.isFunction) {
            this.executeWithFlags(p_sql, 0);
            return 0;
        }
        this.executeWithFlags(p_sql, 4);
        for (ResultWrapper iter = this.result; iter != null; iter = iter.getNext()) {
            if (iter.getResultSet() == null) continue;
            throw new PSQLException(GT.tr("A result was returned when none was expected."), PSQLState.TOO_MANY_RESULTS);
        }
        return this.getUpdateCount();
    }

    public int executeUpdate() throws SQLException {
        if (this.isFunction) {
            this.executeWithFlags(0);
            return 0;
        }
        this.executeWithFlags(4);
        for (ResultWrapper iter = this.result; iter != null; iter = iter.getNext()) {
            if (iter.getResultSet() == null) continue;
            throw new PSQLException(GT.tr("A result was returned when none was expected."), PSQLState.TOO_MANY_RESULTS);
        }
        return this.getUpdateCount();
    }

    @Override
    public boolean execute(String p_sql) throws SQLException {
        if (this.preparedQuery != null) {
            throw new PSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement."), PSQLState.WRONG_OBJECT_TYPE);
        }
        return this.executeWithFlags(p_sql, 0);
    }

    @Override
    public boolean executeWithFlags(String p_sql, int flags) throws SQLException {
        this.checkClosed();
        p_sql = AbstractJdbc2Statement.replaceProcessing(p_sql, this.replaceProcessingEnabled, this.connection.getStandardConformingStrings());
        Query simpleQuery = this.connection.getQueryExecutor().createSimpleQuery(p_sql);
        this.execute(simpleQuery, null, 1 | flags);
        this.lastSimpleQuery = simpleQuery;
        return this.result != null && this.result.getResultSet() != null;
    }

    public boolean execute() throws SQLException {
        return this.executeWithFlags(0);
    }

    @Override
    public boolean executeWithFlags(int flags) throws SQLException {
        this.checkClosed();
        this.execute(this.preparedQuery.query, this.preparedParameters, flags);
        if (this.isFunction && this.returnTypeSet) {
            int outParameterCount;
            if (this.result == null || this.result.getResultSet() == null) {
                throw new PSQLException(GT.tr("A CallableStatement was executed with nothing returned."), PSQLState.NO_DATA);
            }
            ResultSet rs = this.result.getResultSet();
            if (!rs.next()) {
                throw new PSQLException(GT.tr("A CallableStatement was executed with nothing returned."), PSQLState.NO_DATA);
            }
            int cols = rs.getMetaData().getColumnCount();
            if (cols != (outParameterCount = this.preparedParameters.getOutParameterCount())) {
                throw new PSQLException(GT.tr("A CallableStatement was executed with an invalid number of parameters"), PSQLState.SYNTAX_ERROR);
            }
            this.lastIndex = 0;
            this.callResult = new Object[this.preparedParameters.getParameterCount() + 1];
            int i = 0;
            int j = 0;
            while (i < cols) {
                while (j < this.functionReturnType.length && this.functionReturnType[j] == 0) {
                    ++j;
                }
                this.callResult[j] = rs.getObject(i + 1);
                int columnType = rs.getMetaData().getColumnType(i + 1);
                if (columnType != this.functionReturnType[j]) {
                    if (columnType == 8 && this.functionReturnType[j] == 7) {
                        if (this.callResult[j] != null) {
                            this.callResult[j] = Float.valueOf(((Double)this.callResult[j]).floatValue());
                        }
                    } else {
                        throw new PSQLException(GT.tr("A CallableStatement function was executed and the out parameter {0} was of type {1} however type {2} was registered.", new Object[]{i + 1, "java.sql.Types=" + columnType, "java.sql.Types=" + this.functionReturnType[j]}), PSQLState.DATA_TYPE_MISMATCH);
                    }
                }
                ++i;
                ++j;
            }
            rs.close();
            this.result = null;
            return false;
        }
        return this.result != null && this.result.getResultSet() != null;
    }

    protected void closeForNextExecution() throws SQLException {
        this.clearWarnings();
        while (this.firstUnclosedResult != null) {
            ResultSet rs = this.firstUnclosedResult.getResultSet();
            if (rs != null) {
                rs.close();
            }
            this.firstUnclosedResult = this.firstUnclosedResult.getNext();
        }
        this.result = null;
        if (this.lastSimpleQuery != null) {
            this.lastSimpleQuery.close();
            this.lastSimpleQuery = null;
        }
        if (this.generatedKeys != null) {
            if (this.generatedKeys.getResultSet() != null) {
                this.generatedKeys.getResultSet().close();
            }
            this.generatedKeys = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(Query queryToExecute, ParameterList queryParameters, int flags) throws SQLException {
        this.closeForNextExecution();
        if (!(this.fetchSize <= 0 || this.wantsScrollableResultSet() || this.connection.getAutoCommit() || this.wantsHoldableResultSet())) {
            flags |= 8;
        }
        if ((this.wantsGeneratedKeysOnce || this.wantsGeneratedKeysAlways) && ((flags |= 0x40) & 4) != 0) {
            flags &= 0xFFFFFFFB;
        }
        if (this.preparedQuery != null && this.preparedQuery.query == queryToExecute) {
            this.preparedQuery.increaseExecuteCount();
            if (!(this.m_prepareThreshold != 0 && this.preparedQuery.getExecuteCount() >= this.m_prepareThreshold || this.forceBinaryTransfers)) {
                flags |= 1;
            }
        }
        if (this.connection.getAutoCommit()) {
            flags |= 0x10;
        }
        if (this.concurrency != 1007) {
            flags |= 0x100;
        }
        if (queryToExecute.isEmpty()) {
            flags |= 0x10;
        }
        if (!queryToExecute.isStatementDescribed() && this.forceBinaryTransfers) {
            int flags2 = flags | 0x20;
            StatementResultHandler handler2 = new StatementResultHandler();
            this.connection.getQueryExecutor().execute(queryToExecute, queryParameters, (ResultHandler)handler2, 0, 0, flags2);
            ResultWrapper result2 = handler2.getResults();
            if (result2 != null) {
                result2.getResultSet().close();
            }
        }
        StatementResultHandler handler = new StatementResultHandler();
        this.result = null;
        try {
            this.startTimer();
            this.connection.getQueryExecutor().execute(queryToExecute, queryParameters, (ResultHandler)handler, this.maxrows, this.fetchSize, flags);
        }
        finally {
            this.killTimerTask();
        }
        this.result = this.firstUnclosedResult = handler.getResults();
        if (this.wantsGeneratedKeysOnce || this.wantsGeneratedKeysAlways) {
            this.generatedKeys = this.result;
            this.result = this.result.getNext();
            if (this.wantsGeneratedKeysOnce) {
                this.wantsGeneratedKeysOnce = false;
            }
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkClosed();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkClosed();
        if (this.result == null || this.result.getResultSet() != null) {
            return -1;
        }
        return this.result.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.result == null) {
            return false;
        }
        this.result = this.result.getNext();
        while (this.firstUnclosedResult != this.result) {
            if (this.firstUnclosedResult.getResultSet() != null) {
                this.firstUnclosedResult.getResultSet().close();
            }
            this.firstUnclosedResult = this.firstUnclosedResult.getNext();
        }
        return this.result != null && this.result.getResultSet() != null;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxrows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw new PSQLException(GT.tr("Maximum number of rows must be a value grater than or equal to 0."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.maxrows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
        this.replaceProcessingEnabled = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkClosed();
        return this.timeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkClosed();
        if (seconds < 0) {
            throw new PSQLException(GT.tr("Query timeout must be a value greater than or equals to 0."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.timeout = seconds;
    }

    public void addWarning(SQLWarning warn) {
        if (this.warnings == null) {
            this.warnings = warn;
            this.lastWarning = warn;
        } else {
            this.lastWarning.setNextWarning(warn);
            this.lastWarning = warn;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warnings;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxfieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw new PSQLException(GT.tr("The maximum field size must be a value greater than or equal to 0."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.maxfieldSize = max;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warnings = null;
        this.lastWarning = null;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return null;
        }
        return this.result.getResultSet();
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.killTimerTask();
        this.closeForNextExecution();
        if (this.preparedQuery != null) {
            ((AbstractJdbc2Connection)this.connection).releaseQuery(this.preparedQuery);
        }
        this.isClosed = true;
    }

    static String replaceProcessing(String p_sql, boolean replaceProcessingEnabled, boolean standardConformingStrings) throws SQLException {
        if (replaceProcessingEnabled) {
            int len = p_sql.length();
            StringBuilder newsql = new StringBuilder(len);
            int i = 0;
            while (i < len) {
                if ((i = AbstractJdbc2Statement.parseSql(p_sql, i, newsql, false, standardConformingStrings)) >= len) continue;
                newsql.append(p_sql.charAt(i));
                ++i;
            }
            return newsql.toString();
        }
        return p_sql;
    }

    protected static int parseSql(String p_sql, int i, StringBuilder newsql, boolean stopOnComma, boolean stdStrings) throws SQLException {
        int state = 0;
        int len = p_sql.length();
        int nestedParenthesis = 0;
        boolean endOfNested = false;
        --i;
        while (!endOfNested && ++i < len) {
            char c = p_sql.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '\'') {
                        state = 1;
                    } else if (c == '\"') {
                        state = 6;
                    } else if (c == '(') {
                        ++nestedParenthesis;
                    } else if (c == ')') {
                        if (--nestedParenthesis < 0) {
                            endOfNested = true;
                            break;
                        }
                    } else {
                        if (stopOnComma && c == ',' && nestedParenthesis == 0) {
                            endOfNested = true;
                            break;
                        }
                        if (c == '{' && i + 1 < len) {
                            char nextnext;
                            char next = p_sql.charAt(i + 1);
                            char c2 = nextnext = i + 2 < len ? p_sql.charAt(i + 2) : (char)'\u0000';
                            if (next == 'd' || next == 'D') {
                                state = 3;
                                ++i;
                                newsql.append("DATE ");
                                break;
                            }
                            if (next == 't' || next == 'T') {
                                state = 3;
                                if (nextnext == 's' || nextnext == 'S') {
                                    i += 2;
                                    newsql.append("TIMESTAMP ");
                                    break;
                                }
                                ++i;
                                newsql.append("TIME ");
                                break;
                            }
                            if (next == 'f' || next == 'F') {
                                state = 4;
                                i += nextnext == 'n' || nextnext == 'N' ? 2 : 1;
                                break;
                            }
                            if (next == 'o' || next == 'O') {
                                state = 5;
                                i += nextnext == 'j' || nextnext == 'J' ? 2 : 1;
                                break;
                            }
                            if (next == 'e' || next == 'E') {
                                state = 7;
                                break;
                            }
                        }
                    }
                    newsql.append(c);
                    break;
                }
                case 1: {
                    if (c == '\'') {
                        state = 0;
                    } else if (c == '\\' && !stdStrings) {
                        state = 2;
                    }
                    newsql.append(c);
                    break;
                }
                case 6: {
                    if (c == '\"') {
                        state = 0;
                    }
                    newsql.append(c);
                    break;
                }
                case 2: {
                    state = 1;
                    newsql.append(c);
                    break;
                }
                case 4: {
                    int posArgs = p_sql.indexOf(40, i);
                    if (posArgs != -1) {
                        String functionName = p_sql.substring(i, posArgs).trim();
                        i = posArgs + 1;
                        StringBuilder args = new StringBuilder();
                        i = AbstractJdbc2Statement.parseSql(p_sql, i, args, false, stdStrings);
                        newsql.append(AbstractJdbc2Statement.escapeFunction(functionName, args.toString(), stdStrings));
                    }
                    ++i;
                    while (i < len && p_sql.charAt(i) != '}') {
                        newsql.append(p_sql.charAt(i++));
                    }
                    state = 0;
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    if (c == '}') {
                        state = 0;
                        break;
                    }
                    newsql.append(c);
                }
            }
        }
        return i;
    }

    protected static String escapeFunction(String functionName, String args, boolean stdStrings) throws SQLException {
        int len = args.length();
        ArrayList<StringBuilder> parsedArgs = new ArrayList<StringBuilder>();
        for (int i = 0; i < len; ++i) {
            int lastPos = i;
            StringBuilder arg = new StringBuilder();
            if (lastPos == (i = AbstractJdbc2Statement.parseSql(args, i, arg, true, stdStrings))) continue;
            parsedArgs.add(arg);
        }
        try {
            Method escapeMethod = EscapedFunctions.getFunction(functionName);
            return (String)escapeMethod.invoke(null, parsedArgs);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof SQLException) {
                throw (SQLException)e.getTargetException();
            }
            throw new PSQLException(e.getTargetException().getMessage(), PSQLState.SYSTEM_ERROR);
        }
        catch (Exception e) {
            StringBuilder buf = new StringBuilder();
            buf.append(functionName).append('(');
            for (int iArg = 0; iArg < parsedArgs.size(); ++iArg) {
                buf.append(parsedArgs.get(iArg));
                if (iArg == parsedArgs.size() - 1) continue;
                buf.append(',');
            }
            buf.append(')');
            return buf.toString();
        }
    }

    public int getInsertedOID() throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return 0;
        }
        return (int)this.result.getInsertOID();
    }

    @Override
    public long getLastOID() throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return 0L;
        }
        return this.result.getInsertOID();
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        int oid;
        this.checkClosed();
        switch (sqlType) {
            case 4: {
                oid = 23;
                break;
            }
            case -6: 
            case 5: {
                oid = 21;
                break;
            }
            case -5: {
                oid = 20;
                break;
            }
            case 7: {
                oid = 700;
                break;
            }
            case 6: 
            case 8: {
                oid = 701;
                break;
            }
            case 2: 
            case 3: {
                oid = 1700;
                break;
            }
            case 1: {
                oid = 1042;
                break;
            }
            case -1: 
            case 12: {
                oid = this.connection.getStringVarcharFlag() ? 1043 : 0;
                break;
            }
            case 91: {
                oid = 1082;
                break;
            }
            case 92: 
            case 93: {
                oid = 0;
                break;
            }
            case -7: {
                oid = 16;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                if (this.connection.haveMinimumCompatibleVersion(ServerVersion.v7_2)) {
                    oid = 17;
                    break;
                }
                oid = 26;
                break;
            }
            case 2004: 
            case 2005: {
                oid = 26;
                break;
            }
            case 0: 
            case 1111: 
            case 2001: 
            case 2002: 
            case 2003: {
                oid = 0;
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Unknown Types value."), PSQLState.INVALID_PARAMETER_TYPE);
            }
        }
        if (this.adjustIndex) {
            --parameterIndex;
        }
        this.preparedParameters.setNull(parameterIndex, oid);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkClosed();
        this.bindString(parameterIndex, x ? "1" : "0", 16);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setShort(parameterIndex, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkClosed();
        if (this.connection.binaryTransferSend(21)) {
            byte[] val = new byte[2];
            ByteConverter.int2(val, 0, x);
            this.bindBytes(parameterIndex, val, 21);
            return;
        }
        this.bindLiteral(parameterIndex, Integer.toString(x), 21);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkClosed();
        if (this.connection.binaryTransferSend(23)) {
            byte[] val = new byte[4];
            ByteConverter.int4(val, 0, x);
            this.bindBytes(parameterIndex, val, 23);
            return;
        }
        this.bindLiteral(parameterIndex, Integer.toString(x), 23);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkClosed();
        if (this.connection.binaryTransferSend(20)) {
            byte[] val = new byte[8];
            ByteConverter.int8(val, 0, x);
            this.bindBytes(parameterIndex, val, 20);
            return;
        }
        this.bindLiteral(parameterIndex, Long.toString(x), 20);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkClosed();
        if (this.connection.binaryTransferSend(700)) {
            byte[] val = new byte[4];
            ByteConverter.float4(val, 0, x);
            this.bindBytes(parameterIndex, val, 700);
            return;
        }
        this.bindLiteral(parameterIndex, Float.toString(x), 701);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkClosed();
        if (this.connection.binaryTransferSend(701)) {
            byte[] val = new byte[8];
            ByteConverter.float8(val, 0, x);
            this.bindBytes(parameterIndex, val, 701);
            return;
        }
        this.bindLiteral(parameterIndex, Double.toString(x), 701);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, 3);
        } else {
            this.bindLiteral(parameterIndex, x.toString(), 1700);
        }
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkClosed();
        this.setString(parameterIndex, x, this.getStringType());
    }

    private int getStringType() {
        return this.connection.getStringVarcharFlag() ? 1043 : 0;
    }

    protected void setString(int parameterIndex, String x, int oid) throws SQLException {
        this.checkClosed();
        if (x == null) {
            if (this.adjustIndex) {
                --parameterIndex;
            }
            this.preparedParameters.setNull(parameterIndex, oid);
        } else {
            this.bindString(parameterIndex, x, oid);
        }
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkClosed();
        if (null == x) {
            this.setNull(parameterIndex, -3);
            return;
        }
        if (this.connection.haveMinimumCompatibleVersion(ServerVersion.v7_2)) {
            byte[] copy = new byte[x.length];
            System.arraycopy(x, 0, copy, 0, x.length);
            this.preparedParameters.setBytea(parameterIndex, copy, 0, x.length);
        } else {
            LargeObjectManager lom = this.connection.getLargeObjectAPI();
            long oid = lom.createLO();
            LargeObject lob = lom.open(oid);
            lob.write(x);
            lob.close();
            this.setLong(parameterIndex, oid);
        }
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, null);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, null);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestamp(parameterIndex, x, null);
    }

    private void setCharacterStreamPost71(int parameterIndex, InputStream x, int length, String encoding) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 12);
            return;
        }
        if (length < 0) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        try {
            int n;
            InputStreamReader l_inStream = new InputStreamReader(x, encoding);
            char[] l_chars = new char[length];
            int l_charsRead = 0;
            while ((n = l_inStream.read(l_chars, l_charsRead, length - l_charsRead)) != -1 && (l_charsRead += n) != length) {
            }
            this.setString(parameterIndex, new String(l_chars, 0, l_charsRead), 1043);
        }
        catch (UnsupportedEncodingException l_uee) {
            throw new PSQLException(GT.tr("The JVM claims not to support the {0} encoding.", encoding), PSQLState.UNEXPECTED_ERROR, (Throwable)l_uee);
        }
        catch (IOException l_ioe) {
            throw new PSQLException(GT.tr("Provided InputStream failed."), PSQLState.UNEXPECTED_ERROR, (Throwable)l_ioe);
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (this.connection.haveMinimumCompatibleVersion(ServerVersion.v7_2)) {
            this.setCharacterStreamPost71(parameterIndex, x, length, "ASCII");
        } else {
            this.setBinaryStream(parameterIndex, x, length);
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (this.connection.haveMinimumCompatibleVersion(ServerVersion.v7_2)) {
            this.setCharacterStreamPost71(parameterIndex, x, length, "UTF-8");
        } else {
            this.setBinaryStream(parameterIndex, x, length);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, -3);
            return;
        }
        if (length < 0) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (this.connection.haveMinimumCompatibleVersion(ServerVersion.v7_2)) {
            this.preparedParameters.setBytea(parameterIndex, x, length);
        } else {
            LargeObjectManager lom = this.connection.getLargeObjectAPI();
            long oid = lom.createLO();
            LargeObject lob = lom.open(oid);
            OutputStream los = lob.getOutputStream();
            try {
                int c = x.read();
                for (int p = 0; c > -1 && p < length; ++p) {
                    los.write(c);
                    c = x.read();
                }
                los.close();
            }
            catch (IOException se) {
                throw new PSQLException(GT.tr("Provided InputStream failed."), PSQLState.UNEXPECTED_ERROR, (Throwable)se);
            }
            this.setLong(parameterIndex, oid);
        }
    }

    public void clearParameters() throws SQLException {
        this.preparedParameters.clear();
    }

    private void setPGobject(int parameterIndex, PGobject x) throws SQLException {
        String typename = x.getType();
        int oid = this.connection.getTypeInfo().getPGType(typename);
        if (oid == 0) {
            throw new PSQLException(GT.tr("Unknown type {0}.", typename), PSQLState.INVALID_PARAMETER_TYPE);
        }
        if (x instanceof PGBinaryObject && this.connection.binaryTransferSend(oid)) {
            PGBinaryObject binObj = (PGBinaryObject)((Object)x);
            byte[] data = new byte[binObj.lengthInBytes()];
            binObj.toBytes(data, 0);
            this.bindBytes(parameterIndex, data, oid);
        } else {
            this.setString(parameterIndex, x.getValue(), oid);
        }
    }

    private void setMap(int parameterIndex, Map x) throws SQLException {
        int oid = this.connection.getTypeInfo().getPGType("hstore");
        if (oid == 0) {
            throw new PSQLException(GT.tr("No hstore extension installed."), PSQLState.INVALID_PARAMETER_TYPE);
        }
        if (this.connection.binaryTransferSend(oid)) {
            byte[] data = HStoreConverter.toBytes(x, this.connection.getEncoding());
            this.bindBytes(parameterIndex, data, oid);
        } else {
            this.setString(parameterIndex, HStoreConverter.toString(x), oid);
        }
    }

    public void setObject(int parameterIndex, Object in, int targetSqlType, int scale) throws SQLException {
        this.checkClosed();
        if (in == null) {
            this.setNull(parameterIndex, targetSqlType);
            return;
        }
        switch (targetSqlType) {
            case 4: {
                this.setInt(parameterIndex, AbstractJdbc2Statement.castToInt(in));
                break;
            }
            case -6: 
            case 5: {
                this.setShort(parameterIndex, AbstractJdbc2Statement.castToShort(in));
                break;
            }
            case -5: {
                this.setLong(parameterIndex, AbstractJdbc2Statement.castToLong(in));
                break;
            }
            case 7: {
                this.setFloat(parameterIndex, AbstractJdbc2Statement.castToFloat(in));
                break;
            }
            case 6: 
            case 8: {
                this.setDouble(parameterIndex, AbstractJdbc2Statement.castToDouble(in));
                break;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(parameterIndex, AbstractJdbc2Statement.castToBigDecimal(in, scale));
                break;
            }
            case 1: {
                this.setString(parameterIndex, AbstractJdbc2Statement.castToString(in), 1042);
                break;
            }
            case -1: 
            case 12: {
                this.setString(parameterIndex, AbstractJdbc2Statement.castToString(in), this.getStringType());
                break;
            }
            case 91: {
                if (in instanceof Date) {
                    this.setDate(parameterIndex, (Date)in);
                    break;
                }
                Date tmpd = in instanceof java.util.Date ? new Date(((java.util.Date)in).getTime()) : this.connection.getTimestampUtils().toDate(null, in.toString());
                this.setDate(parameterIndex, tmpd);
                break;
            }
            case 92: {
                if (in instanceof Time) {
                    this.setTime(parameterIndex, (Time)in);
                    break;
                }
                Time tmpt = in instanceof java.util.Date ? new Time(((java.util.Date)in).getTime()) : this.connection.getTimestampUtils().toTime(null, in.toString());
                this.setTime(parameterIndex, tmpt);
                break;
            }
            case 93: {
                if (in instanceof Timestamp) {
                    this.setTimestamp(parameterIndex, (Timestamp)in);
                    break;
                }
                Timestamp tmpts = in instanceof java.util.Date ? new Timestamp(((java.util.Date)in).getTime()) : this.connection.getTimestampUtils().toTimestamp(null, in.toString());
                this.setTimestamp(parameterIndex, tmpts);
                break;
            }
            case -7: {
                this.setBoolean(parameterIndex, AbstractJdbc2Statement.castToBoolean(in));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setObject(parameterIndex, in);
                break;
            }
            case 2004: {
                if (in instanceof Blob) {
                    this.setBlob(parameterIndex, (Blob)in);
                    break;
                }
                if (in instanceof InputStream) {
                    long oid = this.createBlob(parameterIndex, (InputStream)in, -1L);
                    this.setLong(parameterIndex, oid);
                    break;
                }
                throw new PSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", new Object[]{in.getClass().getName(), "Types.BLOB"}), PSQLState.INVALID_PARAMETER_TYPE);
            }
            case 2005: {
                if (in instanceof Clob) {
                    this.setClob(parameterIndex, (Clob)in);
                    break;
                }
                throw new PSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", new Object[]{in.getClass().getName(), "Types.CLOB"}), PSQLState.INVALID_PARAMETER_TYPE);
            }
            case 2003: {
                if (in instanceof Array) {
                    this.setArray(parameterIndex, (Array)in);
                    break;
                }
                throw new PSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", new Object[]{in.getClass().getName(), "Types.ARRAY"}), PSQLState.INVALID_PARAMETER_TYPE);
            }
            case 2001: {
                this.bindString(parameterIndex, in.toString(), 0);
                break;
            }
            case 1111: {
                if (in instanceof PGobject) {
                    this.setPGobject(parameterIndex, (PGobject)in);
                    break;
                }
                this.bindString(parameterIndex, in.toString(), 0);
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Unsupported Types value: {0}", targetSqlType), PSQLState.INVALID_PARAMETER_TYPE);
            }
        }
    }

    private static String asString(Clob in) throws SQLException {
        return in.getSubString(1L, (int)in.length());
    }

    private static int castToInt(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Integer.parseInt((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).intValue();
            }
            if (in instanceof java.util.Date) {
                return (int)((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1 : 0;
            }
            if (in instanceof Clob) {
                return Integer.parseInt(AbstractJdbc2Statement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Integer.parseInt(in.toString());
            }
        }
        catch (Exception e) {
            throw AbstractJdbc2Statement.cannotCastException(in.getClass().getName(), "int", e);
        }
        throw AbstractJdbc2Statement.cannotCastException(in.getClass().getName(), "int");
    }

    private static short castToShort(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Short.parseShort((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).shortValue();
            }
            if (in instanceof java.util.Date) {
                return (short)((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? (short)1 : 0;
            }
            if (in instanceof Clob) {
                return Short.parseShort(AbstractJdbc2Statement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Short.parseShort(in.toString());
            }
        }
        catch (Exception e) {
            throw AbstractJdbc2Statement.cannotCastException(in.getClass().getName(), "short", e);
        }
        throw AbstractJdbc2Statement.cannotCastException(in.getClass().getName(), "short");
    }

    private static long castToLong(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Long.parseLong((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).longValue();
            }
            if (in instanceof java.util.Date) {
                return ((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1L : 0L;
            }
            if (in instanceof Clob) {
                return Long.parseLong(AbstractJdbc2Statement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Long.parseLong(in.toString());
            }
        }
        catch (Exception e) {
            throw AbstractJdbc2Statement.cannotCastException(in.getClass().getName(), "long", e);
        }
        throw AbstractJdbc2Statement.cannotCastException(in.getClass().getName(), "long");
    }

    private static float castToFloat(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Float.parseFloat((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).floatValue();
            }
            if (in instanceof java.util.Date) {
                return ((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1.0f : 0.0f;
            }
            if (in instanceof Clob) {
                return Float.parseFloat(AbstractJdbc2Statement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Float.parseFloat(in.toString());
            }
        }
        catch (Exception e) {
            throw AbstractJdbc2Statement.cannotCastException(in.getClass().getName(), "float", e);
        }
        throw AbstractJdbc2Statement.cannotCastException(in.getClass().getName(), "float");
    }

    private static double castToDouble(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Double.parseDouble((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).doubleValue();
            }
            if (in instanceof java.util.Date) {
                return ((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1.0 : 0.0;
            }
            if (in instanceof Clob) {
                return Double.parseDouble(AbstractJdbc2Statement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Double.parseDouble(in.toString());
            }
        }
        catch (Exception e) {
            throw AbstractJdbc2Statement.cannotCastException(in.getClass().getName(), "double", e);
        }
        throw AbstractJdbc2Statement.cannotCastException(in.getClass().getName(), "double");
    }

    private static BigDecimal castToBigDecimal(Object in, int scale) throws SQLException {
        try {
            if (in instanceof String) {
                return new BigDecimal((String)in).setScale(scale, RoundingMode.HALF_UP);
            }
            if (in instanceof BigDecimal) {
                return ((BigDecimal)in).setScale(scale, RoundingMode.HALF_UP);
            }
            if (in instanceof BigInteger) {
                return new BigDecimal((BigInteger)in, scale);
            }
            if (in instanceof Long || in instanceof Integer || in instanceof Short || in instanceof Byte) {
                return BigDecimal.valueOf(((Number)in).longValue(), scale);
            }
            if (in instanceof Double || in instanceof Float) {
                return BigDecimal.valueOf(((Number)in).doubleValue()).setScale(scale, RoundingMode.HALF_UP);
            }
            if (in instanceof java.util.Date) {
                return BigDecimal.valueOf(((java.util.Date)in).getTime(), scale);
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            if (in instanceof Clob) {
                return new BigDecimal(AbstractJdbc2Statement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return new BigDecimal(new char[]{((Character)in).charValue()}).setScale(scale, RoundingMode.HALF_UP);
            }
        }
        catch (Exception e) {
            throw AbstractJdbc2Statement.cannotCastException(in.getClass().getName(), "BigDecimal", e);
        }
        throw AbstractJdbc2Statement.cannotCastException(in.getClass().getName(), "BigDecimal");
    }

    private static boolean castToBoolean(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return ((String)in).equalsIgnoreCase("true") || ((String)in).equals("1") || ((String)in).equalsIgnoreCase("t");
            }
            if (in instanceof BigDecimal) {
                return ((BigDecimal)in).signum() != 0;
            }
            if (in instanceof Number) {
                return ((Number)in).longValue() != 0L;
            }
            if (in instanceof java.util.Date) {
                return ((java.util.Date)in).getTime() != 0L;
            }
            if (in instanceof Boolean) {
                return (Boolean)in;
            }
            if (in instanceof Clob) {
                String asString = AbstractJdbc2Statement.asString((Clob)in);
                return asString.equalsIgnoreCase("true") || asString.equals("1") || asString.equalsIgnoreCase("t");
            }
            if (in instanceof Character) {
                return ((Character)in).charValue() == '1' || ((Character)in).charValue() == 't' || ((Character)in).charValue() == 'T';
            }
        }
        catch (Exception e) {
            throw AbstractJdbc2Statement.cannotCastException(in.getClass().getName(), "boolean", e);
        }
        throw AbstractJdbc2Statement.cannotCastException(in.getClass().getName(), "boolean");
    }

    private static String castToString(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return (String)in;
            }
            if (in instanceof Number || in instanceof Boolean || in instanceof Character || in instanceof java.util.Date) {
                return in.toString();
            }
            if (in instanceof Clob) {
                return AbstractJdbc2Statement.asString((Clob)in);
            }
        }
        catch (Exception e) {
            throw AbstractJdbc2Statement.cannotCastException(in.getClass().getName(), "String", e);
        }
        throw AbstractJdbc2Statement.cannotCastException(in.getClass().getName(), "String");
    }

    private static PSQLException cannotCastException(String fromType, String toType) {
        return AbstractJdbc2Statement.cannotCastException(fromType, toType, null);
    }

    private static PSQLException cannotCastException(String fromType, String toType, Exception cause) {
        return new PSQLException(GT.tr("Cannot convert an instance of {0} to type {1}", new Object[]{fromType, toType}), PSQLState.INVALID_PARAMETER_TYPE, (Throwable)cause);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, 1111);
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
        } else if (x instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)x);
        } else if (x instanceof Clob) {
            this.setClob(parameterIndex, (Clob)x);
        } else if (x instanceof Array) {
            this.setArray(parameterIndex, (Array)x);
        } else if (x instanceof PGobject) {
            this.setPGobject(parameterIndex, (PGobject)x);
        } else if (x instanceof Character) {
            this.setString(parameterIndex, ((Character)x).toString());
        } else if (x instanceof Map) {
            this.setMap(parameterIndex, (Map)x);
        } else {
            throw new PSQLException(GT.tr("Can''t infer the SQL type to use for an instance of {0}. Use setObject() with an explicit Types value to specify the type to use.", x.getClass().getName()), PSQLState.INVALID_PARAMETER_TYPE);
        }
    }

    public void registerOutParameter(int parameterIndex, int sqlType, boolean setPreparedParameters) throws SQLException {
        this.checkClosed();
        switch (sqlType) {
            case -6: {
                sqlType = 5;
                break;
            }
            case -1: {
                sqlType = 12;
                break;
            }
            case 3: {
                sqlType = 2;
                break;
            }
            case 6: {
                sqlType = 8;
                break;
            }
            case -4: 
            case -3: {
                sqlType = -2;
                break;
            }
        }
        if (!this.isFunction) {
            throw new PSQLException(GT.tr("This statement does not declare an OUT parameter.  Use '{' ?= call ... '}' to declare one."), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        this.checkIndex(parameterIndex, false);
        if (setPreparedParameters) {
            this.preparedParameters.registerOutParameter(parameterIndex, sqlType);
        }
        this.functionReturnType[parameterIndex - 1] = sqlType;
        this.testReturn[parameterIndex - 1] = sqlType;
        if (this.functionReturnType[parameterIndex - 1] == 1 || this.functionReturnType[parameterIndex - 1] == -1) {
            this.testReturn[parameterIndex - 1] = 12;
        } else if (this.functionReturnType[parameterIndex - 1] == 6) {
            this.testReturn[parameterIndex - 1] = 7;
        }
        this.returnTypeSet = true;
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale, boolean setPreparedParameters) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType, setPreparedParameters);
    }

    public boolean wasNull() throws SQLException {
        if (this.lastIndex == 0) {
            throw new PSQLException(GT.tr("wasNull cannot be call before fetching a result."), PSQLState.OBJECT_NOT_IN_STATE);
        }
        return this.callResult[this.lastIndex - 1] == null;
    }

    public String getString(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 12, "String");
        return (String)this.callResult[parameterIndex - 1];
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -7, "Boolean");
        if (this.callResult[parameterIndex - 1] == null) {
            return false;
        }
        return (Boolean)this.callResult[parameterIndex - 1];
    }

    public byte getByte(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 5, "Byte");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0;
        }
        return ((Integer)this.callResult[parameterIndex - 1]).byteValue();
    }

    public short getShort(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 5, "Short");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0;
        }
        return ((Integer)this.callResult[parameterIndex - 1]).shortValue();
    }

    public int getInt(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 4, "Int");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0;
        }
        return (Integer)this.callResult[parameterIndex - 1];
    }

    public long getLong(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -5, "Long");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0L;
        }
        return (Long)this.callResult[parameterIndex - 1];
    }

    public float getFloat(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 7, "Float");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0.0f;
        }
        return ((Float)this.callResult[parameterIndex - 1]).floatValue();
    }

    public double getDouble(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 8, "Double");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0.0;
        }
        return (Double)this.callResult[parameterIndex - 1];
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 2, "BigDecimal");
        return (BigDecimal)this.callResult[parameterIndex - 1];
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -3, -2, "Bytes");
        return (byte[])this.callResult[parameterIndex - 1];
    }

    public Date getDate(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 91, "Date");
        return (Date)this.callResult[parameterIndex - 1];
    }

    public Time getTime(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 92, "Time");
        return (Time)this.callResult[parameterIndex - 1];
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 93, "Timestamp");
        return (Timestamp)this.callResult[parameterIndex - 1];
    }

    public Object getObject(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex);
        return this.callResult[parameterIndex - 1];
    }

    public String toString() {
        if (this.preparedQuery == null) {
            return super.toString();
        }
        return this.preparedQuery.query.toString(this.preparedParameters);
    }

    protected void bindLiteral(int paramIndex, String s, int oid) throws SQLException {
        if (this.adjustIndex) {
            --paramIndex;
        }
        this.preparedParameters.setLiteralParameter(paramIndex, s, oid);
    }

    protected void bindBytes(int paramIndex, byte[] b, int oid) throws SQLException {
        if (this.adjustIndex) {
            --paramIndex;
        }
        this.preparedParameters.setBinaryParameter(paramIndex, b, oid);
    }

    private void bindString(int paramIndex, String s, int oid) throws SQLException {
        if (this.adjustIndex) {
            --paramIndex;
        }
        this.preparedParameters.setStringParameter(paramIndex, s, oid);
    }

    protected void checkIndex(int parameterIndex, int type1, int type2, String getName) throws SQLException {
        this.checkIndex(parameterIndex);
        if (type1 != this.testReturn[parameterIndex - 1] && type2 != this.testReturn[parameterIndex - 1]) {
            throw new PSQLException(GT.tr("Parameter of type {0} was registered, but call to get{1} (sqltype={2}) was made.", new Object[]{"java.sql.Types=" + this.testReturn[parameterIndex - 1], getName, "java.sql.Types=" + type1}), PSQLState.MOST_SPECIFIC_TYPE_DOES_NOT_MATCH);
        }
    }

    protected void checkIndex(int parameterIndex, int type, String getName) throws SQLException {
        this.checkIndex(parameterIndex);
        if (type != this.testReturn[parameterIndex - 1]) {
            throw new PSQLException(GT.tr("Parameter of type {0} was registered, but call to get{1} (sqltype={2}) was made.", new Object[]{"java.sql.Types=" + this.testReturn[parameterIndex - 1], getName, "java.sql.Types=" + type}), PSQLState.MOST_SPECIFIC_TYPE_DOES_NOT_MATCH);
        }
    }

    private void checkIndex(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, true);
    }

    private void checkIndex(int parameterIndex, boolean fetchingData) throws SQLException {
        if (!this.isFunction) {
            throw new PSQLException(GT.tr("A CallableStatement was declared, but no call to registerOutParameter(1, <some type>) was made."), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        if (fetchingData) {
            if (!this.returnTypeSet) {
                throw new PSQLException(GT.tr("No function outputs were registered."), PSQLState.OBJECT_NOT_IN_STATE);
            }
            if (this.callResult == null) {
                throw new PSQLException(GT.tr("Results cannot be retrieved from a CallableStatement before it is executed."), PSQLState.NO_DATA);
            }
            this.lastIndex = parameterIndex;
        }
    }

    @Override
    public void setPrepareThreshold(int newThreshold) throws SQLException {
        this.checkClosed();
        if (newThreshold < 0) {
            this.forceBinaryTransfers = true;
            newThreshold = 1;
        }
        this.m_prepareThreshold = newThreshold;
    }

    @Override
    public int getPrepareThreshold() {
        return this.m_prepareThreshold;
    }

    @Override
    public void setUseServerPrepare(boolean flag) throws SQLException {
        this.setPrepareThreshold(flag ? 1 : 0);
    }

    @Override
    public boolean isUseServerPrepare() {
        return this.preparedQuery != null && this.m_prepareThreshold != 0 && this.preparedQuery.getExecuteCount() + 1 >= this.m_prepareThreshold;
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new PSQLException(GT.tr("This statement has been closed."), PSQLState.OBJECT_NOT_IN_STATE);
        }
    }

    @Override
    public void addBatch(String p_sql) throws SQLException {
        this.checkClosed();
        if (this.preparedQuery != null) {
            throw new PSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement."), PSQLState.WRONG_OBJECT_TYPE);
        }
        if (this.batchStatements == null) {
            this.batchStatements = new ArrayList();
            this.batchParameters = new ArrayList();
        }
        p_sql = AbstractJdbc2Statement.replaceProcessing(p_sql, this.replaceProcessingEnabled, this.connection.getStandardConformingStrings());
        this.batchStatements.add(this.connection.getQueryExecutor().createSimpleQuery(p_sql));
        this.batchParameters.add(null);
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.batchStatements != null) {
            this.batchStatements.clear();
            this.batchParameters.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClosed();
        this.closeForNextExecution();
        if (this.batchStatements == null || this.batchStatements.isEmpty()) {
            return new int[0];
        }
        int size = this.batchStatements.size();
        int[] updateCounts = new int[size];
        Query[] queries = this.batchStatements.toArray(new Query[this.batchStatements.size()]);
        ParameterList[] parameterLists = this.batchParameters.toArray(new ParameterList[this.batchParameters.size()]);
        this.batchStatements.clear();
        this.batchParameters.clear();
        int flags = 0;
        boolean preDescribe = false;
        flags = this.wantsGeneratedKeysAlways ? 320 : 4;
        if (this.preparedQuery != null) {
            this.preparedQuery.increaseExecuteCount(queries.length);
        }
        if (this.m_prepareThreshold == 0 || this.preparedQuery == null || this.preparedQuery.getExecuteCount() < this.m_prepareThreshold) {
            flags |= 1;
        } else {
            preDescribe = this.wantsGeneratedKeysAlways && !queries[0].isStatementDescribed();
            flags |= 0x80;
        }
        if (this.connection.getAutoCommit()) {
            flags |= 0x10;
        }
        if (preDescribe || this.forceBinaryTransfers) {
            int flags2 = flags | 0x20;
            StatementResultHandler handler2 = new StatementResultHandler();
            this.connection.getQueryExecutor().execute(queries[0], parameterLists[0], (ResultHandler)handler2, 0, 0, flags2);
            ResultWrapper result2 = handler2.getResults();
            if (result2 != null) {
                result2.getResultSet().close();
            }
        }
        this.result = null;
        ResultHandler handler = this.isFunction ? new CallableBatchResultHandler(queries, parameterLists, updateCounts) : new BatchResultHandler(queries, parameterLists, updateCounts, this.wantsGeneratedKeysAlways);
        try {
            this.startTimer();
            this.connection.getQueryExecutor().execute(queries, parameterLists, handler, this.maxrows, this.fetchSize, flags);
        }
        finally {
            this.killTimerTask();
        }
        if (this.wantsGeneratedKeysAlways) {
            this.generatedKeys = new ResultWrapper(((BatchResultHandler)handler).getGeneratedKeys());
        }
        return updateCounts;
    }

    @Override
    public void cancel() throws SQLException {
        this.connection.cancelQuery();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public int getFetchDirection() {
        return this.fetchdirection;
    }

    @Override
    public int getResultSetConcurrency() {
        return this.concurrency;
    }

    @Override
    public int getResultSetType() {
        return this.resultsettype;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                this.fetchdirection = direction;
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Invalid fetch direction constant: {0}.", direction), PSQLState.INVALID_PARAMETER_VALUE);
            }
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (rows < 0) {
            throw new PSQLException(GT.tr("Fetch size must be a value greater to or equal to 0."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.fetchSize = rows;
    }

    public void addBatch() throws SQLException {
        this.checkClosed();
        if (this.batchStatements == null) {
            this.batchStatements = new ArrayList();
            this.batchParameters = new ArrayList();
        }
        this.batchStatements.add(this.preparedQuery.query);
        this.batchParameters.add(this.preparedParameters.copy());
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        ResultSet rs = this.getResultSet();
        if (rs == null || ((AbstractJdbc2ResultSet)rs).isResultSetClosed()) {
            int flags = 49;
            StatementResultHandler handler = new StatementResultHandler();
            this.connection.getQueryExecutor().execute(this.preparedQuery.query, this.preparedParameters, (ResultHandler)handler, 0, 0, flags);
            ResultWrapper wrapper = handler.getResults();
            if (wrapper != null) {
                rs = wrapper.getResultSet();
            }
        }
        if (rs != null) {
            return rs.getMetaData();
        }
        return null;
    }

    public void setArray(int i, Array x) throws SQLException {
        AbstractJdbc2Array arr;
        this.checkClosed();
        if (null == x) {
            this.setNull(i, 2003);
            return;
        }
        String typename = x.getBaseTypeName() + "[]";
        int oid = this.connection.getTypeInfo().getPGType(typename);
        if (oid == 0) {
            throw new PSQLException(GT.tr("Unknown type {0}.", typename), PSQLState.INVALID_PARAMETER_TYPE);
        }
        if (x instanceof AbstractJdbc2Array && (arr = (AbstractJdbc2Array)((Object)x)).isBinary()) {
            this.bindBytes(i, arr.toBytes(), oid);
            return;
        }
        this.setString(i, x.toString(), oid);
    }

    protected long createBlob(int i, InputStream inputStream, long length) throws SQLException {
        LargeObjectManager lom = this.connection.getLargeObjectAPI();
        long oid = lom.createLO();
        LargeObject lob = lom.open(oid);
        OutputStream outputStream = lob.getOutputStream();
        byte[] buf = new byte[4096];
        try {
            long remaining = length > 0L ? length : Long.MAX_VALUE;
            int numRead = inputStream.read(buf, 0, length > 0L && remaining < (long)buf.length ? (int)remaining : buf.length);
            while (numRead != -1 && remaining > 0L) {
                outputStream.write(buf, 0, numRead);
                numRead = inputStream.read(buf, 0, length > 0L && remaining < (long)buf.length ? (int)(remaining -= (long)numRead) : buf.length);
            }
        }
        catch (IOException se) {
            throw new PSQLException(GT.tr("Unexpected error writing large object to database."), PSQLState.UNEXPECTED_ERROR, (Throwable)se);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
        return oid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlob(int i, Blob x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(i, 2004);
            return;
        }
        InputStream inStream = x.getBinaryStream();
        try {
            long oid = this.createBlob(i, inStream, x.length());
            this.setLong(i, oid);
        }
        finally {
            try {
                inStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public void setCharacterStream(int i, Reader x, int length) throws SQLException {
        this.checkClosed();
        if (x == null) {
            if (this.connection.haveMinimumServerVersion(ServerVersion.v7_2)) {
                this.setNull(i, 12);
            } else {
                this.setNull(i, 2005);
            }
            return;
        }
        if (length < 0) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (this.connection.haveMinimumCompatibleVersion(ServerVersion.v7_2)) {
            char[] l_chars = new char[length];
            int l_charsRead = 0;
            try {
                int n;
                while ((n = x.read(l_chars, l_charsRead, length - l_charsRead)) != -1 && (l_charsRead += n) != length) {
                }
            }
            catch (IOException l_ioe) {
                throw new PSQLException(GT.tr("Provided Reader failed."), PSQLState.UNEXPECTED_ERROR, (Throwable)l_ioe);
            }
            this.setString(i, new String(l_chars, 0, l_charsRead));
        } else {
            LargeObjectManager lom = this.connection.getLargeObjectAPI();
            long oid = lom.createLO();
            LargeObject lob = lom.open(oid);
            OutputStream los = lob.getOutputStream();
            try {
                int c = x.read();
                for (int p = 0; c > -1 && p < length; ++p) {
                    los.write(c);
                    c = x.read();
                }
                los.close();
            }
            catch (IOException se) {
                throw new PSQLException(GT.tr("Unexpected error writing large object to database."), PSQLState.UNEXPECTED_ERROR, (Throwable)se);
            }
            this.setLong(i, oid);
        }
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(i, 2005);
            return;
        }
        Reader l_inStream = x.getCharacterStream();
        int l_length = (int)x.length();
        LargeObjectManager lom = this.connection.getLargeObjectAPI();
        long oid = lom.createLO();
        LargeObject lob = lom.open(oid);
        Charset connectionCharset = Charset.forName(this.connection.getEncoding().name());
        OutputStream los = lob.getOutputStream();
        OutputStreamWriter lw = new OutputStreamWriter(los, connectionCharset);
        try {
            int c = l_inStream.read();
            for (int p = 0; c > -1 && p < l_length; ++p) {
                ((Writer)lw).write(c);
                c = l_inStream.read();
            }
            ((Writer)lw).close();
        }
        catch (IOException se) {
            throw new PSQLException(GT.tr("Unexpected error writing large object to database."), PSQLState.UNEXPECTED_ERROR, (Throwable)se);
        }
        this.setLong(i, oid);
    }

    public void setNull(int i, int t, String s) throws SQLException {
        this.checkClosed();
        this.setNull(i, t);
    }

    public void setRef(int i, Ref x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setRef(int,Ref)");
    }

    public void setDate(int i, Date d, Calendar cal) throws SQLException {
        this.checkClosed();
        if (d == null) {
            this.setNull(i, 91);
            return;
        }
        if (this.connection.binaryTransferSend(1082)) {
            byte[] val = new byte[4];
            TimeZone tz = cal != null ? cal.getTimeZone() : null;
            this.connection.getTimestampUtils().toBinDate(tz, val, d);
            this.preparedParameters.setBinaryParameter(i, val, 1082);
            return;
        }
        if (cal != null) {
            cal = (Calendar)cal.clone();
        }
        this.bindString(i, this.connection.getTimestampUtils().toString(cal, d), 0);
    }

    public void setTime(int i, Time t, Calendar cal) throws SQLException {
        this.checkClosed();
        if (t == null) {
            this.setNull(i, 92);
            return;
        }
        if (cal != null) {
            cal = (Calendar)cal.clone();
        }
        this.bindString(i, this.connection.getTimestampUtils().toString(cal, t), 0);
    }

    public void setTimestamp(int i, Timestamp t, Calendar cal) throws SQLException {
        this.checkClosed();
        if (t == null) {
            this.setNull(i, 93);
            return;
        }
        if (cal != null) {
            cal = (Calendar)cal.clone();
        }
        this.bindString(i, this.connection.getTimestampUtils().toString(cal, t), 0);
    }

    public Array getArray(int i) throws SQLException {
        this.checkClosed();
        this.checkIndex(i, 2003, "Array");
        return (Array)this.callResult[i - 1];
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 2, "BigDecimal");
        return (BigDecimal)this.callResult[parameterIndex - 1];
    }

    public Blob getBlob(int i) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBlob(int)");
    }

    public Clob getClob(int i) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getClob(int)");
    }

    public Object getObjectImpl(int i, Map map) throws SQLException {
        if (map == null || map.isEmpty()) {
            return this.getObject(i);
        }
        throw Driver.notImplemented(this.getClass(), "getObjectImpl(int,Map)");
    }

    public Ref getRef(int i) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRef(int)");
    }

    public Date getDate(int i, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex(i, 91, "Date");
        if (this.callResult[i - 1] == null) {
            return null;
        }
        if (cal != null) {
            cal = (Calendar)cal.clone();
        }
        String value = this.callResult[i - 1].toString();
        return this.connection.getTimestampUtils().toDate(cal, value);
    }

    public Time getTime(int i, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex(i, 92, "Time");
        if (this.callResult[i - 1] == null) {
            return null;
        }
        if (cal != null) {
            cal = (Calendar)cal.clone();
        }
        String value = this.callResult[i - 1].toString();
        return this.connection.getTimestampUtils().toTime(cal, value);
    }

    public Timestamp getTimestamp(int i, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex(i, 93, "Timestamp");
        if (this.callResult[i - 1] == null) {
            return null;
        }
        if (cal != null) {
            cal = (Calendar)cal.clone();
        }
        String value = this.callResult[i - 1].toString();
        return this.connection.getTimestampUtils().toTimestamp(cal, value);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter(int,int,String)");
    }

    protected synchronized void startTimer() {
        if (this.timeout == 0) {
            return;
        }
        this.killTimerTask();
        this.cancelTimerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    AbstractJdbc2Statement.this.cancel();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        };
        this.connection.addTimerTask(this.cancelTimerTask, this.timeout * 1000);
    }

    private synchronized void killTimerTask() {
        if (this.cancelTimerTask != null) {
            this.cancelTimerTask.cancel();
            this.cancelTimerTask = null;
            this.connection.purgeTimerTasks();
        }
    }

    protected boolean getForceBinaryTransfer() {
        return this.forceBinaryTransfers;
    }

    private class CallableBatchResultHandler
    implements ResultHandler {
        private BatchUpdateException batchException = null;
        private int resultIndex = 0;
        private final Query[] queries;
        private final ParameterList[] parameterLists;
        private final int[] updateCounts;

        CallableBatchResultHandler(Query[] queries, ParameterList[] parameterLists, int[] updateCounts) {
            this.queries = queries;
            this.parameterLists = parameterLists;
            this.updateCounts = updateCounts;
        }

        @Override
        public void handleResultRows(Query fromQuery, Field[] fields, List tuples, ResultCursor cursor) {
        }

        @Override
        public void handleCommandStatus(String status, int updateCount, long insertOID) {
            if (this.resultIndex >= this.updateCounts.length) {
                this.handleError(new PSQLException(GT.tr("Too many update results were returned."), PSQLState.TOO_MANY_RESULTS));
                return;
            }
            this.updateCounts[this.resultIndex++] = updateCount;
        }

        @Override
        public void handleWarning(SQLWarning warning) {
            AbstractJdbc2Statement.this.addWarning(warning);
        }

        @Override
        public void handleError(SQLException newError) {
            if (this.batchException == null) {
                int[] successCounts;
                if (this.resultIndex >= this.updateCounts.length) {
                    successCounts = this.updateCounts;
                } else {
                    successCounts = new int[this.resultIndex];
                    System.arraycopy(this.updateCounts, 0, successCounts, 0, this.resultIndex);
                }
                String queryString = "<unknown>";
                if (this.resultIndex < this.queries.length) {
                    queryString = this.queries[this.resultIndex].toString(this.parameterLists[this.resultIndex]);
                }
                this.batchException = new BatchUpdateException(GT.tr("Batch entry {0} {1} was aborted.  Call getNextException to see the cause.", new Object[]{this.resultIndex, queryString}), newError.getSQLState(), successCounts);
            }
            this.batchException.setNextException(newError);
        }

        @Override
        public void handleCompletion() throws SQLException {
            if (this.batchException != null) {
                throw this.batchException;
            }
        }
    }

    private class BatchResultHandler
    implements ResultHandler {
        private BatchUpdateException batchException = null;
        private int resultIndex = 0;
        private final Query[] queries;
        private final ParameterList[] parameterLists;
        private final int[] updateCounts;
        private final boolean expectGeneratedKeys;
        private ResultSet generatedKeys;

        BatchResultHandler(Query[] queries, ParameterList[] parameterLists, int[] updateCounts, boolean expectGeneratedKeys) {
            this.queries = queries;
            this.parameterLists = parameterLists;
            this.updateCounts = updateCounts;
            this.expectGeneratedKeys = expectGeneratedKeys;
        }

        @Override
        public void handleResultRows(Query fromQuery, Field[] fields, List tuples, ResultCursor cursor) {
            if (!this.expectGeneratedKeys) {
                this.handleError(new PSQLException(GT.tr("A result was returned when none was expected."), PSQLState.TOO_MANY_RESULTS));
            } else if (this.generatedKeys == null) {
                try {
                    this.generatedKeys = AbstractJdbc2Statement.this.createResultSet(fromQuery, fields, tuples, cursor);
                }
                catch (SQLException e) {
                    this.handleError(e);
                }
            } else {
                ((AbstractJdbc2ResultSet)this.generatedKeys).addRows(tuples);
            }
        }

        @Override
        public void handleCommandStatus(String status, int updateCount, long insertOID) {
            if (this.resultIndex >= this.updateCounts.length) {
                this.handleError(new PSQLException(GT.tr("Too many update results were returned."), PSQLState.TOO_MANY_RESULTS));
                return;
            }
            this.updateCounts[this.resultIndex++] = updateCount;
        }

        @Override
        public void handleWarning(SQLWarning warning) {
            AbstractJdbc2Statement.this.addWarning(warning);
        }

        @Override
        public void handleError(SQLException newError) {
            if (this.batchException == null) {
                int[] successCounts;
                if (this.resultIndex >= this.updateCounts.length) {
                    successCounts = this.updateCounts;
                } else {
                    successCounts = new int[this.resultIndex];
                    System.arraycopy(this.updateCounts, 0, successCounts, 0, this.resultIndex);
                }
                String queryString = "<unknown>";
                if (this.resultIndex < this.queries.length) {
                    queryString = this.queries[this.resultIndex].toString(this.parameterLists[this.resultIndex]);
                }
                this.batchException = new BatchUpdateException(GT.tr("Batch entry {0} {1} was aborted.  Call getNextException to see the cause.", new Object[]{this.resultIndex, queryString}), newError.getSQLState(), successCounts);
            }
            this.batchException.setNextException(newError);
        }

        @Override
        public void handleCompletion() throws SQLException {
            if (this.batchException != null) {
                throw this.batchException;
            }
        }

        public ResultSet getGeneratedKeys() {
            return this.generatedKeys;
        }
    }

    public class StatementResultHandler
    implements ResultHandler {
        private SQLException error;
        private ResultWrapper results;

        ResultWrapper getResults() {
            return this.results;
        }

        private void append(ResultWrapper newResult) {
            if (this.results == null) {
                this.results = newResult;
            } else {
                this.results.append(newResult);
            }
        }

        @Override
        public void handleResultRows(Query fromQuery, Field[] fields, List tuples, ResultCursor cursor) {
            try {
                ResultSet rs = AbstractJdbc2Statement.this.createResultSet(fromQuery, fields, tuples, cursor);
                this.append(new ResultWrapper(rs));
            }
            catch (SQLException e) {
                this.handleError(e);
            }
        }

        @Override
        public void handleCommandStatus(String status, int updateCount, long insertOID) {
            this.append(new ResultWrapper(updateCount, insertOID));
        }

        @Override
        public void handleWarning(SQLWarning warning) {
            AbstractJdbc2Statement.this.addWarning(warning);
        }

        @Override
        public void handleError(SQLException newError) {
            if (this.error == null) {
                this.error = newError;
            } else {
                this.error.setNextException(newError);
            }
        }

        @Override
        public void handleCompletion() throws SQLException {
            if (this.error != null) {
                throw this.error;
            }
        }
    }
}

