/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.welcome;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.InputStream;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import org.gephi.desktop.importer.api.ImportControllerUI;
import org.gephi.desktop.mrufiles.api.MostRecentFiles;
import org.gephi.desktop.project.api.ProjectControllerUI;
import org.jdesktop.swingx.JXHeader;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.border.DropShadowBorder;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class WelcomeTopComponent
extends JPanel {
    private static WelcomeTopComponent instance;
    public static final String STARTUP_PREF = "WelcomeScreen_Open_Startup";
    private static final String GEPHI_EXTENSION = "gephi";
    private static final Object LINK_PATH;
    private Action openAction;
    private JXHeader header;
    private JLabel labelNew;
    private JLabel labelRecent;
    private JLabel labelSamples;
    private JPanel mainPanel;
    private JXHyperlink newProjectLink;
    private JXHyperlink openFileLink;
    private JCheckBox openOnStartupCheckbox;
    private JPanel recentPanel;
    private JPanel samplesPanel;
    private JPanel southPanel;

    public static synchronized WelcomeTopComponent getInstance() {
        if (instance == null) {
            instance = new WelcomeTopComponent();
        }
        return instance;
    }

    private WelcomeTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(WelcomeTopComponent.class, (String)"CTL_WelcomeTopComponent"));
        this.putClientProperty("netbeans.winsys.tc.dragging_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.maximization_disabled", Boolean.TRUE);
        this.initAction();
        this.loadMRU();
        this.loadSamples();
        this.loadPrefs();
    }

    private void closeDialog() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Container container = WelcomeTopComponent.this;
                while (!(container instanceof JDialog)) {
                    container = container.getParent();
                }
                ((Component)container).setVisible(false);
            }
        });
    }

    private void initAction() {
        this.openAction = new AbstractAction("", ImageUtilities.loadImageIcon((String)"org/gephi/desktop/welcome/resources/gephifile20.png", (boolean)false)){

            @Override
            public void actionPerformed(ActionEvent e) {
                JXHyperlink link = (JXHyperlink)e.getSource();
                File file = (File)link.getClientProperty(LINK_PATH);
                FileObject fileObject = FileUtil.toFileObject((File)file);
                if (fileObject.hasExt(WelcomeTopComponent.GEPHI_EXTENSION)) {
                    ProjectControllerUI pc = (ProjectControllerUI)Lookup.getDefault().lookup(ProjectControllerUI.class);
                    try {
                        pc.openProject(file);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WelcomeTopComponent.class, (String)"WelcomeTopComponent.openGephiError"), 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                    }
                } else {
                    ImportControllerUI importController = (ImportControllerUI)Lookup.getDefault().lookup(ImportControllerUI.class);
                    if (importController.getImportController().isFileSupported(FileUtil.toFile((FileObject)fileObject))) {
                        importController.importFile(fileObject);
                    }
                }
                WelcomeTopComponent.this.closeDialog();
            }
        };
        this.newProjectLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectControllerUI pc = (ProjectControllerUI)Lookup.getDefault().lookup(ProjectControllerUI.class);
                pc.newProject();
                WelcomeTopComponent.this.closeDialog();
            }
        });
        this.openFileLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectControllerUI pc = (ProjectControllerUI)Lookup.getDefault().lookup(ProjectControllerUI.class);
                pc.openFile();
                WelcomeTopComponent.this.closeDialog();
            }
        });
    }

    private void loadMRU() {
        MigLayout migLayout1 = new MigLayout();
        migLayout1.setColumnConstraints((Object)"[pref]");
        this.recentPanel.setLayout((LayoutManager)migLayout1);
        MostRecentFiles mru = (MostRecentFiles)Lookup.getDefault().lookup(MostRecentFiles.class);
        for (String filePath : mru.getMRUFileList()) {
            JXHyperlink fileLink = new JXHyperlink(this.openAction);
            File file = new File(filePath);
            if (!file.exists()) continue;
            fileLink.setText(file.getName());
            fileLink.putClientProperty(LINK_PATH, (Object)file);
            this.recentPanel.add((Component)fileLink, "wrap");
        }
    }

    private void loadSamples() {
        MigLayout migLayout1 = new MigLayout();
        migLayout1.setColumnConstraints((Object)"[pref]");
        this.samplesPanel.setLayout((LayoutManager)migLayout1);
        String[] samplePath = new String[]{"/org/gephi/desktop/welcome/samples/Les Miserables.gexf", "/org/gephi/desktop/welcome/samples/Java.gexf", "/org/gephi/desktop/welcome/samples/Power Grid.gml"};
        String[] sampleTooltip = new String[]{"Coappearance Network of Characters in 'Les Miserables' (D. E. Knuth)", "Java Programming Language Dependency graph (V. Batagelj)", "Topology of the Western States Power Grid of the US (D. Watts & S. Strogatz)"};
        try {
            for (int i = 0; i < samplePath.length; ++i) {
                final String s = samplePath[i];
                String tooltip = sampleTooltip[i];
                String fileName = s.substring(s.lastIndexOf(47) + 1, s.length());
                final String importer = fileName.substring(fileName.lastIndexOf(46), fileName.length());
                JXHyperlink fileLink = new JXHyperlink((Action)new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        InputStream stream = WelcomeTopComponent.class.getResourceAsStream(s);
                        ImportControllerUI importController = (ImportControllerUI)Lookup.getDefault().lookup(ImportControllerUI.class);
                        importController.importStream(stream, importer);
                        WelcomeTopComponent.this.closeDialog();
                    }
                });
                fileLink.setText(fileName);
                fileLink.setToolTipText(tooltip);
                fileLink.putClientProperty(LINK_PATH, (Object)importer);
                this.samplesPanel.add((Component)fileLink, "wrap");
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void loadPrefs() {
        Boolean openStartup = NbPreferences.forModule(WelcomeTopComponent.class).getBoolean(STARTUP_PREF, Boolean.TRUE);
        this.openOnStartupCheckbox.setSelected(openStartup);
        this.openOnStartupCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NbPreferences.forModule(WelcomeTopComponent.class).putBoolean(WelcomeTopComponent.STARTUP_PREF, WelcomeTopComponent.this.openOnStartupCheckbox.isSelected());
            }
        });
    }

    private void initComponents() {
        this.header = new JXHeader();
        this.mainPanel = new JPanel();
        this.labelRecent = new JLabel();
        this.recentPanel = new JPanel();
        this.labelNew = new JLabel();
        this.newProjectLink = new JXHyperlink();
        this.labelSamples = new JLabel();
        this.samplesPanel = new JPanel();
        this.openFileLink = new JXHyperlink();
        this.southPanel = new JPanel();
        this.openOnStartupCheckbox = new JCheckBox();
        this.setOpaque(true);
        this.setPreferredSize(new Dimension(679, 379));
        this.setLayout(new BorderLayout());
        this.header.setIcon((Icon)new ImageIcon(this.getClass().getResource("/org/gephi/desktop/welcome/resources/logo_transparent_small.png")));
        this.header.setTitle(NbBundle.getMessage(WelcomeTopComponent.class, (String)"WelcomeTopComponent.header.title"));
        this.header.setTitleFont(this.header.getTitleFont().deriveFont((float)this.header.getTitleFont().getSize() + 4.0f));
        this.header.setTitleForeground(new Color(39, 119, 198));
        this.header.setBorder((Border)new DropShadowBorder());
        this.add((Component)this.header, "First");
        this.mainPanel.setBackground(new Color(255, 255, 255));
        this.labelRecent.setFont(this.labelRecent.getFont().deriveFont(this.labelRecent.getFont().getStyle() | 1, this.labelRecent.getFont().getSize() + 2));
        Mnemonics.setLocalizedText((JLabel)this.labelRecent, (String)NbBundle.getMessage(WelcomeTopComponent.class, (String)"WelcomeTopComponent.labelRecent.text"));
        this.recentPanel.setOpaque(false);
        this.labelNew.setFont(this.labelNew.getFont().deriveFont(this.labelNew.getFont().getStyle() | 1, this.labelNew.getFont().getSize() + 2));
        Mnemonics.setLocalizedText((JLabel)this.labelNew, (String)NbBundle.getMessage(WelcomeTopComponent.class, (String)"WelcomeTopComponent.labelNew.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.newProjectLink, (String)NbBundle.getMessage(WelcomeTopComponent.class, (String)"WelcomeTopComponent.newProjectLink.text"));
        this.labelSamples.setFont(this.labelSamples.getFont().deriveFont(this.labelSamples.getFont().getStyle() | 1, this.labelSamples.getFont().getSize() + 2));
        Mnemonics.setLocalizedText((JLabel)this.labelSamples, (String)NbBundle.getMessage(WelcomeTopComponent.class, (String)"WelcomeTopComponent.labelSamples.text"));
        this.samplesPanel.setOpaque(false);
        Mnemonics.setLocalizedText((AbstractButton)this.openFileLink, (String)NbBundle.getMessage(WelcomeTopComponent.class, (String)"WelcomeTopComponent.openFileLink.text"));
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.recentPanel, -2, 232, -2).addComponent(this.labelRecent)).addGap(18, 18, 18).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.samplesPanel, -1, -1, Short.MAX_VALUE).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelNew).addComponent(this.labelSamples).addGroup(mainPanelLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.openFileLink, -2, -1, -2).addComponent((Component)this.newProjectLink, -2, -1, -2)))).addGap(62, 62, 62))).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.labelNew).addComponent(this.labelRecent)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGap(5, 5, 5).addComponent((Component)this.newProjectLink, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.openFileLink, -2, -1, -2).addGap(18, 18, 18).addComponent(this.labelSamples).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.samplesPanel, -1, 81, Short.MAX_VALUE)).addComponent(this.recentPanel, -1, 160, Short.MAX_VALUE)).addContainerGap()));
        this.add((Component)this.mainPanel, "Center");
        this.southPanel.setBackground(new Color(255, 255, 255));
        this.southPanel.setLayout(new FlowLayout(0));
        Mnemonics.setLocalizedText((AbstractButton)this.openOnStartupCheckbox, (String)NbBundle.getMessage(WelcomeTopComponent.class, (String)"WelcomeTopComponent.openOnStartupCheckbox.text"));
        this.southPanel.add(this.openOnStartupCheckbox);
        this.add((Component)this.southPanel, "South");
    }

    static {
        LINK_PATH = new Object();
    }
}

