/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.utils;

import com.csvreader.CsvWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class JTableCSVExporter {
    private static final Character DEFAULT_SEPARATOR = Character.valueOf(',');

    public static void writeCSVFile(JTable table, File file, Character separator, Charset charset, Integer[] columnsToExport) throws IOException {
        TableModel model = table.getModel();
        FileOutputStream out = new FileOutputStream(file);
        if (separator == null) {
            separator = DEFAULT_SEPARATOR;
        }
        if (columnsToExport == null) {
            columnsToExport = new Integer[model.getColumnCount()];
            for (int i = 0; i < columnsToExport.length; ++i) {
                columnsToExport[i] = i;
            }
        }
        CsvWriter writer = new CsvWriter((OutputStream)out, separator.charValue(), charset);
        for (int column = 0; column < columnsToExport.length; ++column) {
            writer.write(model.getColumnName(columnsToExport[column]), true);
        }
        writer.endRecord();
        for (int row = 0; row < table.getRowCount(); ++row) {
            for (int column = 0; column < columnsToExport.length; ++column) {
                Object value = model.getValueAt(table.convertRowIndexToModel(row), columnsToExport[column]);
                String text = value != null ? value.toString() : "";
                writer.write(text, true);
            }
            writer.endRecord();
        }
        writer.close();
    }
}

