/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.utils;

import java.io.File;
import java.io.IOException;

public class TempDirUtils {
    public static TempDir createTempDir() throws IOException {
        return new TempDir(TempDirUtils.createTempDirectory());
    }

    public static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        temp.deleteOnExit();
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }

    public static class TempDir {
        private File tempDir;

        private TempDir(File tempDir) {
            this.tempDir = tempDir;
        }

        public File createFile(String fileName) {
            File file = new File(this.tempDir, fileName);
            file.deleteOnExit();
            return file;
        }
    }
}

