/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.io.export;

import org.gephi.desktop.io.export.ExportControllerUI;
import org.gephi.io.exporter.api.ExportController;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.utils.longtask.api.LongTaskErrorHandler;
import org.gephi.utils.longtask.api.LongTaskExecutor;
import org.gephi.utils.longtask.spi.LongTask;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DesktopExportController
implements ExportControllerUI {
    private final LongTaskExecutor executor;
    private final LongTaskErrorHandler errorHandler;
    private final ExportController controller = (ExportController)Lookup.getDefault().lookup(ExportController.class);

    public DesktopExportController() {
        this.errorHandler = new LongTaskErrorHandler(){

            public void fatalError(Throwable t) {
                t.printStackTrace();
                String message = t.getCause().getMessage();
                if (message == null || message.isEmpty()) {
                    message = t.getMessage();
                }
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)message, 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            }
        };
        this.executor = new LongTaskExecutor(true, "Exporter", 10);
    }

    @Override
    public void exportFile(final FileObject fileObject, final Exporter exporter) {
        if (exporter == null) {
            throw new RuntimeException(NbBundle.getMessage(this.getClass(), (String)"error_no_matching_file_exporter"));
        }
        LongTask task = null;
        if (exporter instanceof LongTask) {
            task = (LongTask)exporter;
        }
        String taskmsg = NbBundle.getMessage(DesktopExportController.class, (String)"DesktopExportController.exportTaskName", (Object)fileObject.getNameExt());
        this.executor.execute(task, new Runnable(){

            @Override
            public void run() {
                try {
                    DesktopExportController.this.controller.exportFile(FileUtil.toFile((FileObject)fileObject), exporter);
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(DesktopExportController.class, (String)"DesktopExportController.status.exportSuccess", (Object)fileObject.getNameExt()));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }, taskmsg, this.errorHandler);
    }

    @Override
    public ExportController getExportController() {
        return this.controller;
    }
}

