/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.uihandler;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class PasswdEncryption {
    private static final String delimiter = ":";
    public static final int MAX_ENCRYPTION_LENGHT = 100;

    public static String encrypt(String text) throws IOException, GeneralSecurityException {
        return PasswdEncryption.encrypt(text, PasswdEncryption.getPublicKey());
    }

    public static byte[] encrypt(byte[] text) throws IOException, GeneralSecurityException {
        return PasswdEncryption.encrypt(text, PasswdEncryption.getPublicKey());
    }

    public static byte[] encrypt(byte[] text, PublicKey key) throws IOException, GeneralSecurityException {
        assert (text.length <= 100);
        Cipher rsaCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        rsaCipher.init(1, key);
        byte[] encoded = null;
        encoded = rsaCipher.doFinal(text);
        return encoded;
    }

    public static byte[] decrypt(byte[] text, PrivateKey key) throws IOException, GeneralSecurityException {
        Cipher rsaCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        rsaCipher.init(2, key);
        byte[] decoded = null;
        decoded = rsaCipher.doFinal(text);
        return decoded;
    }

    public static String encrypt(String text, PublicKey key) throws IOException, GeneralSecurityException {
        byte[] encrypted = PasswdEncryption.encrypt(text.getBytes(), key);
        return PasswdEncryption.arrayToString(encrypted);
    }

    public static String decrypt(String text, PrivateKey key) throws IOException, GeneralSecurityException {
        byte[] decrypted = PasswdEncryption.decrypt(PasswdEncryption.stringToArray(text), key);
        return new String(decrypted);
    }

    private static String arrayToString(byte[] array) {
        String result = "";
        for (int i = 0; i < array.length; ++i) {
            byte b = array[i];
            result = result.concat(Byte.toString(b) + delimiter);
        }
        return result;
    }

    private static byte[] stringToArray(String str) {
        String[] numbers = str.split(delimiter);
        byte[] result = new byte[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            result[i] = Byte.parseByte(numbers[i]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PublicKey getPublicKey() throws IOException, GeneralSecurityException {
        InputStream inputStr = PasswdEncryption.class.getResourceAsStream("pubKey");
        byte[] encodedKey = new byte[inputStr.available()];
        try {
            inputStr.read(encodedKey);
        }
        finally {
            inputStr.close();
        }
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(encodedKey);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PublicKey publicKey = kf.generatePublic(publicKeySpec);
        return publicKey;
    }
}

