/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.kotlin.ModuleVisibilityManager;
import org.jetbrains.kotlin.load.kotlin.ModuleVisibilityUtilsKt;
import org.jetbrains.kotlin.modules.Module;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyPackageDescriptor;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.util.ModuleVisibilityHelper;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/cli/common/ModuleVisibilityHelperImpl;", "Lorg/jetbrains/kotlin/util/ModuleVisibilityHelper;", "()V", "findModule", "Lorg/jetbrains/kotlin/modules/Module;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "modules", "", "isInFriendModule", "", "what", "from", "kotlin-compiler"})
public final class ModuleVisibilityHelperImpl
implements ModuleVisibilityHelper {
    @Override
    public boolean isInFriendModule(@NotNull DeclarationDescriptor what, @NotNull DeclarationDescriptor from) {
        Object object;
        Intrinsics.checkParameterIsNotNull(what, "what");
        Intrinsics.checkParameterIsNotNull(from, "from");
        SourceElement fromSource = ModuleVisibilityUtilsKt.getSourceElement(from);
        if (fromSource instanceof KotlinSourceElement) {
            Project project = ((KotlinSourceElement)fromSource).getPsi().getProject();
            object = project;
            Intrinsics.checkExpressionValueIsNotNull(project, "fromSource.psi.project");
        } else {
            DeclarationDescriptor declarationDescriptor = from;
            if (!(declarationDescriptor instanceof LazyPackageDescriptor)) {
                declarationDescriptor = null;
            }
            if ((object = (LazyPackageDescriptor)declarationDescriptor) == null || (object = ((LazyPackageDescriptor)object).getDeclarationProvider()) == null || (object = object.getPackageFiles()) == null || (object = (KtFile)CollectionsKt.firstOrNull((Iterable)object)) == null || (object = ((PsiFileImpl)object).getProject()) == null) {
                return true;
            }
        }
        Collection<KtFile> project = object;
        ModuleVisibilityManager moduleVisibilityManager = ModuleVisibilityManager.SERVICE.getInstance((Project)((Object)project));
        if (!moduleVisibilityManager.getEnabled()) {
            return true;
        }
        Iterable $receiver$iv = moduleVisibilityManager.getFriendPaths();
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            if (!ModuleVisibilityUtilsKt.isContainedByCompiledPartOfOurModule(what, new File(it))) continue;
            return true;
        }
        Collection<Module> modules = moduleVisibilityManager.getChunk();
        SourceElement whatSource = ModuleVisibilityUtilsKt.getSourceElement(what);
        if (whatSource instanceof KotlinSourceElement) {
            if (modules.size() > 1 && fromSource instanceof KotlinSourceElement) {
                return this.findModule(what, modules) == this.findModule(from, modules);
            }
            return true;
        }
        if (modules.isEmpty()) {
            return false;
        }
        if (modules.size() == 1 && ModuleVisibilityUtilsKt.isContainedByCompiledPartOfOurModule(what, new File(((Module)CollectionsKt.single((Iterable)modules)).getOutputDirectory()))) {
            return true;
        }
        return this.findModule(from, modules) == this.findModule(what, modules);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Module findModule(DeclarationDescriptor descriptor2, Collection<? extends Module> modules) {
        Object element$iv;
        Object v2;
        boolean bl;
        SourceElement sourceElement = ModuleVisibilityUtilsKt.getSourceElement(descriptor2);
        if (sourceElement instanceof KotlinSourceElement) {
            Object v1;
            Module module;
            block10: {
                module = (Module)CollectionsKt.singleOrNull((Iterable)modules);
                if (module != null) {
                    return module;
                }
                Iterable $receiver$iv = modules;
                for (Object element$iv2 : $receiver$iv) {
                    Module it = (Module)element$iv2;
                    if (!it.getSourceFiles().contains(((KotlinSourceElement)sourceElement).getPsi().getContainingKtFile().getVirtualFile().getPath())) continue;
                    v1 = element$iv2;
                    break block10;
                }
                v1 = null;
            }
            module = v1;
            return module;
        }
        Iterable $receiver$iv = modules;
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            block13: {
                block12: {
                    boolean bl2;
                    block11: {
                        if (!iterator2.hasNext()) {
                            v2 = null;
                            return v2;
                        }
                        element$iv = iterator2.next();
                        Module module = (Module)element$iv;
                        if (ModuleVisibilityUtilsKt.isContainedByCompiledPartOfOurModule(descriptor2, new File(module.getOutputDirectory()))) break block12;
                        Iterable $receiver$iv2 = module.getFriendPaths();
                        for (Object element$iv3 : $receiver$iv2) {
                            String it = (String)element$iv3;
                            if (!ModuleVisibilityUtilsKt.isContainedByCompiledPartOfOurModule(descriptor2, new File(it))) continue;
                            bl2 = true;
                            break block11;
                        }
                        bl2 = false;
                    }
                    if (!bl2) break block13;
                }
                bl = true;
                continue;
            }
            bl = false;
        } while (!bl);
        v2 = element$iv;
        return v2;
    }
}

