/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.logging;

import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.tasks.testing.DecoratingTestDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestClassDescriptor;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.results.TestListenerInternal;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;

public class TestWorkerProgressListener
implements TestListenerInternal {
    private final ProgressLoggerFactory factory;
    private final ProgressLogger parentProgressLogger;
    private final Map<String, ProgressLogger> testWorkerProgressLoggers = new HashMap<String, ProgressLogger>();

    public TestWorkerProgressListener(ProgressLoggerFactory factory, ProgressLogger parentProgressLogger) {
        this.factory = factory;
        this.parentProgressLogger = parentProgressLogger;
    }

    @Override
    public void started(TestDescriptorInternal testDescriptor, TestStartEvent startEvent) {
        String description;
        boolean testClassDescriptor = this.isDefaultTestClassDescriptor(testDescriptor);
        if (testClassDescriptor && !this.testWorkerProgressLoggers.containsKey(description = this.createProgressLoggerDescription(testDescriptor))) {
            ProgressLogger progressLogger = this.factory.newOperation(TestWorkerProgressListener.class, this.parentProgressLogger);
            progressLogger.start(description, description);
            this.testWorkerProgressLoggers.put(description, progressLogger);
        }
    }

    @Override
    public void completed(TestDescriptorInternal testDescriptor, TestResult testResult, TestCompleteEvent completeEvent) {
        String description;
        boolean testClassDescriptor = this.isDefaultTestClassDescriptor(testDescriptor);
        if (testClassDescriptor && this.testWorkerProgressLoggers.containsKey(description = this.createProgressLoggerDescription(testDescriptor))) {
            ProgressLogger progressLogger = this.testWorkerProgressLoggers.remove(description);
            progressLogger.completed();
        }
    }

    @Override
    public void output(TestDescriptorInternal testDescriptor, TestOutputEvent event) {
    }

    public void completeAll() {
        for (ProgressLogger progressLogger : this.testWorkerProgressLoggers.values()) {
            progressLogger.completed();
        }
        this.testWorkerProgressLoggers.clear();
    }

    private boolean isDefaultTestClassDescriptor(TestDescriptorInternal testDescriptor) {
        return testDescriptor.isComposite() && testDescriptor instanceof DecoratingTestDescriptor && ((DecoratingTestDescriptor)testDescriptor).getDescriptor() instanceof DefaultTestClassDescriptor;
    }

    private String createProgressLoggerDescription(TestDescriptorInternal testDescriptor) {
        DecoratingTestDescriptor decoratingTestDescriptor = (DecoratingTestDescriptor)testDescriptor;
        DefaultTestClassDescriptor defaultTestClassDescriptor = (DefaultTestClassDescriptor)decoratingTestDescriptor.getDescriptor();
        return "Executing test " + defaultTestClassDescriptor.getClassName();
    }

    Map<String, ProgressLogger> getTestWorkerProgressLoggers() {
        return this.testWorkerProgressLoggers;
    }
}

