/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.composite.internal.IncludedBuildController;
import org.gradle.composite.internal.IncludedBuildControllers;
import org.gradle.composite.internal.IncludedBuildTaskGraph;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.util.Path;

public class DefaultIncludedBuildTaskGraph
implements IncludedBuildTaskGraph {
    private final Multimap<BuildIdentifier, BuildIdentifier> buildDependencies = LinkedHashMultimap.create();
    private final IncludedBuildControllers includedBuilds;

    public DefaultIncludedBuildTaskGraph(IncludedBuildControllers includedBuilds) {
        this.includedBuilds = includedBuilds;
    }

    public synchronized void addTask(BuildIdentifier requestingBuild, BuildIdentifier targetBuild, String taskPath) {
        boolean newBuildDependency = this.buildDependencies.put((Object)requestingBuild, (Object)targetBuild);
        if (newBuildDependency) {
            ArrayList candidateCycle = Lists.newArrayList();
            this.checkNoCycles(requestingBuild, targetBuild, candidateCycle);
        }
        this.getBuildController(targetBuild).queueForExecution(taskPath);
    }

    public void awaitCompletion(BuildIdentifier targetBuild, String taskPath) {
        this.includedBuilds.startTaskExecution(false);
        this.getBuildController(targetBuild).awaitCompletion(taskPath);
    }

    public boolean isComplete(BuildIdentifier targetBuild, String taskPath) {
        IncludedBuildController controller = this.getBuildController(targetBuild);
        return controller.isComplete(taskPath);
    }

    private IncludedBuildController getBuildController(BuildIdentifier buildId) {
        return this.includedBuilds.getBuildController(buildId);
    }

    private void checkNoCycles(BuildIdentifier sourceBuild, BuildIdentifier targetBuild, List<BuildIdentifier> candidateCycle) {
        candidateCycle.add(targetBuild);
        for (BuildIdentifier nextTarget : this.buildDependencies.get((Object)targetBuild)) {
            if (sourceBuild.equals(nextTarget)) {
                candidateCycle.add(nextTarget);
                ProjectComponentSelector selector = DefaultProjectComponentSelector.newSelector((BuildIdentifier)candidateCycle.get(0), (String)Path.ROOT.getPath());
                throw new ModuleVersionResolveException((ComponentSelector)selector, "Included build dependency cycle: " + this.reportCycle(candidateCycle));
            }
            this.checkNoCycles(sourceBuild, nextTarget, candidateCycle);
        }
        candidateCycle.remove(targetBuild);
    }

    private String reportCycle(List<BuildIdentifier> cycle) {
        StringBuilder cycleReport = new StringBuilder();
        for (BuildIdentifier buildIdentifier : cycle) {
            cycleReport.append(buildIdentifier);
            cycleReport.append(" -> ");
        }
        cycleReport.append(cycle.get(0));
        return cycleReport.toString();
    }
}

