/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.Callable;
import org.gradle.api.internal.classloading.GroovySystemLoader;
import org.gradle.api.internal.classloading.GroovySystemLoaderFactory;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.CachingClassLoader;
import org.gradle.internal.classloader.ClassLoaderFactory;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.MultiParentClassLoader;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.io.ClassLoaderObjectInputStream;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.progress.BuildOperationDescriptor;
import org.gradle.internal.progress.BuildOperationState;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.internal.serialize.ExceptionReplacingObjectInputStream;
import org.gradle.internal.serialize.ExceptionReplacingObjectOutputStream;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.util.GUtil;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.WorkSpec;
import org.gradle.workers.internal.Worker;
import org.gradle.workers.internal.WorkerFactory;
import org.gradle.workers.internal.WorkerProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsolatedClassloaderWorkerFactory
implements WorkerFactory {
    private final ClassLoaderFactory classLoaderFactory;
    private final WorkerLeaseRegistry workerLeaseRegistry;
    private final BuildOperationExecutor buildOperationExecutor;
    private final GroovySystemLoaderFactory groovySystemLoaderFactory = new GroovySystemLoaderFactory();

    public IsolatedClassloaderWorkerFactory(ClassLoaderFactory classLoaderFactory, WorkerLeaseRegistry workerLeaseRegistry, BuildOperationExecutor buildOperationExecutor) {
        this.classLoaderFactory = classLoaderFactory;
        this.workerLeaseRegistry = workerLeaseRegistry;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public <T extends WorkSpec> Worker<T> getWorker(final Class<? extends WorkerProtocol<T>> workerImplementationClass, final DaemonForkOptions forkOptions) {
        return new Worker<T>(){

            @Override
            public DefaultWorkResult execute(T spec) {
                return this.execute(spec, IsolatedClassloaderWorkerFactory.this.workerLeaseRegistry.getCurrentWorkerLease(), IsolatedClassloaderWorkerFactory.this.buildOperationExecutor.getCurrentOperation());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DefaultWorkResult execute(final T spec, WorkerLeaseRegistry.WorkerLease parentWorkerWorkerLease, final BuildOperationState parentBuildOperation) {
                WorkerLeaseRegistry.WorkerLeaseCompletion workerLease = parentWorkerWorkerLease.startChild();
                try {
                    DefaultWorkResult defaultWorkResult = (DefaultWorkResult)IsolatedClassloaderWorkerFactory.this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<DefaultWorkResult>(){

                        public DefaultWorkResult call(BuildOperationContext context) {
                            return IsolatedClassloaderWorkerFactory.this.executeInWorkerClassLoader(workerImplementationClass, spec, forkOptions);
                        }

                        public BuildOperationDescriptor.Builder description() {
                            return BuildOperationDescriptor.displayName((String)spec.getDisplayName()).parent(parentBuildOperation);
                        }
                    });
                    return defaultWorkResult;
                }
                finally {
                    workerLease.leaseFinish();
                }
            }
        };
    }

    @Override
    public IsolationMode getIsolationMode() {
        return IsolationMode.CLASSLOADER;
    }

    private <T extends WorkSpec> DefaultWorkResult executeInWorkerClassLoader(Class<? extends WorkerProtocol<T>> workerImplementationClass, T spec, DaemonForkOptions forkOptions) {
        ClassLoader actionClasspathLoader = this.createActionClasspathLoader(forkOptions);
        GroovySystemLoader actionClasspathGroovy = this.groovySystemLoaderFactory.forClassLoader(actionClasspathLoader);
        ClassLoader workerClassLoader = this.createWorkerClassLoader(actionClasspathLoader, forkOptions.getSharedPackages(), spec.getClass());
        ClassLoader previousContextLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(workerClassLoader);
            Callable<?> worker = this.transferWorkerIntoWorkerClassloader(workerImplementationClass, spec, workerClassLoader);
            Object result = worker.call();
            DefaultWorkResult defaultWorkResult = this.transferResultFromWorkerClassLoader(result);
            return defaultWorkResult;
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        finally {
            actionClasspathGroovy.shutdown();
            Thread.currentThread().setContextClassLoader(previousContextLoader);
        }
    }

    private ClassLoader createActionClasspathLoader(DaemonForkOptions forkOptions) {
        return this.classLoaderFactory.createIsolatedClassLoader((ClassPath)new DefaultClassPath(forkOptions.getClasspath()));
    }

    private ClassLoader createWorkerClassLoader(ClassLoader actionClasspathLoader, Iterable<String> sharedPackages, Class<?> actionClass) {
        FilteringClassLoader.Spec actionFilterSpec = new FilteringClassLoader.Spec();
        for (String packageName : sharedPackages) {
            actionFilterSpec.allowPackage(packageName);
        }
        ClassLoader actionFilteredClasspathLoader = this.classLoaderFactory.createFilteringClassLoader(actionClasspathLoader, actionFilterSpec);
        FilteringClassLoader.Spec gradleApiFilterSpec = new FilteringClassLoader.Spec();
        gradleApiFilterSpec.allowPackage("org.slf4j");
        gradleApiFilterSpec.allowClass(Logger.class);
        gradleApiFilterSpec.allowClass(LogLevel.class);
        gradleApiFilterSpec.allowPackage("org.gradle.internal.nativeintegration");
        gradleApiFilterSpec.allowPackage("org.gradle.internal.nativeplatform");
        gradleApiFilterSpec.allowPackage("net.rubygrapefruit.platform");
        ClassLoader gradleApiLoader = this.classLoaderFactory.createFilteringClassLoader(actionClass.getClassLoader(), gradleApiFilterSpec);
        CachingClassLoader actionAndGradleApiLoader = new CachingClassLoader((ClassLoader)new MultiParentClassLoader(new ClassLoader[]{gradleApiLoader, actionFilteredClasspathLoader}));
        return new VisitableURLClassLoader((ClassLoader)actionAndGradleApiLoader, ClasspathUtil.getClasspath((ClassLoader)actionClass.getClassLoader()));
    }

    private <T extends WorkSpec> Callable<?> transferWorkerIntoWorkerClassloader(Class<? extends WorkerProtocol<T>> workerImplementationClass, T spec, ClassLoader workerClassLoader) throws IOException, ClassNotFoundException {
        byte[] serializedWorker = GUtil.serialize(new WorkerCallable(workerImplementationClass, spec, null));
        ClassLoaderObjectInputStream ois = new ClassLoaderObjectInputStream((InputStream)new ByteArrayInputStream(serializedWorker), workerClassLoader);
        return (Callable)ois.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultWorkResult transferResultFromWorkerClassLoader(Object result) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream resultBytes = new ByteArrayOutputStream();
        ExceptionReplacingObjectOutputStream oos = new ExceptionReplacingObjectOutputStream((OutputStream)resultBytes);
        try {
            oos.writeObject(result);
        }
        finally {
            oos.close();
        }
        ExceptionReplacingObjectInputStream ois = new ExceptionReplacingObjectInputStream((InputStream)new ByteArrayInputStream(resultBytes.toByteArray()), this.getClass().getClassLoader());
        return (DefaultWorkResult)ois.readObject();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WorkerCallable<T extends WorkSpec>
    implements Callable<Object>,
    Serializable {
        private final Class<? extends WorkerProtocol<T>> workerImplementationClass;
        private final T spec;

        private WorkerCallable(Class<? extends WorkerProtocol<T>> workerImplementationClass, T spec) {
            this.workerImplementationClass = workerImplementationClass;
            this.spec = spec;
        }

        @Override
        public Object call() throws Exception {
            return ((WorkerProtocol)DirectInstantiator.INSTANCE.newInstance(this.workerImplementationClass, new Object[0])).execute(this.spec);
        }

        /* synthetic */ WorkerCallable(Class x0, WorkSpec x1, 1 x2) {
            this(x0, x1);
        }
    }
}

