/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.run;

import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.play.internal.run.PlayAppLifecycleUpdate;
import org.gradle.play.internal.run.PlayRunWorkerServerProtocol;
import org.gradle.play.internal.run.PlayWorkerClient;
import org.gradle.process.internal.worker.WorkerProcess;

public class PlayApplicationRunnerToken {
    private final PlayWorkerClient clientCallBack;
    private final PlayRunWorkerServerProtocol workerServer;
    private final WorkerProcess process;
    private final AtomicBoolean stopped;

    public PlayApplicationRunnerToken(PlayRunWorkerServerProtocol workerServer, PlayWorkerClient clientCallBack, WorkerProcess process) {
        this.workerServer = workerServer;
        this.clientCallBack = clientCallBack;
        this.process = process;
        this.stopped = new AtomicBoolean(false);
    }

    public PlayAppLifecycleUpdate stop() {
        this.workerServer.stop();
        PlayAppLifecycleUpdate update = this.clientCallBack.waitForStop();
        this.process.waitForStop();
        this.stopped.set(true);
        return update;
    }

    public void rebuildSuccess() {
        this.workerServer.buildSuccess();
    }

    public void rebuildFailure(Throwable failure) {
        this.workerServer.buildError(failure);
    }

    public boolean isRunning() {
        return !this.stopped.get();
    }

    public void rebuildInProgress() {
        this.workerServer.rebuildInProgress();
    }
}

