/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.run;

import java.io.Serializable;
import java.net.URLClassLoader;
import java.util.concurrent.CountDownLatch;
import org.gradle.api.Action;
import org.gradle.api.logging.Logging;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.play.internal.run.PlayAppLifecycleUpdate;
import org.gradle.play.internal.run.PlayRunSpec;
import org.gradle.play.internal.run.PlayRunWorkerClientProtocol;
import org.gradle.play.internal.run.PlayRunWorkerServerProtocol;
import org.gradle.play.internal.run.VersionedPlayRunAdapter;
import org.gradle.process.internal.worker.WorkerProcessContext;

public class PlayWorkerServer
implements Action<WorkerProcessContext>,
PlayRunWorkerServerProtocol,
Serializable {
    private PlayRunSpec runSpec;
    private VersionedPlayRunAdapter runAdapter;
    private volatile CountDownLatch stop;

    public PlayWorkerServer(PlayRunSpec runSpec, VersionedPlayRunAdapter runAdapter) {
        this.runSpec = runSpec;
        this.runAdapter = runAdapter;
    }

    public void execute(WorkerProcessContext context) {
        this.stop = new CountDownLatch(1);
        PlayRunWorkerClientProtocol clientProtocol = (PlayRunWorkerClientProtocol)context.getServerConnection().addOutgoing(PlayRunWorkerClientProtocol.class);
        context.getServerConnection().addIncoming(PlayRunWorkerServerProtocol.class, (Object)this);
        context.getServerConnection().connect();
        PlayAppLifecycleUpdate result = this.startServer();
        try {
            clientProtocol.update(result);
            this.stop.await();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        finally {
            clientProtocol.update(PlayAppLifecycleUpdate.stopped());
        }
    }

    private PlayAppLifecycleUpdate startServer() {
        try {
            this.run();
            return PlayAppLifecycleUpdate.running();
        }
        catch (Exception e) {
            Logging.getLogger(this.getClass()).error("Failed to run Play", (Throwable)e);
            return PlayAppLifecycleUpdate.failed(e);
        }
    }

    private void run() {
        ClassLoaderUtils.disableUrlConnectionCaching();
        Thread thread = Thread.currentThread();
        ClassLoader previousContextClassLoader = thread.getContextClassLoader();
        URLClassLoader classLoader = new URLClassLoader(new DefaultClassPath(this.runSpec.getClasspath()).getAsURLArray(), null);
        thread.setContextClassLoader(classLoader);
        try {
            Object buildDocHandler = this.runAdapter.getBuildDocHandler(classLoader, this.runSpec.getClasspath());
            Object buildLink = this.runAdapter.getBuildLink(classLoader, this.runSpec.getProjectPath(), this.runSpec.getApplicationJar(), this.runSpec.getChangingClasspath(), this.runSpec.getAssetsJar(), this.runSpec.getAssetsDirs());
            this.runAdapter.runDevHttpServer(classLoader, classLoader, buildLink, buildDocHandler, this.runSpec.getHttpPort());
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        finally {
            thread.setContextClassLoader(previousContextClassLoader);
        }
    }

    public void stop() {
        this.stop.countDown();
    }

    @Override
    public void buildSuccess() {
        this.runAdapter.buildSuccess();
    }

    @Override
    public void buildError(Throwable throwable) {
        this.runAdapter.buildError(throwable);
    }

    @Override
    public void rebuildInProgress() {
        this.runAdapter.rebuildInProgress();
    }
}

